#include "kxsettings_contactlist_optionsimpl.h"
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>
#include <qmessagebox.h>

/* 
 *  Constructs a kxSettings_ContactList_OptionsImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_ContactList_OptionsImpl::kxSettings_ContactList_OptionsImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_ContactList_Options( parent, name, fl )
{
//	QObject::connect(showOffline,SIGNAL(released()), this, SLOT(SlotToggle()));	
//	QObject::connect(showNonAuth,SIGNAL(released()), this, SLOT(SlotToggle()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_ContactList_OptionsImpl::~kxSettings_ContactList_OptionsImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxSettings_ContactList_OptionsImpl::apply()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");
  
  config->writeEntry("Popup Message Chat On Receive",popupChat->isChecked());
  config->writeEntry("Popup Message Chat On Press",popupChatPress->isChecked());  
  config->writeEntry("Notify Contact",notifyContact->isChecked());
  config->writeEntry("Ignore Auth",ignoreAuth->isChecked());
//  config->writeEntry("Show Offline",showOffline->isChecked());
//  config->writeEntry("Show Unknown",showUnknown->isChecked());
  config->writeEntry("Show Wait Auth",showAuth->isChecked());
  config->writeEntry("3D Effect",effect3d->isChecked());

	config->writeEntry("Use Groups",groupSupport->isChecked());	
	config->writeEntry("Sort Nick",sortNick->isChecked());	
	config->writeEntry("Sort Status",sortStatus->isChecked());	
	config->writeEntry("Sort Group",sortGroup->isChecked());	
	
//  config->writeEntry("Transparant",transparant->isChecked());
  config->setGroup("Messaging");
  config->writeEntry("Use Color",useColor->isChecked());
  config->sync();

}
void kxSettings_ContactList_OptionsImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");
  
  popupChat->setChecked(config->readBoolEntry("Popup Message Chat On Receive",FALSE));
  popupChatPress->setChecked(config->readBoolEntry("Popup Message Chat On Press",FALSE));  
  notifyContact->setChecked(config->readBoolEntry("Notify Contact",TRUE));
  ignoreAuth->setChecked(config->readBoolEntry("Ignore Auth",FALSE));  

//  showOffline->setChecked(config->readBoolEntry("Show Offline",TRUE));
//  showUnknown->setChecked(config->readBoolEntry("Show Unknown",TRUE));
  showAuth->setChecked(config->readBoolEntry("Show Wait Auth",TRUE));
  effect3d->setChecked(config->readBoolEntry("3D Effect",TRUE));
	
	groupSupport->setChecked(config->readBoolEntry("Use Groups",FALSE));	
	sortNick->setChecked(config->readBoolEntry("Sort Nick",TRUE));	
	sortStatus->setChecked(config->readBoolEntry("Sort Status",TRUE));	
	sortGroup->setChecked(config->readBoolEntry("Sort Group",FALSE));
	
//  transparant->setChecked(config->readBoolEntry("Transparant",FALSE));
  config->setGroup("Messaging");
  useColor->setChecked(config->readBoolEntry("Use Color",TRUE));

}
void kxSettings_ContactList_OptionsImpl::SlotToggle()
{
  QMessageBox::warning(this,tr("Settings Changed"),tr("You need te restart KXicq2 to activate this option."));
}
