#include "kxsettings_contactlist_colorimpl.h"
#include <kcolorbutton.h>
#include <qcheckbox.h>
#include <kglobal.h>
#include <kconfig.h>

/*
 *  Constructs a kxSettings_ContactList_ColorImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
kxSettings_ContactList_ColorImpl::kxSettings_ContactList_ColorImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_ContactList_Colors( parent, name, fl )
{
	QObject::connect(useKDEColors, SIGNAL(clicked()), SLOT(SlotToggled()));
}

/*
 *  Destroys the object and frees any allocated resources
 */
kxSettings_ContactList_ColorImpl::~kxSettings_ContactList_ColorImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxSettings_ContactList_ColorImpl::SlotToggled()
{
	if (useKDEColors->isChecked())
	{
		background->setEnabled(FALSE);
		selectedBackground->setEnabled(FALSE);
		text->setEnabled(FALSE);
		selectedText->setEnabled(FALSE);
	}
	else
	{
		background->setEnabled(TRUE);
		selectedBackground->setEnabled(TRUE);
		text->setEnabled(TRUE);
		selectedText->setEnabled(TRUE);	
	}
}

void kxSettings_ContactList_ColorImpl::apply()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");

	config->writeEntry("Use KDE Colors",useKDEColors->isChecked());		
	config->writeEntry("Background Color",background->color());
	config->writeEntry("Selected Background Color",selectedBackground->color());
	config->writeEntry("Text Color",text->color());
	config->writeEntry("Selected Text Color",selectedText->color());
  config->sync();
}
void kxSettings_ContactList_ColorImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");

	useKDEColors->setChecked(config->readBoolEntry("Use KDE Colors",TRUE));	
	SlotToggled();
	background->setColor(config->readColorEntry("Background Color",&colorGroup().highlight()));
	QColor tm(colorGroup().highlight().light(120));
	selectedBackground->setColor(config->readColorEntry("Selected Background Color",&tm));
	text->setColor(config->readColorEntry("Text Color",&colorGroup().highlightedText()));
	selectedText->setColor(config->readColorEntry("Selected Text Color", &colorGroup().highlightedText()));

}
