//#include <dcopclient.h>

#include <signal.h>
#include <kapp.h>
#include <kuniqueapp.h>
#include <stdlib.h>
#include "kxmainwindow.h"
#include <kxengine.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>  
#include <config.h>
//#include <kxDCOP.h>
#include <klocale.h>
#include <kglobal.h>
#include <wmkxicq.h>

extern "C"
{
  void sigPipe(int _i)
  {
    debug("Broken Pipe..continue !! (pipe: %d)",_i);
  }
}

static KCmdLineOptions kxOptions[] =
{
  { 0, 0, 0 }
};     

int main(int argc, char* argv[])
{

  KAboutData aboutData("kxicq2",
                        I18N_NOOP("KXicq2"),
                        VERSION,
                        I18N_NOOP("The KDE2 ICQ client"),
                        KAboutData::License_GPL,
                        "Copyright (C) 1998-2001, Herwin Jan Steehouwer",
                        0,
                        "http://www.kxicq.org/",
                        "steehouwer@kde.org");
 
  aboutData.addAuthor("Herwin Jan Steehouwer",I18N_NOOP("Maintainer"),"steehouwer@kde.org");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( kxOptions );
//  KUniqueApplication::addCmdLineOptions();
 
  // setup mainwindow
/*  if (!KUniqueApplication::start())
  {
    fprintf(0,"KXicq2 already running !");
    exit(0);
  }  */
  KApplication app;
  
  KGlobal::locale()->insertCatalogue("kxicq2");
  
  signal(SIGPIPE,sigPipe);  

  kxEngine *engine;
  engine=new kxEngine;
  engine->init();
  
  //kxDCOP *dcop;
  //dcop=new kxDCOP("KXicq2 DCOP");

  if (app.isRestored())
    RESTORE(kxMainWindow)
  else
  {
    kxMainWindow* mainWindow;
    mainWindow = new kxMainWindow("KXicq2");
    //mainWindow->show();
  } 
  if (MAINWINDOW->kxConfig.wmDock)
  {
#ifdef HAVE_XPM
    wmkxicq_init(argc,argv);
#endif 
  }
  
//  DCOPClient *client=app.dcopClient();
//  client->attach();
//  client->registerAs("kxicq2");
    
  return app.exec();
}

