#include <wmkxicq.h>
#include <kglobalaccel.h>
#include "kxpaneldock.h"
#include <kxengine.h>
#include <kxmessage.h>
#include <qpainter.h>
#include <kxreceivedmessageimpl.h>
#include <qcolor.h>
#include <kxcontact.h>
#include <kxmainwindow.h>
#include <kwin.h>
#include <klocale.h>

kxPanelDock::kxPanelDock() : QLabel(0L,"dock")
{
  showIcon=TRUE;
  
  QObject::connect(&blinkTimer, SIGNAL(timeout()), this, SLOT(SlotTimeout()));
  QObject::connect(ENGINE, SIGNAL(SignalUpdateDock()), this, SLOT(SlotUpdatePixmap()));
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecount(UIN)));
  
  KGlobalAccel *ga = new KGlobalAccel(); 
  ga->insertItem( i18n("Read Message"), "Read Message", "CTRL+ALT+R" ); 
  ga->connectItem( "Read Message", this, SLOT( SlotShowMessage() ) );

  status="";
  message="";

  ga->readSettings();
  icon=2;
  SlotUpdatePixmap();

}

void kxPanelDock::paintEvent(QPaintEvent *)
{
  QPixmap pm(size());
  QPainter paint;
  pm.fill(backgroundColor());
  if (showIcon)
  {
    paint.begin(&pm);
    int x=(height()/2)-(pixmap.height()/2);
    int y=(width()/2)-(pixmap.width()/2);
    paint.drawPixmap(x,y,pixmap);
    paint.end();
  }
  bitBlt(this, 0, 0, &pm);
}
void kxPanelDock::SlotShowMessage()
{
  showMessage();
}
int kxPanelDock::showMessage()
{
  if (ENGINE->MESSAGE->countAllUnread()>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl(0L,"view all");
    dialog->resize(200,300);
    dialog->show();
    return 1;    
  }
  else return 0;
}

void kxPanelDock::mousePressEvent(QMouseEvent *_e)
{
  if (_e->button()==QMouseEvent::LeftButton)
  {  
    if (!showMessage())
    {
      if (MAINWINDOW->isHidden() || MAINWINDOW->isMinimized())
      {
         MAINWINDOW->showWindow();
      }
      else
      {
         MAINWINDOW->hideWindow();
      }
    }      
  }
  else
  {
    if (_e->button()==QMouseEvent::RightButton)
    {
        KWin::Info i = KWin::info( winId() );
        QRect g = i.geometry;
 
        if ( g.x() > QApplication::desktop()->width()/2 &&
             g.y() + MAINWINDOW->popup->height() > QApplication::desktop()->height() )
            MAINWINDOW->popup->popup(QPoint( g.x(), g.y() - MAINWINDOW->popup->height()));
        else
            MAINWINDOW->popup->popup(QPoint( g.x() + width(), g.y() + height()));
    }
  }
}
void kxPanelDock::SlotRecount(UIN)
{
  SlotUpdatePixmap();  
}
void kxPanelDock::SlotTimeout()
{
  showIcon=!showIcon;
  if (showIcon) blinkTimer.start(1200);
  else blinkTimer.start(750);  
  update();
  paintWM();
}
void kxPanelDock::paintWM()
{
	DrawIcon(icon);
  if (ENGINE->loggedOn())
  {
    switch(ENGINE->getStatus())
    {
      case STATUS_AWAY:
        status="Away";
        break;
      case STATUS_NA:
        status="NA";
        break;
      case STATUS_OCCUPIED:
        status="Occupied";
        break;
      case STATUS_FFC:
        status="FFChat";
        break;
      case STATUS_INVISIBLE:
        status="Invisible";
        break;
      case STATUS_DND:
        status="DND";
        break;
      case STATUS_OFFLINE:
        status="Offline";
        break;
      case STATUS_ONLINE:
      default:
        status="Available";
        break;
    }
    icon=1;
  }
  else
  {
    status="Offline";
    icon=2;
  }	
  if (MAINWINDOW->kxConfig.wmDock) DrawStatus(status.latin1());
  if (showIcon)
  {
      if (MAINWINDOW->kxConfig.wmDock) { DrawIcon(icon); DrawMessage(message.latin1()); }
  }
  else
  {
    if (MAINWINDOW->kxConfig.wmDock) { DrawIcon(0); DrawMessage(""); }
  }

}
void kxPanelDock::SlotUpdatePixmap()
{
  int mc=ENGINE->MESSAGE->countAllUnread();
  
  if ( mc>0 )
  {
    showIcon=TRUE;
 		switch(ENGINE->MESSAGE->getMessageInfo(ENGINE->MESSAGE->giveFirstAllUnread())->type)
 		{
 			case URL_TYPE:
 		    pixmap=MAINWINDOW->kxIcons.url;
 				break;			
 			case MESSAGE_TYPE:
 			default:
 		    pixmap=MAINWINDOW->kxIcons.message;
 		}
    blinkTimer.start(1000);
    message="New MSG";
  }
  else
  {
    message="";
    if (ENGINE->loggedOn()) 
    {
      switch(ENGINE->getStatus())
      {
        case STATUS_AWAY:
          pixmap=MAINWINDOW->kxIcons.away;
          break;
        case STATUS_NA:
          pixmap=MAINWINDOW->kxIcons.na;
          break;
        case STATUS_OCCUPIED:
          pixmap=MAINWINDOW->kxIcons.occupied;
          break;
        case STATUS_FFC:
          pixmap=MAINWINDOW->kxIcons.ffc;
          break;
        case STATUS_INVISIBLE:
          pixmap=MAINWINDOW->kxIcons.invisible;
          break;
        case STATUS_DND:
          pixmap=MAINWINDOW->kxIcons.dnd;
          break;                    
        case STATUS_OFFLINE:
          pixmap=MAINWINDOW->kxIcons.offline;
          break;
        case STATUS_ONLINE:
        default:
          pixmap=MAINWINDOW->kxIcons.online;
          break; 
      }
    }
    else 
    {
      pixmap=MAINWINDOW->kxIcons.offline;
    }
    showIcon=TRUE;
    blinkTimer.stop();     
  }  
  update();
  paintWM();
}
