#ifndef KXMAINWINDOW_H
#define KXMAINWINDOW_H

class kxLabel;
#include <qtimer.h>
#include <kxmessage.h>
#include <kapp.h>
#include <ktmainwindow.h>
//#include "kxcontactlist.h"
#include "v2_codes.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kpopupmenu.h>

class kxContactList;

struct kxIconStruct
{
  QPixmap available;
  QPixmap na;
  QPixmap dnd;
  QPixmap ffc;
  QPixmap occupied;
  QPixmap away;  
  QPixmap online;
  QPixmap offline; 
  QPixmap message;
  QPixmap url;
  QPixmap file;
  QPixmap history; 
  QPixmap invisible;
  QPixmap groupUp;
  QPixmap groupDown;
  QPixmap contactSMS;
  QPixmap contactInvisible;
	QPixmap contactVisible;
}  ;

struct kxConfigStruct
{
  // connection
  bool reconnect;
  int retry;
  bool retryAtFailure;

  // contact list
  bool popupMessageChatOnPress;
  bool popupMessageChatOnReceive;
  bool notifyContactOnAdding;
  bool ignoreContactAuth;
  bool saveGeometry;
  bool saveStatus;
  bool showOffline;
  bool showUnknown;
  bool showWaitAuth;
  bool transparant;
  bool effect3d;

  // startup
  bool autoConnect;
  bool stayOnTop;
  bool sticky;
  bool showDebug;

  //Dock
  bool kdeDock;
  bool wmDock;

  // auto away
  bool autoAway;
  bool autoUnAway;
  int awayTime;
  int naTime;

  bool askAwayMessage;
  QString awayMessage;
  QString naMessage;
  QString dndMessage;

  int lastStatus;
  bool hideIP;
  bool webStatus;

  bool useColor;

  bool useGroups;
  bool sortNick;
  bool sortStatus;
  bool sortGroup;

  bool rejectMessage;
  bool rejectUrl;
  bool rejectRest;

  bool byPassAuth;
  int minPort;
  int maxPort;

  QString lastName;
  QString firstName;
  QString email;
  bool authorize;

  QString server;
  Q_UINT32 serverPort;

  QString password;
  QString nick;
  UIN uin;

  QString encoderLanguage;

  bool useKDEColors;
  QColor backgroundColor;
  QColor selectedBackgroundColor;
  QColor textColor;
  QColor selectedTextColor;

};


class kxMainWindow;

#define MAINWINDOW kxMainWindow::getPointer()

class kxMainWindow : public KTMainWindow
{Q_OBJECT

public:
	kxMainWindow(const char *name = 0L);
	~kxMainWindow();
	
  static kxMainWindow *ptr;
  static kxMainWindow *getPointer() { return ptr; };

  QTimer autoAwayTimer;
  QTimer waitForAutoAwayTimer;
  bool waitForAutoAway;
  Q_UINT16 wantStatus;
  bool useGroups;
  bool showAuth;
  bool useKDEColors;
  QColor backgroundColor;
  QColor selectedBackgroundColor;
  QColor textColor;
  QColor selectedTextColor;

  void readConfig(); // read config
  void rereadConfig();
  void init();
  void loadIcons();
  QPixmap loadIcon( const QString&);
	
	kxContactList *list;
	int retryCounter;
	bool firstLoad;
	
	bool manualStatusChange;
	kxLabel *statusLabel;
	QPushButton *menuButton;
	KPopupMenu *popup;
  KPopupMenu *statusPopup;	

  struct kxConfigStruct kxConfig;
  struct kxIconStruct kxIcons;
	
  void makeSound(int);
  void updateIcon();
  void updateStatusMessage(int, QString);
  void setBasicInfo(QString, QString, QString, QString);
  QTimer tryConnect;
  
  // for docking  
  QPoint Mpos;
  QSize Msize;
  
  void showWindow();
  void hideWindow();
  	
public slots:
  void SlotConnect();
  void SlotMenuConnect();
  void SlotDisconnect();  
  void SlotConnected();
  void SlotConnecting();
  void SlotErrorString(QString);
  void SlotDisconnected(int);  
  void SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16);	
  void SlotContactChange(UIN);	
  void SlotChangeStatus(int);
  void SlotChangeStatusByMenu(int);
  void SlotStatusUpdate(int);
  void SlotStatusMessage(UIN, QString);
  void SlotLabelButton();
  void SlotAboutDialog();
  void SlotReportBug();
  void SlotReadMessage();  
  void SlotSettings();
  void SlotRandomSearch();
  void SlotNotLoggedOn();
  void SlotChangeInfo();
  void SlotAddNonICQ();

  void SlotRequestInfo(Q_UINT16, Q_UINT32, bool *);

  void SlotRequestAdd2List(Q_UINT32);

  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotNewFile(UIN,int,QString,QString, int);
  
  void SlotExit();
  void SlotSearch();
  void SlotCheckAutoAway();
  /** Try a connect on a timeout of a QTimer */
  void SlotTryConnect();
  void SlotWaitForAutoAway();

signals:
  void SignalNewMessage(UIN, kxMessageStruct);    
  void SignalExit();
  
protected:
  void closeEvent(QCloseEvent *);
  void timerEvent(QTimerEvent *);

private:

};
#endif

