/***************************************************************************
                          kxudp.h  -  description                              
                             -------------------                                         
    begin                : Wed Jun 23 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXUDP_H
#define KXUDP_H

#include "kxpacket.h"
#include "v2_codes.h"
#include "kxcontact.h"

#include <qwidget.h>
#include <qobject.h>
#include <qtimer.h>
#include <qsocketnotifier.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <kxmessage.h>

  /********************************************************
The following data constitutes fair use for compatibility.
*********************************************************/
static const Q_UINT8 table[] = {
 0x59, 0x60, 0x37 , 0x6B , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D,
 0x5E, 0x34, 0x6D , 0x36 , 0x50 , 0x3F , 0x6F , 0x67 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x47 , 0x63 , 0x39,
 0x50, 0x5F, 0x5F , 0x3F , 0x6F , 0x47 , 0x43 , 0x69 , 0x48 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A , 0x4A , 0x42,
 0x56, 0x40, 0x67 , 0x53 , 0x41 , 0x07 , 0x6C , 0x49 , 0x58 , 0x3B , 0x4D , 0x46 , 0x68 , 0x43 , 0x69 , 0x48,
 0x33, 0x31, 0x44 , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x41 , 0x07 , 0x6C , 0x69 , 0x48 , 0x33 , 0x51 , 0x54,
 0x5D, 0x4E, 0x6C , 0x49 , 0x38 , 0x4B , 0x55 , 0x4A , 0x62 , 0x46 , 0x48 , 0x33 , 0x51 , 0x34 , 0x6D , 0x36,
 0x50, 0x5F, 0x5F , 0x5F , 0x3F , 0x6F , 0x47 , 0x63 , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A,
 0x6A, 0x52, 0x6E , 0x3C , 0x51 , 0x34 , 0x6D , 0x36 , 0x50 , 0x5F , 0x5F , 0x3F , 0x4F , 0x37 , 0x4B , 0x35,
 0x5A, 0x4A, 0x62 , 0x66 , 0x58 , 0x3B , 0x4D , 0x66 , 0x58 , 0x5B , 0x5D , 0x4E , 0x6C , 0x49 , 0x58 , 0x3B,
 0x4D, 0x66, 0x58 , 0x3B , 0x4D , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64,
 0x55, 0x6A, 0x32 , 0x3E , 0x44 , 0x45 , 0x52 , 0x6E , 0x3C , 0x31 , 0x64 , 0x55 , 0x6A , 0x52 , 0x4E , 0x6C,
 0x69, 0x48, 0x53 , 0x61 , 0x4C , 0x39 , 0x30 , 0x6F , 0x47 , 0x63 , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D , 0x3E,
 0x64, 0x35, 0x3A , 0x3A , 0x5A , 0x6A , 0x52 , 0x4E , 0x6C , 0x69 , 0x48 , 0x53 , 0x61 , 0x6C , 0x49 , 0x58,
 0x3B, 0x4D, 0x46 , 0x68 , 0x63 , 0x39 , 0x50 , 0x5F , 0x5F , 0x3F , 0x6F , 0x67 , 0x53 , 0x41 , 0x25 , 0x41,
 0x3C, 0x51, 0x54 , 0x3D , 0x5E , 0x54 , 0x5D , 0x4E , 0x4C , 0x39 , 0x50 , 0x5F , 0x5F , 0x5F , 0x3F , 0x6F,
 0x47, 0x43, 0x69 , 0x48 , 0x33 , 0x51 , 0x54 , 0x5D , 0x6E , 0x3C , 0x31 , 0x64 , 0x35 , 0x5A , 0x00 , 0x00,
};

/** Time struct */
struct TIME
{
    Q_UINT16 year;
    Q_UINT8 month;
    Q_UINT8 day;
    Q_UINT8 hour;
    Q_UINT8 min;
};

/** Struct for messages */
struct MESSAGE
{
    int online;  								// 1=Online, 0=Offline
    TIME time;                  // Online=Localtime, Offline=Servertime
    Q_UINT32 sender;
    int length;
    char *message;
};

/** Struct for URLs */
struct URL
{
    int online;
    TIME time;
    Q_UINT32 sender;
    char *url;
    char *desc;
};

/** Struct for "You've been added" msgs */
struct ADDED
{
    int online;
    TIME time;
    Q_UINT32 sender;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    int auth_req;
    char *auth_text;
};

/** Struct for Search results */
struct SEARCH_RESULT
{
    Q_UINT32 uin;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    Q_UINT16 seq;

};

/** struct for Extended Search Results */
struct EXT_SEARCH_RESULT
{
    Q_UINT32 uin;
    char *city;
    char *state;
    Q_UINT16 country_code;
    Q_UINT16 age;
    Q_UINT8 sex;
    char *phone;
    char *home_page;
    char *about;
    Q_UINT16 seq;
};

struct keepAliveStruct
{
  int counter;
  int seq;
};

struct kxSeqStruct
{
  int seq;
  int seq2;
};


/**
	* KXicq class for UDP packet handling for server connection
	*
	* This class handles all the UDP functions.
	* It uses class kxPacket for the packet handling
	*
	* It handles ICQ version 5.
	* with almost all the v5 specifications !
	*
	*@short KXicq class for handling UDP server connection ICQ version 5
  *@author Herwin Jan Steehouwer
  *@version 0.1.1

  */

class kxUDP : public QObject, kxPacket
{
	Q_OBJECT
public:
	enum Reason { GoAway, Manual, ByServer, TimeOut, Sending };


signals:
};


#endif

