/***************************************************************************
                          kxtcp.h  -  description                              
                             -------------------                                         
    begin                : Sun Aug 15 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXTCP_H
#define KXTCP_H

#include <kxmessage.h>
#include <qdatastream.h>
#include "ksock.h"
#include <qobject.h>
#include "v2_codes.h"
#include "kxpacket.h"
//#include "kxaim.h"
#include <qcolor.h>
#include <kxudp.h>

bool kxDecryptClient(QByteArray *pkt, Q_UINT16 len, unsigned long version);
void kxEncryptClient(QByteArray *pkt, Q_UINT16 len, unsigned long version);

struct kxAddContactStruct;

typedef struct kxIncommingPacket
{
	QByteArray packet;
	Q_UINT16 length;
	KSocket *mySocket;
	Q_UINT16 totalRead;
};
	
typedef struct kxContactExchange
{
	UIN uin;
	char *nick;
};

typedef struct kxChatContactStruct
{
  UIN uin;
  QString nick;
  int br, bg, bb;  // background colors
  int fr, fg, fb;  // foreground colors
  int fontSize;    // font size  
  int fontFamily;  // font font family
  QString fontName;
  Q_UINT32 ip, realIp;
  Q_UINT32 port;
  KSocket *socket;
  int status; // chat packet status
  bool last; // last packets before chat session?
  QString text;
  QByteArray *buffer;
  int bufferLen;
};

typedef struct kxChatSessionStruct
{
  kxChatContactStruct ourInfo;
  KServerSocket *sockserver;
  QList<kxChatContactStruct> contact;
};


/**This class handles the TCP connection between ICQ clients.

It hadles TCP v2 at this moment !
  *@author Herwin Jan Steehouwer
  */

class kxTCP : public QObject, kxPacket  {
	Q_OBJECT
public:
	enum handShakeStatus{NONE=0, RECEIVED, SEND_WAIT_ACK, SEND_WAIT_HANDSHAKE, RECEIVE_WAIT_ACK, RECEIVE_WAIT_HANDSHAKE};

	kxTCP(Q_UINT32 _minPort, Q_UINT32 _maxPort);
  /** Get our port */
  Q_UINT16 getPort();
  Q_UINT32 getIntAddr();
  /** Get out addres */
  Q_UINT32 getAddr();
	~kxTCP();
  /** parse the packet */
  void parseData(QByteArray *a, KSocket *, int, bool _sendAck = 1);
  /** Send this packet */
  int send(Q_UINT16 _type, KSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _command=0, const char *_message=NULL, int port=0);
  
  int kxTCP::sendFileAccept(KSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _port=0);
  /** parse this message */
  void parseMessage(char *message, int type, Q_UINT32 uin , bool _usecolor=false, Q_UINT32 fg=0x00FFFFFF, Q_UINT32 bg=0x00 );
  /** connect to this IP */
  int connect(UIN uin);
  /** Send a packet, URL or MSG */
  int sendPacket(UIN _ruin, int _type,const char *_message=NULL, int _command=0,KSocket *_ks=NULL, int _seq=0,  int _port=0, kxMessageStruct *_ms=NULL); // UIN, int,char *);
  /** Send a TCP message */
  int sendMessage(UIN, char *, kxMessageStruct *_ms=NULL);
  /** Send a TCP URL */
  int sendUrl(UIN, char *, char *, kxMessageStruct *_ms=NULL);
  int sendRandomInfoRequest(UIN _uin);
  /** send the handshake */
  void sendHandshake(UIN , KSocket *);
  void sendHandshake_Ack(UIN , KSocket *);
  /**  */
  void parseContacts(char *, UIN);
  /** read the status message */
  int sendReadStatus(UIN, Q_UINT16 status);
  /** chat request */
  int sendChatRequest(UIN, const char *);
  int sendFileRequest(UIN _uin, const char *_message, const char *_file, Q_UINT32 _size);
  /** reject chat */
  int sendChatReject(UIN, Q_UINT32, const char *, KSocket *_k=NULL);
  /** reject chat */
  int sendFileReject(UIN, Q_UINT32, const char *, KSocket *_k=NULL);
  /** Accept chat */
  int sendChatAccept(UIN, Q_UINT32, int);
  /** Accept File */
  int sendFileAccept(UIN, Q_UINT32, int);
  /** delete this socket */
  void deleteSocket(UIN);
  int sendFileAcceptAck(KSocket *_ks, Q_UINT32 _ruin, Q_UINT32 _seq=0, int _port=0);
  int sendContacts(UIN _uin,QList<kxAddContactStruct> *lst);

  int InitBuffer(QByteArray *b, Q_UINT32 _ruin, Q_UINT32 uin, QString msg, Q_UINT16 command, Q_UINT16 status, Q_UINT16 type, Q_UINT16 commandType, Q_UINT32 _seq);

	
	KServerSocket *myServerSocket;	
	QList<kxIncommingPacket> packetList;
	Q_UINT16 sequence;
	UIN session_id;

	KServerSocket *getNextFreePort();
	
	QList<kxChatSessionStruct> chatSessions;
	
	Q_UINT32 freePort;
	Q_UINT32 minPort;
	Q_UINT32 maxPort;		
			
public slots:
  /** Accept  a incomming connection... */
  void SlotAccepted(KSocket *);
  /**  */
  void SlotReadEvent(KSocket *);
  /**  */
  void SlotWriteEvent(KSocket *);
  /**  */
  void SlotCloseEvent(KSocket *);

signals:
	/** there is a message for UIN */
	void receivedMessage(UIN, kxMessageStruct );
	/** there is a URL for UIN */
	void receivedUrl(UIN uin, kxMessageStruct);
	/** we got a Ack message */
	void receivedAck(int seq);
	/** we got a Chat Ack message */
	void receivedChatAck(int seq, int status, UIN uin,Q_UINT16 port, char *);

	/** we received a status message in the ack file !*/
	void receivedStatusMessage(UIN uin, char *message);
	void receivedRandomAck(UIN, char *);
  void receivedAskAddContact(UIN,QList<kxAddContactStruct> *);	
  void receivedUnknownStartPacket(QByteArray *, UIN, Q_UINT16);
  void receivedUnknownCancelPacket(QByteArray *, UIN, Q_UINT16);
  void SignalNewFile(UIN,int,QString, QString, int);
  void receivedHandshakeAck(UIN);
};

#endif

