/***************************************************************************
                          kxtcp.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Aug 15 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <config.h>

#include <qstring.h>
#include "kxtcp.h"
#include "kxaim.h"
#include <sys/time.h>
#include <unistd.h>
#include <sys/stat.h>
#include "kxengine.h"
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYSENT_H
#include <sysent.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>

static unsigned char client_check_data[] = {
  "As part of this software beta version Mirabilis is "
  "granting a limited access to the ICQ network, "
  "servers, directories, listings, information and databases (\""
  "ICQ Services and Information\"). The "
  "ICQ Service and Information may databases (\""
  "ICQ Services and Information\"). The "
  "ICQ Service and Information may\0"
};

void kxEncryptClient(QByteArray *pkt, Q_UINT16 len, unsigned long version)
{


  unsigned long B1, M1, check;
  unsigned int i;
  unsigned char X1, X2, X3;
  unsigned char *buf = (unsigned char*)pkt->data();
  unsigned char bak[6];
  unsigned long offset;
	unsigned long size = len;
	
	debug("Len: %d-%d",len, pkt->size());
  	
	
  if (version < 4)
    return;  // no encryption necessary.

  switch(version)
  {
    case 4:
    case 5:
      offset = 6;
      break;
    case 6:
    case 7:
    case 8:
    default:
      offset = 0;
  }


  // calculate verification data
  M1 = (rand() % ((size < 255 ? size : 255)-10))+10;
  X1 = buf[M1] ^ 0xFF;
  X2 = rand() % 220;
  X3 = client_check_data[X2] ^ 0xFF;
  if(offset) {
    for(i=0;i<6;i++)  bak[i] = buf[i];
    B1 = (buf[offset+4]<<24)|(buf[offset+6]<<16)|(buf[2]<<8)|buf[0];
  }
  else
    B1 = (buf[4]<<24)|(buf[6]<<16)|(buf[4]<<8)|(buf[6]);

  // calculate checkcode
  check = (M1 << 24) | (X1 << 16) | (X2 << 8) | X3;
  check ^= B1;
//  DEBUG_ENCRYPTION(("complete check %08lx\n", check));

  // main XOR key
  unsigned long key = 0x67657268 * size + check;

  // XORing the actual data
  for(i=0;i<(size+3)/4;i+=4){
    unsigned long hex = key + client_check_data[i&0xFF];
    buf[i+0] ^= hex&0xFF;buf[i+1] ^= (hex>>8)&0xFF;
    buf[i+2] ^= (hex>>16)&0xFF;buf[i+3] ^= (hex>>24)&0xFF;
  }

  // in TCPv4 are the first 6 bytes unencrypted
  // so restore them
  if(offset)  for(i=0;i<6;i++) buf[i] = bak[i];

  // storing the checkcode
  buf[offset+3] = (check>>24)&0xFF;
  buf[offset+2] = (check>>16)&0xFF;
  buf[offset+1] = (check>>8)&0xFF;
  buf[offset+0] = check&0xFF;
	
  unsigned char *bu=(unsigned char *)pkt->data();

  debug("Encode: buf[0] = %0X bu[0] = %0X", buf[0], bu[0]);
  debug("Encode: buf[0] = %0X bu[0] = %0X", buf[1], bu[1]);
  debug("Encode: buf[0] = %0X bu[0] = %0X", buf[2], bu[2]);
  debug("Encode: buf[0] = %0X bu[0] = %0X", buf[3], bu[3]);
	
}


bool kxDecryptClient(QByteArray *pkt, Q_UINT16 len, unsigned long version)
{
  unsigned long hex, key, B1, M1, check;
  unsigned int i;
  unsigned char X1, X2, X3;
  unsigned char *buf = (unsigned char*)pkt->data();
  unsigned char bak[6];
  unsigned long size = len;
  unsigned long offset;

  if(version < 4)
    return true;  // no decryption necessary.

  switch(version) {
  case 4:
  case 5:
    offset = 6;
    break;
  case 6:
  case 7:
  case 8:
  default:
    offset = 0;
  }

  // backup the first 6 bytes
  if(offset)
    for(i=0;i<6;i++)  bak[i] = buf[i];

  // retrieve checkcode
  check = (buf[offset+3]<<24)|(buf[offset+2]<<16)|(buf[offset+1]<<8)|(buf[offset+0]);


  // main XOR key
  key = 0x67657268 * size + check;

  for(i=4; i<(size+3)/4; i+=4) {
    hex = key + client_check_data[i&0xFF];
    buf[i+0] ^= hex&0xFF;buf[i+1] ^= (hex>>8)&0xFF;
    buf[i+2] ^= (hex>>16)&0xFF;buf[i+3] ^= (hex>>24)&0xFF;
  }

  // retrive validate data
  if(offset) {
    // in TCPv4 are the first 6 bytes unencrypted
    // so restore them
    for(i=0;i<6;i++) buf[i] = bak[i];
    B1 = (buf[offset+4]<<24)|(buf[offset+6]<<16)|(buf[2]<<8)|buf[0];
  }
  else
    B1 = (buf[4]<<24) | (buf[6]<<16) | (buf[4]<<8) | (buf[6]<<0);

  // special decryption
  B1 ^= check;

  // validate packet
  M1 = (B1 >> 24) & 0xFF;
  if(M1 < 10 || M1 >= size) {

    return false;
  }

  X1 = buf[M1] ^ 0xFF;
  if(((B1 >> 16) & 0xFF) != X1) {
    return false;
  }

  X2 = ((B1 >> 8) & 0xFF);
  if(X2 < 220) {
    X3 = client_check_data[X2] ^ 0xFF;
    if((B1 & 0xFF) != X3) {

      return false;
    }
  }

  return true;
}
int gethostbyname_r_portable(const char *szHostName, struct hostent *h)
{
// Linux
#if defined(__GLIBC__)
  struct hostent *h_buf;
  char temp[1024];
  int herror = 0;
  gethostbyname_r(szHostName, h, temp, 1024, &h_buf, &herror);
  return herror;
// Solaris
#elif defined(sun)
  struct hostent *h_buf;
  char temp[1024];
  int herror = 0;
  h_buf = gethostbyname_r(szHostName, h, temp, 1024, &herror);
  return herror;
// not sure about this one (actually pretty sure it's wrong)
// who uses OSF anyway?
#elif defined(__osf__)
  h = gethostbyname(szHostName);
  return h_error;
// Default to thread unsafe version
#else
#warning "I don't know how to do reentrant gethostbyname on this machine."
#warning "Using thread-unsafe version."
  struct hostent *h_buf;
  h_buf = gethostbyname(szHostName);
  if (h_buf != NULL) memcpy(h, h_buf, sizeof(struct hostent));
  return (h == NULL ? h_errno : 0);
#endif
}
bool getOwnIP()
{
	int sock=-1;
	int _port=3456;
	
	int t=0;
	struct sockaddr_in name;
	
	do
	{
		_port++;
    sock = ::socket( PF_INET, SOCK_STREAM, 0 );
    if (sock < 0)
    {
      warning( "Could not create socket\n");
      sock=-1;
      //return false;
    }

    name.sin_family = AF_INET;
    name.sin_port = htons( _port );
    name.sin_addr.s_addr = htonl(INADDR_ANY);

    if ( bind( sock, (struct sockaddr*) &name,sizeof( name ) ) < 0 )
    {
            warning("Could not bind to socket\n");
            ::close( sock );
            sock = -1;

    }

      if ( listen( sock, SOMAXCONN ) < 0 )
    {
            warning("Error listening on socket\n");
            ::close( sock );
            sock = -1;

    }
    t++;
    debug("sock: %d, t: %d",sock,t);
  }
  while(t<4 && sock==-1);

  struct sockaddr_in m_sLocalAddr=name;

  ksize_t  sizeofSockaddr = sizeof(struct sockaddr_in);
  if (getsockname(sock, (struct sockaddr *)&m_sLocalAddr, &sizeofSockaddr) < 0)
  {
  	debug("no IP ;-(");
    return false;
  }
  if (m_sLocalAddr.sin_addr.s_addr == INADDR_ANY)
  {
    char szHostName[256];
    if (gethostname(szHostName, 256) == -1)
    {
      strcpy(szHostName, "localhost");
      debug("no ip ;-(");
      return false;
    }
    struct hostent sLocalHost;
    h_errno = gethostbyname_r_portable(szHostName, &sLocalHost);
    if (h_errno != 0)
    {
    	debug("again no ip ;-( ");
      return false;
    }
    m_sLocalAddr.sin_addr.s_addr = *((unsigned long *)sLocalHost.h_addr);
    name.sin_addr.s_addr = *((unsigned long *)sLocalHost.h_addr);
  }

  Q_UINT32 ip=name.sin_addr.s_addr;
  Q_UINT8 p1, p2, p3, p4;
        p1=ip;
        ip>>= 8;
        p2=ip;
        ip>>=8;
        p3=ip;
        ip>>=8;
        p4=ip;
        debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);
  Q_UINT32 our_ip=name.sin_addr.s_addr;
  ENGINE->ourIntIP=our_ip;
  ::close(sock);
  return TRUE;
}


// ====================================

kxTCP::kxTCP(Q_UINT32 _minPort=1024, Q_UINT32 _maxPort=6500)
{
	sequence=1;
  chatSessions.setAutoDelete(TRUE);
	freePort=_minPort;
	minPort=_minPort;
	maxPort=_maxPort;

	debug("Max: %d, Min: %d",minPort, maxPort);
	//todo
	return;
	myServerSocket=getNextFreePort();
	if (!myServerSocket) 
	{
	  debug("error get port ;-( ");
	  return;
	}
  getOwnIP();
	debug("Got port: %d:%d",getAddr(), getPort());
	QObject::connect(myServerSocket, SIGNAL(accepted(KSocket *)), this, SLOT(SlotAccepted(KSocket *)));

	initPacket();
}

kxTCP::~kxTCP(){
	delete myServerSocket;
}

/** Get out addres */
Q_UINT32 kxTCP::getIntAddr(){
	return ENGINE->ourIntIP;
}
/** Get out addres */
Q_UINT32 kxTCP::getAddr(){
  return ENGINE->ourExtIP;	
}

/** Get our port */
Q_UINT16 kxTCP::getPort(){
	return freePort; //myServerSocket->port();	
}

/** Accept  a incomming connection... */
void kxTCP::SlotAccepted(KSocket *_ks){
	debug("=-=-=-=-=-= Incomming !!!=-=-=-=-=-=-=-=");
	debug("-> %d, %ld", _ks->socket(), _ks->ipv4_addr());
//	_ks->enableWrite(TRUE);
	_ks->enableRead(TRUE);		
	QObject::connect(_ks,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
	QObject::connect(_ks,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
	QObject::connect(_ks,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));
}


/**  */
void kxTCP::SlotReadEvent(KSocket *_ks){

	kxIncommingPacket *p;
	int len;
	Q_UINT16 packetLen;
	Q_UINT32 sock=_ks->socket();
	for (Q_UINT16 t=0; t<packetList.count(); t++)
	{
		p=packetList.at(t);
		if (p->mySocket==_ks)
		{
			if (p->length==0)
			{
				char *buf2=new char[3];		
				len=recv(sock, buf2, 2,0 );
			 	QByteArray  a; //=new QByteArray(2049);
				a.setRawData( buf2, len );
				QDataStream s( a, IO_ReadOnly );            // open on a's data
				s.setByteOrder(QDataStream::LittleEndian);	
				s >> (Q_UINT16 &)packetLen;		
				p->length=packetLen;
				p->totalRead=0;
				delete buf2;

				return;
			}
			QDataStream s(p->packet, IO_ReadWrite);
			s.setByteOrder(QDataStream::LittleEndian);
			
			char *buf=new char[p->length-p->totalRead+1];	
			len=recv(sock, buf, p->length-p->totalRead,0 );
			if (len>0)
			{	
				s.device()->at(p->totalRead);
				s.writeRawBytes(buf,len);	
				p->totalRead+=len;
				debug("packet: len: %d, %d",len, p->totalRead);
			}
			delete buf;
			if (p->totalRead>=p->length)
			{
				parseData(&p->packet, _ks, p->totalRead);
				packetList.remove(t);
			}
			return;
		}
	}
  p=new kxIncommingPacket;
  p->length=0;
  p->totalRead=0;
  p->mySocket=_ks;
  packetList.append(p);

 	char *buf2=new char[3];		
 	len=recv(sock, buf2, 2,0 );
 	QByteArray  a; //=new QByteArray(2049);
 	a.setRawData( buf2, len );
 	QDataStream s( a, IO_ReadOnly );            // open on a's data
 	s.setByteOrder(QDataStream::LittleEndian);	
 	s >> (Q_UINT16 &)packetLen;		
 	p->length=packetLen;
 	p->totalRead=0;
 	a.resetRawData(buf2, len);
 	delete buf2;
}

/**  */
void kxTCP::SlotCloseEvent(KSocket *_ks){
	packetDef *p;
	int t;
	for (t=0; t<count(); t++)
	{
		p=getPacket(t);
		if (p->mySocket==_ks)
		{
			p->mySocket=NULL;
			t=count();
			continue;
		}
	}
	debug("delete _ks ?");
	kxContactStruct cs;
	for (t=0; t<ENGINE->CONTACT->count(); t++)
	{
		cs=ENGINE->CONTACT->getContact(t);
		if (cs.mySocket==_ks)
		{
					ENGINE->CONTACT->updateSocket(cs.uin, NULL);
					debug("sock bound to user !! delete");
		}
	}
	delete _ks;
}

/** parse the packet */
void kxTCP::parseData(QByteArray *a, KSocket *_ks, int len,bool _sendAck = 1)
{
	QDataStream s( *a, IO_ReadOnly );            // open on a's data
	s.setByteOrder(QDataStream::LittleEndian);	
	
	Q_UINT32 uin, uin2, ip, ip2, port, seq=0x0, hversion, rport;
	Q_UINT16 version , command, unknown_1, type, length;
	Q_UINT16 status, commandType;
	Q_UINT32 chatPort;
	char *message=0;
	char *filename=0;
	bool useColor=FALSE;
	Q_UINT8 tmp;

	debug("[TCP]=========================[receive]=======================");	
	debug("packet: len: %d",len);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (int t=0; t<len; t++)
	{	
		s >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps);		
    if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }				
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[end receive]=======================");

	
	Q_UINT8 handshake;
	s.device()->at(0);
	s >> (Q_UINT8 &)handshake;
	if (handshake==0xff)
	{
		debug("HandShake");
		kxContactStruct cs;
 		for (int t=0; t<ENGINE->CONTACT->count(); t++)
		{
			 cs=ENGINE->CONTACT->getContact(t);
			 if (cs.mySocket==_ks)
			 {
			   debug( "status: %d",cs.handshakeStatus);
			 	 if (cs.handshakeStatus==SEND_WAIT_HANDSHAKE)
			 	 {
			 	 		debug("Ok, have REVERSE !!");

			 	 		ENGINE->CONTACT->setHandshakeStatus((UIN)cs.uin,(int) RECEIVED);			 	 		
			 	 		sendHandshake_Ack(cs.uin, _ks);
			 	 		emit receivedHandshakeAck(cs.uin);
			 	 		return;
			 	 }
			 }
		}		
		s >> (Q_UINT16 &)hversion;
		switch(hversion)
		{
			case 2:
			case 3:
			case 4:
			case 5:
			{
		  	Q_UINT16 u16;
        s >> (Q_UINT16 &)u16;			
    		s >> (Q_UINT32 &)port;
    		s >> (Q_UINT32 &)uin;
    		s >> (Q_UINT32 &)ip;
    		s >> (Q_UINT32 &)ip2;
    		s >> (Q_UINT8  &)tmp;
    		s >> (Q_UINT32 &)rport;		
   		}
   		break;
      case 6:
      case 7:
      case 8:
      {
      	Q_UINT16 u16;
      	Q_UINT32 u32, ruin;
      	   s >> (Q_UINT16 &)u16;
    		s >> (Q_UINT32 &)ruin;
    		s >> (Q_UINT16 &)u16;    		
    		s >> (Q_UINT32 &)port;
    		s >> (Q_UINT32 &)uin;
    		s >> (Q_UINT32 &)ip;
    		s >> (Q_UINT32 &)ip2;
    		s >> (Q_UINT8  &)tmp;
    		s >> (Q_UINT32 &)rport;
    		s >> (Q_UINT32 &)u32;		
    		s >> (Q_UINT32 &)u32;
    		s >> (Q_UINT32 &)u32; 		

      }
    }
//		send(TCP_MSG_MSG, _ks, uin, 0);
//		sendHandshake(uin, _ks);
		debug("verion :%d, uin:%d, port: %d",hversion, uin, port);
    Q_UINT8 p1, p2, p3, p4;
  	p1=ip;
  	ip>>= 8;
  	p2=ip;
  	ip>>=8;
  	p3=ip;
  	ip>>=8;
  	p4=ip;
  	debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);		
//    Q_UINT8 p1, p2, p3, p4;
  	p1=ip2;
  	ip2>>= 8;
  	p2=ip2;
  	ip2>>=8;
  	p3=ip2;
  	ip2>>=8;
  	p4=ip2;
  	debug("IP2: [%d] %02d.%02d.%02d.%02d",ip2, p1, p2, p3, p4);		
		
//		kxContactStruct cs;
		for (int t=0; t<ENGINE->CONTACT->count(); t++)
		{
			cs=ENGINE->CONTACT->getContact(t);
			if (cs.uin==uin)
			{
				debug("found already sock !");
				if (cs.mySocket)
				{
					delete cs.mySocket;
					ENGINE->CONTACT->updateSocket(cs.uin, NULL);
					debug("Deleted sock");
				}
				ENGINE->CONTACT->updateSocket(uin,_ks, hversion);
				debug("Version: %d - %d",cs.tcpVersion, hversion);
		 	  if ((hversion==6 || hversion==7))
		 	  {
		 	  	debug("V6 or V7 send Ack !");
 		 	 	  sendHandshake_Ack(cs.uin, _ks);
 		 	 	  debug("Ack send..");
 		 	 	  ENGINE->CONTACT->setHandshakeStatus((UIN)cs.uin,(int) RECEIVE_WAIT_ACK);
 		 	 	  debug("Now send handshake");
 		 	 	  sendHandshake(cs.uin, _ks);	
 		 	 	  debug("Handshake send..");	 	 	
		 	  }
			}
		}
	} else
	{
	 if (handshake==0x01)  // need to be fixed !
	 {
	   debug("Got Handshake Ack !");
	 	 kxContactStruct cs;
 		 for (int t=0; t<ENGINE->CONTACT->count(); t++)
		 {
			 cs=ENGINE->CONTACT->getContact(t);
			 if (cs.mySocket==_ks)
			 {
			 	 debug("Ok Set REVERSE..%d, ",cs.handshakeStatus);
			 	 if (cs.handshakeStatus==SEND_WAIT_ACK)
			 	 {
  				 ENGINE->CONTACT->setHandshakeStatus((UIN)cs.uin, (int)SEND_WAIT_HANDSHAKE);			 	
			 	 }
			 	 else
			 	 {
			 	 	 if (cs.handshakeStatus!=RECEIVED)
			 	 	 {
			 	 	   debug("Is Last");
			 	 	   ENGINE->CONTACT->setHandshakeStatus((UIN)cs.uin,(int) RECEIVED);			 	 		
		 	 		   sendHandshake_Ack(cs.uin, _ks);
		 	 		   emit receivedHandshakeAck(cs.uin);
		 	 		 }
			 	 }			 	 	
			 	 return;
			 }
		 }
	 }
	 else
	 {
	  int backColor, foreColor;
	  int receivedVersion=0x0;
	  kxContactStruct cs;
 		for (int t=0; t<ENGINE->CONTACT->count(); t++)
		{
			 cs=ENGINE->CONTACT->getContact(t);
			 if (cs.mySocket==_ks)
			 {
			 	receivedVersion=cs.tcpVersion;
			 	uin=cs.uin;
			 	continue;			 	
			 }
		}		
		chatPort=0;
		s.device()->at(0);
		switch(receivedVersion)
		{
			case 2:
			case 3:
			case 4:
			case 5:
  			{
      		s >> (Q_UINT32 &)uin;
      		s >> (Q_UINT16 &)version;
      		s >> (Q_UINT16 &)command;
      		s >> (Q_UINT16 &)unknown_1;
      		s >> (Q_UINT32 &)uin2;
      		s >> (Q_UINT16 &)type;
      		s >> (Q_UINT16 &)length;
          message=new char[length+1];
          s.readRawBytes(message, length);
      		s >> (Q_UINT32 &)ip;
      		s >> (Q_UINT32 &)ip2;
      		s >> (Q_UINT32 &)port;
      		s >> (Q_UINT8  &)tmp;		
      		s >> (Q_UINT16 &)status;
      		s >> (Q_UINT16 &)commandType;
     	  }
     	  break;
      case 6:
      case 7:
      case 8:
        {
        	kxDecryptClient(a, len,receivedVersion);
        	s.device()->at(0);
	debug("[TCP]=========================[receive]=======================");	
	debug("packet: len: %d",len);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (int t=0; t<len; t++)
	{	
		s >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps);		
    if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }				
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[end receive]=======================");
	s.device()->at(0);        	
        	version=receivedVersion;
        	Q_UINT32 checksum;
        	Q_UINT16 unknown;
        	s >> (Q_UINT32 &)checksum;        	
        	s >> (Q_UINT16 &)command;
        	s >> (Q_UINT16 &)unknown;
        	s >> (Q_UINT16 &)seq;
        	debug("Seq: %d",seq);
        	s >> (Q_UINT32 &)checksum;        	
        	s >> (Q_UINT32 &)checksum;        	
        	s >> (Q_UINT32 &)checksum;        	
        	s >> (Q_UINT16 &)type;
        	s >> (Q_UINT16 &)status;
      		s >> (Q_UINT16 &)commandType;
        	s >> (Q_UINT16 &)length;
          message=new char[length+1];
          s.readRawBytes(message, length);  	
					if (type!=TCP_MSG_CHAT && !(type==TCP_MSG_FILE && command==TCP_ACK))
					{
          	s >> (Q_UINT32 &)foreColor;        	
          	s >> (Q_UINT32 &)backColor;        	
					}
          useColor=TRUE;
        }
        break;
    }
		
    debug("verion :%d, uin:%d, port: %d", version, uin, port);
    if (receivedVersion<=4)
    {
      Q_UINT8 p1, p2, p3, p4;
    	p1=ip;
    	ip>>= 8;
    	p2=ip;
    	ip>>=8;
    	p3=ip;
    	ip>>=8;
    	p4=ip;
    	debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);		
  //    Q_UINT8 p1, p2, p3, p4;
    	p1=ip2;
    	ip2>>= 8;
    	p2=ip2;
    	ip2>>=8;
    	p3=ip2;
    	ip2>>=8;
    	p4=ip2;
    	debug("IP2: [%d] %02d.%02d.%02d.%02d",ip2, p1, p2, p3, p4);		
  	}
    QString sessionContact;
		
		if(type==TCP_MSG_CHAT && status==0)
		{
			Q_UINT16 len, ioport, none;
//			Q_UINT8 c;
//			Q_UINT32 zero;
			s >> (Q_UINT16 &)len;			
      char *session=new char[len+1];
      s.readRawBytes(session, len);
      debug("Chat session with: %d, %s",len, session);
      sessionContact=session;
      delete session;
			s >> ( Q_UINT16 &)ioport;
			s >> (Q_UINT16 &)none;
			s >> (Q_UINT32 &)chatPort;					
			//s >> ( Q_UINT32 &) zero;
			if (chatPort==0) chatPort=(ioport>>8) | ((ioport&255)<<8);
						
			debug("Got ports: %d, %d",chatPort, ioport);
		}
		Q_UINT32 flen;
		if (type==TCP_MSG_FILE && command==TCP_START)
		{
		  Q_UINT16 len;
		  Q_UINT32 junk;
 		                           
		  s >> (Q_UINT32 &)junk;
 		  s >> (Q_UINT16 &)len;
      filename=new char[len+1];
      s.readRawBytes(filename, len);
      s >> (Q_UINT32 &)flen;      
		  s >> (Q_UINT32 &)junk;
		  
		  debug("Got file: [%s] size: %d",filename, flen);
		}
    if (type==TCP_MSG_FILE && command==TCP_ACK)
    {
    		debug("Got File tranfer Ack..");
        Q_UINT32 rp1,zero, p1;
        Q_UINT16 len;
        Q_UINT8 c; 
       	s >> ( Q_UINT32 &) rp1;    //port
 				s >> (Q_UINT16 &)len;			
  			for (int t=0; t<len; t++)
  				s>> (Q_UINT8 &)c;
       	s >> ( Q_UINT32 &) zero;		// file size =0 in ACK
       	s >> ( Q_UINT32 &) p1;	    // port normal
       	chatPort=p1;
  			debug("With Port: %X, %d, %d",p1, p1, zero);
    }
    debug("Sequence: %d",seq);
		if (receivedVersion<=4) s >> (Q_UINT32 &)seq;

		debug( "[TCP] UIN: %d, Seq: %d, command, %d(%x), lenmsg: %d, Type: %X version: %d, status: %d, commandType: %d(%x)",uin, seq, command, command, strlen(message), type, version, status, commandType, commandType);
//		debug( "[TCP] %X, %X, %X, %X, %X",command,  type, type|0x8000, type^0x8000, type&0x8000);

//debug("type: %X",type);					
		if (type>0x8000)
		{
			debug("Mass message !");
			type^=0x8000;
		}
		debug("type: %X",type);					
		
		switch(command)
		{
			case TCP_ACK:
				debug("got ack, %d - %d", chatPort, seq);
				emit receivedAck(seq);
				if (type==TCP_MSG_CHAT || type==TCP_MSG_FILE)
					emit receivedChatAck(seq, status, uin, chatPort, message);
				if (strlen(message)>0 && !( ( type==TCP_MSG_CHAT || type==TCP_MSG_FILE || type==0x3EE) ))
				{
				  debug("this");
					emit receivedStatusMessage(uin, message);
				}
				if (type==0x3EE)
				{
				  debug("or this");
				  emit receivedRandomAck(uin, message);
				}
				return;
				break;
			case TCP_START:
     		switch(type)
     		{
     			case TCP_MSG_MSG:
     				debug("got message");
     				parseMessage(message, type, uin, useColor, foreColor, backColor);
     				send(type, _ks, uin, seq);
     				break;
     			case TCP_MSG_URL:
     				debug("got URL");
     				parseMessage(message, type, uin, useColor, foreColor, backColor);
     				send(type, _ks, uin, seq);
     				break;
     			case TCP_MSG_FILE:
    			  {
     			  bool haveUser=FALSE;
//     				debug("got file %d - %d",ENGINE->CONTACT->getContact(uin).uin, ENGINE->kxConfig.rejectChat);
     				debug("File: message: %s",message);
     				
     				kxContactStruct cs;
           	for (int t=0; t<ENGINE->CONTACT->count(); t++)
           	{
           		cs=ENGINE->CONTACT->getContact(t);
           		if (cs.uin==uin)
           		{
           			haveUser=TRUE; 			
           		}
           	}
           	if (!haveUser)
           	{
           	  break;
//todo           		ENGINE->SlotAddUser(uin,"","","","",0);
           		ENGINE->CONTACT->updateSocket(uin, _ks);
           	}
           	emit SignalNewFile(uin,seq,QString(message), QString(filename),flen);
            //kxFile *fileXfer;
            //fileXfer=new kxFile(uin,GOT_FILE_REQUEST,seq,"", message);
            //fileXfer->show(); 
     				break;
     				}
     			case TCP_MSG_CHAT:
/*todo     				{
   					bool haveUser=FALSE;
   					
   					debug("chat: %d - %d",ENGINE->CONTACT->getContact(uin).uin, ENGINE->kxConfig.rejectChat);
                        if ((ENGINE->CONTACT->getContact(uin).uin==0 && ENGINE->kxConfig.rejectChat) || (ENGINE->currentStatus!=STATUS_FFC && ENGINE->currentStatus!=STATUS_ONLINE) ) 
                      	{
                      	  debug("reject chat !");
                         	  
                      	  QString tmp;
                      	  if (!(ENGINE->currentStatus!=STATUS_FFC && ENGINE->currentStatus!=STATUS_ONLINE))
                      	    tmp=i18n("User not accept chat from user that are not in his contact list!");
                      	  else
                      	    tmp.sprintf("User is %s:\n\r%s",ENGINE->CONTACT->status2str(ENGINE->currentStatus),
                      	      ENGINE->getAwayMessage(ENGINE->currentStatus).latin1());
                          sendChatReject(uin,seq,tmp.latin1(), _ks );	  
                      	  return;
                      	}	  		
                      	kxContactStruct cs;
                       	for (int t=0; t<ENGINE->CONTACT->count(); t++)
                       	{
                       		cs=ENGINE->CONTACT->getContact(t);
                       		if (cs.uin==uin)
                       		{
                       			haveUser=TRUE; 			
                       		}
                       	}
                       	if (!haveUser)
                       	{
                       		ENGINE->SlotAddUser(uin,"","","","",0);
                       		ENGINE->CONTACT->updateSocket(uin, _ks);
                       	}
                     kxChat2 *c=new kxChat2(uin, CHAT_GOT_REQUEST, seq, message);
//     				kxChatRequest *c=new kxChatRequest(uin, CHAT_GOT_REQUEST, message, sessionContact, seq, chatPort);
     				debug("show request");
     				if (c) c->show();
     				} */
     				break;
     			case TCP_MSG_READAWAY:
     				debug("got read Away");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READOCCUPIED:
     				debug("got read Occupied");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READNA:
     				debug("got read NA");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READDND:
     				debug("got read DND");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READFFC:
     				debug("got read FFC");
     				send(type, _ks, uin);
     				break;
     			case 0x03EE:
     				debug("got ??? TCP 3ee");
     				send(type, _ks, uin);
     				break;     			
     			case TCP_MSG_WAV: //must do !
            break;
     			case TCP_MSG_CONTACT:
     				debug("got contact exchange");
     				parseContacts(message, uin);
     				send(type, _ks, uin, seq);
     				break;
     			default:
     			  emit receivedUnknownStartPacket(a, uin, type);
     		}			
     		break;
   		case TCP_CANCEL:
   			debug("TCP cancel");
   			switch(type)
   			{
   				case TCP_MSG_CHAT:
   					status=1; // BAD !!
   					emit receivedChatAck(seq, status, uin, chatPort, message);
   					break;
   				default:
   				  emit receivedUnknownCancelPacket(a, uin, type);
   			}
   			break;
   	}
	 }
  }
}

/** parse this message */
void kxTCP::parseMessage(char *_message, int type,Q_UINT32 _uin , bool _usecolor=false, Q_UINT32 fg=0x00FFFFFF, Q_UINT32 bg=0x00){
	if (type==TCP_MSG_MSG)
	{
    kxMessageStruct message;
    message.uin = _uin;                   
    message.type=MESSAGE_TYPE;
    message.send=FALSE;
    message.useColor=FALSE;
  
    message.message=_message;    

    message.online = 1;
    QDate tmpDate(QDate::currentDate());
    QTime tmpTime(QTime::currentTime());

    message.dateTime.setDate(tmpDate);
    message.dateTime.setTime(tmpTime);
    message.useColor=_usecolor;
    Q_UINT32 c=fg;
    Q_UINT8 p1, p2, p3, p4;
  	p1=c;
  	c>>= 8;
  	p2=c;
  	c>>=8;
  	p3=c;
  	c>>=8;
  	p4=c;
    message.foreground.setRgb(p1,p2,p3);
    c=bg;
  	p1=c;
  	c>>= 8;
  	p2=c;
  	c>>=8;
  	p3=c;
  	c>>=8;
  	p4=c;
    message.background.setRgb(p1,p2,p3);
    emit receivedMessage((UIN)_uin, message);
	}
	else
	{
	  kxMessageStruct message;
	  
    message.uin = _uin;                   
    message.type=MESSAGE_TYPE;
    message.send=FALSE;
    message.useColor=FALSE;
  
    message.online = 1;
    QDate tmpDate(QDate::currentDate());
    QTime tmpTime(QTime::currentTime());

    message.dateTime.setDate(tmpDate);
    message.dateTime.setTime(tmpTime);      
    
//  	char *tmp1=_message;
  	int tlen=strlen(_message);
    char tmpdelim[ 2 ];
    tmpdelim[ 0 ] = 0xFE;
    tmpdelim[ 1 ] = '\0';
    char *desc = kxicqStrSep( &_message, tmpdelim );
    char *_url = kxicqStrSep( &_message, "" );
    bool del=FALSE;
    if (tlen-1<=(int)strlen(desc)) 
    {
      _url=new char[2];
      _url[0]=0;
      del=TRUE;
    }      
    message.message=desc;
  	message.url=_url;
  	if (del) delete _url;
        
    emit receivedUrl((UIN)_uin, message);
	}
}

/** Send this packet */
int kxTCP::send(Q_UINT16 _type, KSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _command=0, const char *_message=NULL, int _port=0){
// to UIN _ruin, int _type,const char *_message=NULL, int _command=0,KSocket *_ks=NULL, int _seq=0,  int _port=0
	return sendPacket(_ruin, _type, _message, _command, _ks, _seq, _port);
}

/**  */
void kxTCP::SlotWriteEvent(KSocket *_ks)
{
	packetDef *p, *pc;
	for (int t=0; t<count(); t++)
	{
		p=getPacket(t);
		if (p->mySocket==_ks)
		{
			
			QByteArray *b=p->packet;
			QByteArray a;
			QDataStream s(a, IO_ReadWrite);
			s.setByteOrder(QDataStream::LittleEndian);
			s << (Q_UINT16) p->length;
			
			int ret=::send(_ks->socket(), a.data(), 2, 0);
			if (ret > 0)
			{
	QDataStream s1(*p->packet, IO_ReadWrite);
	s1.setByteOrder(QDataStream::LittleEndian);
	s1.device()->at(0);
	Q_UINT16 len=p->length;
	debug("[TCP]=========================[SEND]=======================");	
	debug("packet: len: %d",len);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (int t1=0; t1<len; t1++)
	{	
		s1 >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps.latin1());		
		if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }		
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[SEND]=======================");
	if (len<=0) { debug("PAKET iz SERO !!!!!!!!!!!!!!!!!!!!! ;-(("); delete _ks; return; }
  s1.device()->at(2);
				ret=::send(_ks->socket(), b->data(), p->length, 0);
				if (ret > 0 )
				{
					_ks->enableWrite(FALSE);
					debug("Send TCP ok !(%d, %d)", ret, p->length );
					deletePacket(t);
					bool found=FALSE;
					kxContactStruct cs;
					for (int t=0; t<ENGINE->CONTACT->count(); t++)
					{
						cs=ENGINE->CONTACT->getContact(t);
						if (cs.mySocket==_ks)
						{
							found=TRUE;
							debug("sock bound to user ! !");
						}
					}					
					if (found==FALSE)
					{
						debug("sock not bound, delete !");
						delete _ks;
					}
					else
					{
  					for (int t1=0; t1<count(); t1++)
  					{
  						pc=getPacket(t1);
  						
  						if (pc->mySocket==_ks)
  						{
  							_ks->enableWrite(TRUE);
  							t1=count();
  							continue;
  						}
  					}
  			  }
					return;
				}
			}
		}
	}
}

/** connect to this IP */
int kxTCP::connect(UIN uin)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(uin);
  
	if (p.mySocket) return p.mySocket->socket();
	if (p.port==0 || p.ip==0) return -1;
	Q_UINT32 ip;	
	if (p.intIp) debug("Use Internal IP %d",p.realIp);
	if (p.intIp) ip=p.realIp; else ip=p.ip;
//  ip=p.realIp;
	Q_UINT32 l=icqToIp(ip);
/*	l1=l;
	Q_UINT8 p1, p2, p3, p4;
	p1=l;
	l>>= 8;
	p2=l;
	l>>=8;
	p3=l;
	l>>=8;
	p4=l;
	l=l1;
	debug("IP: [%d] %02d.%02d.%02d.%02d:%d",p.ip, p1, p2, p3, p4, p.port);
	QString sip;
	sip.sprintf("%02d.%02d.%02d.%02d",p1, p2, p3, p4);*/
	KSocket *_ks;
//	debug ("IP: %s:%d",ip.latin1(), p.port);
  debug("we use IP: %s",QString("%4.%3.%2.%1").arg(l>>24).arg((l>>16) & 0xFF).arg((l>>8) & 0xFF).arg(l & 0xFF).latin1());
	_ks=new KSocket(QString("%1.%2.%3.%4").arg(l & 0xFF).arg((l>>8) & 0xFF).arg((l>>16) & 0xFF).arg(l>>24).latin1(), p.port);
	debug("new KSocket");
	if (_ks->socket()!=-1)
	{
		_ks->enableRead(TRUE);
		QObject::connect(_ks,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
		QObject::connect(_ks,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
		QObject::connect(_ks,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));
		ENGINE->CONTACT->updateSocket(uin, _ks);
		ENGINE->CONTACT->setHandshakeStatus((UIN)uin, (int)SEND_WAIT_ACK);		
		sendHandshake(uin, _ks);
		return _ks->socket();
	}
	else
	{
		delete _ks;
	}
	return -1;
}
void kxTCP::sendHandshake_Ack(UIN _ruin, KSocket *_ks)
{
	debug("Send Handshake Ack");
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	Q_UINT32 ok=0x01;
	s << (Q_UINT32 ) ok;
	length=4;
	addPacket2List(_ks, _ruin);
	_ks->enableWrite(TRUE);   	

}
/** send the handshake */
void kxTCP::sendHandshake(UIN _ruin, KSocket *_ks)
{
	debug("Send HandShake");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32  ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr()),port=getPort(), uin=ENGINE->ourUin;
  Q_UINT16 zero=0, version;
  
	Q_UINT32 chatPort=0x0;
	Q_UINT8 hs=0xff, mode=0x04;	 // mode = DIRECT
	bool doAck=FALSE;
	
	switch(contacts->getContact(_ruin).tcpVersion)
	{
		case 2:
		case 3:
  	case 4:
		case 5:
			{
				version=0x0002;
      	s << ( Q_UINT8  ) hs;
      	s << ( Q_UINT16 ) version;	
       	s << ( Q_UINT16 ) zero;
      	s << ( Q_UINT32 ) port;
      	s << ( Q_UINT32 ) uin;
      	s << ( Q_UINT32 ) ip;	
      	s << ( Q_UINT32 ) lip;		
      	s << ( Q_UINT8  ) mode;
      	s << ( Q_UINT32 ) chatPort;	
      	
      	//	debug("ack Packet to send: command: %Xd (%d)",command,command);
				doAck=TRUE;
      	length=1+2+2+4+4+4+4+1+4;
       }		
			break;
/*			{
				version=0x04;
      	s << ( Q_UINT8  ) hs;
      	s << ( Q_UINT16 ) version;	
       	s << ( Q_UINT16 ) zero;
      	s << ( Q_UINT16 ) zero;
      	s << ( Q_UINT16 ) zero;
      	s << ( Q_UINT32 ) uin;
      	s << ( Q_UINT32 ) ip;	
      	s << ( Q_UINT32 ) lip;		
      	s << ( Q_UINT8  ) tcpc;
      	s << ( Q_UINT32 ) port;	
      	
      	//	debug("ack Packet to send: command: %Xd (%d)",command,command);

      	length=1+2+2+4+4+4+4+1+4;
      	kxEncryptClient(byteArray, 0x04);
       }
       break;*/ // We do not yest support version 4 and 5 !
   case 6:
   case 7:
   case 8:
   		{
   			version=0x0007;
   			zero=0x0;
   			hs=0xFF;
        Q_UINT32 c1=0x00000050;
        Q_UINT32 c2=0x00000003;   			
        if (session_id==0)
        {
        	session_id=rand();
        	debug("session: %d",session_id);
        }
   			s << ( Q_UINT8  ) hs;
   			s << ( Q_UINT32 ) version;
   			s << ( Q_UINT32 ) _ruin;
				s << ( Q_UINT16 ) zero;
				s << ( Q_UINT32 ) port;
				s << ( Q_UINT32 ) uin;
      	s << ( Q_UINT32 ) lip;	
      	s << ( Q_UINT32 ) ip;		
      	s << ( Q_UINT8  ) mode;
      	s << ( Q_UINT32 ) port;					
        s << ( Q_UINT32 ) session_id;
        s << ( Q_UINT32 ) c1;
        s << ( Q_UINT32 ) c2;

        length=44;


      //  kxEncryptClient(byteArray, length, 0x06);   				   			
   			
   		}
   		break;
  }
	addPacket2List(_ks, _ruin);

	_ks->enableWrite(TRUE);   	
	if (doAck) emit receivedHandshakeAck(_ruin);
	debug("Length: %d",length);
}

/** Send a TCP message */
int kxTCP::sendMessage(UIN _uin, char *_message, kxMessageStruct *_ms=NULL)
{
  if (strlen(_message)>3000) _message[30001]=0; // max len ! UDP=450, TCP=30000
  char *txt=new char[strlen(_message)+2];
  sprintf(txt,"%s",_message);
	return sendPacket(_uin, TCP_MSG_MSG, txt, TCP_MESSAGE, NULL, 0, 0, _ms);		

}

/** Send a TCP URL */
int kxTCP::sendUrl(UIN _uin, char *_url, char *_message, kxMessageStruct *_ms=NULL)
{
  if (strlen(_message)>30000) _message[300001]=0; // max len ! UDP=450, TCP=30000
	char *txt=new char[strlen(_url)+strlen(_message)+2];
	sprintf(txt, "%s%c%s",_message, 0xFE, _url);
	return sendPacket(_uin, TCP_MSG_URL, txt, TCP_MESSAGE, NULL, 0, 0, _ms);		
}
int kxTCP::InitBuffer(QByteArray *b, Q_UINT32 _ruin, Q_UINT32 uin, QString msg, Q_UINT16 command, Q_UINT16 status, Q_UINT16 type, Q_UINT16 commandType, Q_UINT32 seq)
{
	QDataStream s(*b, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(0);

	Q_UINT32 ip=ipToIcq(getAddr()), port=myServerSocket->port(), lip=ipToIcq(getIntAddr());
	
	Q_UINT8 tmp=0x04;
	Q_UINT16 version;
	Q_UINT16 unknown=0x0;
	Q_UINT16 len=msg.length()+1;
	
	switch(contacts->getContact(_ruin).tcpVersion)
	{
		case 2:
		case 3:
		case 4:
		case 5:
			{
 				version=0x02;
 	
      	s << ( Q_UINT32 ) uin;
      	s << ( Q_UINT16 ) version;	
      	s << ( Q_UINT16 ) command;
      	s << ( Q_UINT16 ) unknown;
      	s << ( Q_UINT32 ) uin;	
      	s << ( Q_UINT16 ) type;		
      	s << ( Q_UINT16 ) len;
      	s.writeRawBytes(msg.latin1(),len);		
      	s << ( Q_UINT32 ) ip;		
      	s << ( Q_UINT32 ) lip;	
      	s << ( Q_UINT32 ) port;	
      	s << ( Q_UINT8 ) tmp;
      	s << ( Q_UINT16 ) status;			
      	
      	if (type==TCP_CHAT) commandType=0x0010;
      	
      	s << ( Q_UINT16 ) commandType;

     }
     length=4+2+2+2+4+2+2+4+4+4+1+2+len+2;
     break;
   case 6:
   case 7:
   case 8:
   	{
   		version=0x07;
   		Q_UINT32 zero=0;
   		unknown=0x000E;
   		
   		s << ( Q_UINT32 ) zero;
     	s << ( Q_UINT16 ) command;
     	s << ( Q_UINT16 ) unknown;
     	s << ( Q_UINT16 ) seq;
     	s << ( Q_UINT32 ) zero;
     	s << ( Q_UINT32 ) zero;
     	s << ( Q_UINT32 ) zero;
     	s << ( Q_UINT16 ) type;     	
     	s << ( Q_UINT16 ) status;
     	s << ( Q_UINT16 ) commandType;
     	s << ( Q_UINT16 ) len;
     	s.writeRawBytes(msg.latin1(),len);
     	length=4+2+2+2+4+4+4+2+2+2+2+len;
   	}
  }	
}
/** Send a packet, URL or MSG */
int kxTCP::sendPacket(UIN _ruin, int _type,const char *_message=NULL, int _command=0,KSocket *_ks=NULL, int _seq=0,  int _port=0, kxMessageStruct *_ms=NULL)
{
	debug("Send packet %d",_type);	
	kxContactStruct p=ENGINE->CONTACT->getContact(_ruin);
	Q_UINT32 seq;
	if (_seq==0) seq=sequence++; else seq=_seq;	
	
	if (!_ks)
	{
		_ks=p.mySocket;
		if (p.mySocket==NULL) return -1;
	}

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT16 command=_command,  type=_type, len=1, status=0x0, commandType=0x0;
//	Q_UINT16 version;
	if (_command==0) command=TCP_ACK;

	QString msg="";
	
  if (_message==NULL)
  {
  	switch(_type)
  	{
  		case TCP_MSG_READAWAY:
   		case TCP_MSG_READOCCUPIED:
   		case TCP_MSG_READNA:
   		case TCP_MSG_READDND:
   		case TCP_MSG_READFFC:
   		case 0x3EE:
  	 		msg=ENGINE->getStatusMessages(_type);	
   			break;		
  		default:
  			msg=ENGINE->getStatusMessages(ENGINE->currentStatus);
  			break;
  	}
  }
  else
  {
  	msg=_message;
  }

	switch(ENGINE->currentStatus)
	{
		case STATUS_ONLINE:
		case STATUS_INVISIBLE:
		case STATUS_FFC:
			status=TCP_STAT_ONLINE;
			break;
		case STATUS_AWAY:
			status=TCP_STAT_AWAY;
			break;
		case STATUS_NA:
			status=TCP_STAT_NA;
			break;
		case STATUS_DND:
			status=TCP_STAT_DND;
			break;
		case STATUS_OCCUPIED:
			status=TCP_STAT_OCCUPIED;
			break;
	}		
 	int clen=0;	
 	debug("Contact needs version: %d",contacts->getContact(_ruin).tcpVersion);

	debug("send %d, %d",status, commandType);

	InitBuffer(byteArray, _ruin, uin, msg, command, status, type, commandType, seq);
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	switch(contacts->getContact(_ruin).tcpVersion)
	{
		case 2:
		case 3:
		case 4:
		case 5:
		{		
       	if (_type==TCP_CHAT && status==0)
        	{
        		debug(" send chat commands");
        		Q_UINT16 len=0x1, z=0x0;
        		Q_UINT8 zero=0x0;
        		Q_UINT32 dx=0x0;
        		s << ( Q_UINT16 ) len;	
        		s << ( Q_UINT8 ) zero;	
        		s << ( Q_UINT16 ) z;	
        		s << ( Q_UINT16 ) z;	
        		s << ( Q_UINT32 ) dx;
        		clen=11;
        	}
        	s << ( Q_UINT32 ) seq;		
        	length+=clen+4;
  		}
  		break;
  		case 6:
  		case 7:
  		case 8:
  		{
       	bool useColor=FALSE;
       	if (_ms) { debug("_ms!!"); if (_ms->useColor) useColor=TRUE; }
       	debug("useColor: %d",useColor);
       	if (useColor)
       	{
       		int r,g,b, z=0;
       		_ms->foreground.rgb(&r, &g, &b);
       		s << ( Q_UINT8  ) r;
       		s << ( Q_UINT8  ) g;
       		s << ( Q_UINT8  ) b;     		
       		s << ( Q_UINT8  ) z;
       		debug("Color: %02X%02X%02X",r,g,b);    		
       		_ms->background.rgb(&r, &g, &b); 		     		

       		s << ( Q_UINT8  ) r;
       		s << ( Q_UINT8  ) g;
       		s << ( Q_UINT8  ) b;     		
       		s << ( Q_UINT8  ) z;
       		debug("Color: %02X%02X%02X",r,g,b);     		
       	}
       	else
       	{     	
       		Q_UINT32 zero=0x00;
       	  s << ( Q_UINT32 ) zero; 			//color ?
       	  s << ( Q_UINT32 ) 0x00FFFFFF; // color?     	     	
       	}  		
       	length+=4+4;
   	     	kxEncryptClient(byteArray, length, 0x06); 		
  		}
  		break;
 	}

	debug("Packet to send: command: %d, %X (%d)",seq,command,command);
	debug("len: %d, %d, %d",length, len, clen);
	
	s.device()->at(0);
	debug("[TCP]=========================[tmp send]=======================");	
	debug("packet: len: %d",length);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (Q_UINT16 t=0; t<length; t++)
	{	
		s >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps.latin1());
		if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }				
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[end tmp send]=======================");

	addPacket2List(_ks, _ruin);

	_ks->enableWrite(TRUE);   	
	return sequence-1;

}

/**  */
void kxTCP::parseContacts(char *_msg, UIN _uin)
{
  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';

  char *p1,*p, *n = kxicqStrSep( &_msg, tmpdelim );
  debug("Contacts: %s", n);
  QList<kxAddContactStruct> list;
  kxAddContactStruct *c;

//  delete p;
  do
  {
  	p  = kxicqStrSep( &_msg, tmpdelim );
  	p1 = kxicqStrSep( &_msg, tmpdelim );
//        QString tmp=p1;
//todo        ENGINE->SlotConvertIncommingMessage(&tmp);
//        p1=tmp.latin1();
        //ENGINE->SlotConvertIncommingMessage((QString *)p1);
  	if (p)
  	{
  		debug("Ask to add: %s (%s)",p, p1);
   		c=new kxAddContactStruct;
  		c->nick=p1;
  		c->uin=atoi(p);
  		list.append(c);  		
  	}      
  }
  while(p);
  emit receivedAskAddContact(_uin,&list);
}

/** read the status message */
int kxTCP::sendReadStatus(UIN uin, Q_UINT16 status){
	char *message=new char[2];
	message[0]=0;
	Q_UINT16 type=0;
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			type=TCP_MSG_READAWAY; 			
 			break;
 		case STATUS_NA:
			type=TCP_MSG_READNA; 			 		
 			break;					
 		case STATUS_DND:								
			type=TCP_MSG_READDND; 			 		
 			break;								
 		case STATUS_OCCUPIED:
			type=TCP_MSG_READOCCUPIED; 			
 			break;
 		case STATUS_FFC:								
			type=TCP_MSG_READFFC; 			 		
 			break;
 	}
 	if (type>0) sendPacket(uin, type, message);
 	return 0;
}


/** Accept chat */
int kxTCP::sendChatAccept(UIN _uin, Q_UINT32 _seq, int _port)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);

	if (p.mySocket==NULL) return -1;
	KSocket *_ks=p.mySocket;
	return send((Q_UINT16)TCP_CHAT, _ks, _uin, _seq, TCP_ACK, "", _port);
}

/** Accept chat */
int kxTCP::sendFileAccept(UIN _uin, Q_UINT32 _seq, int _port)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);

	if (p.mySocket==NULL) return -1;
	KSocket *_ks=p.mySocket;
	return sendFileAcceptAck( _ks, _uin, _seq, _port);
}


/** reject chat */
int kxTCP::sendChatReject(UIN _ruin, Q_UINT32 _seq, const char *_message, KSocket *_k)
{
// send ack back...
  KSocket *_ks;
  if (_k==NULL)
  {
	  kxContactStruct p=ENGINE->CONTACT->getContact(_ruin);
	  if (p.mySocket==NULL) return -1;
	  _ks=p.mySocket;
	}
	else
	{
	  debug("send to unknown");
	  _ks=_k;
	}
	
	debug("Send Chat reject %d, %d, %s",_ruin, _seq, _message);
	char *msg=new char[strlen(_message)];
	strcpy(msg,_message);	
		debug("Send file accept packet %d", _seq);	
	
	return send((Q_UINT16) TCP_CHAT, _ks, _ruin, _seq, TCP_CANCEL, msg);

}
/** reject chat */
int kxTCP::sendFileReject(UIN _uin, Q_UINT32 _seq, const char *_message, KSocket *_k)
{
// send ack back...
  KSocket *_ks=NULL;
  if (_k==NULL)
  {
	  kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	  if (p.mySocket==NULL) return -1;
	  _ks=p.mySocket;
	}
	else
	{
	  debug("send to unknown");
	  _ks=_k;
	}
	
	debug("Send Chat reject %d, %d, %s",_uin, _seq, _message);
	QString msg=_message;

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 seq=_seq;
	Q_UINT16 command=TCP_ACK;
//	Q_UINT16 unknown=0x0;
	Q_UINT16 type=TCP_FILE;
	Q_UINT16 status=TCP_STAT_REFUSE;
	Q_UINT16 commandType=0x00;

  InitBuffer(byteArray, _uin, uin, msg, command, status, type, commandType, seq);
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

 	debug(" send file reject commands");
 	Q_UINT16 p1=0, rp1=0 ; //((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);;
 	Q_UINT16 zero=0x0, zero1=0x1;
 	
 	s << ( Q_UINT32 ) rp1;    //port
 	s << ( Q_UINT16 ) zero1;  //file length
 	s << ( Q_UINT8  ) zero;   // empty string
 	s << ( Q_UINT32 ) zero;		// file size =0 in ACK
 	s << ( Q_UINT32 ) p1;	    // port normal
		
 	length+=15;
 	switch(contacts->getContact(_uin).tcpVersion)
	{
		case 2:
		case 3:
		case 4:
		case 5:
			s << ( Q_UINT32 ) seq;		
			length+=4;
			break;
		case 6:
		case 7:
		case 8:
			kxEncryptClient(byteArray, length, 0x06); 		
			break;
	}
	
	debug("send %d, %d",status, commandType);
	debug("ack refuse Packet to send: command: %d, %Xd (%d)",seq, command,command);

	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}

/** chat request */
int kxTCP::sendChatRequest(UIN _uin, const char *_message)
{
	char *msg=new char[strlen(_message)+10];
	strcpy(msg, _message);
	msg[strlen(_message)]=0;
	debug("send Chat Request");
	return sendPacket(_uin, TCP_CHAT, msg);
}

/** delete this socket */
void kxTCP::deleteSocket(UIN uin){
	kxContactStruct p=ENGINE->CONTACT->getContact(uin);
	if (p.mySocket)
	{
		debug("delete socket");
		delete p.mySocket;
		ENGINE->CONTACT->updateSocket(uin, NULL);
	}
}

/** Send this packet */
int kxTCP::sendFileAcceptAck(KSocket *_ks, Q_UINT32 _ruin, Q_UINT32 _seq=0, int _port=0){
	debug("Send file accept packet %d", _seq);	
	
	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 seq=_seq;
	Q_UINT16 command=TCP_ACK;
	Q_UINT16 type=TCP_FILE;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0;
	
	QString msg="";

    InitBuffer(byteArray, _ruin, uin, msg, command, status, type, commandType, seq);
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

 	debug(" send file accept commands");
 	
 	_port=htons(_port);
 	Q_UINT16 p1=_port, rp1=((_port >> 8) & 0xFF) + ((_port & 0xFF) << 8)   ;
 	//((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);
 	Q_UINT16 zero=0x0, zero1=0x01;
	debug("Port: %d",p1);		
 	s << ( Q_UINT32 ) rp1;    //port
 	s << ( Q_UINT16 ) zero1;  //file length
 	s << ( Q_UINT8  ) zero;   // empty string
 	s << ( Q_UINT32 ) zero;		// file size =0 in ACK
 	s << ( Q_UINT32 ) p1;	    // port normal
 	length+=4+2+1+4+4;
 	
	switch(contacts->getContact(_ruin).tcpVersion)
	{
		case 2:
		case 3:
		case 4:
		case 5:
			s << ( Q_UINT32 ) seq;		
			length+=4;
			break;
		case 6:
		case 7:
		case 8:
			kxEncryptClient(byteArray, length, 0x06); 		
			break;
	}
	
	debug("send %d, %d",status, commandType);
	debug("ack Packet to send: command: %d, %Xd (%d)",seq, command,command);

	addPacket2List(_ks, _ruin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}
/** chat request */
int kxTCP::sendFileRequest(UIN _uin, const char *_message, const char *_file, Q_UINT32 _size)
{
	debug("Send file request packet");	

	Q_UINT32 uin=ENGINE->ourUin;
//	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
//	Q_UINT32 port=myServerSocket->port();	
   Q_UINT32 seq=sequence++;
//	Q_UINT16 version=0x02;
	Q_UINT16 command=TCP_MESSAGE;
//	Q_UINT16 unknown=0x0;
	Q_UINT16 type=TCP_FILE;
//	Q_UINT16 len=1;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0010;
//	Q_UINT8 tmp=0x04;
	
	QString msg=_message;

     InitBuffer(byteArray, _uin, uin, msg, command, status, type, commandType, seq);
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

/*	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8 ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15
	s << ( Q_UINT16 ) commandType;    //2   = 2         */

  Q_UINT16 fnl=0;
  Q_UINT32 flen=_size;

  msg=_file;
  fnl=msg.length()+1;

 	Q_UINT16 p1=0x0; //_port, rp1=((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);;
  debug("File size: %d, Filename: %s",flen, msg.latin1()); 			
  s << (Q_UINT16 )p1;
  s << (Q_UINT16 )p1;  
  s << (Q_UINT16 )fnl;
  s.writeRawBytes(msg.latin1(), fnl);
  s << (Q_UINT32 )flen;      
  s << (Q_UINT32 )p1;

	length+=2+2+2+4+4+msg.length()+1;
		
	switch(contacts->getContact(_uin).tcpVersion)
	{
		case 2:
		case 3:
		case 4:
		case 5:
			s << ( Q_UINT32 ) seq;		
			length+=4;
			break;
		case 6:
		case 7:
		case 8:
			kxEncryptClient(byteArray, length, 0x06); 		
			break;
	}

	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	if (p.mySocket==NULL) return -1;
	KSocket *_ks=p.mySocket;

	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;

}

KServerSocket* kxTCP::getNextFreePort()
{
  KServerSocket *tmp;
  bool done=FALSE;
  debug("Try: %d",freePort);
  tmp=new KServerSocket(freePort);
	while (tmp->socket()==-1)
	{
	  debug("error: %d, try next",freePort);
		delete tmp;
		freePort++;
		if (freePort>maxPort)
		{
		  freePort=minPort;
		  if (done) return NULL;
		  done=TRUE;
		}		
		debug("Try: %d",freePort);
		tmp=new KServerSocket(freePort);		
	}
	debug("Port: %d, freePort: %d",tmp->port(), freePort);

	return tmp;
}
/** chat request */
int kxTCP::sendRandomInfoRequest(UIN _uin)
{
	debug("Send random request packet");	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
	Q_UINT32 port=myServerSocket->port();
	Q_UINT32 seq=sequence++;
	Q_UINT16 version=0x06;
	Q_UINT16 command=TCP_MESSAGE;
	Q_UINT16 unknown=0x0;
	Q_UINT16 type=0x3EE;
	Q_UINT16 len=1;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0010;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	
	char *msg;
  msg=new char[2];
	msg[0]=0;
	len=1;
  
	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8 ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15
	s << ( Q_UINT16 ) commandType;    //2   = 2
 	
	s << ( Q_UINT32 ) seq;		

	length=18+21+len;

	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	if (p.mySocket==NULL) return -1;
	KSocket *_ks=p.mySocket;

	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}
int kxTCP::sendContacts(UIN _uin,QList<kxAddContactStruct> *lst)
{
	debug("Send CONTATCS");	

  QString t;
	QCString msg;
	
	QByteArray data;
	QDataStream d(data, IO_ReadWrite);	

	msg.sprintf("%d",lst->count());
  d.writeRawBytes(msg.data(), msg.length());
	kxAddContactStruct *li;
	for (int t1=0; t1<(int)lst->count(); t1++)
	{
	  li=lst->at(t1);
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(QString().setNum(li->uin),(QString().setNum(li->uin)).length());
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(li->nick.latin1(),li->nick.length());
	}
	d << (Q_UINT8) 0xFE;
	d << (Q_UINT8) 0x00;	
	
  char *txt=new char[data.size()+2];
  sprintf(txt,"%s",data.data());
	return sendPacket(_uin, TCP_MSG_CONTACT, txt);		
	
}
