#ifndef KXSEND_H
#define KXSEND_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <kxmessage.h>
#include <v2_codes.h>
#include <qtimer.h>
#include <qlist.h>
class kxAddContactStruct;


class kxSend : public QObject
{
  Q_OBJECT
public:
  kxSend(int, int, UIN, QString, QString, bool, QColor _fg, QColor _bg,  bool _useColor=FALSE);
  kxSend(int, UIN, QList<kxAddContactStruct> *, bool);
  
  QTimer sendTimer;
  kxMessageStruct message;
  int sendAck;
  int sendSeq;
  bool send;
  QList<kxAddContactStruct> *contactList;
  
  int type; // 1 = UDP, 0 = TCP;
  
  UIN uin;
  void init();    
  void sendToServer();
  void sendToClient();
  void cancelSend();  
  
public slots:
  void SlotTimeout();
  void SlotReceivedAck(Q_UINT16);
  void SlotReceivedErrorAck(Q_UINT16, Q_UINT16);

  void SlotSendToClient(UIN);
  
signals:
  void SignalSendToClientError(int);
  void SignalSendToClientOk(int);
  void SignalSendToServerError(int);
  void SignalSendToServerOk(int);

};

#endif

