#include <kxcountry.h>
#include <qdict.h>

QString kxCountry::getCountry(QString num)
{
	init();
	return countryDict[num.latin1()];
}
QString kxCountry::getCode(QString country)
{
	init();
	
  QDictIterator<char> it( countryDict ); // iterator for dict

  while ( it.current() ) {
      if (  it.current()==country)
      {
      	QString num=it.currentKey().latin1();
      	return num;
      }
      ++it;
  }
	return QString::null;
}
Q_UINT16 kxCountry::getCountryNum(QString _num)
{
	if (_num.length()==0) _num="0";
	init();
	
  QDictIterator<char> it( countryDict ); // iterator for dict

  Q_UINT16 num=0;
  while ( it.current() ) {
      if (  it.currentKey()==_num)
      {
      	return num;
      }
      num++;
      ++it;
  }
	return 0;
}


QString kxCountry::getGMT(QString num)
{
	gmtInit();
	return gmtDict[num.latin1()];
}
QString kxCountry::getGMTCode(QString country)
{
	gmtInit();
	
  QDictIterator<char> it( gmtDict ); // iterator for dict

  while ( it.current() ) {
      if (  it.current()==country)
      {
      	QString num=it.currentKey().latin1();
      	return num;
      }
      ++it;
  }
	return QString::null;
}
int kxCountry::getGMTNum(QString _num)
{
	if (_num.length()==0) _num="-100";
	gmtInit();
	
  QDictIterator<char> it( gmtDict ); // iterator for dict

  Q_UINT16 num=0;
  while ( it.current() ) {
      if (  it.currentKey()==_num)
      {
      	return num;
      }
      num++;
      ++it;
  }
	return 0;
}

QString kxCountry::getOccupation(QString num)
{
	occupationInit();
	return occupationDict[num.latin1()];
}
QString kxCountry::getOccupationCode(QString country)
{
	occupationInit();
	
  QDictIterator<char> it( occupationDict ); // iterator for dict

  while ( it.current() ) {
      if (  it.current()==country)
      {
      	QString num=it.currentKey().latin1();
      	return num;
      }
      ++it;
  }
	return QString::null;
}
Q_UINT16 kxCountry::getOccupationNum(QString _num)
{
	occupationInit();
	
  QDictIterator<char> it( occupationDict ); // iterator for dict

  Q_UINT16 num=0;
  while ( it.current() ) {
      if (  it.currentKey()==_num)
      {
      	return num;
      }
      num++;
      ++it;
  }
	return 0;
}

QString kxCountry::getLang(QString num)
{
	langInit();
	return langDict[num.latin1()];
}
QString kxCountry::getLangCode(QString country)
{
	langInit();
	
  QDictIterator<char> it( langDict ); // iterator for dict

  while ( it.current() ) {
      if (  it.current()==country)
      {
      	QString num=it.currentKey().latin1();
      	return num;
      }
      ++it;
  }
	return QString::null;
}
Q_UINT16 kxCountry::getLangNum(QString _num)
{
	langInit();
	
  QDictIterator<char> it( langDict ); // iterator for dict

  Q_UINT16 num=0;
  while ( it.current() ) {
      if (  it.currentKey()==_num)
      {
      	return num;
      }
      num++;
      ++it;
  }
	return 0;
}
QString kxCountry::getMonth(QString num)
{
	monthInit();
	return monthDict[num.latin1()];
}
QString kxCountry::getMonthCode(QString country)
{
	monthInit();
	
  QDictIterator<char> it( monthDict ); // iterator for dict

  while ( it.current() ) {
      if (  it.current()==country)
      {
      	QString num=it.currentKey().latin1();
      	return num;
      }
      ++it;
  }
	return QString::null;
}
Q_UINT16 kxCountry::getMonthNum(QString _num)
{
	monthInit();
	
  QDictIterator<char> it( monthDict ); // iterator for dict

  Q_UINT16 num=0;
  while ( it.current() ) {
      if (  it.currentKey()==_num)
      {
      	return num;
      }
      num++;
      ++it;
  }
	return 0;
}
void kxCountry::gmtInit()
{
	gmtDict.resize(51);
gmtDict.insert("-100"," ");
gmtDict.insert("24","GMT -12:00");
gmtDict.insert("23","GMT -11:30");
gmtDict.insert("22","GMT -11:00");
gmtDict.insert("21","GMT -10:30");
gmtDict.insert("20","GMT -10:00");
gmtDict.insert("19","GMT -09:30");
gmtDict.insert("18","GMT -09:00");
gmtDict.insert("17","GMT -08:30");
gmtDict.insert("16","GMT -08:00");
gmtDict.insert("15","GMT -07:30");
gmtDict.insert("14","GMT -07:00");
gmtDict.insert("13","GMT -06:30");
gmtDict.insert("12","GMT -06:00");
gmtDict.insert("11","GMT -05:30");
gmtDict.insert("10","GMT -05:00");
gmtDict.insert("9","GMT -04:30");
gmtDict.insert("8","GMT -04:00");
gmtDict.insert("7","GMT -03:30");
gmtDict.insert("6","GMT -03:00");
gmtDict.insert("5","GMT -02:30");
gmtDict.insert("4","GMT -02:00");
gmtDict.insert("3","GMT -01:30");
gmtDict.insert("2","GMT -01:00");
gmtDict.insert("1","GMT -00:30");
gmtDict.insert("0","GMT +00:00");
gmtDict.insert("-1","GMT +00:30");
gmtDict.insert("-2","GMT +01:00");
gmtDict.insert("-3","GMT +01:30");
gmtDict.insert("-4","GMT +02:00");
gmtDict.insert("-5","GMT +02:30");
gmtDict.insert("-6","GMT +03:00");
gmtDict.insert("-7","GMT +03:30");
gmtDict.insert("-8","GMT +04:00");
gmtDict.insert("-9","GMT +04:30");
gmtDict.insert("-10","GMT +05:00");
gmtDict.insert("-11","GMT +05:30");
gmtDict.insert("-12","GMT +06:00");
gmtDict.insert("-13","GMT +06:30");
gmtDict.insert("-14","GMT +07:00");
gmtDict.insert("-15","GMT +07:30");
gmtDict.insert("-16","GMT +08:00");
gmtDict.insert("-17","GMT +08:30");
gmtDict.insert("-18","GMT +09:00");
gmtDict.insert("-19","GMT +09:30");
gmtDict.insert("-20","GMT +10:00");
gmtDict.insert("-21","GMT +10:30");
gmtDict.insert("-22","GMT +11:00");
gmtDict.insert("-23","GMT +11:30");
gmtDict.insert("-24","GMT +12:00");

}
void kxCountry::init()
{	
	countryDict.resize(250);
//	countryDict.setAutoDelete(TRUE);

	countryDict.insert("0","");
	countryDict.insert("93","Afghanistan");
	countryDict.insert("355" , "Albania");
	countryDict.insert("213" , "Algeria");
	countryDict.insert("684" , "American Samoa");
	countryDict.insert("376" , "Andorra");
	countryDict.insert("244" , "Angola");
	countryDict.insert("809" , "Anguilla");
countryDict.insert("268" , "Antigua");
countryDict.insert("54" , "Argentina");
countryDict.insert("374" , "Armenia");
countryDict.insert("297" , "Aruba");
countryDict.insert("247" , "Ascension Island");
countryDict.insert("61" , "Australia");
countryDict.insert("672" , "Australian External Territories");
countryDict.insert("43" , "Austria");
countryDict.insert("994" , "Azerbaijan");
countryDict.insert("242" , "Bahamas");
countryDict.insert("246" , "Barbados");
countryDict.insert("973" , "Bahrain");
countryDict.insert("880" , "Bangladesh");
countryDict.insert("375" , "Belarus");
countryDict.insert("32" , "Belgium");
countryDict.insert("501" , "Belize");
countryDict.insert("229" , "Benin");
countryDict.insert("809" , "Bermuda");
countryDict.insert("975" , "Bhutan");
countryDict.insert("284" , "British Virgin Islands");
countryDict.insert("591" , "Bolivia");
countryDict.insert("387" , "Bosnia and Hercegovina");
countryDict.insert("267" , "Botswana");
countryDict.insert("55" , "Brazil");
countryDict.insert("284" , "British V.I.");
countryDict.insert("673" , "Brunei Darussalm");
countryDict.insert("359" , "Bulgaria");
countryDict.insert("226" , "Burkina Faso");
countryDict.insert("257" , "Burundi");
countryDict.insert("855" , "Cambodia");
countryDict.insert("237" , "Cameroon");
countryDict.insert("1" , "Canada");
countryDict.insert("238" , "Capr Verde Islands");
countryDict.insert("1" , "Caribbean Nations");
countryDict.insert("345" , "Cayman Islands");
countryDict.insert("238" , "Cape Verdi");
countryDict.insert("236" , "Central African Republic");
countryDict.insert("235" , "Chad");
countryDict.insert("56" , "Chile");
countryDict.insert("86" , "China (People's Republic)");
countryDict.insert("886" , "China-Taiwan");
countryDict.insert("57" , "Colombia");
countryDict.insert("269" , "Comoros and Mayotte");
countryDict.insert("242" , "Congo");
countryDict.insert("682" , "Cook Islands");
countryDict.insert("506" , "Costa Rica");
countryDict.insert("385" , "Croatia");
countryDict.insert("53" , "Cuba");
countryDict.insert("357" , "Cyprus");
countryDict.insert("420" , "Czech Republic");
countryDict.insert("45" , "Denmark");
countryDict.insert("246" , "Diego Garcia");
countryDict.insert("767" , "Dominca");
countryDict.insert("809" , "Dominican Republic");
countryDict.insert("253" , "Djibouti");
countryDict.insert("593" , "Ecuador");
countryDict.insert("20" , "Egypt");
countryDict.insert("503" , "El Salvador");
countryDict.insert("240" , "Equatorial Guinea");
countryDict.insert("291" , "Eritrea");
countryDict.insert("372" , "Estonia");
countryDict.insert("251" , "Ethiopia");
countryDict.insert("500" , "Falkland Islands");
countryDict.insert("298" , "Faroe (Faeroe) Islands (Denmark)");
countryDict.insert("679" , "Fiji");
countryDict.insert("358" , "Finland");
countryDict.insert("33" , "France");
countryDict.insert("596" , "French Antilles");
countryDict.insert("594" , "French Guiana");
countryDict.insert("241" , "Gabon (Gabonese Republic)");
countryDict.insert("220" , "Gambia");
countryDict.insert("995" , "Georgia");
countryDict.insert("49" , "Germany");
countryDict.insert("233" , "Ghana");
countryDict.insert("350" , "Gibraltar");
countryDict.insert("30" , "Greece");
countryDict.insert("299" , "Greenland");
countryDict.insert("473" , "Grenada/Carricou");
countryDict.insert("671" , "Guam");
countryDict.insert("502" , "Guatemala");
countryDict.insert("224" , "Guinea");
countryDict.insert("245" , "Guinea-Bissau");
countryDict.insert("592" , "Guyana");
countryDict.insert("509" , "Haiti");
countryDict.insert("504" , "Honduras");
countryDict.insert("852" , "Hong Kong");
countryDict.insert("36" , "Hungary");
countryDict.insert("354" , "Iceland");
countryDict.insert("91" , "India");
countryDict.insert("62" , "Indonesia");
countryDict.insert("98" , "Iran");
countryDict.insert("964" , "Iraq");
countryDict.insert("353" , "Ireland (Irish Republic; Eire)");
countryDict.insert("972" , "Israel");
countryDict.insert("39" , "Italy");
countryDict.insert("225" , "Ivory Coast (La Cote d'Ivoire)");
countryDict.insert("876" , "Jamaica");
countryDict.insert("81" , "Japan");
countryDict.insert("962" , "Jordan");
countryDict.insert("7" , "Kazakhstan");
countryDict.insert("254" , "Kenya");
countryDict.insert("855" , "Khmer Republic (Cambodia/Kampuchea)");
countryDict.insert("686" , "Kiribati Republic (Gilbert Islands)");
countryDict.insert("82" , "Korea, Republic of (South Korea)");
countryDict.insert("850" , "Korea, People's Republic of (North Korea)");
countryDict.insert("965" , "Kuwait");
countryDict.insert("996" , "Kyrgyz Republic");
countryDict.insert("371" , "Latvia");
countryDict.insert("856" , "Laos");
countryDict.insert("961" , "Lebanon");
countryDict.insert("266" , "Lesotho");
countryDict.insert("231" , "Liberia");
countryDict.insert("370" , "Lithuania");
countryDict.insert("218" , "Libya");
countryDict.insert("423" , "Liechtenstein");
countryDict.insert("352" , "Luxembourg");
countryDict.insert("853" , "Macao");
countryDict.insert("389" , "Macedonia");
countryDict.insert("261" , "Madagascar");
countryDict.insert("265" , "Malawi");
countryDict.insert("60" , "Malaysia");
countryDict.insert("960" , "Maldives");
countryDict.insert("223" , "Mali");
countryDict.insert("356" , "Malta");
countryDict.insert("692" , "Marshall Islands");
countryDict.insert("596" , "Martinique (French Antilles)");
countryDict.insert("222" , "Mauritania");
countryDict.insert("230" , "Mauritius");
countryDict.insert("269" , "Mayolte");
countryDict.insert("52" , "Mexico");
countryDict.insert("691" , "Micronesia (F.S. of Polynesia)");
countryDict.insert("373" , "Moldova");
countryDict.insert("33" , "Monaco");
countryDict.insert("976" , "Mongolia");
countryDict.insert("473" , "Montserrat");
countryDict.insert("212" , "Morocco");
countryDict.insert("258" , "Mozambique");
countryDict.insert("95" , "Myanmar (former Burma)");
countryDict.insert("264" , "Namibia (former South-West Africa)");
countryDict.insert("674" , "Nauru");
countryDict.insert("977" , "Nepal");
countryDict.insert("31" , "Netherlands");
countryDict.insert("599" , "Netherlands Antilles");
countryDict.insert("869" , "Nevis");
countryDict.insert("687" , "New Caledonia");
countryDict.insert("64" , "New Zealand");
countryDict.insert("505" , "Nicaragua");
countryDict.insert("227" , "Niger");
countryDict.insert("234" , "Nigeria");
countryDict.insert("683" , "Niue");
countryDict.insert("850" , "North Korea");
countryDict.insert("1 670" , "North Mariana Islands (Saipan)");
countryDict.insert("47" , "Norway");
countryDict.insert("968" , "Oman");
countryDict.insert("92" , "Pakistan");
countryDict.insert("680" , "Palau");
countryDict.insert("507" , "Panama");
countryDict.insert("675" , "Papua New Guinea");
countryDict.insert("595" , "Paraguay");
countryDict.insert("51" , "Peru");
countryDict.insert("63" , "Philippines");
countryDict.insert("48" , "Poland");
countryDict.insert("351" , "Portugal (includes Azores)");
countryDict.insert("1 787" , "Puerto Rico");
countryDict.insert("974" , "Qatar");
countryDict.insert("262" , "Reunion (France)");
countryDict.insert("40" , "Romania");
countryDict.insert("7" , "Russia");
countryDict.insert("250" , "Rwanda (Rwandese Republic)");
countryDict.insert("670" , "Saipan");
countryDict.insert("378" , "San Marino");
countryDict.insert("239" , "Sao Tome and Principe");
countryDict.insert("966" , "Saudi Arabia");
countryDict.insert("221" , "Senegal");
countryDict.insert("381" , "Serbia and Montenegro");
countryDict.insert("248" , "Seychelles");
countryDict.insert("232" , "Sierra Leone");
countryDict.insert("65" , "Singapore");
countryDict.insert("421" , "Slovakia");
countryDict.insert("386" , "Slovenia");
countryDict.insert("677" , "Solomon Islands");
countryDict.insert("252" , "Somalia");
countryDict.insert("27" , "South Africa");
countryDict.insert("34" , "Spain");
countryDict.insert("94" , "Sri Lanka");
countryDict.insert("290" , "St. Helena");
countryDict.insert("869" , "St. Kitts/Nevis");
countryDict.insert("508" , "St. Pierre &(et) Miquelon (France)");
countryDict.insert("249" , "Sudan");
countryDict.insert("597" , "Suriname");
countryDict.insert("268" , "Swaziland");
countryDict.insert("46" , "Sweden");
countryDict.insert("41" , "Switzerland");
countryDict.insert("963" , "Syrian Arab Republic (Syria)");
countryDict.insert("689" , "Tahiti (French Polynesia)");
countryDict.insert("886" , "Taiwan");
countryDict.insert("7" , "Tajikistan");
countryDict.insert("255" , "Tanzania (includes Zanzibar)");
countryDict.insert("66" , "Thailand");
countryDict.insert("228" , "Togo (Togolese Republic)");
countryDict.insert("690" , "Tokelau");
countryDict.insert("676" , "Tonga");
countryDict.insert("1 868" , "Trinidad and Tobago");
countryDict.insert("216" , "Tunisia");
countryDict.insert("90" , "Turkey");
countryDict.insert("993" , "Turkmenistan");
countryDict.insert("688" , "Tuvalu (Ellice Islands)");
countryDict.insert("256" , "Uganda");
countryDict.insert("380" , "Ukraine");
countryDict.insert("971" , "United Arab Emirates");
countryDict.insert("44" , "United Kingdom");
countryDict.insert("598" , "Uruguay");
countryDict.insert("1" , "USA");
countryDict.insert("7" , "Uzbekistan");
countryDict.insert("678" , "Vanuatu (New Hebrides)");
countryDict.insert("39" , "Vatican City");
countryDict.insert("58" , "Venezuela");
countryDict.insert("84" , "Viet Nam");
countryDict.insert("1 340" , "Virgin Islands");
countryDict.insert("681" , "Wallis and Futuna");
countryDict.insert("685" , "Western Samoa");
countryDict.insert("381" , "Yemen (People's Democratic Republic of)");
countryDict.insert("967" , "Yemen Arab Republic (North Yemen)");
countryDict.insert("381" , "Yugoslavia (discontinued)");
countryDict.insert("243" , "Zaire");
countryDict.insert("260" , "Zambia");
countryDict.insert("263" , "Zimbabwe");
}
void kxCountry::occupationInit()
{
	occupationDict.resize(20);
occupationDict.insert("0","");
occupationDict.insert("1","Academic");
occupationDict.insert("2","Administrative");
occupationDict.insert("3","Art/Entertainment");
occupationDict.insert("4","College Student");
occupationDict.insert("5","Computers");
occupationDict.insert("6","Community & Social");
occupationDict.insert("7","Education");
occupationDict.insert("8","Engineering");
occupationDict.insert("9","Financial Services");
occupationDict.insert("10","Government");
occupationDict.insert("11","High School Student");
occupationDict.insert("12","Home");
occupationDict.insert("13","ICQ - Providing Help");
occupationDict.insert("14","Law");
occupationDict.insert("15","Managerial");
occupationDict.insert("16","Manufacturing");
occupationDict.insert("17","Medical/Health");
}

void kxCountry::langInit()
{
langDict.resize(65);
langDict.insert("0","");
langDict.insert("1","Arabic");
langDict.insert("2","Bhojpuri");
langDict.insert("3","Bulgarian");
langDict.insert("4","Burmese");
langDict.insert("5","Cantonese");
langDict.insert("6","Catalan");
langDict.insert("7","Chinese");
langDict.insert("8","Croatian");
langDict.insert("9","Czech");
langDict.insert("10","Danish");
langDict.insert("11","Dutch");
langDict.insert("12","English");
langDict.insert("13","Esperanto");
langDict.insert("14","Estonian");
langDict.insert("15","Farci");
langDict.insert("16","Finnish");
langDict.insert("17","French");
langDict.insert("18","Gaelic");
langDict.insert("19","German");
langDict.insert("20","Greek");
langDict.insert("21","Hebrew");
langDict.insert("22","Hindi");
langDict.insert("23","Hungarian");
langDict.insert("24","Icelandic");
langDict.insert("25","Indonesian");
langDict.insert("26","Italian");
langDict.insert("27","Japanese");
langDict.insert("28","Khmer");
langDict.insert("29","Korean");
langDict.insert("30","Lao");
langDict.insert("31","Latvian");
langDict.insert("32","Lithuanian");
langDict.insert("33","Malay");
langDict.insert("34","Norwegian");
langDict.insert("35","Polish");
langDict.insert("36","Portuguese");
langDict.insert("37","Romanian");
langDict.insert("38","Russian");
langDict.insert("39","Serbo-Croatian");
langDict.insert("40","Slovak");
langDict.insert("41","Slovenian");
langDict.insert("42","Somali");
langDict.insert("43","Spanish");
langDict.insert("44","Swahili");
langDict.insert("45","Swedish");
langDict.insert("46","Tagalog");
langDict.insert("47","Tatar");
langDict.insert("48","Thai");
langDict.insert("49","Turkish");
langDict.insert("50","Ukrainian");
langDict.insert("51","Urdu");
langDict.insert("52","Vietnamese");
langDict.insert("53","Yiddish");
langDict.insert("54","Yoruba");
langDict.insert("55","Afrikaans");
langDict.insert("56","Bosnian");
langDict.insert("57","Persian");
langDict.insert("58","Albanian");
}
void kxCountry::monthInit()
{
monthDict.resize(13);
monthDict.insert("1","Januari");
monthDict.insert("2","Februari");
monthDict.insert("3","March");
monthDict.insert("4","April");
monthDict.insert("5","May");
monthDict.insert("6","June");
monthDict.insert("7","July");
monthDict.insert("8","August");
monthDict.insert("9","September");
monthDict.insert("10","Oktober");
monthDict.insert("11","November");
monthDict.insert("12","December");
}
