/***************************************************************************
                          kxaim.h  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001 by Herwin Jan Steehouwer
    email                : steehouwer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXAIM_H
#define KXAIM_H

#define BOS_WAITING_CONN_ACK 0x0001
#define BOS_WAITING_LOGIN_REPLAY 0x0002
#define AUTH_WAITING_CONN_ACK 0x0003

#include <qobject.h>
#include "kxpacket.h"
#include "kxsnac.h"
#include <ksock.h>
#include <qlist.h>
#include "kxtlv.h"
#include <v2_codes.h>
#include <kxmessage.h>
#include <qstringlist.h>

typedef struct kxAIMIncommingPacket
{
        QByteArray packet;
        Q_UINT8 channel;
        Q_UINT8 command;
        Q_UINT16 seq;
        Q_UINT16 length;
        KSocket *mySocket;
        Q_UINT16 totalRead;
};

/**KXicq AIM ICQ v7 protocol
  *@author Herwin Jan Steehouwer
  */

class kxAIM : public QObject,kxPacket, kxTLV, kxSNAC  {
	Q_OBJECT
public:
	enum Reason { GoAway, Manual, ByServer, TimeOut, Sending, NoCookie, ToManyRetries, NoServer };

	QString passwd;
	Q_UINT32 uin;
	bool myLoggedOn;
	Q_UINT32 messageSeq;
	int connectStatus;
	
	Q_UINT32 port;
	Q_UINT32 lanIP;
	Q_UINT32 wanIP;
	bool continueSendLogin;

  KSocket *aimSock;
  kxAIMIncommingPacket *incommingPacket;
  int connState;
  int state;
  Q_UINT16 ourStatus;
  char *cookie;
  Q_UINT16 searchSequence;

  QString server;
  Q_UINT32 serverPort;

  int seq;

	kxAIM(Q_UINT16, Q_UINT32);
	~kxAIM();
	
	void setFirstData(Q_UINT32, const QString &);
	
	void setServer(QString _s, Q_UINT32 _p) { server=_s; serverPort=_p; debug("Setted: %s:%d",server.latin1(), serverPort);};
  void parseData(const QByteArray *a, int len, Q_UINT8 command, Q_UINT8 channel, Q_UINT16 seq);
  void parseMessages(const QString&, Q_UINT16 msgType, char *msg, QDataStream *st, Q_UINT16 subType);
  /** Connect to the ICQ server the first time */
  /** Send cookie to the login server */
  void sendCookie();
  int connect(Q_UINT16 status=0x0000);
  void disconnect(Q_UINT16);
  void reconnect(QString server);

  /** No descriptions */
  void sendAuthRequest();
  /** No descriptions */
  void sendImICQ();

  void parseSNAC( QDataStream *s, int len);
  /** No descriptions */
  void sendRateRequest();
  void sendRateRequestAck();
  void sendICQMode();
  void sendUserInfo();
  /** No descriptions */
  void requestRightInfoLocationService();
  /** No descriptions */
  void requestPersonalInfo();
  /** No descriptions */
  void requestBOS();
  /** No descriptions */
  void requestICBM();
  /** No descriptions */
  void requestRightInfoBubbyList();
  void sendContactList();
  void sendVisibleList();
  void sendInvisibleList();

  void addToVisibleList(Q_UINT32);
  void removeFromVisibleList(Q_UINT32);
	void addToInvisibleList(Q_UINT32);
  void removeFromInvisibleList(Q_UINT32);

  void sendClientReady();
  void sendAckRequestOfflineMessages();
  void sendRequestOfflineMessages();
  int sendMessage(Q_UINT32, QString msg);
  int sendAdvanchedMessage(Q_UINT32, kxMessageStruct *message, QList<kxAddContactStruct> *lst=NULL);
  int sendUrl(Q_UINT32, QString msg, QString url);
  int sendRequestInfoOnUin( Q_UINT32 _uin);
  int sendRequestOwnInfo( Q_UINT32 _uin);
  int sendMetaSearchNick(QString,QString, QString);
  int sendMetaSearchEmail(QString);
  int sendAuthRequest( Q_UINT32 _uin, bool _given, QString _reason);
  int sendStatus( int _status);
  int sendStatusFull( int _status);
  void sendRequestStatusMessage(Q_UINT32);
  void sendAddUser2List(Q_UINT32);
  void sendRemoveUser2List(Q_UINT32);
  void sendReuqestMessage(Q_UINT32 _uin, Q_UINT8 _status);
  void sendMessage2Ack(Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT16, char *);
  int sendRequestInfo(Q_UINT32);
  void sendAddUser(Q_UINT32 _uin,QString, QString, QString, QString, bool auth=FALSE);
  int sendContacts(UIN,QList<kxAddContactStruct> *);
  void sendAuthRequest(Q_UINT32, const QString &);
  int sendRandomSearch(Q_UINT16 type);
  int sendSMS(const QString &, const QString &, const QString &);
  int sendMainHomeInfo( QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
  int sendEmailList(const QStringList &lst);
  int sendWorkInfo(QString _n, QString _p,QString _d, QString _s,QString _z, QString _c,QString _st, QString _url, QString _ph, QString _f,Q_UINT16 _co, Q_UINT16 _oc);
  int sendAboutInfo(QString);
  int sendMoreInfo(Q_UINT16, Q_UINT8, QString, Q_UINT16, Q_UINT8, Q_UINT8, Q_UINT8, Q_UINT8, Q_UINT8 );

  bool loggedOn();


public slots:
  void SlotReadEvent(KSocket *);
  void SlotCloseEvent(KSocket *_ks);
  void SlotWriteEvent(KSocket *_ks);

signals:
	void connecting();
	void connected();
	void disconnected(int);
	void signalContactStatusChange(UIN, Q_UINT16, Q_UINT16 );
	void receivedMessage(UIN uin, kxMessageStruct message);
	void receivedUrl(UIN uin, kxMessageStruct url);
	void receivedAuth(UIN uin, kxMessageStruct auth);
	void receivedAuthReply(UIN uin, kxMessageStruct auth);	
	void receivedAdded(UIN uin, kxMessageStruct auth);
	void receivedSMSReply(UIN,kxMessageStruct sms);
	void receivedMetaSearch(Q_UINT16, UIN, QString, QString, QString, QString, Q_UINT8,Q_UINT8, bool);
	void receivedMetaSearchFailed(Q_UINT16);
	void changeOurStatus(Q_UINT16);
	void receivedStatusMessage(UIN, QString);
	void receivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
	void receivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString , Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);
	void receivedEmailInfo(Q_UINT16, QStringList);
	void receivedWorkInfo(Q_UINT16, QString, QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16);
	void receivedAboutInfo(Q_UINT16, QString);
	void searchEnd(Q_UINT16);
	void receivedContacts(UIN, kxMessageStruct);
	void receivedAck(Q_UINT16);
	void receivedErrorAck(Q_UINT16, Q_UINT16);
	void receivedSMSAck(Q_UINT16,QString, QString);
	
};

#endif
