#include "kxsettings_general_startupimpl.h"
#include <qspinbox.h>
#include <kxmainwindow.h>
#include <qlineedit.h>
#include <qstringlist.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>

/* 
 *  Constructs a kxSettings_General_StartupImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_General_StartupImpl::kxSettings_General_StartupImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_General_Startup( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_General_StartupImpl::~kxSettings_General_StartupImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxSettings_General_StartupImpl::apply() 
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Startup");
  
  config->writeEntry("Auto Connect",autoConnect->isChecked());
  config->writeEntry("Stay on Top",stayOnTop->isChecked());
  config->writeEntry("Sticky",sticky->isChecked());
  config->writeEntry("Debug output",Debug->isChecked());
  config->sync();

}
void kxSettings_General_StartupImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Startup");
  
  autoConnect->setChecked(config->readBoolEntry("Auto Connect",TRUE));
  stayOnTop->setChecked(config->readBoolEntry("Stay on Top",TRUE));  
  sticky->setChecked(config->readBoolEntry("Sticky",FALSE));
  Debug->setChecked(config->readBoolEntry("Debug output",FALSE));
  startupStatus->setEnabled(FALSE);
  
}
