#include "kxsettings_contactlist_optionsimpl.h"
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>

/* 
 *  Constructs a kxSettings_ContactList_OptionsImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_ContactList_OptionsImpl::kxSettings_ContactList_OptionsImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_ContactList_Options( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_ContactList_OptionsImpl::~kxSettings_ContactList_OptionsImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxSettings_ContactList_OptionsImpl::apply()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");
  
  config->writeEntry("Popup Message Chat On Receive",popupChat->isChecked());
  config->writeEntry("Popup Message Chat On Press",popupChatPress->isChecked());  
  config->writeEntry("Notify Contact",notifyContact->isChecked());
  config->writeEntry("Ignore Auth",ignoreAuth->isChecked());  
  config->writeEntry("Save Geometry",saveGeometry->isChecked());
  config->writeEntry("Save Status",saveStatus->isChecked());  
  config->sync();

}
void kxSettings_ContactList_OptionsImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Contact List");
  
  popupChat->setChecked(config->readBoolEntry("Popup Message Chat On Receive",FALSE));
  popupChatPress->setChecked(config->readBoolEntry("Popup Message Chat On Press",FALSE));  
  notifyContact->setChecked(config->readBoolEntry("Notify Contact",TRUE));
  ignoreAuth->setChecked(config->readBoolEntry("Ignore Auth",FALSE));  
  saveGeometry->setChecked(config->readBoolEntry("Save Geometry",TRUE));
  saveStatus->setChecked(config->readBoolEntry("Save Status",FALSE));  
}
