#include "kxsettings_connections_optionsimpl.h"
#include <qspinbox.h>
#include <kxmainwindow.h>
#include <qlineedit.h>
#include <qstringlist.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>

/* 
 *  Constructs a kxSettings_Connections_OptionsImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_Connections_OptionsImpl::kxSettings_Connections_OptionsImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_Connections_Options( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_Connections_OptionsImpl::~kxSettings_Connections_OptionsImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxSettings_Connections_OptionsImpl::apply() 
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Connections");
  
  config->writeEntry("Reconnect",reconnect->isChecked());
  config->writeEntry("Retry",QString(retry->text()).toInt());
  config->sync();

}
void kxSettings_Connections_OptionsImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Connections");
  
  reconnect->setChecked(config->readBoolEntry("Reconnect",TRUE));
  retry->setValue(config->readNumEntry("Retry",3));
  retry->setMinValue(0);
  retry->setMaxValue(10);
}
