#include <kxpacket.h>
#include <kxcontact.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <klocale.h>
#include "kxinfodialogimpl.h"
#include <qlineedit.h>
#include <kxengine.h>
#include <kxudp.h>
#include <kxmainwindow.h>
#include <qpushbutton.h>

/* 
 *  Constructs a kxInfoDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxInfoDialogImpl::kxInfoDialogImpl( UIN _uin,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxInfoDialog( parent, name, modal, fl )
{
  uin=_uin;
  
  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
  
  QObject::connect(okButton,SIGNAL(clicked()), this, SLOT(SlotOkButton()));
  
  kxContactStruct c;
  c=ENGINE->CONTACT->getContact(_uin);
  QString u;
  u.sprintf("%d",_uin);
  uinInput->setText(u.data()); 
  u=i18n("Contact information for ")+u;
  setCaption(u);
  if (c.uin>0)
  {    
      if (c.port>0)
      {
          kxPacket p;
          Q_UINT32 l=p.ipToIcq(c.ip);
          Q_UINT8 p1, p2, p3, p4;
          p1=l;
          l>>= 8;
          p2=l;
          l>>=8;
          p3=l;
          l>>=8;
          p4=l;
          QString _ip;
          _ip.sprintf("%02d.%02d.%02d.%02d",p1, p2, p3, p4);
          ip->setText(_ip);
          _ip.sprintf("%d",c.port);
          port->setText(_ip);
      }
    
  }
  startSearch();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoDialogImpl::~kxInfoDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxInfoDialogImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  delete this;
}  
void kxInfoDialogImpl::setupDisabled()
{
}
void kxInfoDialogImpl::startSearch()
{
  QObject::connect(ENGINE->UDP,SIGNAL(receivedGenInfo(Q_UINT16, const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,Q_UINT32, Q_UINT16, Q_UINT8)),
                    this, SLOT(SlotGenInfo(Q_UINT16, const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,Q_UINT32, Q_UINT16, Q_UINT8)));
  QObject::connect(ENGINE->UDP,SIGNAL(receivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, const char *, Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)),
                    this,SLOT(SlotMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, const char *, Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)));
  QObject::connect(ENGINE->UDP,SIGNAL(receivedAboutInfo(Q_UINT16, const char *)),
                          this,SLOT(SlotAboutInfo(Q_UINT16, const char *)));
  QObject::connect(ENGINE->UDP,SIGNAL(receivedWorkInfo(Q_UINT16, const char *, const char *,const char *, const char *,const char *, Q_UINT32, Q_UINT16, const char *, const char *,const char *, Q_UINT16, const char *)),
                    this,SLOT(SlotWorkInfo(Q_UINT16, const char *, const char *,const char *, const char *,const char *, Q_UINT32, Q_UINT16, const char *, const char *,const char *, Q_UINT16, const char *)));       
  statusLabel->setText(i18n("Searching..."));
  sendAnim->start();
  search=TRUE;
  searchCount=0;
  okButton->setText(i18n("Stop"));
  seq=ENGINE->UDP->sendRequestInfo(uin);
}
void kxInfoDialogImpl::SlotGenInfo(Q_UINT16 s,const char *_n,const char *_f,const char *_l,const char *_e,const char *_s,const char *_o,const char *_c,const char *_st,const char *_p,const char *_fa,const char *_ste,const char *_ce,Q_UINT32 _zip, Q_UINT16 _country, Q_UINT8 _gmt)
{
  if (seq==s)
  {
    nick->setText(_n);
    firstName->setText(_f);
    lastName->setText(_l);    
    primary->setText(_e);
    second->setText(_s);    
    old->setText(_o);
    city->setText(_c);
    state->setText(_st);
    phone->setText(_p);  
    fax->setText(_fa);
    street->setText(_ste);
    gsm->setText(_ce);
    QString tmp;    
    if (_zip>0)
    {      
      tmp.sprintf("%u",_zip);
      zip->setText(tmp);
    }
    signed char tgmt=_gmt*-1;
    if ((tgmt>>1)!=-50)
    {
      tmp.sprintf("GMT %+02d:00",tgmt>>1);
      gmt->setText(tmp);
    }
    doCount();
  }
}
void kxInfoDialogImpl::SlotMoreInfo(Q_UINT16 s,Q_UINT16 _age, Q_UINT8 _sex, const char *_homepage, Q_UINT8 j,Q_UINT8 d,Q_UINT8 m,Q_UINT8 l1,Q_UINT8 l2,Q_UINT8 l3) 
{
  if (seq==s)
  {
    QString tmp;
    tmp.sprintf("%d",_age);
    age->setText(tmp);
    if (_sex==1)
      tmp=i18n("Female");
    else
      if (_sex==2)
        tmp=i18n("Male");
      else
        tmp=i18n("Not specified");
    gender->setText(tmp);
    
    url->setText(_homepage);
    if (!(m==0 || d==0 || j==0))
    {
      tmp.sprintf("%02d",m);
      month->setText(tmp);
      tmp.sprintf("%02d",d);
      day->setText(tmp);
      tmp.sprintf("%04d",j+1900);
      year->setText(tmp);
    }      
    doCount();
  }
}
void kxInfoDialogImpl::SlotAboutInfo(Q_UINT16 s, const char *_a)
{
  if (seq==s)
  {
    about->setText(_a);
    doCount();
  }
}
void kxInfoDialogImpl::SlotWorkInfo(Q_UINT16 s, const char *_c, const char *_s,const char *_p, const char *_f,const char *_st, Q_UINT32 _zip, Q_UINT16 _co, const char *_n, const char *_dep,const char *_pos, Q_UINT16 _un, const char *_hp)
{
  if (seq==s)
  {
    compCity->setText(_c);
    compState->setText(_s);    
    compPhone->setText(_p);
    compFax->setText(_f);
    compStreet->append(_st);
    QString tmp;    
    if (_zip>0)
    {      
      tmp.sprintf("%u",_zip);
      compZip->setText(tmp);
      
    }
    compName->setText(_n);
    compDept->setText(_dep);
    compOccupation->setText(_pos);
    compHomePage->setText(_hp);
    
    doCount();
  }
}
void kxInfoDialogImpl::doCount()
{
  searchCount++;
  if (searchCount>=4)
  {
    SlotOkButton();
    statusLabel->setText(i18n("Found all information."));
  }
}
void kxInfoDialogImpl::SlotOkButton()
{
  if (search)
  {
    seq=0;
    search=FALSE;
    okButton->setText(i18n("Ok"));
    sendAnim->stop();
    statusLabel->setText("");
  }    
  else
  {
    hide();
  }
}
