#include <qurl.h>
#include <kxudp.h>
#include <kxchangenickdialogimpl.h>
#include <kxcontacttransferdialogimpl.h>
#include <qdragobject.h>
#include <kxinfodialogimpl.h>
#include <kxhistorydialogimpl.h>
#include <kxmainwindow.h>
#include "kxcontactlist.h"
#include <kxengine.h>
#include "kxcontact.h"
#include "v2_codes.h"
#include "kxSendMessageImpl.h"
#include "kxsendmessagesimpl.h"
#include "kxreceivedmessageimpl.h"
#include <qcolor.h>
#include <qpalette.h>
#include <qfontmetrics.h>
#include <kxmessage.h>
#include <klocale.h>

kxContactListSeparatorItem::kxContactListSeparatorItem(int _type, QWidget *_parent) : kxContactListItem(_parent)
{
  type=_type;
  setAcceptDrops(FALSE);
}

void kxContactListSeparatorItem::paintEvent(QPaintEvent *)
{
  QPainter paint(this);
  QColor back, text;
  int x1,y1,w1,x2;
  int _width=width()-1;
  int _height=height();
  
  back=colorGroup().base();
  text=colorGroup().text();
  
  paint.setBrush(back);
  paint.setPen(back);  
  paint.drawRect(0,0,_width, _height);    
  
  QFont font(font());
  font.setPointSize(8);
  font.setBold(TRUE);
  paint.setFont(font);
  QFontMetrics fm(font);

  QString tmp="";
  tmp="Offline";
  if (type==1) tmp="Online";
    
  x1=3;
  y1=getHeight()/2;
  w1=(_width/2)-(fm.width(tmp)/2)-6;
  
  x2=w1+6+fm.width(tmp);
  
  paint.setPen(back.dark());    
  paint.drawLine(x1,y1+2,w1,y1+2);
  paint.drawLine(x2,y1+2,x2+w1,y1+2);
  paint.drawLine(x1,y1-2,w1,y1-2);
  paint.drawLine(x2,y1-2,x2+w1,y1-2);
  
  paint.setPen(back.light());  
  paint.drawLine(x1,y1-3,w1,y1-3);
  paint.drawLine(x2,y1-3,x2+w1,y1-3);
  paint.drawLine(x1,y1+1,w1,y1+1);
  paint.drawLine(x2,y1+1,x2+w1,y1+1);
      
  paint.setPen(text);
  paint.drawText(w1+4,(_height/2)-(fm.height()/2), fm.width(tmp),fm.height(), AlignLeft, tmp.latin1());
}

kxContactListContactItem::kxContactListContactItem(Q_UINT32 _uin, int _type, QWidget *_parent) : kxContactListItem(_parent)
{
  uin=_uin;
  type=_type;
  focus=FALSE;
  status=ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status);

  QObject::connect(ENGINE->CONTACT, SIGNAL(repaintContact(UIN)), this, SLOT(repaintItem(UIN)));

  options=new KPopupMenu(this);
  options->setCheckable(TRUE);  
  InvisibleItem = options->insertItem(i18n("Invisible"),this, SLOT(SlotSetInvisible()));
  OnlineItem    = options->insertItem(i18n("Online Notify"),this, SLOT(SlotSetOnlineNotify()));
  VisibleItem   = options->insertItem(i18n("Visible"),this, SLOT(SlotSetVisible()));
  ServerItem    = options->insertItem(i18n("Always through server"),this, SLOT(SlotSetAlwaysServer()));
  IgnoreItem    = options->insertItem(i18n("Ignore"),this, SLOT(SlotSetIgnore()));
  IntIPItem     = options->insertItem(i18n("User internal IP"),this, SLOT(SlotSetIntIP()));  
  
  QObject::connect(options, SIGNAL(aboutToShow()), SLOT(SlotShowOptionsMenu()));
    
  popup=new KPopupMenu(this);
  popup->insertTitle(i18n("Send"));
  popup->insertItem(i18n("Message"),this, SLOT(SlotSendMessage()));
  popup->insertItem(i18n("Message Chat"),this, SLOT(SlotSendMessages()));
  popup->insertItem(i18n("Url"), this, SLOT(SlotSendUrl())); 
  popup->insertItem(i18n("File"), this, SLOT(SlotSendFile()));   
  popup->insertItem(i18n("Contacts"), this, SLOT(SlotSendContacts()));     
  popup->insertTitle(i18n("Retreive"));
  popup->insertItem(i18n("Status Message"), this, SLOT(SlotAskStatusMessage())); 
  popup->insertTitle(i18n("History"));
  popup->insertItem(i18n("History"), this, SLOT(SlotHistory()));   
  popup->insertTitle(i18n("Contact"));
  popup->insertItem(i18n("Information"), this, SLOT(SlotInfo())); 
  popup->insertItem(i18n("Delete"), this, SLOT(SlotRemove())); 
  popup->insertItem(i18n("Update Nick"), this, SLOT(SlotUpdateNick()));
  popup->insertItem(i18n("Rename Nick"), this, SLOT(SlotRenameNick()));   
  popup->insertItem(i18n("Options"),options);

//  popup->insertTitle(i18n("Contact"));
//  popup->insertItem(i18n("Remove"));
//  popup->insertItem("Rename");   

  int i=MAINWINDOW->kxIcons.na.height();
  int f=fontMetrics().height();
  itemHeight=0;
  if (i>f) itemHeight=i+4;
  else itemHeight=f+4;
  setAcceptDrops(TRUE);  
}
int kxContactListContactItem::getHeight()
{
  return itemHeight;
}

void kxContactListContactItem::repaintItem(UIN _uin)
{
  if (uin==_uin) update();
}
void kxContactListContactItem::enterEvent(QEvent *)
{
  focus=TRUE;
  update();
}
void kxContactListContactItem::leaveEvent(QEvent *)
{
  focus=FALSE;
  update();
}
void kxContactListContactItem::dragEnterEvent(QDragEnterEvent *e)
{
  focus=TRUE;
  update();
  e->accept(QTextDrag::canDecode(e));  
}
void kxContactListContactItem::dragLeaveEvent(QDragLeaveEvent *)
{
  focus=FALSE;
  update();
}
void kxContactListContactItem::dropEvent(QDropEvent *e)
{
  QString text;
  
  if (QTextDrag::decode(e,text))
  {
    QUrl u(text);
    text=u.path();
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,FILE_TYPE,text.latin1(),0L,"SendMessage");
    dialog->resize(200,250);
    dialog->show();  
    debug("Dropped text: %s",text.latin1());
  }
}

void kxContactListContactItem::mousePressEvent(QMouseEvent *_e)
{
  if (_e->button()==QMouseEvent::LeftButton)
  {
    int f=ENGINE->MESSAGE->giveFirstUnread(uin);    
    if (f>0)
    {
      if (ENGINE->MESSAGE->getType(f)==MESSAGE_TYPE && MAINWINDOW->kxConfig.popupMessageChatOnReceive)  
      {
        kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,TRUE,0L,"SendMessages");
        dialog->resize(200,350);
        dialog->show();          
      }
      else
      {      
        kxReceivedMessageImpl *dialog=new kxReceivedMessageImpl(uin, 0L, "received");
        dialog->resize(200,350);
        dialog->show();    
      }
    }
    else
    {
      if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
      {
        if (MAINWINDOW->kxConfig.popupMessageChatOnPress)
        {
          kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,0L,"SendMessages");
          dialog->resize(200,350);
          dialog->show();          
        }
        else
        {
          kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,MESSAGE_TYPE,0L,"SendMessage");
          dialog->resize(200,300);
          dialog->show();
        }
      }   
    }
  }
  else
  {
    if (_e->button()==QMouseEvent::RightButton)
    {
      popup->popup(_e->globalPos());
    }
  }   
}
void kxContactListContactItem::paintEvent(QPaintEvent *)
{
  QPainter paint(this);
  QColor back, text;
  int _width=width()-1;
  int _height=height()-1;
  
  if (hasFocus() || focus)
  {
   back=colorGroup().highlight();
   text=colorGroup().highlightedText();
  }
  else  
  {
   back=colorGroup().base();
   text=colorGroup().text();
  }
  
  paint.setBrush(back);
  paint.setPen(back);  
  paint.drawRect(1,1,_width-1, _height-1);
  
  paint.setPen(back.light());  
  paint.drawLine(0,0,0, _height);
  paint.drawLine(0,0,_width, 0);  
  
  paint.setPen(back.dark());  
  paint.drawLine(_width,1,_width, _height);
  paint.drawLine(1,_height,_width, _height);    
  
  QString tmp;
  tmp.sprintf("%s",ENGINE->CONTACT->getContact(uin).nick);

  paint.setPen(text);
  
  QPixmap pix;  
  bool draw=FALSE;  
  switch(ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status))
  {
    case STATUS_DND: 			
      pix=MAINWINDOW->kxIcons.dnd; 	    
      draw=TRUE;
	  	break;
	  case STATUS_OCCUPIED: 	
      pix=MAINWINDOW->kxIcons.occupied;
      draw=TRUE;
	  	break;
	  case STATUS_NA: 				
	  	pix=MAINWINDOW->kxIcons.na; 	    
	  	draw=TRUE;
	  	break;
	  case STATUS_AWAY: 			
	  	pix=MAINWINDOW->kxIcons.away; 	    
	  	draw=TRUE;
	  	break;
	  case STATUS_FFC: 			
	  	pix=MAINWINDOW->kxIcons.ffc; 	    
	  	draw=TRUE;
	  	break;
	  case STATUS_INVISIBLE:
  	  draw=TRUE;
  	  pix=MAINWINDOW->kxIcons.invisible;
  	  break;    
	  default:
	    if (ENGINE->MESSAGE->isAnyMessage(uin))
	    {
	      pix=MAINWINDOW->kxIcons.history; 	    
	      draw=TRUE;
	    }
	  	break;
  }

  QFont font(font());

  if (ENGINE->CONTACT->getContact(uin).invisible || ENGINE->CONTACT->getContact(uin).visible)
    font.setItalic(TRUE);
  paint.setFont(font);
  
  if (ENGINE->CONTACT->countMessages(uin)>0)
  {
    pix=MAINWINDOW->kxIcons.message;
    draw=TRUE;
  }
  int pixmapWidth=MAINWINDOW->kxIcons.na.width();
  if (draw) paint.drawPixmap((getHeight()/2)-(pix.height()/2),2,pix);
  paint.drawText(pixmapWidth+3+2,(getHeight()/2)-(fontMetrics().height()/2), _width-3, _height-2, AlignLeft, tmp.latin1());
  
}
void kxContactListContactItem::updateContent()
{
  status=ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status);
  repaint();
}
void kxContactListContactItem::SlotHistory()
{
  kxHistoryDialogImpl *dialog;
  dialog=new kxHistoryDialogImpl(uin,0L, "hist");
  dialog->show();
}
void kxContactListContactItem::SlotSendMessage()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,1,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
  }   
}
void kxContactListContactItem::SlotSendMessages()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,0L,"SendMessage");
    dialog->resize(200,350);
    dialog->show();
  }   
}

void kxContactListContactItem::SlotSendUrl()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,URL_TYPE,0L,"SendUrl");
    dialog->resize(200,300);
    dialog->show();
  }
}
void kxContactListContactItem::SlotSendContacts()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxContactTransferDialogImpl *dialog=new kxContactTransferDialogImpl(uin,0L,"SendUrl");
    dialog->resize(200,300);
    dialog->show();
  }
}

void kxContactListContactItem::SlotRemove()
{
  MAINWINDOW->list->removeContact(uin);
}
void kxContactListContactItem::SlotInfo()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(uin,0L,"info");
  dialog->show();
}
void kxContactListContactItem::SlotUpdateNick()
{
  (void)new kxUpdateContactNick(uin);
}
void kxContactListContactItem::SlotRenameNick()
{
  kxChangeNickDialogImpl *dialog=new kxChangeNickDialogImpl(uin,0);
  dialog->show();
}

void kxContactListContactItem::SlotAskStatusMessage()
{
  if (ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)!=STATUS_ONLINE  &&
      ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)!=STATUS_OFFLINE )    
  {
    ENGINE->getStatusMessage(uin,ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status));
  }
}
void kxContactListContactItem::SlotShowOptionsMenu()
{
  options->setItemChecked(InvisibleItem,ENGINE->CONTACT->getContact(uin).invisible);
  options->setItemChecked(VisibleItem,ENGINE->CONTACT->getContact(uin).visible);
  options->setItemChecked(IgnoreItem,ENGINE->CONTACT->getContact(uin).ignore);
  options->setItemChecked(OnlineItem,ENGINE->CONTACT->getContact(uin).onlineNotify);
  options->setItemChecked(ServerItem,ENGINE->CONTACT->getContact(uin).alwaysServer);
  options->setItemChecked(IntIPItem,ENGINE->CONTACT->getContact(uin).intIp);  
}                         
void kxContactListContactItem::SlotSetInvisible()
{
  if (ENGINE->CONTACT->getContact(uin).invisible)
    ENGINE->CONTACT->setInvisible(uin,FALSE);
  else
    ENGINE->CONTACT->setInvisible(uin,TRUE);  
  ENGINE->UDP->sendInvisibleStatus(uin, ENGINE->CONTACT->getContact(uin).invisible);
}
void kxContactListContactItem::SlotSetOnlineNotify()
{
  if (ENGINE->CONTACT->getContact(uin).onlineNotify)
    ENGINE->CONTACT->setOnlineNotify(uin,FALSE);
  else
    ENGINE->CONTACT->setOnlineNotify(uin,TRUE);  
}
void kxContactListContactItem::SlotSetVisible()
{
  if (ENGINE->CONTACT->getContact(uin).visible)
    ENGINE->CONTACT->setVisible(uin,FALSE);
  else
    ENGINE->CONTACT->setVisible(uin,TRUE);  
  ENGINE->UDP->sendVisibleStatus(uin, ENGINE->CONTACT->getContact(uin).visible);    
}
void kxContactListContactItem::SlotSetAlwaysServer()
{
  if (ENGINE->CONTACT->getContact(uin).alwaysServer)
    ENGINE->CONTACT->setAlwaysServer(uin,FALSE);
  else
    ENGINE->CONTACT->setAlwaysServer(uin,TRUE);  
}
void kxContactListContactItem::SlotSetIgnore()
{
  if (ENGINE->CONTACT->getContact(uin).ignore)
    ENGINE->CONTACT->setIgnore(uin,FALSE);
  else
    ENGINE->CONTACT->setIgnore(uin,TRUE);  
}
void kxContactListContactItem::SlotSetIntIP()
{
  if (ENGINE->CONTACT->getContact(uin).intIp)
    ENGINE->CONTACT->setIntIp(uin,FALSE);
  else
    ENGINE->CONTACT->setIntIp(uin,TRUE);  
}

  
  
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-





kxContactList::kxContactList(QWidget *_parent) : QScrollView(_parent,"Qview")
{
  enableClipper(TRUE);
  setAcceptDrops(TRUE);
  setDragAutoScroll(TRUE);

  setVScrollBarMode(QScrollView::Auto);
  setHScrollBarMode(QScrollView::AlwaysOff);  

  kxContactListSeparatorItem *nw;
  nw=new kxContactListSeparatorItem(1,clipper());
  int w,h;
  w=contentsWidth();
  itemList.append(nw);
  h=0;
  addChild(nw,0,h);  
  resizeContents(w,h+nw->getHeight());
    
  nw=new kxContactListSeparatorItem(2,clipper());
  h=calcHeight(-1);
  itemList.append(nw);
  w=contentsWidth();
  addChild(nw,0,h);  
  resizeContents(w,h+nw->getHeight());

  QObject::connect(ENGINE->CONTACT, SIGNAL(contactAdded(UIN, QString)), this, SLOT(SlotContactAdded(UIN, QString)));
}

void kxContactList::resizeEvent(QResizeEvent *_e)
{
  viewportSize(_e->size().width(),_e->size().height());
  QScrollView::resizeEvent(_e);

  kxContactListItem *i;
  for (i=itemList.first(); i != 0; i=itemList.next())
  {
      i->resize(clipper()->width(), i->getHeight());
  }
}

void kxContactList::addContact(Q_UINT32 _uin, int _status, bool _resize)
{
  kxContactListContactItem *nw;
  int placetoStop=0;
  int w,h;  
  kxContactListItem *i;
  bool move=FALSE;
  int searchFor=0;

  h=0;  
  w=contentsWidth();    
  nw=new kxContactListContactItem(_uin,_status,clipper());
  
  if (_status!=STATUS_OFFLINE)
  {
    searchFor=1;
  }
  else
    searchFor=2;
      
  for (i=itemList.first(); i != 0; i=itemList.next())
  {
    if (i->getType()==searchFor)
    {     
        int pos=itemList.at()+1;
        itemList.insert(pos,nw);
        h=calcHeight(pos-1);
        addChild(nw,0,h);
        nw->resize(clipper()->width(), nw->getHeight());
        nw->show();
        move=TRUE;
        placetoStop+=i->getHeight();
        continue;  
    }
    if (move)
    {
      moveChild(i,0,placetoStop);        
    }      
    placetoStop+=i->getHeight();
  }
  if (_resize) resizeContents(w,calcHeight(-1));  
}

void kxContactList::changeContact(Q_UINT32 _uin, int _status)
{
  kxContactListItem *i,*j;
  int placetoStop=0;
  bool move=FALSE;
  bool stop=FALSE;
  i=itemList.first();
  
  while(i && !stop)
  {    
    if (i->getType()==3)
    {      
      kxContactListContactItem *ci;
      ci=(kxContactListContactItem *)i;
      if (ci->uin==_uin && ( (ci->status==STATUS_OFFLINE && _status!=STATUS_OFFLINE) || 
                             (ci->status!=STATUS_OFFLINE && _status==STATUS_OFFLINE) )
           )
      {
        move=TRUE;        
        int pos=itemList.at();
        j=i;
        itemList.remove(i);
        removeChild(j);
        delete j;
        for (Q_UINT16 t=pos; t<itemList.count(); t++)
        {
          i=itemList.at(t);
          moveChild(i,0,placetoStop);
          placetoStop+=i->getHeight();
        }
        stop=TRUE;
        addContact(_uin,_status,FALSE);
        return;
      }
      else
      {
        ci->updateContent();
      }
    }
    placetoStop+=i->getHeight();
    i=itemList.next();
  }
}

int kxContactList::calcHeight(int _to)
{
  if (_to<0) _to=itemList.count()-1;

  int h=0;
  kxContactListItem *i;
  for (int t=0; t<=_to; t++)
  {
    i=itemList.at(t);
    h+=i->getHeight();
  }
  return h;
}
void kxContactList::SlotContactAdded(UIN _uin, QString _nick)
{
  addContact(_uin, STATUS_OFFLINE);
}
void kxContactList::repaintContact(UIN _uin)
{
  kxContactListItem *i;
  i=itemList.first();
  bool stop=FALSE;
  
  while(i && !stop)
  {    
    if (i->getType()==3)
    {      
      kxContactListContactItem *ci;
      ci=(kxContactListContactItem *)i;
      if (ci->uin==_uin)
      {
        stop=TRUE;
        ci->updateContent();
      }
    }    
    i=itemList.next();
  }
}

void kxContactList::removeContact(UIN _uin)
{
  ENGINE->CONTACT->remove(_uin);
  int w=contentsWidth();    
  kxContactListItem *i,*j;
  int placetoStop=0;
  bool move=FALSE;
  bool stop=FALSE;
  i=itemList.first();
  
  while(i && !stop)
  {    
    if (i->getType()==3)
    {      
      kxContactListContactItem *ci;
      ci=(kxContactListContactItem *)i;
      if (ci->uin==_uin)
      {
        move=TRUE;        
        int pos=itemList.at();
        j=i;
        itemList.remove(i);
        removeChild(j);
        delete j;
        for (Q_UINT16 t=pos; t<itemList.count(); t++)
        {
          i=itemList.at(t);
          moveChild(i,0,placetoStop);
          placetoStop+=i->getHeight();
        }
        stop=TRUE;
        resizeContents(w,calcHeight(-1));
        return;
      }
    }
    placetoStop+=i->getHeight();
    i=itemList.next();
  }
  resizeContents(w,calcHeight(-1));
}

void kxContactListContactItem::SlotSendFile()
{
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,FILE_TYPE,0L,"SendMessage");
    dialog->resize(200,250);
    dialog->show();  
}
