#include "kxchangenickdialogimpl.h"
#include <kxengine.h>
#include <kxcontact.h>
#include <qlineedit.h>
#include <qpushbutton.h>

kxChangeNickDialogImpl::kxChangeNickDialogImpl(UIN _uin, QWidget* parent,  const char* name) :
  kxChangeNickDialog(parent,name)
{
  uin=_uin;
  nick->setText(ENGINE->CONTACT->getContact(uin).nick);
  QObject::connect(cancel, SIGNAL(clicked()), SLOT(SlotCancelButton()));
  QObject::connect(okButton, SIGNAL(clicked()), SLOT(SlotOkButton()));
  nick->setFocus();
}
void kxChangeNickDialogImpl::SlotOkButton()
{
  ENGINE->CONTACT->rename(uin,nick->text());
  ENGINE->SlotContactChange(uin);
  hide();  
}
void kxChangeNickDialogImpl::SlotCancelButton()
{
  hide();
}
void kxChangeNickDialogImpl::hide()
{
  debug("Close RenameNickDialog");
  delete this;
}
