#include <qcolor.h>
#include <qpalette.h>
#include <kglobalaccel.h>
#include "kxreceivedmessageimpl.h"
#include <dcopclient.h>
#include <kbugreport.h>
#include <kaboutapplication.h>
#include <kxlabel.h>
#include <kxhistorydialogimpl.h>
#include <kxstatusmessagedialogimpl.h>
#include <kxsettingsdialog.h>
#include <xautolock.h>
#include <qpoint.h>
#include <klocale.h>
#include "kxmainwindow.h"
#include "kxengine.h"
#include <qobject.h>
#include "kxcontact.h"
#include "v2_codes.h"
#include <qlayout.h>
#include <qobject.h>
#include <kwin.h>
#include <kpopupmenu.h>
#include "kxsearchdialogimpl.h"
#include <kstddirs.h>
#include <stdlib.h>
#include <kiconloader.h>
#include <kxstartupwizardimpl.h>
#include <kxpaneldock.h>

#define popupConnectID    101
#define popupDisconnectID 102
#define popupStatusID     104

void DebugOutput(QtMsgType _type, const char *_msg)
{
  if (MAINWINDOW) if (!MAINWINDOW->kxConfig.showDebug) return;
  if (!_msg) fprintf(stderr,"Debug Message Error: Null Pointer\n");
  switch(_type)
  {
    case QtDebugMsg:
      fprintf(stderr,"%s\n",_msg);
      break;
    case QtWarningMsg:
      fprintf(stderr,"WARNING: %s\n",_msg);
      break;
    case QtFatalMsg:
      fprintf(stderr,"FATAL: %s\n",_msg);
      abort();
      break;
  }
}

kxMainWindow *kxMainWindow::ptr=0L; 

kxMainWindow::kxMainWindow(const char *name )
: KTMainWindow(name )
{
  ptr=this;
    
//  createGUI();
  kxConfig.showDebug=FALSE;
  qInstallMsgHandler(DebugOutput);

  kxConfig.maxPort=65000;
  kxConfig.minPort=1024;  
  
  waitForAutoAway=FALSE;
  manualStatusChange=FALSE;
  retryCounter=0;
  
  readConfig();
  loadIcons();
  
  if (kxConfig.uin==0)
  {
    kxStartupWizardImpl *wizard=new kxStartupWizardImpl(0,"wizrad",TRUE);
    wizard->exec();
    readConfig();
    if (kxConfig.uin==0) exit(0);
  }  
  debug("Config loaded");
  
  ENGINE->setUserInfo(kxConfig.uin, kxConfig.password, "icq4.mirabilis.com",4000,kxConfig.minPort, kxConfig.maxPort);
  
  QObject::connect(ENGINE, SIGNAL(SignalNewMessage(UIN, kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(ENGINE, SIGNAL(SignalNewFile(UIN, int, QString,QString, int)), this, SLOT(SlotNewFile(UIN, int, QString,QString, int)));
  
  QString cap;
  cap.sprintf("%d",ENGINE->ourUin);
  setPlainCaption(cap);

  QVBoxLayout *vbox = new QVBoxLayout( this );
  vbox->setSpacing( 3 );
  vbox->setMargin( 0 );
  
  list=new kxContactList(this); 
  list->update();
  list->show();
  vbox->addWidget( list ); 
  QHBoxLayout *hbox = new QHBoxLayout;
  hbox->setSpacing( 3 );
  hbox->setMargin( 0 );
  list->setBackgroundColor(colorGroup().base());
 
  menuButton = new QPushButton( this, "PushButton5" );
  menuButton->setText( tr( "Menu"  ) );
  menuButton->setMinimumSize( QSize( 50, 25 ) );
  menuButton->setMaximumSize( QSize( 50, 25 ) );

  hbox->addWidget( menuButton );
 
  statusLabel = new kxLabel( this, "TextLabel3" );
  statusLabel->setText( tr( "KXicq 2"  ) );
  statusLabel->setLineWidth( 2 );
  statusLabel->setFrameShape( QLabel::WinPanel );
  statusLabel->setFrameShadow( QLabel::Sunken );
  QObject::connect(statusLabel, SIGNAL(clicked()), this, SLOT(SlotLabelButton()));
  
  hbox->addWidget( statusLabel );
  vbox->addLayout( hbox );        

  setView((QWidget *)vbox);

  // connect slots 
  QObject::connect(ENGINE, SIGNAL(SignalStatusUpdate(int) ),this, SLOT(SlotStatusUpdate(int) ));  
  QObject::connect(ENGINE, SIGNAL(SignalStatusMessage(UIN, char *) ),this, SLOT(SlotStatusMessage(UIN, char *) ));  
  QObject::connect(ENGINE, SIGNAL(SignalConnected() ),this, SLOT(SlotConnected() ));
  QObject::connect(ENGINE, SIGNAL(SignalConnecting() ),this, SLOT(SlotConnecting() ));
  QObject::connect(ENGINE, SIGNAL(SignalConnectError(QString) ),this, SLOT(SlotErrorString(QString) ));
  QObject::connect(ENGINE, SIGNAL(SignalDisconnected(int) ),this, SLOT(SlotDisconnected(int) ));
  QObject::connect(ENGINE, SIGNAL(SignalContactStatusChange(UIN, Q_UINT16, Q_UINT16) ),this, SLOT(SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16) ));
  QObject::connect(ENGINE, SIGNAL(SignalContactChange(UIN) ),this, SLOT(SlotContactChange(UIN) ));  
  QObject::connect(&autoAwayTimer, SIGNAL(timeout()), this, SLOT(SlotCheckAutoAway()));
  QObject::connect(&waitForAutoAwayTimer, SIGNAL(timeout()), this, SLOT(SlotWaitForAutoAway()));  
  
  // add all contacts to the contact list
  for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
  {
    list->addContact(ENGINE->CONTACT->getContact((int)t).uin, STATUS_OFFLINE,TRUE);
  }
  
  statusPopup=new KPopupMenu(this);
  statusPopup->insertTitle(i18n("Status"));  
  statusPopup->insertItem(kxIcons.available, i18n("Available"),STATUS_ONLINE);
  statusPopup->insertItem(kxIcons.away,i18n("Away"),STATUS_AWAY);  
  statusPopup->insertItem(kxIcons.dnd,i18n("Do Not Desturb"),STATUS_DND);
  statusPopup->insertItem(kxIcons.na,i18n("N/A"),STATUS_NA);
  statusPopup->insertItem(kxIcons.occupied,i18n("Occupied"),STATUS_OCCUPIED);
  statusPopup->insertItem(kxIcons.ffc,i18n("Free For Chat"),STATUS_FFC);
  statusPopup->insertItem(kxIcons.invisible,i18n("Invisible"),STATUS_INVISIBLE);
  QObject::connect(statusPopup, SIGNAL(activated(int)), this, SLOT(SlotChangeStatusByMenu(int)));

  popup=new KPopupMenu(this);
  popup->insertTitle(i18n("Connection"));
  popup->insertItem(i18n("&Connect"),this, SLOT(SlotMenuConnect()),0,popupConnectID);
  popup->insertItem(i18n("&Disconnect"),this, SLOT(SlotDisconnect()),0,popupDisconnectID);    
  popup->insertSeparator();
  popup->insertItem(i18n("&Status"),statusPopup,0,popupStatusID);   
  popup->insertSeparator();  
  popup->insertItem(i18n("&Add/Search contacts"), this, SLOT(SlotSearch()),0);  
  popup->insertSeparator();
  popup->insertItem(i18n("&Preferences"), this, SLOT(SlotSettings()),0);  
  popup->insertSeparator();
  popup->insertItem(i18n("&Report Bug"), this, SLOT(SlotReportBug()),0);  
  popup->insertItem(i18n("A&bout"), this, SLOT(SlotAboutDialog()),0);    
  popup->insertSeparator();
  popup->insertItem(i18n("&Quit"), this, SLOT(SlotExit()),0);
  popup->setItemEnabled(popupDisconnectID,FALSE);  
  menuButton->setPopup(popup);
  
  kxPanelDock *panel=new kxPanelDock();
  KWin::setSystemTrayWindowFor(panel->winId(),0);
  KWin::setType(panel->winId(),NET::Dock);
  QApplication::syncX();
  panel->resize(42,42);
  panel->show();
  panel->update(); 
  
  KGlobalAccel *ga = new KGlobalAccel(); 
  ga->insertItem( i18n("Monitor settings2"), "Monitor settings2", "CTRL+ALT+M" ); 
  ga->connectItem( "Monitor settings2", this, SLOT( SlotReadMessage() ) );


  if (kxConfig.saveGeometry)
  {
    KConfig *config=KGlobal::config();
    config->reparseConfiguration();
    config->setGroup("Geometry");    
    int x=config->readNumEntry("X",0);
    int y=config->readNumEntry("Y",0);        
    int w=config->readNumEntry("Width",0);
    int h=config->readNumEntry("Height",0);            
    KWin::Info i = KWin::info( winId() );
    int desktop=config->readNumEntry("Desktop",1);
    if (w>0 && h>0)
    {
      QPoint p(x,y);
      QSize s(w,h);
      KWin::setCurrentDesktop(desktop);
      resize(s);
      move(p);
    }
    else
    {
      resize(200,250);
    }
    config->sync();
  }
  else
  {
    resize(200,250);
  }
  show();  
  init();
}

kxMainWindow::~kxMainWindow()
{
}

void kxMainWindow::init()
{
  KWin::clearState(this->winId(),NET::StaysOnTop | NET::Sticky);
  KWin::setState(this->winId(), kxConfig.stayOnTop ? NET::StaysOnTop : 0  | kxConfig.sticky ? NET::Sticky : 0 );
  KWin::setOnAllDesktops(this->winId(), kxConfig.sticky);  
  if (!ENGINE->loggedOn() && kxConfig.autoConnect)
  {
    SlotConnect();
  }
  if (ENGINE->loggedOn() )
  {
    if (ENGINE->getStatus()==STATUS_ONLINE && kxConfig.autoAway)
    {    
      initTimeOut(kxConfig.awayTime);
      autoAwayTimer.start(360);
    }
    if (ENGINE->getStatus()==STATUS_AWAY && kxConfig.autoAway)
    {    
      initTimeOut(kxConfig.naTime);
      autoAwayTimer.start(360);
    }
  }
}
void kxMainWindow::readConfig()
{
  kxConfig.askAwayMessage=TRUE;
  kxConfig.awayMessage="The User is currenty Away!";
  kxConfig.naMessage="The User is currently gone!";  
  kxConfig.dndMessage="The User is doning other things!";  
  ENGINE->setStatusMessages(kxConfig.awayMessage, kxConfig.naMessage, kxConfig.dndMessage);

  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Personal Settings");
  
  kxConfig.password = config->readEntry("Password","");
  kxConfig.nick = config->readEntry("Nick","");
  kxConfig.firstName = config->readEntry("Last Name","");
  kxConfig.lastName = config->readEntry("First Name","");
  kxConfig.email = config->readEntry("Email","");
  kxConfig.uin = config->readUnsignedLongNumEntry("UIN",0);
  if (kxConfig.uin==0) return;

  config->setGroup("Auto Away");
  kxConfig.autoAway = config->readBoolEntry("Auto Away",TRUE);
  kxConfig.autoUnAway = config->readBoolEntry("Auto Un Away",TRUE);
  kxConfig.awayTime = config->readNumEntry("Away Time",10);  
  kxConfig.naTime = config->readNumEntry("N/A Time",10);    
  
  kxConfig.awayTime *= 60;
  kxConfig.naTime *= 60;
    
  config->setGroup("ICQ Servers");
  kxConfig.servers = config->readListEntry("Server");
  kxConfig.serverPorts = config->readListEntry("Server Ports");  
  
  config->setGroup("Startup");  
  kxConfig.autoConnect=config->readBoolEntry("Auto Connect",TRUE);
  kxConfig.stayOnTop=config->readBoolEntry("Stay on Top",TRUE);
  kxConfig.sticky=config->readBoolEntry("Sticky",FALSE);
  kxConfig.showDebug=config->readBoolEntry("Debug output",FALSE);
                        config->setGroup("Contact List");
  kxConfig.notifyContactOnAdding = config->readBoolEntry("Notify Contact On Adding",TRUE);
  kxConfig.popupMessageChatOnReceive=config->readBoolEntry("Popup Message Chat On Receive",FALSE);
  kxConfig.popupMessageChatOnPress=config->readBoolEntry("Popup Message Chat On Press",FALSE);
  kxConfig.ignoreContactAuth=config->readBoolEntry("Ignore Auth",FALSE);
  kxConfig.saveGeometry=config->readBoolEntry("Save Geometry",TRUE);
  kxConfig.saveStatus=config->readBoolEntry("Save Status",FALSE);
  
  config->setGroup("Conections");  
  kxConfig.reconnect=config->readBoolEntry("Reconnect",TRUE);
  kxConfig.retry=config->readNumEntry("Retry",3);


}
void kxMainWindow::rereadConfig()
{
  readConfig();
  init();
}
void kxMainWindow::loadIcons()
{
  kxIcons.available=loadIcon("available.xpm");
  kxIcons.invisible=loadIcon("invisible.xpm");
  kxIcons.na=loadIcon("na.xpm");
  kxIcons.dnd=loadIcon("dnd.xpm");
  kxIcons.occupied=loadIcon("occupied.xpm");
  kxIcons.away=loadIcon("away.xpm");
  kxIcons.online=loadIcon("online.xpm");
  kxIcons.offline=loadIcon("offline.xpm");
  kxIcons.message=loadIcon("newmsg.xpm");
  kxIcons.history=loadIcon("history.xpm"); 
} 

QPixmap kxMainWindow::loadIcon(const QString& icon)
{
  QString f = KGlobal::dirs()->findResource("data","kxicq2/pics/"+icon);
  if (f == QString::null)
  {
    return QPixmap(NULL);
  }
  return QPixmap(f);
}


void kxMainWindow::SlotConnected()
{
  statusLabel->setText(i18n("Connected"));
  popup->setItemEnabled(popupDisconnectID,TRUE);
  popup->setItemEnabled(popupConnectID,FALSE);
  retryCounter=0;
  if (kxConfig.autoAway)
  {    
    initTimeOut(kxConfig.awayTime);
    autoAwayTimer.start(360);
  }
}
void kxMainWindow::SlotConnecting()
{
  statusLabel->setText(i18n("Connecting.."));
  popup->setItemEnabled(popupConnectID,FALSE);
  popup->setItemEnabled(popupDisconnectID,TRUE);
}
void kxMainWindow::SlotErrorString(QString _s)
{
  statusLabel->setText(_s);
}
void kxMainWindow::SlotDisconnected(int e) 
{
  statusLabel->setText(i18n("Disconnected"));
  ENGINE->disconnect();
  popup->setItemEnabled(popupConnectID,TRUE);
  popup->setItemEnabled(popupDisconnectID,FALSE);
  if (kxConfig.reconnect && e>=0)
  {
    debug("Retry: %d -%d ",          retryCounter,kxConfig.retry );
    if (retryCounter++<kxConfig.retry)
      SlotConnect();
  }
}
void kxMainWindow::SlotContactStatusChange(UIN _uin, Q_UINT16 _status, Q_UINT16 _type)
{
  list->changeContact(_uin,_status);  
}
void kxMainWindow::SlotContactChange(UIN _uin)
{
  list->repaintContact(_uin);  
}

void kxMainWindow::closeEvent(QCloseEvent *)
{
  debug("Close !!");
  if (kxConfig.saveGeometry)
  {
    KConfig *config=KGlobal::config();
    config->reparseConfiguration();
    config->setGroup("Geometry");    
    config->writeEntry("X",pos().x());
    config->writeEntry("Y",pos().y());        
    config->writeEntry("Width",size().width());
    config->writeEntry("Height",size().height());            
    KWin::Info i = KWin::info( winId() );
    config->writeEntry("Desktop",i.desktop);
    config->sync();
  }
  ENGINE->disconnect();
  exit(1);
}
void kxMainWindow::SlotMenuConnect()
{
  retryCounter=0;
  SlotConnect();
}
void kxMainWindow::SlotConnect()
{
  ENGINE->disconnect();
  if (ENGINE->connect()>0)
  {
    debug("try login..");
    ENGINE->login(STATUS_ONLINE);
    popup->setItemEnabled(popupConnectID,FALSE);
    popup->setItemEnabled(popupDisconnectID,TRUE);    
  }
  else
  {
    statusLabel->setText(i18n("Connection problem"));
    if (kxConfig.reconnect)
     if (retryCounter++<kxConfig.retry)
      SlotConnect();
  }
  // todo
}
void kxMainWindow::SlotDisconnect()
{
  SlotDisconnected(-1);
}
void kxMainWindow::SlotExit()
{
  emit SignalExit();
  close();
}
void kxMainWindow::SlotSearch()
{
  kxSearchDialogImpl *dialog;
  dialog=new kxSearchDialogImpl(0L,"search");
  dialog->show();
}
void kxMainWindow::SlotChangeStatusByMenu(int _status)
{
  if (kxConfig.askAwayMessage)
  {
    if (_status!=STATUS_ONLINE)
    {
      kxStatusMessageDialogImpl dialog(kxConfig.uin, _status, (QWidget *)this, "Status", TRUE);
      if (dialog.exec()==QDialog::Accepted)
      {
        if (_status!=STATUS_ONLINE) manualStatusChange=TRUE;
        else manualStatusChange=FALSE;
        SlotChangeStatus(_status);
      }    
    }
    else
    {
      manualStatusChange=FALSE;
      SlotChangeStatus(_status);
    }
  }
}

void kxMainWindow::SlotChangeStatus(int _status)
{
  if (ENGINE->loggedOn())
  {
    ENGINE->changeStatus(_status);
  }
  else
  {
    SlotMenuConnect(); 
  }
}
void kxMainWindow::SlotStatusUpdate(int _status)
{  
  statusLabel->setText(ENGINE->CONTACT->status2str(_status));
  waitForAutoAway=FALSE;
  waitForAutoAwayTimer.stop();  
}
void kxMainWindow::SlotNewMessage(UIN _uin, kxMessageStruct _message)
{
  makeSound(MESSAGE_TYPE);
  emit SignalNewMessage(_uin, _message);
}
void kxMainWindow::SlotWaitForAutoAway()
{                  
  waitForAutoAway=FALSE;
  waitForAutoAwayTimer.stop();
}
void kxMainWindow::SlotCheckAutoAway()
{
  int move=0;  
  if (kxConfig.autoAway && ENGINE->loggedOn() && !manualStatusChange)
  {
    int check=checkTimeOut(move);
    if (move)
    {
      waitForAutoAway=FALSE;
      waitForAutoAwayTimer.stop();
    }
    if (check)
    {
      if (ENGINE->getStatus()==STATUS_ONLINE || ENGINE->getStatus()==STATUS_FFC)
      {
        SlotChangeStatus(STATUS_AWAY);
        waitForAutoAway=TRUE;
        initTimeOut(kxConfig.naTime);
        autoAwayTimer.start(360);
        waitForAutoAwayTimer.start(180);
      }
      else if (ENGINE->getStatus()==STATUS_AWAY)
      {
        SlotChangeStatus(STATUS_NA);
        waitForAutoAway=TRUE;
        waitForAutoAwayTimer.start(360);
        if (kxConfig.autoUnAway) autoAwayTimer.start(180);
        else
        {
          autoAwayTimer.stop();
          freeTimeOut();
        }
      }
    }
    else
    {
      if (kxConfig.autoUnAway && move && ENGINE->getStatus()!=STATUS_ONLINE && !waitForAutoAway)
      {
        waitForAutoAway=FALSE;
        SlotChangeStatus(STATUS_ONLINE);
        initTimeOut(kxConfig.awayTime);
        autoAwayTimer.start(180);
      }        
    }    
  }
}
void kxMainWindow::makeSound(int _type)
{
  if (ENGINE->getStatus()==STATUS_ONLINE) QApplication::beep();
}
void kxMainWindow::SlotSettings()
{
  kxSettingsDialog *dialog=new kxSettingsDialog(0L,"settings");
  dialog->show();
}
void kxMainWindow::SlotStatusMessage(UIN uin, char *message)
{
  kxStatusMessageDialog *dialog;
  dialog=new kxStatusMessageDialogImpl(uin,message, 0L,"status");
  dialog->show();
}
void kxMainWindow::updateStatusMessage(int status, QString msg)
{
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			kxConfig.awayMessage=msg;
			break;
 		case STATUS_NA:
			kxConfig.naMessage=msg;
 			break;					
 		case STATUS_DND:								
			kxConfig.dndMessage=msg;
 			break;								
 		case STATUS_OCCUPIED:			
 			break;
 		case STATUS_FFC:											
 			break;
 	}
  ENGINE->setStatusMessages(kxConfig.awayMessage, kxConfig.naMessage, kxConfig.dndMessage);
}
void kxMainWindow::SlotReportBug()
{
  KBugReport bug(this,"Bug");
  bug.exec();
}  
void kxMainWindow::SlotAboutDialog()
{
  KAboutApplication dialog(this,"About");
  dialog.exec();
}
void kxMainWindow::SlotLabelButton()
{
  if (ENGINE->MESSAGE->countUnreadMessages(0)>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl((UIN)0,0L,"view all");
    dialog->resize(200,300);
    dialog->show();
  }
  else
  {
    kxHistoryDialogImpl *dialog;
    dialog=new kxHistoryDialogImpl(0,0L, "hist");
    dialog->show();
  }
}
void kxMainWindow::SlotNewFile(UIN _uin,int _seq,QString _msg,QString _filename, int _size)
{ 
  kxReceivedMessageImpl *dialog=new kxReceivedMessageImpl(_uin,_seq,_msg,_filename, _size,0L,"File");
  dialog->show();  
}
void kxMainWindow::SlotReadMessage()
{
  debug("Ok read !!!!!");
  if (ENGINE->MESSAGE->countAllUnread()>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl(0L,"view all");
    dialog->resize(200,300);
    dialog->show();    
  }
}

