/***************************************************************************
                          kxudp.h  -  description                              
                             -------------------                                         
    begin                : Wed Jun 23 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXUDP_H
#define KXUDP_H

#include "kxpacket.h"
#include "v2_codes.h"
#include "kxcontact.h"

#include <qwidget.h>
#include <qobject.h>
#include <qtimer.h>
#include <qsocketnotifier.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <kxmessage.h>

  /********************************************************
The following data constitutes fair use for compatibility.
*********************************************************/
static const Q_UINT8 table[] = {
 0x59, 0x60, 0x37 , 0x6B , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D,
 0x5E, 0x34, 0x6D , 0x36 , 0x50 , 0x3F , 0x6F , 0x67 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x47 , 0x63 , 0x39,
 0x50, 0x5F, 0x5F , 0x3F , 0x6F , 0x47 , 0x43 , 0x69 , 0x48 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A , 0x4A , 0x42,
 0x56, 0x40, 0x67 , 0x53 , 0x41 , 0x07 , 0x6C , 0x49 , 0x58 , 0x3B , 0x4D , 0x46 , 0x68 , 0x43 , 0x69 , 0x48,
 0x33, 0x31, 0x44 , 0x65 , 0x62 , 0x46 , 0x48 , 0x53 , 0x41 , 0x07 , 0x6C , 0x69 , 0x48 , 0x33 , 0x51 , 0x54,
 0x5D, 0x4E, 0x6C , 0x49 , 0x38 , 0x4B , 0x55 , 0x4A , 0x62 , 0x46 , 0x48 , 0x33 , 0x51 , 0x34 , 0x6D , 0x36,
 0x50, 0x5F, 0x5F , 0x5F , 0x3F , 0x6F , 0x47 , 0x63 , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64 , 0x35 , 0x5A,
 0x6A, 0x52, 0x6E , 0x3C , 0x51 , 0x34 , 0x6D , 0x36 , 0x50 , 0x5F , 0x5F , 0x3F , 0x4F , 0x37 , 0x4B , 0x35,
 0x5A, 0x4A, 0x62 , 0x66 , 0x58 , 0x3B , 0x4D , 0x66 , 0x58 , 0x5B , 0x5D , 0x4E , 0x6C , 0x49 , 0x58 , 0x3B,
 0x4D, 0x66, 0x58 , 0x3B , 0x4D , 0x46 , 0x48 , 0x53 , 0x61 , 0x4C , 0x59 , 0x40 , 0x67 , 0x33 , 0x31 , 0x64,
 0x55, 0x6A, 0x32 , 0x3E , 0x44 , 0x45 , 0x52 , 0x6E , 0x3C , 0x31 , 0x64 , 0x55 , 0x6A , 0x52 , 0x4E , 0x6C,
 0x69, 0x48, 0x53 , 0x61 , 0x4C , 0x39 , 0x30 , 0x6F , 0x47 , 0x63 , 0x59 , 0x60 , 0x57 , 0x5B , 0x3D , 0x3E,
 0x64, 0x35, 0x3A , 0x3A , 0x5A , 0x6A , 0x52 , 0x4E , 0x6C , 0x69 , 0x48 , 0x53 , 0x61 , 0x6C , 0x49 , 0x58,
 0x3B, 0x4D, 0x46 , 0x68 , 0x63 , 0x39 , 0x50 , 0x5F , 0x5F , 0x3F , 0x6F , 0x67 , 0x53 , 0x41 , 0x25 , 0x41,
 0x3C, 0x51, 0x54 , 0x3D , 0x5E , 0x54 , 0x5D , 0x4E , 0x4C , 0x39 , 0x50 , 0x5F , 0x5F , 0x5F , 0x3F , 0x6F,
 0x47, 0x43, 0x69 , 0x48 , 0x33 , 0x51 , 0x54 , 0x5D , 0x6E , 0x3C , 0x31 , 0x64 , 0x35 , 0x5A , 0x00 , 0x00,
};

/** Time struct */
struct TIME
{
    Q_UINT16 year;
    Q_UINT8 month;
    Q_UINT8 day;
    Q_UINT8 hour;
    Q_UINT8 min;
};

/** Struct for messages */
struct MESSAGE
{
    int online;  								// 1=Online, 0=Offline
    TIME time;                  // Online=Localtime, Offline=Servertime
    Q_UINT32 sender;
    int length;
    char *message;
};

/** Struct for URLs */
struct URL
{
    int online;
    TIME time;
    Q_UINT32 sender;
    char *url;
    char *desc;
};

/** Struct for "You've been added" msgs */
struct ADDED
{
    int online;
    TIME time;
    Q_UINT32 sender;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    int auth_req;
    char *auth_text;
};

/** Struct for Search results */
struct SEARCH_RESULT
{
    Q_UINT32 uin;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    Q_UINT16 seq;

};

/** struct for Extended Search Results */
struct EXT_SEARCH_RESULT
{
    Q_UINT32 uin;
    char *city;
    char *state;
    Q_UINT16 country_code;
    Q_UINT16 age;
    Q_UINT8 sex;
    char *phone;
    char *home_page;
    char *about;
    Q_UINT16 seq;
};

struct keepAliveStruct
{
  int counter;
  int seq;
};

struct kxSeqStruct
{
  int seq;
  int seq2;
};
  
struct kxAddContactStruct
{
  UIN uin;
  QString nick;
};

/**
	* KXicq class for UDP packet handling for server connection
	*
	* This class handles all the UDP functions.
	* It uses class kxPacket for the packet handling
	*
	* It handles ICQ version 5.
	* with almost all the v5 specifications !
	*
	*@short KXicq class for handling UDP server connection ICQ version 5
  *@author Herwin Jan Steehouwer
  *@version 0.1.1

  */

class kxUDP : public QObject, kxPacket
{
	Q_OBJECT
protected: // Protected methods
  /** Wrinkle the packet */
  void wrinkle();
  /** Handles the Multiple Packets of v5 */
  void parseMultiplePacket(QByteArray *a);
  /** Scrambe checkcode (checksum) */
  Q_UINT32 scrambleCC(Q_UINT32 cc);
  /** Generate the Checksum for this packet */
  void generateChecksum();
	
private:
	/** add the UDP header to the Packet */
	int addHeader(Q_UINT16 command, int _t=0);
  	/** add the UDP header to the Packet with sequence !*/
	int addHeader(Q_UINT16 command, Q_UINT16 seq, Q_UINT16 seq2);
  /** Place the Packet in the QList and try to send them ! */
  void send();
	/** Parse a MessagePacket from the server*/
  void parseMessagePacket(int command, QByteArray *a);
  /** This handles the change of status and going on/offline kxContactst */
  void changeStatus(int command, QByteArray *a);
  /** Parse a Message from the server */
  void parseMessage(int command, QByteArray *a);
	/** Parse a URL from the server */
  void parseUrl(int command, QByteArray *a);
  void parseRandomUser(int command, QByteArray *a);
  /** Parse a You have been added from the server */
  void parseAdded(int command, QByteArray *a);
	/** Parse a Authorization request from the server */
  void parseAuth(int command, QByteArray *a);
  /** Send the Packet to the Server */
  void sendPacket();
  /** Send a Text Code to the server */
  int sendTextCode(char *text, Q_UINT16 X1);
  /** Send the kxContact List to the server */
  int sendContactList();
  /** Send the Visible List to the server */
  int sendVisibleList();
  /** Send the second login packet */
  void login_2();
  /** Send the Ack packet to the server with seq as Sequence */
  void sendAck(int seq, int seq2);
  /** Parse the packets from the server */
  void parseData(QByteArray *a, bool _sendAck = 1, bool SeqCheck=TRUE);
  void parseMetaUser(QByteArray *a, bool _sendAck = 1);
  /** show the first packet in the List */
	void showPacket();
	
public:
	enum Reason { GoAway, Manual, ByServer, TimeOut, Sending };

  /** Send the InVisible List to the server */
  int sendInVisibleList();
  /** auth:
1 = all add
0 = don't add, ask
showip
1 = show
0 = hide
www
1 = show
0 = hide  */
  int sendSecurityUpdate(int auth, int www, int hideip);
  /** Send the Contacts Cisible status */
  int sendVisibleStatus(UIN uin, int status);
  /** Send the Contacts Invisible status */
  int sendInvisibleStatus(UIN uin, int status);
  /** Send the System Message Ack */
  int sendSysMessageAck(int seq, int seq2);
  /** Pasre the message from a webpanel */
  void parseWebPanel(int command, QByteArray *a);
  /** Pasre the message from a email */
  void parseEmail(int command, QByteArray *a);
  /** Add the kxContact List */
  void setkxContactList(kxContact *cl);
  /** Return the packets in the send List */
  int countPackets();
  /** send a Ack that the message is received OK */
  void sendMessageAck(int ack, int ack2);
  /** Close the current connection socket
 */
  void closeConnection();
  /** parse the info reply */
  void infoReply(int command, QByteArray * a);
  /** parse the ext info reply */
  void extInfoReply(int command, QByteArray * a);
  /** Ask info about this user */
  int sendInfoReply(UIN uin);
  /** set the UIN and passwd for first connection */
  void setFirstData(UIN _uin, QString _passwd);
  /** Constucrot without kxContactList */
  kxUDP();
  /** Constucrot without kxContactList, where _port and _addre are for TCP connections.. */
  kxUDP(Q_UINT16, Q_UINT32);

  /** Request the extended info of user UIN */
  int sendAskExtInfoReply(UIN uin);
  /** Search user(s) with this profile */
  int sendUserSearch(const char *email, const char *nick, const char *first, const char *last, Q_UINT16 *t);
  /** Search this UIN */
  int sendUinSearch(UIN uin);
  /** change the info for you */
  int sendChangeInfo(const char *email, const char *nick, const char *first, const char *last);
  /** Request new user uin from the server */
  int requestNewUser(char *password, char *email);
  /** Am i Logged on ? */
  bool loggedOn();
  /** add a user to our kxContact List */
  int sendAddUser2List(UIN nuin);
  /** Change our status ! */
  int sendStatusChange(Q_UINT32 status);
  /** Send a URL to receiver */
  int sendUrl(UIN receiver, const char *url, char *message);
  /** Send a Message to the Server */
  int sendMessage(UIN receiver, char *message);
	/** Destructor */
	~kxUDP();

  /** Send the Logout packet to the server */
  void logout();
  /** Connect to the ICQ server */
  int connect(QString _server, int _port,  bool _wizard=FALSE);
	/** send the Login packet to the server */
	void login(int);
  /** parse contact exchange */
  void parseContacts(QByteArray *a);
  /** We have added a user, let them know !
 */
  int sendAddUser(UIN uin, QString, QString, QString, QString);
  /** We have added a user, ask auth request
 */
  int sendAuthReq(UIN uin, const char *);
  /** ignore the user */
  int sendIgnoreAuth(UIN, const char *);
  /** Send authorize */
  int sendAuth(UIN);
  /** Parse the authorzation reply */
  void parseAuthReply(QByteArray *, int, int );
  int sendAboutChange(const char *about);
  int sendPasswordChange(char *passwd);
  int sendRequestInfo(UIN);
  int sendMoreInfoUpdate(const char *nick, const char *first, const char *last, const char *email, const char *email2, const char *email3,const char *city, const char *state, const char *phone, const char *fax, const char *street, const char *cellular, Q_UINT32 zip, Q_UINT16 country, Q_UINT8 offset, Q_UINT8 hideEmail);
  int sendRandomChat(int catagory);
  int sendRandomChatRequest(int);
  int sendExtraInfoUpdate(Q_UINT16 age, Q_UINT8 gender, const char *homepage, Q_UINT16 year, Q_UINT8 month, Q_UINT8 day);
  int sendWorkInfoUpdate(const char *city, const char *state, const char *phone, const char *fax, const char *street, const char *zip,Q_UINT16 country,const char *name, const char *div, const char *pos,Q_UINT16 occu,  const char *homepage);
  int sendMetaSearchUin(UIN);
  int sendMetaSearchEmail(const char *email);
  int sendMetaSearchNick(const char *nick,const char *first, const char *last);
  
  int sendContacts(UIN,QList<kxAddContactStruct> *);
                             
  
//  void sendNewUser();
public slots:
  void SlotContactListTimeout();
	void receiveData(int);
	void free2SendData(int);
	void sendSlot();
  /** Timeout function for connection */
  void timeOut();
  /** Send keep alive every 2 minutes */
  void SotSendKeepAlive();


signals:
  void connecting();
  void errorString(QString);
  void signalContactStatusChange(UIN, Q_UINT16, Q_UINT16);
	/** we connot connect */
	void errorConnect();	
	/** we are not connected ! */
	void notConnected();
	/** you are connected to the server ! */
	void connected();
	/** you have been disconnected or timeout at connection! */
	void disconnected(int);
	/** there is a kxContactchanged */
	void kxContactUpdate(UIN uin, Q_UINT32, Q_UINT16 );
	/** there is a message from a Email */
	void receivedEmail(UIN uin, MESSAGE message);
	/** there is a message from the WebPanel */
	void receivedWebPanel(UIN uin, MESSAGE message);
	/** there is a message for UIN */
	void receivedMessage(UIN uin, kxMessageStruct message);
	/** there is a URL for UIN */
	void receivedUrl(UIN uin, kxMessageStruct url);
	/** there is a Added for UIN */
	void receivedAdded(UIN uin, kxMessageStruct added);
	/** there is a Auth for UIN */
	void receivedAuth(UIN uin, kxMessageStruct auth);
	/** there is a Auth Reply */
	void receivedAuthReply(UIN uin, int type, MESSAGE msg);
	/** received a search error */
	void receivedSearchError(int);
	/** Invalid Passowrd, a disconnect is forsed ! you need to reconnect by connect() */
	void invalidPassword();
	/** invald UIN in the kxContactList, no disconnect forsed ! */
  void receivedUpdateReplyFail(int);	
  void receivedUpdateReply(int);	
  void receivedRandomUser(UIN, Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT8, Q_UINT16);	
	void invalidUin();
	
	void receivedGenInfo(Q_UINT16, const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,Q_UINT32, Q_UINT16, Q_UINT8);
	void receivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, const char *, Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);
	void receivedAboutInfo(Q_UINT16, const char *);
	void receivedWorkInfo(Q_UINT16, const char *, const char *,const char *, const char *,const char *, Q_UINT32, Q_UINT16, const char *, const char *,const char *, Q_UINT16, const char *);
	
	void receivedMetaSearch(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool);
	void receivedMetaSearchFailed(Q_UINT16);
	/**
		* a GoAway Message is send by the server
		* same as Disconnected !
	*/
	void goAway();
  /** there is a InfoReply waiting ! */
  void receivedInfoReply(Q_UINT16 seq, UIN uin, char *nick, char *first, char *last, char *email, Q_UINT8 auth);  
  /** there is a extInfoReply waiting ! */
  void receivedExtInfoReply(Q_UINT16, UIN, char *, Q_UINT16, char *, Q_UINT16, Q_UINT8, char *, char *, char *);
       
	/** we got a Ack message */
	void receivedAck(int seq);
	/** we got a Security Ack */
	void receivedSecurityAck(int seq, bool status);
	void receivedPasswordChangeAck(int seq, bool status);
	void receivedAboutChangeAck(int seq, bool status);
	void receivedMoreInfoAck(int seq, bool status);
	void receivedExtraInfoAck(int seq, bool status);
	void receivedAskAddContact(UIN, QList<kxAddContactStruct> *);
	
  /** we have en new Incomming event ( eg message, url, email etc ) */
  void newIncommingEvent(UIN uin);
  /** we got the last search */
  void endOfSearch(int, int);
  void receivedNewUin(UIN uin);
  void giveUserInfo();

  void receivedUnknownPacket(QByteArray *,Q_UINT16);
  		
private:
	/** Socket Strucs for the Client */
 	struct sockaddr_in  client;
	/** Socket Strucs for the Server */ 	
	struct sockaddr_in  server;
	/** Socket Notifier, notifie when UDP can send to the server */
	QSocketNotifier *sns;
	/** Socket Notifier, notifie when There is something waiting to receive */
	QSocketNotifier 	*snr;
	/** Timer for tesing if there is a packets to send */
	QTimer *sendTimer;
	/** timer for Timeout ! */
	QTimer *to;
	/** keep alive timer, every 2 minutes ! */
	QTimer *keepAlive;
	/** UDP packets sequence */
	Q_UINT16 sequence;
	/** UDP search packets sequence */
	Q_UINT16 searchSequence;

	/** UDP packet version */
	Q_UINT16 packet_version;

  /** The sock for the connection to the ICQ server */
  int  sock;
	UIN uin;
  kxContact *kxContactsList;
  QString passwd;
  bool AutoSendContacts;
  UIN session_id;
  UIN seq_num1;
  /** are we go to login ?*/
	bool doLogin;		
	/** is logged on ? */
	bool isLoggedon;
	/** is the wizard running ? */
	bool wizard;
	bool doNewUser;
	
	int contactListSeq;
	QTimer contactListTimer;
	Q_UINT16 tcpPort;
	Q_UINT32 tcpAddr;
	QList<keepAliveStruct> keepAliveList;
	QList<kxSeqStruct> seqList;
	int aliveCounter;
  int loginStatus;
};


#endif

