/***************************************************************************
                          kxudp.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Jun 23 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kxengine.h"
#include <config.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include "kxudp.h"
#include <fcntl.h>
#include <qstring.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <qiodevice.h>
#include <sys/time.h>
#include <qdatetime.h>
#include <kxmessage.h>

kxUDP::kxUDP()
{
	tcpPort=0;
	tcpAddr=0;
	
	contactListSeq=0;
	sns=NULL;
	snr=NULL;
	to=NULL;
	sendTimer=NULL;
	sock=-1;
  doNewUser=FALSE;	
	sendTimer=new QTimer;
	to=new QTimer;
	keepAlive=new QTimer;
	QObject::connect(keepAlive, SIGNAL(timeout()), this, SLOT(SotSendKeepAlive()));
  aliveCounter=0;
  	
//	contacts;
	initPacket();
	packet_version=0x05;
	sequence=1;
	seq_num1=0;
	session_id=0;
	searchSequence=1;
//	uin=22791299;
	isLoggedon=FALSE;
	doLogin=FALSE;
	AutoSendContacts=TRUE;

  keepAliveList.setAutoDelete(TRUE);
	seqList.setAutoDelete(TRUE);
}
kxUDP::kxUDP(Q_UINT16 _port, Q_UINT32 _addr)
{
	tcpPort=_port;
	tcpAddr=_addr;
	
	contactListSeq=0;
	sns=NULL;
	snr=NULL;
	to=NULL;
	sendTimer=NULL;
	sock=-1;
	
	sendTimer=new QTimer;
	to=new QTimer;
	keepAlive=new QTimer;
	QObject::connect(keepAlive, SIGNAL(timeout()), this, SLOT(SotSendKeepAlive()));
	QObject::connect(&contactListTimer, SIGNAL(timeout()), this, SLOT(SlotContactListTimeout()));
  aliveCounter=0;
  
//	contacts;
	initPacket();
	packet_version=0x05;
	sequence=1;
	seq_num1=0;
	session_id=0;
	searchSequence=1;
//	uin=22791299;
	isLoggedon=FALSE;
	doLogin=FALSE;
	AutoSendContacts=TRUE;
	keepAliveList.setAutoDelete(TRUE);
	seqList.setAutoDelete(TRUE);
  loginStatus=0;
}

/** Add the kxContact List */
void kxUDP::setkxContactList(kxContact *cl)
{

}

kxUDP::~kxUDP()
{
	isLoggedon=FALSE;
}

int kxUDP::addHeader(Q_UINT16 command, int _t=0)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	Q_UINT32 zero=0;
	s << ( Q_UINT16  )packet_version;
  s << ( Q_UINT32  )zero;
  s << ( Q_UINT32 ) uin;
  if (session_id==0)
  {
  	session_id=rand() &   0x3fffffff;
  	debug("session: %d",session_id);
  }
  s << (  Q_UINT32  )session_id;
  s << (  Q_UINT16  )command;
  if (seq_num1==0)
  {
  	seq_num1=rand() & 0x7fff;
  	debug("seq2: %d",seq_num1);
  }
  s << (  Q_UINT16  )(seq_num1++);
  s << (  Q_UINT16  )sequence++;
  s << (  Q_UINT32  )zero;

	length=24;
	debug("Packet to send: command: %Xd (%d), seq: %d, %d, session: %d",command,command, (seq_num1-1),sequence-1,  session_id);
	if (_t==0) return sequence-1;
	return seq_num1-1;
}

int kxUDP::addHeader(Q_UINT16 command, Q_UINT16 seq, Q_UINT16 seq2)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	Q_UINT32 zero=0;
	s << ( Q_UINT16  )packet_version;
  s << ( Q_UINT32  )zero;
  s << ( Q_UINT32 ) uin;
  if (session_id==0)
  {
  	session_id=rand() &   0x3fffffff;
  	debug("session: %d",session_id);
  }
  s << (  Q_UINT32  )session_id;
  s << (  Q_UINT16  )command;
  if (seq_num1==0)
  {
  	seq_num1=rand() & 0x7fff;
  	debug("seq2: %d",seq_num1);
  }

  s << (  Q_UINT16  )seq;
  s << (  Q_UINT16  )seq2;
  s << (  Q_UINT32  )zero;

	length=24;
	debug("ack Packet to send: command: %Xd (%d), seq: %d, %d",command,command,  seq2+seq_num1, seq2);
	return sequence-1;
}

void kxUDP::showPacket()
{
/*
	debug("==========[Show Packet]=======================\ncount packet: %d",countList());
	packetDef *tmp=getFirstPacket();
	QByteArray *b=tmp->packet;
	debug("UDP Packet, len: %d", tmp->length);
	QString str,tmps;
	for (int t=0; t<tmp->length; t++)
	{
		tmps.sprintf("[%02X] ",(Q_UINT8)b->data()[t]);
		str.append(tmps.data());
	}
	debug("%s\n==========[end Show Packet]===========================", str.data());
*/
}


/** Connect to the ICQ server */
int kxUDP::connect(QString _server, int _port, bool _wizard)
{
	seqList.clear();
	session_id=0;
	wizard=_wizard;
//	if (sock>=0) return 0;
	keepAliveList.clear();
	aliveCounter=0;
//	sock=-1;
  struct in_addr *addr;  // Internet address of server

    struct hostent *host;
    static struct in_addr saddr;

    QString serverA=_server;
    Q_UINT32 port=_port;
   	
   	QObject::disconnect(snr, SIGNAL(activated(int)), this, SLOT(receiveData(int)));
   	QObject::disconnect(sns, SIGNAL(activated(int)), this, SLOT(free2SendData(int)));

    saddr.s_addr = inet_addr( serverA.data() );
    if ( saddr.s_addr != ( Q_UINT32 ) - 1 )
        addr = &saddr;
    else
    {
        host = gethostbyname( serverA.data() );
        if ( host != NULL )
        {
            addr = ( struct in_addr * ) *host->h_addr_list;
        }
        else
        {
            debug( "libXicq: lookup" );
            emit errorString("Error with DNS lookup");
            return -1;
        }
    }

    //if (sock<0) 
    sock = socket( AF_INET, SOCK_DGRAM, 0 );

    if ( sock <= 0 )
    {
      debug("retry..%d, %s", errno, strerror(errno) );
    }

    /* Set up the server info */
    memset( ( char * ) &server, 0, sizeof( server ) );
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = addr->s_addr;
    server.sin_port = htons( port ); //port;

    /* Set up another structure for our local socket */
    memset( ( char * ) &client, 0, sizeof( client ) );
    client.sin_family = AF_INET;
    client.sin_addr.s_addr = htonl( INADDR_ANY );
    client.sin_port = htons( 0 );

    fcntl(sock,F_SETFL, O_NONBLOCK);
 		int ret;
    ret=::connect(sock, ( struct sockaddr * ) &server, sizeof( server ) );
	  //ret=1;
	  if (!(ret>=0 && errno!=EINPROGRESS ))
    {
						debug("Connect error %s", strerror(errno));    				
            debug("libXicq: bind (%d, %d, %d)", ret, EINPROGRESS, errno );
            close(sock);
            //sock=-1;
            emit errorConnect();
						return -1;
    }

    debug("connect: %d, errno: %d",ret, errno);
    debug("connection OK: socket: %d",sock);
    if (snr) delete snr;
    if (sns) delete sns;

    snr=new QSocketNotifier(sock, QSocketNotifier::Read, this);
	  sns=new QSocketNotifier(sock, QSocketNotifier::Write, this);
   	
   	QObject::connect(snr, SIGNAL(activated(int)), SLOT(receiveData(int)));
   	QObject::connect(sns, SIGNAL(activated(int)), SLOT(free2SendData(int)));
		
		sns->setEnabled(FALSE);   	
		snr->setEnabled(TRUE);   	
		
		QObject::connect(sendTimer, SIGNAL(timeout()), SLOT(sendSlot()));
		sendTimer->start(3600);
		
		QObject::connect(to, SIGNAL(timeout()), SLOT(timeOut()));				
		to->start(3600);
		debug("============[connected !]=================");
		return sock;
}

/** Place the Packet in the QList and try to send them ! */
void kxUDP::send()
{
	debug("doLogin: %d",doLogin);
	if (isLoggedon==FALSE && doLogin==FALSE)
	{
		debug("Not COnnected!");
		emit notConnected();
		return;
	}
	debug("==========[Show Packet]=======================\ncount packet: %d",countList());
	debug("UDP Packet, len: %d", length);
	QString str,tmps;
	for (int t=0; t<(int)length; t++)
	{
		tmps.sprintf("[%02X] ",(Q_UINT8)byteArray->data()[t]);
		str.append(tmps.data());
    if (str.length()>200) { debug(str.data()); str.remove(0,str.length()); }		
	}
	debug(str.data());

	debug("==========[end Show Packet]===========================");
	wrinkle();
	addPacket2List();
	sns->setEnabled(TRUE);   	
}

void kxUDP::receiveData(int socket)
{
	debug("=======================[receive]=====================");
	char *buf=new char[4048];	
	int len=recv(socket, buf, 4048,0 );
 	QByteArray  a; //=new QByteArray(2049);
	if (len>0)
	{
		a.setRawData( buf, len );
		debug("packet: len: %d",len);
		
		QString str,tmps;
		for (int t=0; t<len; t++)
		{	
			tmps.sprintf("[%02X] ", (Q_UINT8)buf[t]);
			str.append(tmps.data());
			if (str.length()>200) { debug(str.data()); str.remove(0,str.length()); }
		}
		debug(str.data());		
		debug("=========================[end receive]=======================");
		parseData(&a,TRUE);
		a.resetRawData(buf,len);
	}
	else
	{
		debug("got 0 ??? %d, %s", errno, strerror(errno));
    emit disconnected(Sending);
    emit errorString(strerror(errno));
    closeConnection();
	}
	delete buf;
}

void kxUDP::free2SendData(int socket)
{
//	debug("aant packets: %d",countList());
	
	if (countList()>0)  // is Packet list > 0 send the packet
	{
		sendPacket();
	}
	else  // else restart the timer
	{
		if (sns) 			 sns->setEnabled(FALSE);
		if (sendTimer) sendTimer->start(500);	
	}
}

void kxUDP::sendSlot()
{
	if (sendTimer) sendTimer->stop();
	if (sns) sns->setEnabled(TRUE);   		
}

/** Send the Packet to the Server */
void kxUDP::sendPacket()
{
  static bool Sending=FALSE;
  if (Sending) return;
  Sending=TRUE;
	sns->setEnabled(FALSE);
	showPacket();
  packetDef *tmp=getFirstPacket();
	QByteArray *b=tmp->packet;
	
	int go;
	int ret=0;
	debug("send packet count: %d, len: %d",countList(), tmp->length);
#ifdef sun
	ksize_t *gotot=NULL;
	char *got=0;
 	go=getsockopt(sock,SOL_SOCKET, SO_ERROR, got,gotot);  // chack if send can continue, for NON_BLOCKING !
#else
  ksize_t *gotot=NULL;
  char got=0;
	go=getsockopt(sock,SOL_SOCKET, SO_ERROR, &got,gotot);  // chack if send can continue, for NON_BLOCKING !
#endif
  
//#warning PLEASE Help me in this one !! Solaris needs char * and int *, Linux need int and socklent_t * ?????

	debug("send socket: %d, %d, %d",sock, go, got);
	if (got==0) // no problems to send
	{
		to->stop();
		ret=::send(sock, b->data(), tmp->length, 0) ; //, 0,  ( struct sockaddr * ) &server, sizeof( server )  );
		//ret=1;
		if (ret>0)
		{
			  deleteFirstPacket();
				debug("send return: %d",ret);
				if (sns) sns->setEnabled(TRUE);
		}
		else
		{
			if (ret<=0)
			{
			  Sending=FALSE;
				timeOut();
			}		
		}
	}
	Sending=FALSE;
}

/** Timeout function for connection */
void kxUDP::timeOut()
{
	keepAlive->stop();
	sns->setEnabled(FALSE);
	snr->setEnabled(FALSE);
	sendTimer->stop();
	to->stop();
	closeConnection();
		
	isLoggedon=FALSE;
	emit disconnected(TimeOut);
}

void kxUDP::SlotContactListTimeout()
{
  contactListTimer.start(10000);
  contactListSeq=sendContactList();
}  

/** Parse the packets from the server */
void kxUDP::parseData(QByteArray *a, bool _sendAck, bool SeqCheck)
{
	Q_UINT16 version, command, seq2, seq;
	Q_UINT32 session, _uin;
	QDataStream s( *a, IO_ReadOnly );            // open on a's data
	s.setByteOrder(QDataStream::LittleEndian);	
	
	s >> version;
	if (version==0x05)
	{
	  s.device()->at(3);
	  s >> session;
	  s >> command;
	  s >> seq;
	  s >> seq2;
	  
	}
	else
	{
// s.device()->at(3);
	  s >> command;
	  s >> seq;
	  seq2=0;
	  session=0;
	}
	if (SeqCheck)
	{
    for (Q_UINT16 t=0; t<seqList.count(); t++)
    {
      if(seq==seqList.at(t)->seq && seq2==seqList.at(t)->seq2)
      {
        sendAck(seq, seq2);	
        debug("double seq...send Ack, then skip");
  	    return;
  	 }
  	}
  	kxSeqStruct *seqP=new kxSeqStruct;
  	seqP->seq=seq;
    seqP->seq2=seq2;	
  	seqList.append(seqP);
  	if (seqList.count()>30)
  	  seqList.remove(seqList.getFirst());
  }  	
	if (version==0x05)
	{
 	  if (session!=session_id && !doNewUser) return;
	  if (_sendAck==TRUE) if (command != S_ACK) if (command !=S_LOGIN_REPLY) if (command != S_META_USER) sendAck(seq, seq2);
	  if (command==S_LOGIN_REPLY) sendAck(0,0);
	}
  debug("Recieved Packet version: %d, command: %04X, seq: %d, %d (2), session: %d, %d",version, command, seq,seq2, session,session_id);					
	switch(command)
	{
		case S_ACK:						// ack packet, and check for keepalive acks
		  if (seq2==contactListSeq)
		  {
		    contactListTimer.stop();
		  }
		  keepAliveStruct *p;
      debug("Got Seq: %d , %d",seq2, seq);
    	for (unsigned int t=0; t<keepAliveList.count(); t++)
	    {
	      p=keepAliveList.at(t);
        debug("Seq : %d == %d ?",p->seq, seq2);
	      if (p->seq==seq2)
	      {
	        keepAliveList.clear();
	        debug("RemoveList: %d(%d), %d",t, seq2,keepAliveList.count());
	        t=15; 
	        continue;
	      }
	    }
			emit receivedAck(seq2);
			break;
		case S_MULTI_PACKET:
		  debug("========Multiple packets");
			parseMultiplePacket(a);
			break;
		case S_LOGIN_REPLY:		// Login reply packet
			//login_2();
debug("======== Login packet !!");			
			Q_UINT32 ip;

      
      s.device()->at(21);
			s >> ip;

  		ENGINE->ourExtIP=icqToIp(ip);
      Q_UINT8 p1, p2, p3, p4;
    	p1=ip;
    	ip>>= 8;
    	p2=ip;
    	ip>>=8;
    	p3=ip;
    	ip>>=8;
    	p4=ip;
    	debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);		

			doLogin=FALSE;
			isLoggedon=TRUE;
			if (!wizard)
			{
				debug("========kxContacts: %d",contacts->count());
				contactListSeq=sendContactList();
				contactListTimer.start(10000); // wait 10 seconds
				sendInVisibleList();
				sendVisibleList();
        ENGINE->setCurrentStatus(loginStatus);

			}
			keepAlive->start(1*60*1000);
			emit connected();	
			break;
		case S_USER_ONLINE:
			debug("========user online");
			changeStatus(command,a);
			break;
		case S_USER_OFFLINE:
			debug("========user offline");
			changeStatus(command,a);
			break;
		case S_STATUS_UPDATE:
			debug("========status update");
			changeStatus(command,a);
			break;
		case S_GET_MESSAGE:			
			debug("========get message");
			sendMessageAck(seq, seq2);			
			parseMessagePacket(command, a);
			break;
		case S_RECEIVE_MESSAGE:
			debug("========receive message");
			sendMessageAck(seq, seq2);			
			parseMessagePacket(command, a);
			break;	
		case S_DISCONNECTED:
			debug("========disconnected by the server");
			logout();
			timeOut();
			emit disconnected(ByServer);
			break;
		case S_GO_AWAY:
			debug("========goAway by the server");
			logout();
			timeOut();
			emit disconnected(GoAway);
			break;
		case S_WRONG_PASSWORD:
			debug("========Invalid Password");
			emit invalidPassword();
			break;
		case S_INVALID_UIN:
			debug("========a invalid UIN in the kxContactList");
			emit invalidUin();
			break;		
		case S_TRY_AGAIN:
			debug("========TryAgain by server");
			login(loginStatus);
		case S_INFO_REPLY:
		case S_USER_FOUND:
			debug("========Info reply");
			infoReply(command, a);
			break;
		case S_EXT_INFO_REPLY:
		  debug("========Ext Info reply");
		  extInfoReply(command, a);
		case S_END_OF_SEARCH:
			debug("========End of Search");
			Q_UINT8 d;
			s.device()->at(21);
			s >> (Q_UINT8 &) d;
			debug("end of num: %d",d);
			emit endOfSearch(seq2, (int)d);
			break;
		case S_SYSMESSAGE_DONE:
			debug("========SysMessageDone");
			sendSysMessageAck(seq, seq2);
			break;
		case S_META_USER:
			debug("========Meta User");
			parseMetaUser(a, 1);
			break;
		case S_SEARCH_ERROR:
			debug("========Search Error?");
			emit receivedSearchError(seq);
			break;
		case S_UPDATE_REPLY:
			debug("========Update Basic reply");
			emit receivedUpdateReply(seq);
			break;
		case S_UPDATE_REPLY_FAIL:
			debug("========Update Basic fail reply");
			emit receivedUpdateReplyFail(seq);
			break;
    case S_RAND_USER:
      debug("========Random user !!");
      parseRandomUser(command, a);
      break;
		case S_NEW_USER_UIN:
		  debug("========New UIN !");
      s >> (Q_UINT16 &)seq2; // unknown
      s >> (Q_UINT32 &)_uin;
 			doLogin=FALSE;
   		isLoggedon=TRUE;
 		  emit receivedNewUin(_uin);
 		  doNewUser=FALSE;
/* 	  case 0x5800:
 	    debug("========Give User info ??");
 	    doLogin=TRUE;
 	    emit giveUserInfo();
 	    break;*/
		default:
		  emit receivedUnknownPacket(a,command);
			debug("unkown Packet: %d (%04X)",command, command);
	}
	//delete a;
}

/** Send the Ack packet to the server with seq as Sequence */
void kxUDP::sendAck(int seq, int seq2)
{
	debug("Send Ack %d, %d !", seq, seq2);	
	addHeader(C_ACK, seq, seq2);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT32 ran=rand();
  s << (Q_UINT32) ran;
	length+=4;
	
	send();
}

/** send a Ack that the message is received OK */
void kxUDP::sendMessageAck(int ack, int ack2)
{
	addHeader(C_ACK_MSG, ack, ack2);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT32 ran=rand();
  s << (Q_UINT32) ran;
	length+=4;
	
	send();
}

/** send the Login packet to the server */
void kxUDP::login(int _status=STATUS_ONLINE)
{
  loginStatus=_status; 
	doLogin=TRUE;
//	debug("Login with: %d, %s",uin,passwd);
	Q_UINT32 clientAddr=tcpAddr;
	addHeader(C_LOGIN);

	Q_UINT16	pwdlen	= passwd.length()+1;	
  Q_UINT32        X1      = 0x00000078;
  Q_UINT32        ip      = clientAddr;
  Q_UINT32				port    = tcpPort;
  Q_UINT8 			X2    = ENGINE->ourMode;  // accept TCP/IP !
  Q_UINT32        status=_status;
/*  if (ENGINE->lastStatus!=STATUS_OFFLINE) 
  {	
    status=ENGINE->lastStatus;
  }
  else
  {
    status=_status;
  }*/
  loginStatus=status;
  if (ENGINE->webStatus && ENGINE->hideIP) status=status|0x00030000;
  else
  {
    if ( ENGINE->webStatus ) status=status|0x00010000; // must be login status
    if ( ENGINE->hideIP    ) status=status|0x00020000; // must be login status
  }

  Q_UINT32        X3      = 0x00000002;  // TCP version !
  Q_UINT32        X4      = 0x00000000;  // ??
  Q_UINT32        X5      = 0x003f0020;  // ??
  Q_UINT32        X6      = 0x00000050;  // ?
  Q_UINT32        X7      = 0x00000003; // ??
  Q_UINT32        X8      = 0x385bfaac; // ??
  Q_UINT32        X9      = 0x37c10e05;  
  Q_UINT32        X10      = 0x00000000;
  
  Q_UINT32 ctime= time(NULL);

	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);

	s << ( Q_UINT32 ) ctime;						length+=4;
	s << ( Q_UINT32 ) port; 						length+=4;	
	s << ( Q_UINT16 ) pwdlen; 					length+=2;
	passwd[pwdlen]=0;
	s.writeRawBytes(passwd.latin1(),pwdlen);     length+=pwdlen;
	s << ( Q_UINT32 )X1; 								length+=4;	
	s << ( Q_UINT32 )ip; 								length+=4;		
	s << ( Q_UINT8  )X2; 								length+=1;
	s << ( Q_UINT32 )status; 						length+=4;
	s << ( Q_UINT32 )X3; 								length+=4;	
	s << ( Q_UINT32 )X4; 								length+=4;	
	s << ( Q_UINT32 )X5; 								length+=4;	
	s << ( Q_UINT32 )X6; 								length+=4;	
	s << ( Q_UINT32 )X7; 								length+=4;	
	s << ( Q_UINT32 )X8; 								length+=4;	
	s << ( Q_UINT32 )X9; 								length+=4;	
	s << ( Q_UINT32 )X10; 								length+=4;	
	s << ( Q_UINT32 )X10; 								length+=4;	
	Q_UINT16 len;
	char str[30];
	sprintf(str, "KXicq2 0.0.6, www.kxicq.org");
	len=strlen(str);
	s << ( Q_UINT16 ) len; 					length+=2;
	str[len]=0;
	s.writeRawBytes(str,len);     length+=len;

	send();
	emit connecting();
}

/** Send the second login packet */
void kxUDP::login_2()
{
	addHeader(C_LOGIN_1);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT32 ran=rand();
  s << (Q_UINT32) ran;
	length+=4;

	send();
}

/** Send the kxContact List to the server */
int kxUDP::sendContactList()
{
  Q_UINT16 cnt=0;
  int seq=0;
  while (cnt<contacts->count())
  {
  	seq=addHeader(C_CONTACT_LIST);
  	QDataStream s(*byteArray, IO_WriteOnly );
  	s.setByteOrder(QDataStream::LittleEndian);
    s.device()->at(length);
  	Q_UINT8 len=40;
  	if (cnt+40>contacts->count()) len=contacts->count()-cnt;
  	kxContactStruct rc;
  	
  	s<< (Q_UINT8) len; 			length+=1;
  	for (int t=cnt; t<(int)cnt+len; t++)
  	{
  		rc=contacts->getContact(t);
  		s << (Q_UINT32) rc.uin;					length+=4;
  	}
  	cnt+=len;
  	send();	
  }
	return seq;
}

/** Send the Visible List to the server */
int kxUDP::sendVisibleList()
{
	int seq=addHeader(C_VISIBLE_LIST);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	Q_UINT8 len=0;
	kxContactStruct rc;

	for (int t=0; t<(int)contacts->count(); t++)
	{
	  rc=contacts->getContact(t);
		if (rc.visible) len++;	
	}
		
	s<< (Q_UINT8) len; 			length+=1;
	for (int t=0; t<(int)contacts->count(); t++)
	{
	  rc=contacts->getContact(t);
	  if (rc.visible)
	  {
			s << (Q_UINT32) rc.uin;					length+=4;
		}
	}
	if (len>0)
		send();	
	return seq;
}

/** Send the Visible List to the server */
int kxUDP::sendInVisibleList()
{
	debug("Send InVisibleList");
	int seq=addHeader(C_INVISIBLE_LIST);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	Q_UINT8 len=0;
	kxContactStruct rc;

	for (int t=0; t<(int)contacts->count(); t++)
	{
		rc=contacts->getContact(t);
		if (rc.invisible) len++;	
	}
		
	s<< (Q_UINT8) len; 			length+=1;
	for (int t=0; t<(int)contacts->count(); t++)
	{
		rc=contacts->getContact(t);
	  if (rc.invisible)
	  {
			s << (Q_UINT32) rc.uin;					length+=4;
		}
	}
	if (len>0)
		send();	
	return seq;
}

/** Send the Logout packet to the server */
void kxUDP::logout()
{
	debug("Logout NOW");
  static bool LogoutInProgress=FALSE;
  if (LogoutInProgress)
    return;
  LogoutInProgress=TRUE;
  char *tmp;
  tmp=new char[25];
  sprintf(tmp,"B_USER_DISCONNECTED");
	sendTextCode(tmp,5 );
	close(sock);
	sock=0;
	isLoggedon=FALSE;
	delete tmp;
	keepAlive->stop();
	timeOut();
	emit disconnected(Manual);
	LogoutInProgress=FALSE;
}

/** Send a Text Code to the server */
int kxUDP::sendTextCode(char *text, Q_UINT16 X1)
{
	int seq=addHeader(C_SEND_TEXT_CODE);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);	
  int len=strlen(text)+1;
  text[len]=0;
  s<<(Q_UINT16) len;				length+=2;
	s.writeRawBytes(text,len); 					length+=len;	
	s<<(Q_UINT16)X1;        	length+=2;
	send();
	sendPacket();
	return seq;
}

/** Parse a MessagePacket from the server*/
void kxUDP::parseMessagePacket(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;

	if (command==S_GET_MESSAGE) // online !
	{	
	  s.device()->at(25);	
	}
	else                        // offline
	{
		s.device()->at(31);	
	}		
	Q_UINT16 typ;
	s >> (Q_UINT16 &)typ;
	debug("type message: %02X",typ);				
	if (typ>0x8000)
	{
		debug("Mass message !");
		typ^=0x8000;
	}

	switch(typ)
	{
		case 0x0001: // message
			parseMessage(command,a);
			break;
		case 0x0004: // URL
			parseUrl(command,a);
			break;
		case 0x000C: // Added
			parseAdded(command,a);
			break;
		case 0x0006: // Auth request
			parseAuth(command,a);
			break;
		case 0x0008: // auth OK
			debug("auth OK");
			parseAuthReply(a, command, typ);
			break;
		case 0x0007: // auth ignored
			debug("auth Ignored");
			parseAuthReply(a, command, typ);
			break;
		case 0x000D: // web panel
			debug("WebPanel");
			parseWebPanel(command, a);
			break;
		case 0x000E: // email page
			debug("EmailPager");
			parseEmail(command, a);
			break;
		case 0x0013: // contact list
			parseContacts(a);
			break;
		case 0x001A: // user info
			break;
		case 0x8000: // MultiRec
			break;
	}
	emit newIncommingEvent(uin);
}

/** Parse a Message from the server */
void kxUDP::parseMessage(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  
  kxMessageStruct message;
  message.uin = uin;
  message.type=MESSAGE_TYPE;
  message.send=FALSE;
	
  Q_UINT16 msgLength;

  if ( command==S_GET_MESSAGE ) // online
  {
  		s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      char *tmp;
      tmp=new char[msgLength+1];
      
      s.readRawBytes(tmp, msgLength);
      message.message=tmp;
      delete tmp;

      time_t t = time( NULL );
      tm *t2 = localtime( &t );

      message.online = TRUE;
      QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
      QTime tmpTime(t2->tm_hour,t2->tm_min);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      
  }
  else // offline
  {
      message.online = FALSE;
      s.device()->at(25);	
      Q_UINT16 y;
      Q_UINT8 mo, d, h, m;
  		s >> (Q_UINT16&) y;
			s >> (Q_UINT8&) mo;
			s >> (Q_UINT8&) d ;
			s >> (Q_UINT8&) h ;
			s >> (Q_UINT8&) m ;
			                  
      QDate tmpDate(y,mo,d);
      QTime tmpTime(h,m);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      

			s.device()->at(33);	
      s >> (Q_UINT16 &)msgLength;
      
      char *tmp;
      tmp=new char[msgLength+1];
      
      s.readRawBytes(tmp, msgLength);
      message.message=tmp;
      delete tmp;
  }
  debug("yupe: %d, sender: %d",message.online, message.uin);
  debug("message: [%s]",message.message.latin1());
  emit receivedMessage((UIN)uin, message);
}

/** Parse a URL from the server */
void kxUDP::parseUrl(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  s.device()->at(25);	
  Q_UINT16 msgLength;
  kxMessageStruct message;
  char *tmp;
  message.uin = uin;
  message.type=URL_TYPE;
  message.send=FALSE;

  if ( command==S_GET_MESSAGE ) // online
  {
  		s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      tmp=new char[msgLength+1];
      
      s.readRawBytes(tmp, msgLength);

      time_t t = time( NULL );
      tm *t2 = localtime( &t );     
      
      QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
      QTime tmpTime(t2->tm_hour,t2->tm_min);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      
      message.online=TRUE;
  }
  else // offline
  {
      message.online = FALSE;
			s.device()->at(25);	
			
      Q_UINT16 y;
      Q_UINT8 mo, d, h, m;
  		s >> (Q_UINT16&) y;
			s >> (Q_UINT8&) mo;
			s >> (Q_UINT8&) d ;
			s >> (Q_UINT8&) h ;
			s >> (Q_UINT8&) m ;

      QDate tmpDate(y,mo,d);
      QTime tmpTime(h,m);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      
			
			s.device()->at(33);	
      s >> (Q_UINT16 &)msgLength;
      tmp=new char[msgLength+1];
      s.readRawBytes(tmp, msgLength);
  }
  debug("url: [%s]",tmp);
	char *tmp1=tmp;
	int tlen=strlen(tmp);
  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';
  char *desc = kxicqStrSep( &tmp, tmpdelim );
  char *_url = kxicqStrSep( &tmp, "" );
  if (tlen-1<=(int)strlen(desc)) 
  {
    _url=new char[2];
    _url[0]=0;
  }      
  message.message=desc;
	message.url=_url;
  
  delete tmp1;
  emit receivedUrl(uin, message);
}

/** Parse a You have been Added from the server */
void kxUDP::parseAdded(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;

  Q_UINT16 msgLength;
  kxMessageStruct message;
  message.uin = uin;
  message.type=ADDED_TYPE;
  message.send=FALSE;
  
  char *tmp;


  if ( command==S_GET_MESSAGE ) // online
  {
  		s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      tmp=new char[msgLength+1];
      s.readRawBytes(tmp, msgLength);
      
      time_t t = time( NULL );
      tm *t2 = localtime( &t );          
      
      QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
      QTime tmpTime(t2->tm_hour,t2->tm_min);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      
      message.online=TRUE;

  }
  else // offline
  {
      message.online = FALSE;
			s.device()->at(25);	
			
      Q_UINT16 y;
      Q_UINT8 mo, d, h, m;
  		s >> (Q_UINT16&) y;
			s >> (Q_UINT8&) mo;
			s >> (Q_UINT8&) d ;
			s >> (Q_UINT8&) h ;
			s >> (Q_UINT8&) m ;

      QDate tmpDate(y,mo,d);
      QTime tmpTime(h,m);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      

			s.device()->at(33);	
      s >> (Q_UINT16 &)msgLength;
      tmp=new char[msgLength+1];
      s.readRawBytes(tmp, msgLength);
  }
	char *tmp1=tmp;
  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';

  char *nick = kxicqStrSep( &tmp, tmpdelim );
  char *firstName = kxicqStrSep( &tmp, tmpdelim );
  char *lastName = kxicqStrSep( &tmp, tmpdelim );
  char *email = kxicqStrSep( &tmp, tmpdelim );
  char *auth = kxicqStrSep( &tmp, "" );

	message.nick=nick;
	message.firstName=firstName;	
	message.lastName=lastName;		
	message.email=email;	

	if (auth)
	{
  	if ( auth[ 0 ] == '0' )
  		message.auth_request = 1; // You need authorization to add this user
  	else
			message.auth_request = 0; // You don't need authorization to add this user
	}
	else
					message.auth_request = 0; // You don't need authorization to add this user
	
	delete tmp1;

	emit receivedAdded((UIN) uin, message);
}

/** Parse a Authorization request from the server */
void kxUDP::parseAuth(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  kxMessageStruct message;
  message.uin = uin;
  message.type=REQUEST_TYPE;
  message.send=FALSE;
	
  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;

  Q_UINT16 msgLength;
  char *tmp;

  if ( command==S_GET_MESSAGE ) // online
  {
	    s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      tmp=new char[msgLength+1];
      s.readRawBytes(tmp, msgLength);
      
      time_t t = time( NULL );
      tm *t2 = localtime( &t );

      QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
      QTime tmpTime(t2->tm_hour,t2->tm_min);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      
      message.online=TRUE;

  }
  else // offline 
  {
      message.online = FALSE;
  	  s.device()->at(25);	
  
      Q_UINT16 y;
      Q_UINT8 mo, d, h, m;
  		s >> (Q_UINT16&) y;
			s >> (Q_UINT8&) mo;
			s >> (Q_UINT8&) d ;
			s >> (Q_UINT8&) h ;
			s >> (Q_UINT8&) m ;

      QDate tmpDate(y,mo,d);
      QTime tmpTime(h,m);

      message.dateTime.setDate(tmpDate);
      message.dateTime.setTime(tmpTime);      

		  s.device()->at(33);	
      s >> (Q_UINT16&)msgLength;
      tmp=new char[msgLength+1];
      s.readRawBytes(tmp, msgLength);

  }
	char *tmp1=tmp;
  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';

  char *nick = kxicqStrSep( &tmp, tmpdelim );
  char *firstName = kxicqStrSep( &tmp, tmpdelim );
  char *lastName = kxicqStrSep( &tmp, tmpdelim );
  char *email = kxicqStrSep( &tmp, tmpdelim );
  char *auth = kxicqStrSep( &tmp, tmpdelim );
 	char *text = kxicqStrSep( &tmp, "" );
 	bool del=FALSE;
 	if (!text)
 	{
 		del=TRUE;
 		text=new char [2];
 		text[0]=0;
 	}

	message.nick=nick;
	message.firstName=firstName;	
	message.lastName=lastName;		
	message.email=email;	
	message.message=text;	
  if ( auth[ 0 ] == '0' )
  	message.auth_request = 1; // You need authorization to add this user
  else
		message.auth_request = 0; // You don't need authorization to add this user
		
	delete tmp1;
	if (del) delete text;
	
//  debug("Auth: [%s]",message.message);
	emit receivedAuth((UIN) uin, message);
}

/** This handles the change of status and going on/offline kxContactst */
void kxUDP::changeStatus(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  s.device()->at(25);	
  Q_UINT32 status=0;
 	Q_UINT32 ip=0, realIp=0, tcpVersion=0;		   	
 	Q_UINT16 port=0, none=0;
  Q_UINT8 mode=0;
	switch(command)
  {
		case S_USER_ONLINE:

		   	s >> (Q_UINT32 & ) ip;
		   	s >> (Q_UINT16 & ) port;
		   	s >> (Q_UINT16 & ) none;
        s >> (Q_UINT32 & ) realIp;		   	 	   	
		   	s >> (Q_UINT8  & ) mode;
				s >> (Q_UINT32 & ) status;
				s >> (Q_UINT32 & ) tcpVersion;			
		
      	ip=icqToIp( ip );
    		contacts->updateContact(uin,status, ip, port, mode, realIp, tcpVersion);
    		emit signalContactStatusChange(uin, status, S_USER_ONLINE);
				break;
		case S_USER_OFFLINE:
				contacts->updateContact(uin, STATUS_OFFLINE);
				emit signalContactStatusChange(uin, STATUS_OFFLINE, S_USER_OFFLINE);
				break;
		case S_STATUS_UPDATE:
				s >> (Q_UINT32 & ) status;
				contacts->updateContact(uin,status);				
				emit signalContactStatusChange(uin, status, S_STATUS_UPDATE);
				break;
	}
	debug("Hide IP: %X",status&0x00020000);
  debug("Web IP: %X",status&0x00010000);
	debug("change status:%d, %X",uin, status);	
	emit kxContactUpdate(uin, ip, port);
}

/** Send a Message to the Server */
int kxUDP::sendMessage(UIN receiver, char *message)
{
  if (strlen(message)>350) message[351]=0; // max len ! UDP=450, TCP=30000
	int seq=addHeader(C_SEND_MESSAGE);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	
  Q_UINT16 type=1;
  Q_UINT16 len=strlen(message)+1;
	
	s << (UIN) receiver;							length+=4;
	s << (Q_UINT16) type; 	length+=2;
	s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(message,len);			length+=len;
	
	send();	
	return seq;
}

/** Send a URL to receiver */
int kxUDP::sendUrl(UIN receiver, const char *url, char *message)
{
  if (strlen(message)>300) message[301]=0; // max len ! UDP=450, TCP=30000
	int seq=addHeader(C_SEND_MESSAGE);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	
  Q_UINT16 type=4;
	Q_UINT16 len=strlen(message)+strlen(url)+2;
	
	s << (UIN) receiver;							length+=4;
	s << (Q_UINT16) type; 	length+=2;
	s << (Q_UINT16) len;		length+=2;

	char *tmp=new char[len+1];
	
  sprintf(tmp,"%s%c%s",message, 0xFE, url);
	s.writeRawBytes(tmp,len);					length+=len;
	
	delete tmp;
	
	send();
	return seq;
}

/** Change our status ! */
int kxUDP::sendStatusChange(Q_UINT32 status)
{
  debug("send change status");
	int seq=addHeader(C_STATUS_CHANGE);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	Q_UINT32 st=status&0x0000FFFF;
	if (ENGINE->webStatus) st=st|0x00010000;
  if (ENGINE->hideIP) st=st|0x00010000;	
  debug("status: %d, %X",st,st);	
  s << (Q_UINT32) st;				length+=4;

  send();
  return seq;
}

/** add a user to our kxContact List */
int kxUDP::sendAddUser2List(UIN nuin)
{
	int seq=addHeader(C_ADD_TO_LIST);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);

  s << (Q_UINT32) nuin;				length+=4;

  send();
  return seq;
}

/** Am i Logged on ? */
bool kxUDP::loggedOn()
{
	return isLoggedon;
}

/** Request new user uin from the server */
int kxUDP::requestNewUser(char *password, char *email)
{
  doLogin=TRUE;
  doNewUser=FALSE;
	int seq=addHeader(C_NEW_USER_REG);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
  
/*  Q_UINT16 tmp=0x0002;

  s << (Q_UINT16 )tmp;		length+=2;
  tmp=strlen(password)+1;
  password[tmp]=0;
  s << (Q_UINT16 )tmp;		length+=2;
	s.writeRawBytes(password,tmp);		length+=tmp;
	Q_UINT32 tmp2=0x0072;
	s << (Q_UINT32) tmp2;					length+=4;
	tmp=0x0000;
	s << (Q_UINT32) tmp2; 				length+=4;*/
	
	Q_UINT32 tmp2;
	Q_UINT16 tmp;
	
	tmp=strlen(password)+1;                                                       
  password[tmp]=0;                                                              
  s << (Q_UINT16 )tmp;          length+=2;                                      
  s.writeRawBytes(password,tmp);          length+=tmp;                    
                                                                                
  tmp2=0xA0;                                                              
  s << (Q_UINT32) tmp2;                           length+=4;      
  tmp2=0x2461;                                                        
  s << (Q_UINT32) tmp2;                           length+=4;              
  tmp2=0xA00000;                                                              
  s << (Q_UINT32) tmp2;                           length+=4;      
  tmp2=0x00;                                                        
  s << (Q_UINT32) tmp2;                           length+=4;   
  
  Q_UINT8 tmp3;
  tmp=0;
  tmp3=0;
  tmp2=0;
  
  tmp=strlen(email)+1;
  email[tmp]=0;
  s << (Q_UINT16) tmp; //email
  s.writeRawBytes(email,tmp);          length+=tmp;                    
  
  char *tmpstr;
  tmpstr=new char[25];
  sprintf(tmpstr,"{KXicq 0.4.0}");
  tmp=strlen(tmpstr)+1;
  tmpstr[tmp]=0;
  s << (Q_UINT16) tmp; //unknown ( serial ? )
  s.writeRawBytes(tmpstr,tmp);          length+=tmp;                    
  delete tmpstr;  
  s << (Q_UINT32) tmp2;
  s << (Q_UINT32) tmp2;
  tmp3=0x03;            // UDP version, we use 3 for this
  s << (Q_UINT8) tmp3;  
  
  length+=13;
  
  send();
  return seq;
}

/** change the info for you */
int kxUDP::sendChangeInfo(const char *email, const char *nick, const char *first, const char *last)
{
	int seq=addHeader(C_UPDATE_INFO);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
  
//	s << (Q_UINT16) searchSequence++;	length+=2;
	Q_UINT16 len=0;
	
	len=strlen(nick)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(nick,len);									length+=len;	
	
	len=strlen(first)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(first,len);									length+=len;	
	
	len=strlen(last)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(last,len);									length+=len;	
		
	len=strlen(email)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(email,len);									length+=len;	

//	Q_UINT8 leeg=0;
//	s << ( Q_UINT8 ) !ENGINE->kxConfig.Auth;								length+=1;
//	s << ( Q_UINT8 ) !ENGINE->kxConfig.hideIP;								length+=1;
//	s << ( Q_UINT8 ) ENGINE->kxConfig.webStatus;								length+=1;
	debug("send basic update NOW");
	send();
	return seq;
}

/** Search this UIN */
int kxUDP::sendUinSearch(UIN uin)
{
	int seq=addHeader(C_SEARCH_UIN);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);

	s << (Q_UINT32) uin;										length+=4;	

	send();
	return seq;
}

/** Search user(s) with this profile */
int kxUDP::sendUserSearch(const char *email, const char *nick, const char *first, const char *last, Q_UINT16 *t)
{
	int seq=addHeader(C_SEARCH_USER);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);

	Q_UINT16 len=0;
	
	len=strlen(nick)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(nick,len);									length+=len;	
	
	len=strlen(first)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(first,len);									length+=len;	
	
	len=strlen(last)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(last,len);									length+=len;	
		
	len=strlen(email)+1;
	s << (Q_UINT16) len; 							length+=2;
	s.writeRawBytes(email,len);									length+=len;	

	send();
	return seq;
}

/** Request the extended info of user UIN */
int kxUDP::sendAskExtInfoReply(UIN uin)
{
	int seq=addHeader(C_EXT_INFO_REQ);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);

	s << (Q_UINT32) uin;										length+=4;
	
	send();		
	return seq;
}


/** set the UIN and passwd for first connection */
void kxUDP::setFirstData(UIN _uin, QString _passwd)
{
	debug("Set first Data");
	uin=_uin;
	passwd=_passwd;
	AutoSendContacts=FALSE;
//debug("%d, %s",uin, passwd);
}


/** parse the info reply */
void kxUDP::infoReply(int command, QByteArray * a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT16  searchSeq;
  Q_UINT32  uin;
  Q_UINT16 nickLength;
  char *nick;
  Q_UINT16 firstLength;
  char *first;
  Q_UINT16 lastLength;
  char *last;
  Q_UINT16 emailLength;
  char *email;
  Q_UINT8 auth;

  s.device()->at(11);
  s>>(Q_UINT16 &)searchSeq;
  s.device()->at(21);
  s>>(Q_UINT32 &)uin;
	s>>(Q_UINT16 &)nickLength;
	nick=new char[nickLength+1];
	s.readRawBytes(nick, nickLength);
	s>>(Q_UINT16 &)firstLength;
	first=new char[firstLength+1];
	s.readRawBytes(first, firstLength);	
	s>>(Q_UINT16 &)lastLength;
	last=new char[lastLength+1];
	s.readRawBytes(last, lastLength);
	s>>(Q_UINT16 &)emailLength;
	email=new char[emailLength+1];
	s.readRawBytes(email, emailLength);
	s>>(Q_UINT8 &)auth;	
	emit receivedInfoReply(searchSeq, uin, nick, first, last, email, auth);
}

/** parse the ext info reply */
void kxUDP::extInfoReply(int command, QByteArray * a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);
	
	char *city, *phone, *homePage, *about, *state;
	Q_UINT16 len,age, searchSeq, cc;
	Q_UINT32 uin;
	Q_UINT8  sex, unknown;	
	
	s.device()->at(11);
  s>>(Q_UINT16 &)searchSeq;
  s.device()->at(21);
  s>>(Q_UINT32 &)uin;
  
  s>>(Q_UINT16 &)len;
	city=new char[len+1];
	s.readRawBytes(city, len);	
	s>>(Q_UINT16 &)cc;
	s>>(Q_UINT8 &)unknown;
  
  s>>(Q_UINT16 &)len;
	state=new char[len+1];
	s.readRawBytes(state, len);	
	
	s>>(Q_UINT16 &)age;
	s>>(Q_UINT8 &)sex;
	
  s>>(Q_UINT16 &)len;
	phone=new char[len+1];
	s.readRawBytes(phone, len);	
	
  s>>(Q_UINT16 &)len;
	homePage=new char[len+1];
	s.readRawBytes(homePage, len);		
	
  s>>(Q_UINT16 &)len;
	about=new char[len+1];
	s.readRawBytes(about, len);		
	
	emit receivedExtInfoReply(searchSeq, uin, city, cc, state, age, sex, phone, homePage, about);  	
}

/** Ask info about this user */
int kxUDP::sendInfoReply(UIN uin)
{
	int seq=addHeader(C_INFO_REQ);
	QDataStream s(*byteArray, IO_WriteOnly );
	s.setByteOrder(QDataStream::LittleEndian);
  s.device()->at(length);
	s << (Q_UINT32) uin;										length+=4;	
	send();
	return seq;
}

/** Close the current connection socket
 */
void kxUDP::closeConnection()
{
	if (loggedOn()) { 
    logout(); 
    sleep(1);
		close(sock);
//		sleep(1);
//		sock=-1;	
		debug("close connection NOW");
		
   	QObject::disconnect(snr, SIGNAL(activated(int)), this, SLOT(receiveData(int)));
   	QObject::disconnect(sns, SIGNAL(activated(int)), this, SLOT(free2SendData(int)));
	}
}

/** Return the packets in the send List */
int kxUDP::countPackets(){
	return countList();
}

/** Pasre the message from a webpanel */
void kxUDP::parseWebPanel(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  MESSAGE message;
  uin=0;
  message.sender = 50;

  Q_UINT16 msgLength;
  debug("command: %d",command);
  if ( command==S_GET_MESSAGE ) // online
  {
  		s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);

      time_t t = time( NULL );
      tm *t2 = localtime( &t );

      message.online = 1;
      message.time.year = t2->tm_year + 1900;
      message.time.month = t2->tm_mon + 1;
      message.time.day = t2->tm_mday;
      message.time.hour = t2->tm_hour;
      message.time.min = t2->tm_min;
      message.length = msgLength;
  }
  else // offline
  {
      message.online = 0;
      s.device()->at(25);	
  		s >> (Q_UINT16&)      message.time.year;
			s >> (Q_UINT8&) message.time.month;
			s >> (Q_UINT8&) message.time.day;			  		
			s >> (Q_UINT8&) message.time.hour;
			s >> (Q_UINT8&) message.time.min;			
			s.device()->at(33);	
      s >> (Q_UINT16 &)msgLength;
      message.length = msgLength;
      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);
  }
  emit receivedWebPanel((UIN)uin, message);
}
/** Pasre the message from a email */
void kxUDP::parseEmail(int command, QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  MESSAGE message;
  uin=0;
  message.sender = 50;

  Q_UINT16 msgLength;

  if ( command==S_GET_MESSAGE ) // online
  {
  		s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);

      time_t t = time( NULL );
      tm *t2 = localtime( &t );

      message.online = 1;
      message.time.year = t2->tm_year + 1900;
      message.time.month = t2->tm_mon + 1;
      message.time.day = t2->tm_mday;
      message.time.hour = t2->tm_hour;
      message.time.min = t2->tm_min;
      message.length = msgLength;
  }
  else // offline
  {
      message.online = 0;
      s.device()->at(25);	
  		s >> (Q_UINT16&)      message.time.year;
			s >> (Q_UINT8&) message.time.month;
			s >> (Q_UINT8&) message.time.day;			  		
			s >> (Q_UINT8&) message.time.hour;
			s >> (Q_UINT8&) message.time.min;			
			s.device()->at(33);	
      s >> (Q_UINT16 &)msgLength;
      message.length = msgLength;
      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);
  }
  emit receivedEmail((UIN)uin, message);
}


/** Send the System Message Ack */
int kxUDP::sendSysMessageAck(int seq, int seq2)
{
	debug("Send SysMessageAck %d, %d !", seq, seq2);	
	int _seq=addHeader(C_SYSMESSAGE_ACK, seq, seq2);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT32 ran=rand();
  s << (Q_UINT32) ran;
	length+=4;
	
	send();
	return _seq;
}

/** Send keep alive every 2 minutes */
void kxUDP::SotSendKeepAlive()
{
	debug("Keep Alive");
	debug("Keep alive count : (%d, %d)",keepAliveList.count(), aliveCounter);
	keepAliveStruct *p;
	for (unsigned int t=0; t<keepAliveList.count(); t++)
	{
	  p=keepAliveList.at(t);
	  if (p->counter<aliveCounter-2) // to long.. we are offline
	  {
	    debug("close..");
	    closeConnection();
	    return;
	  }
	}
//	if (keepAliveList.count()>2) 
	int _seq=addHeader(C_KEEP_ALIVE);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT32 ran=rand();
  s << (Q_UINT32) ran;
	length+=4;
  keepAliveStruct *_s=new keepAliveStruct;
  _s->seq=_seq;
  _s->counter=aliveCounter++;
  keepAliveList.append(_s);	
  
	send();
	keepAlive->start(1*60*1000);
}

/** Generate the Checksum for this packet */
void kxUDP::generateChecksum()
{
	 Q_UINT32  cc, cc2;
   Q_UINT32  r1,r2;
   Q_UINT8 rc1, rc2, rc3, rc4;
   QDataStream s(*byteArray, IO_ReadWrite);
	 s.setByteOrder(QDataStream::LittleEndian);

   s.device()->at(8);
   s >> (Q_UINT8 &) rc1;
   cc = rc1;
   cc <<= 8;
   s.device()->at(4);
   s >> (Q_UINT8 &) rc2;
   cc += rc2;
   s.device()->at(2);
   s >> (Q_UINT8 &) rc3;
   cc <<= 8;
   cc += rc3;
   s.device()->at(6);
   s >> (Q_UINT8 &) rc4;
   cc <<= 8;
   cc += rc4;

   Q_UINT16 tm=( length - 0x18 );

   r1 = rand() % tm;
   r1 += 0x18;
   r2 = rand() & 0xff;

   cc2 = r1;
   cc2 <<= 8;
   s.device()->at(r1);
   s >> (Q_UINT8 &)rc1;
   cc2 += rc1 ;
   cc2 <<= 8;
   cc2 += r2;
   cc2 <<= 8;
   cc2 += table[ r2 ];
   cc2 ^= 0xff00ff;
	
  s.device()->at(0x14);
  Q_UINT32 code=cc^cc2;

	s << (Q_UINT32)code;
	
}

/** Scrambe checkcode (checksum) */
Q_UINT32 kxUDP::scrambleCC(Q_UINT32 cc)
{
    Q_UINT32 a[6];

    a[1] = cc & 0x0000001F;
    a[2] = cc & 0x03E003E0;
    a[3] = cc & 0xF8000400;
    a[4] = cc & 0x0000F800;
    a[5] = cc & 0x041F0000;

    a[1] <<= 0x0C;
    a[2] <<= 0x01;
    a[3] >>= 0x0A;
    a[4] <<= 0x10;
    a[5] >>= 0x0F;

    return a[1] + a[2] + a[3] + a[4] + a[5];
}

/** Wrinkle the packet */
void kxUDP::wrinkle()
{
   Q_UINT32 checkcode;
   Q_UINT32 code1, code2, code3;
   Q_UINT16 pos;
   Q_UINT32 data;

   generateChecksum();

   QDataStream s(*byteArray, IO_ReadWrite);
	 s.setByteOrder(QDataStream::LittleEndian);
   s.device()->at(0x14);
   s >> (Q_UINT32 &) checkcode;

   code1 = (Q_UINT32 )(length * (Q_UINT32)0x68656c6cL);
   code2 = (Q_UINT32 )(code1 + checkcode);

   for ( pos=0xa ; pos < ( length ); pos+=4 )
   {
      code3 = code2 + table[ pos & 0xFF ];
      s.device()->at(pos);
      s >> (Q_UINT32 &) data;
      data ^= code3;
      s.device()->at(pos);
      s << (Q_UINT32) data;
   }
   checkcode = scrambleCC( checkcode );
   s.device()->at(0x14);
   s<<(Q_UINT32)checkcode;
}

/** Handles the Multiple Packets of v5 */
void kxUDP::parseMultiplePacket(QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  s.device()->at(21);
	Q_UINT8 count;
	Q_UINT16 len, pos=0;
	
	s >> (Q_UINT8 &)count;
	QByteArray *p;
	char *buf;
	for (Q_UINT8 t=0; t<count; t++)
	{
		s.device()->at(22+(pos));
		s >> (Q_UINT16 &)len;
		debug("count: %d, len: %d",count, len);
		
		buf=new char[1250];				
		s.device()->at(24+(pos));
		s.readRawBytes(buf,len);
	
		p=new QByteArray;
		p->setRawData(buf, len);
		pos+=len+2;
		
		parseData(p, FALSE, FALSE);
    delete p;
	}
}

/** Send the Contacts Invisible status */
int kxUDP::sendInvisibleStatus(UIN uin, int status)
{
	debug("Send Invisible Status");	
	int seq=addHeader(C_INVISIBLE_STATUS);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT8 type=0x01; // invisible !
	
  s << (Q_UINT32) uin;
  s << (Q_UINT8) type;
  s << (Q_UINT8) status;
	length+=6;
	
	send();
	return seq;

}
/** Send the Contacts Visible status */
int kxUDP::sendVisibleStatus(UIN uin, int status)
{
	debug("Send visible Status");	
	int seq=addHeader(C_INVISIBLE_STATUS);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT8 type=0x02; // invisible !
	
  s << (Q_UINT32) uin;
  s << (Q_UINT8) type;
  s << (Q_UINT8) status;
	length+=6;
	
	send();
	return seq;
}


/** auth:
1 = all add
0 = don't add, ask
showip
1 = show
0 = hide
www
1 = show
0 = hide  */
int kxUDP::sendSecurityUpdate(int auth, int www, int hideip)
{
	debug("Send Security Update");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=0x0424;
	
	Q_UINT8 on=1, off=0;
	
	s << (Q_UINT16) command;

  s << (Q_UINT8) (auth==1 ? off : on); // 0 = auth
  s << (Q_UINT8) (www==1 ? on : off);  // 1 = show web
  s << (Q_UINT8) (hideip==1 ? off : on);  // 1 = show ip  
	length+=5;
	
	send();
	return seq;
}

/** parse contact exchange */
void kxUDP::parseContacts(QByteArray *a)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);
	Q_UINT16 msgLength;
  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  s.device()->at(27);	
  s>>(Q_UINT16 &)msgLength;
  char *_msg=new char[msgLength+1];
  s.readRawBytes(_msg, msgLength);

  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';
  QList<kxAddContactStruct> list;
  kxAddContactStruct *c;
  char *p1,*p = kxicqStrSep( &_msg, tmpdelim );
//  delete p;
  do
  {
  	p  = kxicqStrSep( &_msg, tmpdelim );
  	p1 = kxicqStrSep( &_msg, tmpdelim );
  	if (p)
  	{
  		debug("Ask to add: %s (%s)",p, p1);
  		c=new kxAddContactStruct;
  		c->nick=p1;
  		c->uin=atoi(p);
  		list.append(c);  		
  	}     
  }
  while(p);
  emit receivedAskAddContact(uin,&list);
}


/** We have added a user, let them know !
 */
int kxUDP::sendAddUser(UIN uin, QString _nick, QString _fn, QString _ln, QString _em)
{
//	debug("byPass: %d",ENGINE->kxConfig.byPassAuth);
//	if (ENGINE->kxConfig.byPassAuth) return 0;	
	debug("Send Add user, let them know");	
	int seq=addHeader(C_MSG_TO_NEW_USER);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT16 type=0x000c;
	
  s << (Q_UINT32) uin;
  s << (Q_UINT16) type;

  QString tmp;
  tmp.sprintf("%s%c%s%c%s%c%s%c%0",_nick.latin1(), 0xFE, _fn.latin1(), 0xFE, _ln.latin1(),0xFE, _em.latin1(),0xFE );
  Q_UINT16 len=tmp.length()+1;
  s << (Q_UINT16) len;
	s.writeRawBytes(tmp.data(),len);

	length+=len+8;
	
	send();
	return seq;
}
/** We have added a user, request auth
 */
int kxUDP::sendAuthReq(UIN uin, const char *mes)
{
	debug("Send auth request");	
	int seq=addHeader(C_MSG_TO_NEW_USER);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT16 type=0x0006;
	
  s << (Q_UINT32) uin;
  s << (Q_UINT16) type;

  QString tmp;
//FIXME  tmp.sprintf("%s%c%s%c%s%c%s%c%0%c%s",ENGINE->ourNick.data(), 0xFE, ENGINE->ourFirstName.data(), 0xFE, ENGINE->ourLastName.data(),0xFE, ENGINE->ourEMail.data(),0xFE, mes );
  Q_UINT16 len=tmp.length()+1;
  s << (Q_UINT16) len;
	s.writeRawBytes(tmp.data(),len);

	length+=len+8;
	
	send();
	return seq;
}

/** Send authorize */
int kxUDP::sendAuth(UIN uin){
	debug("Send authorize");	
	int seq=addHeader(C_MSG_TO_NEW_USER);
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT16 type=0x0008;

  s << (Q_UINT32) uin;
  s << (Q_UINT16) type;

  Q_UINT16 len=0x01;
  Q_UINT8 t=0;
  s << (Q_UINT16) len;
  s << (Q_UINT8) t;

	length+=len+8;
	
	send();
	return seq;
}

/** ignore the user */
int kxUDP::sendIgnoreAuth(UIN uin, const char *mes){
	debug("Send ignore authorize");	
	int seq=addHeader(C_MSG_TO_NEW_USER);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	Q_UINT16 type=0x0007;
	
  s << (Q_UINT32) uin;
  s << (Q_UINT16) type;

  QString tmp;
  tmp.sprintf("%s",mes );
  Q_UINT16 len=tmp.length()+1;
  s << (Q_UINT16) len;
	s.writeRawBytes(tmp.data(),len);

	length+=len+8;
	
	send();
	return seq;

}

/** Parse the authorzation reply */
void kxUDP::parseAuthReply(QByteArray *a, int command, int typ)
{
	QDataStream s(*a, IO_ReadOnly );
	s.setByteOrder(QDataStream::LittleEndian);

  Q_UINT32 uin;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;

  Q_UINT16 msgLength;
  MESSAGE message;
//  char *tmp;
  message.sender = uin;

  if ( command==S_GET_MESSAGE ) // online
  {
	    s.device()->at(27);	
      s>>(Q_UINT16 &)msgLength;

      message.length=msgLength;
      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);

      time_t t = time( NULL );
      tm *t2 = localtime( &t );

      message.online = 1;
      message.time.year = t2->tm_year + 1900;
      message.time.month = t2->tm_mon + 1;
      message.time.day = t2->tm_mday;
      message.time.hour = t2->tm_hour;
      message.time.min = t2->tm_min;

  }
  else // offline
  {
      message.online = 0;
			  s.device()->at(25);	
  		s >> (Q_UINT16&)      message.time.year;
			s >> (Q_UINT8&) message.time.month;
			s >> (Q_UINT8&) message.time.day;			  		
			s >> (Q_UINT8&) message.time.hour;
			s >> (Q_UINT8&) message.time.min;			
			  s.device()->at(33);	
      s >> (Q_UINT16&)msgLength;
      message.length=msgLength;
      message.message=new char[msgLength+1];
      s.readRawBytes(message.message, msgLength);

  }
  debug("Auth reply: [%s]",message.message);
	emit receivedAuthReply((UIN) uin, typ, message );

}
void kxUDP::parseMetaUser(QByteArray *a, bool _sendAck = 1)
{
	Q_UINT16 version, command, seq2, seq;
	Q_UINT32 session;
	QDataStream s( *a, IO_ReadOnly );            // open on a's data
	s.setByteOrder(QDataStream::LittleEndian);	
	s >> version;
	s.device()->at(3);
	s >> session;
	s >> command;
	s >> seq;
	s >> seq2;
	Q_UINT16 metaCommand;
	Q_UINT8 result;
  s.device()->at(21);	
	s >> metaCommand;
	s >> result;
	debug("PArse Meta user: seq: %d, %d, command: %X, result: %X",seq, seq2, command, result);
	if (!(metaCommand==META_SRV_SEC_ACK && result==0x0A)) sendAck(seq, seq2);
	
	switch(metaCommand)
	{
	  case META_SRV_USER_MORE_FOUND:
    case META_SRV_USER_FOUND:
     {
  	  if (result!=0x0A) { emit receivedMetaSearchFailed(seq2); return; }
  	  Q_UINT16 unknown1, unknown2, l;
  	  Q_UINT32 unknown3;
  	  Q_UINT8 auth;
  	  UIN uin;
  	  char *nick, *first, *last, *email;
  	  
  	  s>>unknown1;
  	  s>>uin;
      s>>l;
	    nick=new char[l+1];
  	  s.readRawBytes(nick, l);
  	  s>>l;
	    first=new char[l+1];
  	  s.readRawBytes(first, l);
  	  s>>l;
	    last=new char[l+1];
  	  s.readRawBytes(last, l);
  	  s>>l;
	    email=new char[l+1];
  	  s.readRawBytes(email, l);
  	  s>>auth;
  	  s>>unknown2;
  	  bool _last=FALSE;
  	  if (metaCommand==META_SRV_USER_FOUND)
  	  {
  	    _last=TRUE;
  	    s>>unknown3;
  	  }
  	  else
  	  {
  	    unknown3=0x0;
  	  }
  	  emit receivedMetaSearch(seq2, uin, nick, first, last, email, auth, unknown2, _last);
  	  break;
  	 }          

	  case META_SRV_SEC_ACK: // security ack
 	    if (result==0x0A)
	      emit receivedSecurityAck(seq,TRUE); // gone OK
	    else
	      emit receivedSecurityAck(seq,FALSE); // gone wrong
	    break;      
	  case META_SRV_PASS:
	    if (result==0x0A)
  	    emit receivedPasswordChangeAck(seq,TRUE); // gone OK
	    else
	      emit receivedPasswordChangeAck(seq,FALSE); // gone wrong
	    break;
	  case META_SRV_ABOUT_UPDATE:
	    if (result==0x0A)
  	    emit receivedAboutChangeAck(seq,TRUE); // gone OK
	    else
	      emit receivedAboutChangeAck(seq,FALSE); // gone wrong
	    break;
	  case META_SRV_GEN_UPDATE:
	    if (result==0x0A)
  	    emit receivedMoreInfoAck(seq,TRUE); // gone OK
	    else
	      emit receivedMoreInfoAck(seq,FALSE); // gone wrong
	    break;
	  case META_SRv_EXTRA_UPDATE:
	    if (result==0x0A)
  	    emit receivedExtraInfoAck(seq,TRUE); // gone OK
	    else
	      emit receivedExtraInfoAck(seq,FALSE); // gone wrong
	    break;
	  case META_SRV_GEN:
	  {
	    debug("result: %d",result);
	    char *nick, *first, *last, *email, *sec, *old, *city, *state, *phone, *fax, *cell, *street;
	    Q_UINT32 zip;
	    Q_UINT16 country;
	    Q_UINT8 gmt;
	    Q_UINT16 l;
	    
	    s>>l;
	    nick=new char[l+1];
	    s.readRawBytes(nick, l);
	    s>>l;
	    first=new char[l+1];
	    s.readRawBytes(first, l);
 	    s>>l;
 	    last=new char[l+1];
	    s.readRawBytes(last, l);
 	    s>>l;
 	    email=new char[l+1];
	    s.readRawBytes(email, l);
 	    s>>l;
 	    sec=new char[l+1];
	    s.readRawBytes(sec, l);
	    s>>l;
	    old=new char[l+1];
	    s.readRawBytes(old, l);
 	    s>>l;
 	    city=new char[l+1];
	    s.readRawBytes(city, l);
 	    s>>l;
 	    state=new char[l+1];
	    s.readRawBytes(state, l);
 	    s>>l;
 	    phone=new char[l+1];
	    s.readRawBytes(phone, l);
 	    s>>l;
 	    fax=new char[l+1];
	    s.readRawBytes(fax, l);
 	    s>>l;
 	    street=new char[l+1];
	    s.readRawBytes(street, l);
	    debug("len: %d",l);
 	    s>>l;
 	    debug("len: %d",l);
 	    cell=new char[l+1];
	    s.readRawBytes(cell, l);
	    s>>zip;
	    s>>country;
	    s>>gmt;
	        
	    emit receivedGenInfo(seq2, nick, first, last, email, sec, old, city, state, phone, fax, street, cell, zip, country, gmt);
 	    debug("emit done");
 	    delete nick;
 	    debug("deleted nick");
 	    delete first;
 	    delete last;
 	    delete email;
	    delete sec;
	    delete old;
 	    delete city;
	    delete state;
	    delete phone; 
	    delete fax;
	    delete street;
	    delete cell;

	    break;
    }   
    case META_SRV_MORE:
    {
      Q_UINT16 age;
      Q_UINT8 sex, j, m,d,l1,l2,l3;
	    Q_UINT16 l;
	    char *homepage;
	    
	    s>>age;
	    s>>sex;
	    s>>l;
	    homepage=new char[l+1];
	    s.readRawBytes(homepage, l);
	    s>>j;
	    s>>d;
	    s>>m;
      s>>l1;
      s>>l2;
      s>>l3;
      
      emit receivedMoreInfo(seq2, age,sex,homepage,j,d,m,l1,l2,l3);
      debug("emit hp done");
      delete homepage;
      break;
    }
    case META_SRV_ABOUT:
    {    
      Q_UINT16 l;
	    char *about;
	    
	    s>>l;
	    about=new char[l+1];
	    s.readRawBytes(about, l);
	    
	    emit receivedAboutInfo(seq2, about);
	    debug("emit about done");
	    delete about;
	    break;
	  }
	  case META_SRV_WORK:
	  {
	    char *city, *state, *phone, *fax, *street, *name, *dept, *position, *homepage;
	    Q_UINT32 zip;
	    Q_UINT16 country, unknown;
      Q_UINT16 l;
	    
	    s>>l;
	    city=new char[l+1];
	    s.readRawBytes(city, l);	    
	    s>>l;
	    state=new char[l+1];
	    s.readRawBytes(state, l);	    
	    s>>l;
	    phone=new char[l+1];
	    s.readRawBytes(phone, l);	    
	    s>>l;
	    fax=new char[l+1];
	    s.readRawBytes(fax, l);	    
	    s>>l;
	    street=new char[l+1];
	    s.readRawBytes(street, l);	    
      s>>zip;
      s>>country;
	    s>>l;
	    name=new char[l+1];
	    s.readRawBytes(name, l);	    
	    s>>l;
	    dept=new char[l+1];
	    s.readRawBytes(dept, l);	    
	    s>>l;
	    position=new char[l+1];
	    s.readRawBytes(position, l);	    
      s>>unknown;
	    s>>l;
	    homepage=new char[l+1];
	    s.readRawBytes(homepage, l);	    
	    emit receivedWorkInfo(seq2, city, state, phone, fax, street, zip, country, name, dept, position, unknown, homepage);
	    debug("emit work done");
	    delete city;
	    delete state;
	    delete phone; 
	    delete fax;
	    delete street;
	    delete name;
	    delete dept;
	    delete position;
	    delete homepage;
	    	    
      break;
    }    
	  default:
	    debug("---Unknown Meta command: %d(%X), result; %d",metaCommand,metaCommand, result);
	}
}
int kxUDP::sendPasswordChange(char *passwd)
{
	debug("Send Password Update");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=META_INFO_PASS;
  s << (Q_UINT16) command;
	int len=strlen(passwd)+1;	
  s << (Q_UINT16) len;
  s.writeRawBytes(passwd,len);  
	length+=4+len;
	
	send();
	return seq;
}  
int kxUDP::sendAboutChange(const char *about)
{
	debug("Send About Update");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=META_INFO_ABOUT;
  s << (Q_UINT16) command;
	int len=strlen(about)+1;	
  s << (Q_UINT16) len;
  s.writeRawBytes(about,len);  
	length+=4+len;
	
	send();
	return seq;
}  
int kxUDP::sendRequestInfo(UIN uin)
{
	debug("Send Request Info");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=META_INFO_REQ;
  s << (Q_UINT16) command;
  s << (Q_UINT32) uin;
	length+=4+2;
	
	send();
	return seq;
}  
int kxUDP::sendMoreInfoUpdate(const char *nick, const char *first, const char *last, const char *email, const char *email2, const char *email3,const char *city, const char *state, const char *phone, const char *fax, const char *street, const char *cellular, Q_UINT32 zip, Q_UINT16 country, Q_UINT8 offset, Q_UINT8 hideEmail)
{
	debug("Send More Update");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=META_INFO_SET;
	
	s << (Q_UINT16) command;   length+=2;
  Q_UINT16 len;
  len=strlen(nick)+1;
  s << len;
  s.writeRawBytes(nick,len);  length+=2+len;
  
  len=strlen(first)+1;
  s << len;
  s.writeRawBytes(first,len);  length+=2+len;
  
  len=strlen(last)+1;
  s << len;
  s.writeRawBytes(last,len);  length+=2+len;
  
  debug("Email: %s",email);
  len=strlen(email)+1;
  s << len;
  s.writeRawBytes(email,len);  length+=2+len;
  
  len=strlen(email2)+1;
  s << len;
  s.writeRawBytes(email2,len);  length+=2+len;
  
  len=strlen(email3)+1;
  s << len;
  s.writeRawBytes(email3,len);  length+=2+len;
  len=strlen(city)+1;
  s << len;
  s.writeRawBytes(city,len);  length+=2+len;
  len=strlen(state)+1;
  s << len;
  s.writeRawBytes(state,len);  length+=2+len;
  len=strlen(phone)+1;
  s << len;
  s.writeRawBytes(phone,len);  length+=2+len;
  len=strlen(fax)+1;
  s << len;
  s.writeRawBytes(fax,len);  length+=2+len;
  len=strlen(street)+1;
  s << len;
  s.writeRawBytes(street,len);  length+=2+len;
  len=strlen(cellular)+1;
  s << len;
  s.writeRawBytes(cellular,len);  length+=2+len;
  s << zip;
  s << country;
  s << offset;
  s << hideEmail;
  length+=4+2+1+1;
  debug("length=%d",length);
  send();
	return seq;
}
int kxUDP::sendWorkInfoUpdate(const char *city, const char *state, const char *phone, const char *fax, const char *street, const char *zip,Q_UINT16 country,const char *name, const char *div, const char *pos,Q_UINT16 occu,  const char *homepage)
{
	debug("Send Work Update");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);

	Q_UINT16 command=META_WORK_SET;
	
	s << (Q_UINT16) command;   length+=2;
  Q_UINT16 len;
  len=strlen(city)+1;
  s << len;
  s.writeRawBytes(city,len);  length+=2+len;
  len=strlen(state)+1;
  s << len;
  s.writeRawBytes(state,len);  length+=2+len;
  len=strlen(phone)+1;
  s << len;
  s.writeRawBytes(phone,len);  length+=2+len;
  len=strlen(fax)+1;
  s << len;
  s.writeRawBytes(fax,len);  length+=2+len;
  len=strlen(street)+1;
  s << len;
  s.writeRawBytes(street,len);  length+=2+len;
  len=strlen(zip)+1;
  s << len;
  s.writeRawBytes(zip,len);  length+=2+len;
  
  s << country; length+=2;
  
  len=strlen(name)+1;
  s << len;
  s.writeRawBytes(name,len);  length+=2+len;
  len=strlen(div)+1;
  s << len;
  s.writeRawBytes(div,len);  length+=2+len;
  len=strlen(pos)+1;
  s << len;
  s.writeRawBytes(pos,len);  length+=2+len;
  
  s << occu;
  
  len=strlen(homepage)+1;
  s << len;
  s.writeRawBytes(homepage,len);  length+=2+len;
  
  length+=2;
 
  send();
	return seq;
}

int kxUDP::sendExtraInfoUpdate(Q_UINT16 age, Q_UINT8 gender, const char *homepage, Q_UINT16 year, Q_UINT8 month, Q_UINT8 day)
{
	debug("Send Extra Info");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT16 command=META_EXTRA_SET;
  s << (Q_UINT16) command; length+=2;
  
  s << age;       length+=2;
  s << gender;    length+=1;
    
  Q_UINT16 len;
  len=strlen(homepage)+1;
  s << len;
  s.writeRawBytes(homepage,len);  length+=2+len;
  
  s << year;
  s << day;
  s << month;
  
  Q_UINT8 u=0xFF;
  
  s << u;
  s << u;
  s << u;
  
  length+=4+3;
  send();
	return seq;
}

int kxUDP::sendRandomChat(int catagory)
{
	debug("Send random Chat");	
	int seq=addHeader(C_RAND_SET);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT32 group=catagory;
	
	s<<group;
	length+=4;
	
  send();
	return seq;
}
int kxUDP::sendRandomChatRequest(int catagory)
{
	debug("Send random Chat");	
	int seq=addHeader(C_RAND_SEARCH);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT32 group=catagory;
	
	s<<group;
	length+=4;
	
  send();
	return seq;
}
void kxUDP::parseRandomUser(int command, QByteArray *a)
{

	QDataStream s( *a, IO_ReadOnly );            // open on a's data
	s.setByteOrder(QDataStream::LittleEndian);	
  
  Q_UINT32 uin, IP, IP2, status, port;
  Q_UINT8 type;
  Q_UINT16 version;
  s.device()->at(21);	
  s>>(Q_UINT32 &)uin;
  s>>IP;
  s>>port;
  s>>IP2;
  s>>type;
  s>>status;
  s>>version;
  emit receivedRandomUser(uin, IP, port, status, type,version);
}

int kxUDP::sendContacts(UIN _uin,QList<kxAddContactStruct> *lst)
{
	debug("Send contacts");	
	int seq=addHeader(C_SEND_MESSAGE);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	QString t;
	QCString msg;
	
	QByteArray data;
	QDataStream d(data, IO_ReadWrite);	

	msg.sprintf("%d",lst->count());
  d.writeRawBytes(msg.data(), msg.length());
	kxAddContactStruct *li;
	for (int t1=0; t1<(int)lst->count(); t1++)
	{
	  li=lst->at(t1);
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(QString().setNum(li->uin),(QString().setNum(li->uin)).length());
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(li->nick.latin1(),li->nick.length());
	}
	d << (Q_UINT8) 0xFE;
	d << (Q_UINT8) 0x00;	
	
  Q_UINT16 type=0x0013;
  Q_UINT16 len=data.size();
  debug("Len: %d, [%s]",len, msg.data());
	
	s << (UIN) _uin;							length+=4;
	s << (Q_UINT16) type; 	length+=2;
	s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(data.data(),len);			length+=len;
	
  send();
	return seq;

}

int kxUDP::sendMetaSearchUin(UIN _uin)
{
	debug("Send Meta Search Uin");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT16 command=META_C_SEARCH_UIN;
  s << (Q_UINT16) command; length+=2;
  s << (Q_UINT32) _uin; length+=4;
  
  send();
	return seq;
}

//META_C_SEARCH_NICK
int kxUDP::sendMetaSearchNick(const char *nick, const char *first, const char *last)
{
	debug("Send Meta Search Nick");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT16 command=META_C_SEARCH_NICK;
  s << (Q_UINT16) command; length+=2;
  
  Q_UINT16 len;
  
	len=strlen(first);
	s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(first,len);			length+=len;
	len=strlen(last);
	s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(last,len);			length+=len;
  len=strlen(nick);
  s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(nick,len);			length+=len;
	  
  send();
	return seq;
}

//META_C_SEARCH_EMAIL
int kxUDP::sendMetaSearchEmail(const char *email)
{
	debug("Send Meta Search Email");	
	int seq=addHeader(C_META);	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	s.device()->at(length);
	
	Q_UINT16 command=META_C_SEARCH_EMAIL;
  s << (Q_UINT16) command; length+=2;
  
  Q_UINT16 len;
  
  len=strlen(email);
  s << (Q_UINT16) len;		length+=2;
	s.writeRawBytes(email,len);			length+=len;
  
  send();
	return seq;
}
