/***************************************************************************
                          kxtcp.h  -  description                              
                             -------------------                                         
    begin                : Sun Aug 15 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXTCP_H
#define KXTCP_H

#include <kxmessage.h>
#include <qdatastream.h>
#include "kxsock.h"
#include <qobject.h>
#include "v2_codes.h"
#include "kxpacket.h"
#include "kxudp.h"

typedef struct kxIncommingPacket
{
	QByteArray packet;
	Q_UINT16 length;
	kxSocket *mySocket;
	Q_UINT16 totalRead;
};
	
typedef struct kxContactExchange
{
	UIN uin;
	char *nick;
};

typedef struct kxChatContactStruct
{
  UIN uin;
  QString nick;
  int br, bg, bb;  // background colors
  int fr, fg, fb;  // foreground colors
  int fontSize;    // font size  
  int fontFamily;  // font font family
  QString fontName;
  Q_UINT32 ip, realIp;
  Q_UINT32 port;
  kxSocket *socket;  
  int status; // chat packet status
  bool last; // last packets before chat session?
  QString text;
  QByteArray *buffer;
  int bufferLen;
};

typedef struct kxChatSessionStruct
{
  kxChatContactStruct ourInfo;
  kxServerSocket *sockserver;
  QList<kxChatContactStruct> contact;
};


/**This class handles the TCP connection between ICQ clients.

It hadles TCP v2 at this moment !
  *@author Herwin Jan Steehouwer
  */

class kxTCP : public QObject, kxPacket  {
	Q_OBJECT
public: 
	kxTCP(Q_UINT32 _minPort=0, Q_UINT32 _maxPort=0);
  /** Get our port */
  Q_UINT16 getPort();
  Q_UINT32 getIntAddr();
  /** Get out addres */
  Q_UINT32 getAddr();
	~kxTCP();
  /** parse the packet */
  void parseData(QByteArray *a, kxSocket *, int, bool _sendAck = 1);
  /** Send this packet */
  int send(Q_UINT16 _type, kxSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _command=0, const char *_message=NULL, int port=0);
  
  int kxTCP::sendFileAccept(kxSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _port=0);
  /** parse this message */
  void parseMessage(char *message, int type, Q_UINT32 uin );
  /** connect to this IP */
  int connect(UIN uin);
  /** Send a packet, URL or MSG */
  int sendPacket(UIN, int,char *);
  /** Send a TCP message */
  int sendMessage(UIN, char *);
  /** Send a TCP URL */
  int sendUrl(UIN, char *, char *);
  int sendRandomInfoRequest(UIN _uin);
  /** send the handshake */
  void sendHandshake(UIN , kxSocket *);
  /**  */
  void parseContacts(char *, UIN);
  /** read the status message */
  int sendReadStatus(UIN, Q_UINT16 status);
  /** chat request */
  int sendChatRequest(UIN, const char *);
  int sendFileRequest(UIN _uin, const char *_message, const char *_file, Q_UINT32 _size);
  /** reject chat */
  int sendChatReject(UIN, Q_UINT32, const char *, kxSocket *_k=NULL);
  /** reject chat */
  int sendFileReject(UIN, Q_UINT32, const char *, kxSocket *_k=NULL);
  /** Accept chat */
  int sendChatAccept(UIN, Q_UINT32, int);
  /** Accept File */
  int sendFileAccept(UIN, Q_UINT32, int);
  /** delete this socket */
  void deleteSocket(UIN);
  int sendFileAcceptAck(kxSocket *_ks, Q_UINT32 _ruin, Q_UINT32 _seq=0, int _port=0);
  int sendContacts(UIN _uin,QList<kxAddContactStruct> *lst);
	
	kxServerSocket *myServerSocket;	
	QList<kxIncommingPacket> packetList;
	Q_UINT16 sequence;

	kxServerSocket *getNextFreePort();
	
	QList<kxChatSessionStruct> chatSessions;
	
	Q_UINT32 freePort;
	Q_UINT32 minPort;
	Q_UINT32 maxPort;
	
			
public slots:
  /** Accept  a incomming connection... */
  void SlotAccepted(kxSocket *);
  /**  */
  void SlotReadEvent(kxSocket *);
  /**  */
  void SlotWriteEvent(kxSocket *);
  /**  */
  void SlotCloseEvent(kxSocket *);

signals:
	/** there is a message for UIN */
	void receivedMessage(UIN, kxMessageStruct );
	/** there is a URL for UIN */
	void receivedUrl(UIN uin, kxMessageStruct);
	/** we got a Ack message */
	void receivedAck(int seq);
	/** we got a Chat Ack message */
	void receivedChatAck(int seq, int status, UIN uin,Q_UINT16 port, char *);

	/** we received a status message in the ack file !*/
	void receivedStatusMessage(UIN uin, char *message);
	void receivedRandomAck(UIN, char *);
  void receivedAskAddContact(UIN,QList<kxAddContactStruct> *);	
  void receivedUnknownStartPacket(QByteArray *, UIN, Q_UINT16);
  void receivedUnknownCancelPacket(QByteArray *, UIN, Q_UINT16);
  void SignalNewFile(UIN,int,QString, QString, int);
};

#endif

