#ifndef KXFILE_H
#define KXFILE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kxengine.h>
#include <kxtcp.h>
#include <kxpacket.h>
#include <v2_codes.h>
#include <qobject.h>

struct FileBatch
{
  QString fileName;
  Q_UINT32 len;
};

#define SEND_FILE 1
#define GOT_FILE 2

class kxFile : public QObject, kxPacket
{
  Q_OBJECT
public:
  kxFile(UIN, kxServerSocket *,int, int, QString, int, int _seq=0);
 
  int type;
  kxServerSocket *fileXSock;
  QString fileName;
  kxSocket *fileSock;
  int size;
  UIN uin;
  int port;
  QList<kxIncommingPacket> packetList;
  QList<FileBatch> fileBatch;
  Q_UINT32 batchCount;
  Q_UINT32 batchNum;
  Q_UINT32 sizeDone;
  QFile *file;
  Q_UINT32 fileLen;
  bool sendDone;
  int status;
  
  void parseData(QByteArray *a, int len);
  int doConnect();
  void sendServerInit();
  void sendStartFile(int,int);
  void sendHandshake();
  void sendClientInit();
  void sendFile();
  void sendBatchInfo();
  void saveFile(QString, QFile *, int);
  void closeNow();

public slots:
  void SlotAccepted(kxSocket *);  
  void SlotReadEvent(kxSocket *);  
  void SlotCloseEvent(kxSocket *_ks);  
  void SlotWriteEvent(kxSocket *_ks);  
  
signals:
  void SignalConnectError();  
  void SignalProcessInit(int, int); // batch len, total file size
  void SignalServerInfo(int, int, QString, QString); // total Size, total Files, localname, remote name
  void SignalSaveFile(QString, int, int, int);  // fileName, file num, size, speed
  void SignalSizeUpdate(int);
  void SignalCanNotConnect();
  void SignalGotConnection();
  void SignalFileComplete();
  void SignalAllDone();
  void SignalSendOk();
};

#endif

