#include "kxfile.h"
#include <kxengine.h>
#include <kxcontact.h>
#include <kxtcp.h>

kxFile::kxFile(UIN _uin, kxServerSocket *_sock, int _port, int _type,QString _filename, int _size, int _seq) :  QObject(), kxPacket()
{
  fileName=_filename;
  fileLen=_size;
  uin=_uin;
  port=_port;
  fileXSock=_sock;
 	initPacket();	
  fileBatch.setAutoDelete(TRUE);
  packetList.setAutoDelete(TRUE);
  type=_type;
  sendDone=FALSE;
  
  switch(type)
  {
    case GOT_FILE:
      debug("connect..");    
      QObject::connect(fileXSock,SIGNAL(accepted(kxSocket *)), this, SLOT(SlotAccepted(kxSocket *)));
      debug("send accept..");
      ENGINE->TCP->sendFileAccept(uin,_seq,fileXSock->getPort());
      file=NULL;
      break;
    case SEND_FILE:
      file=new QFile(fileName);
      int s;
			s=doConnect();  // connect to the File port
			debug("Connect Chat: %d",s);
			if (s<=0) { fileSock=NULL; debug("no sock"); emit SignalConnectError(); }
			if (!fileSock) { debug("no sock"); emit SignalConnectError(); }
			else
			{
				sendHandshake();
				sendClientInit();
			}
      break;
  }  
}

int kxFile::doConnect()
{
	kxContactStruct p=ENGINE->CONTACT->getContact(uin);

	if (port==0 || p.ip==0) return -1;
	Q_UINT32 ip;	
	if (p.intIp) debug("Use Internal IP ! %d",p.realIp);
	if (p.intIp) ip=p.realIp; else ip=p.ip;
	Q_UINT32 l=icqToIp(ip);
	fileSock=new kxSocket(l, port);
	debug("new kxSocket");
	if (fileSock->socket()!=-1)
	{
		fileSock->enableRead(TRUE);
		QObject::connect(fileSock,SIGNAL(readEvent(kxSocket *)), this, SLOT(SlotReadEvent(kxSocket *)));
		QObject::connect(fileSock,SIGNAL(closeEvent(kxSocket *)), this, SLOT(SlotCloseEvent(kxSocket *)));
		QObject::connect(fileSock,SIGNAL(writeEvent(kxSocket *)), this, SLOT(SlotWriteEvent(kxSocket *)));
		emit SignalGotConnection();
		return fileSock->socket(); 		
	}
	else
	{
		delete fileSock;
		fileSock=NULL;
		debug("delete sock connect");
		emit SignalCanNotConnect();
	}
	debug("connect error ;-)");
	return -1;
}

void kxFile::SlotAccepted(kxSocket *_ks)
{
  debug("Connected...FileX");
 	QObject::connect(_ks,SIGNAL(readEvent(kxSocket *)), this, SLOT(SlotReadEvent(kxSocket *)));
	QObject::connect(_ks,SIGNAL(closeEvent(kxSocket *)), this, SLOT(SlotCloseEvent(kxSocket *)));
	QObject::connect(_ks,SIGNAL(writeEvent(kxSocket *)), this, SLOT(SlotWriteEvent(kxSocket *)));
	QObject::disconnect(fileXSock,SIGNAL(accepted(kxSocket *)), this, SLOT(SlotAccepted(kxSocket *)));
	fileSock=_ks;
	fileSock->enableRead(TRUE);
	if (fileXSock)
	{
	  delete fileXSock;
	  fileXSock=NULL;
	}
	emit SignalGotConnection();
}

void kxFile::SlotReadEvent(kxSocket *_ks)
{
  debug("read");
	kxIncommingPacket *p;
	int len;
	Q_UINT16 packetLen;
	Q_UINT32 sock=_ks->socket();
	debug("got data");
	if (1)
	{
  	for (Q_UINT16 t=0; t<packetList.count(); t++)
  	{
  		p=packetList.at(t);
  		if (p->mySocket==_ks)
  		{
  			if (p->length==0)
  			{
  				char *buf2=new char[3];		
  				len=recv(sock, buf2, 2,0 );
  			 	QByteArray  a; //=new QByteArray(2049);
  				a.setRawData( buf2, len );
  				QDataStream s( a, IO_ReadOnly );            // open on a's data
  				s.setByteOrder(QDataStream::LittleEndian);	
  				s >> (Q_UINT16 &)packetLen;		
  				p->length=packetLen;
  				p->totalRead=0;
  				delete buf2;

  				return;
  			}
  			QDataStream s(p->packet, IO_ReadWrite);
  			s.setByteOrder(QDataStream::LittleEndian);
  			
  			char *buf=new char[p->length-p->totalRead+1];	
  			len=recv(sock, buf, p->length-p->totalRead,0 );
  			if (len>0)
  			{	
  				s.device()->at(p->totalRead);
  				s.writeRawBytes(buf,len);	
  				p->totalRead+=len;
  				debug("packet: len: %d, %d",len, p->totalRead);
  			}
  			delete buf;
  			if (p->totalRead>=p->length)
  			{
  			  debug("new data");
  				parseData(&p->packet, p->totalRead);
  				packetList.remove(t);
  			}
  			return;
  		}
   }
    p=new kxIncommingPacket;
    p->length=0;
    p->totalRead=0;
    p->mySocket=_ks;
    packetList.append(p);

   	char *buf2=new char[3];		
   	len=recv(sock, buf2, 2,0 );
   	QByteArray  a; //=new QByteArray(2049);
   	a.setRawData( buf2, len );
   	QDataStream s( a, IO_ReadOnly );            // open on a's data
   	s.setByteOrder(QDataStream::LittleEndian);	
   	s >> (Q_UINT16 &)packetLen;		
   	p->length=packetLen;
   	p->totalRead=0;
 }
}
void kxFile::parseData(QByteArray *a, int len)
{
    QDataStream s( *a, IO_ReadOnly );            // open on a's data
		s.setByteOrder(QDataStream::LittleEndian);	

  	
    Q_UINT8 type;
    
    s >> (Q_UINT8  &) type;
    if (type!=0x06)
    {
      s.device()->at(0);    
    	debug("[TCP]=========================[receive]=======================");	
    	debug("packet: len: %d",len);
    	QString str,tmps;
    	Q_UINT8 ttmp;
    	for (int t=0; t<len; t++)
    	{	
    		s >> (Q_UINT8 &)ttmp;		
    		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
    		str.append(tmps.data());		
        if (str.length()>200) { debug(str.data()); str.remove(0,str.length()); }				  		
    	}
    	debug("%s", str.data());
    	debug("[TCP]=========================[end receive]=======================");
    } else debug("{Ignore Data}");    
    s.device()->at(0);
    
    s >> (Q_UINT8  &) type;
    
  	switch(type) //status)
  	{
  	  case 0xFF: // handshake
  	    debug("Got File Handshake, ignore");
  	    break;
  	  case 0x00: // packet 0
  	  {
  	    debug("Got File Packet 0");  
  	      Q_UINT32 junk;
  	      Q_UINT32 total, batchLen, speed;
  	      Q_UINT16 flen;
  	      char *_fileName;
  	      
  	      s >> (Q_UINT32 &)junk;
  	      s >> (Q_UINT32 &)batchLen;
  	      s >> (Q_UINT32 &)total;
  	      s >> (Q_UINT32 &)speed;
  	      s >> (Q_UINT16 &)flen;
  	      _fileName=new char[flen+1];
    	    s.readRawBytes(_fileName, flen);
    	    debug("File: %s, total: %d, batch: %d",_fileName, total, batchLen);  	      
    	    batchCount=batchLen;
    	    batchNum=0;
          emit SignalProcessInit(batchLen, total);
    	    sendServerInit();
  	    break;
  	  }
  	  case 0x01: // packet 0
  	  {
  	    debug("Got File Packet 1");  
        emit SignalServerInfo(file->size(), 1, QString(fileName), QString("")); // total Size, total Files, localname, remote name
  	    sendBatchInfo();
  	    break;
  	  }
  	  case 0x02: // packet 0
  	  {
  	    debug("Got File Packet 2");  
  	    
  	    Q_UINT8 X1,fakechar;
  	    Q_UINT16 flen, fakelen;
  	    Q_UINT32 size;
  	    Q_UINT32 X2, speed;
        char *fileName;  	 
           
  	    s >> (Q_UINT8  &) X1;
  	    s >> (Q_UINT16 &) flen;
  	    fileName=new char[flen];
  	    s.readRawBytes(fileName, flen);
  	    s >> (Q_UINT16 &) fakelen;
  	    s >> (Q_UINT8  &) fakechar;
  	    s >> (Q_UINT32 &) size;
  	    s >> (Q_UINT32 &) X2;
  	    s >> (Q_UINT32 &) speed;
        
        fileLen=size;
        sizeDone=0;
  	    QString tmp;
  	    tmp.sprintf("%d",size);
        batchNum++;
   	    tmp.sprintf("%d / %d",batchNum,batchCount);
   	    debug("Show Num Files: %s",tmp.data());

   	    emit SignalSaveFile(QString(fileName),batchNum,size, speed);
   	    
  	    break;
  	  }
  	  case 0x03: // packet 0
  	  {
  	    debug("Got File Packet 3, start sending");  
  	    
//  	    Q_UINT8 ck;
  	    //s >> (Q_UINT8 &)ck;
  	    s >> (Q_UINT32 &) sizeDone;
  	 
  	    sendDone=FALSE; 	    
  	    sendFile();
  	    debug("=-=-==-=-=-=-=-=-send done !-=-=-=-=-=-=-=-=-=-");
  	    sendDone=TRUE;
        
  	    break;
  	  }
  	  case 0x04: // packet 0
  	    debug("Got File Packet 4, ??");  
  	    break;
  	  case 0x05: // packet 0
  	    debug("Got File Packet 5, change speed");  
  	    break;   
  	  case 0x06: // packet 0
  	  {
  	    debug("Got File Packet 6, file data");    	    
  	    
  	    char *buf;
  	    buf=new char[len+1];
    	  s.readRawBytes(buf, len-1);
    	  int ll=0;
    	  if (file) 
    	    ll=file->writeBlock(buf, len-1);
    	  debug("Length of writing: %d",ll);
    	  if (ll<=0)
    	  { 
   	      debug("close file. error !!");
   	      delete fileSock;
   	      fileSock=NULL;
   	      debug("delete Sock");
   	      return;
   	    }	    

  	    sizeDone+=(len-1);
  	    emit SignalSizeUpdate(sizeDone);
  	    debug("len: %d, done %d, size: %d",len, sizeDone, fileLen);
  	    if (sizeDone>=fileLen) // file complete !
  	    {
  	      emit SignalFileComplete();
          debug("===========file compelete=========");
  	      if (file)  // file is open ?
  	      { 
  	        file->close();
  	        delete file;
  	      }
  	      file=NULL;
  	      debug("file done");
  	      if (!(batchNum<batchCount)) // there is more waiting ??
          {
            emit SignalAllDone();
            return;
          }
  	    }
  	    break;
  	  }
  	}
}

/**  */
void kxFile::SlotCloseEvent(kxSocket *_ks){
	debug("delete _ks !");
	if (fileXSock)
	  delete fileXSock;
	if (_ks!=fileSock) { debug("????????????????? "); delete _ks; }
	if (fileSock) 
	  delete fileSock;
	
	fileSock=NULL;
	fileXSock=NULL;
	if (file) delete file;
	file=NULL;
	debug("Close chat");
}

/**  */
void kxFile::SlotWriteEvent(kxSocket *_ks)
{
  debug("write");
	if (!fileSock) { debug("can not send"); return; }
	packetDef *p, *pc;
	bool stop;
	
 	for (int t=0; t<count(); t++)
	{
		p=getPacket(t);
		if (p->mySocket==_ks)
		{
			debug("try write");			
			QByteArray *b=p->packet;
			QByteArray a;
			QDataStream s(a, IO_ReadWrite);
			s.setByteOrder(QDataStream::LittleEndian);
			s << (Q_UINT16) p->length;
			int ret;
 			ret=::send(_ks->socket(), a.data(), 2, 0);
			debug("send len: %d, %d, %s",ret, errno, strerror(errno));
 			if (ret <= 0)
 				return;
 			debug("send File: %d",p->length);
			ret=::send(_ks->socket(), b->data(), p->length, 0);
			if (ret > 0 )
			{
				_ks->enableWrite(FALSE);
				stop=TRUE;
				debug("Send File TCP ok !(%d, %d, %d)", ret, p->length, _ks->socket() );
				if (status==7) sizeDone+=p->length-1;
				
				deletePacket(t);
//				if (Last)
//					chatStarted=TRUE;
				kxContactStruct cs;
 				for (int t1=0; t1<count(); t1++)
 				{
 					pc=getPacket(t1);
    						
 					if (pc->mySocket==_ks)
 					{
 						_ks->enableWrite(TRUE);
 						stop=FALSE;
 						t1=count();
 						continue;
 					}
			  }
			  if (stop && sendDone)
			  {
          debug("---------file done-----------");
          emit SignalSendOk();
		      if (fileSock)
          {
           	QObject::disconnect(fileSock,SIGNAL(readEvent(kxSocket *)), this, SLOT(SlotReadEvent(kxSocket *)));
          	QObject::disconnect(fileSock,SIGNAL(closeEvent(kxSocket *)), this, SLOT(SlotCloseEvent(kxSocket *)));
        	  QObject::disconnect(fileSock,SIGNAL(writeEvent(kxSocket *)), this, SLOT(SlotWriteEvent(kxSocket *)));
            delete fileSock;
            fileSock=NULL;
          }
			  }			    
				return;				
			}
		}
	}
}

void kxFile::sendStartFile(int pos,int num)
{
 	debug("Send Server Start");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	
	Q_UINT8 packet=3;
	Q_UINT32 speed= 0x64, X1=0;
	Q_UINT32 len=pos;
	
  s << ( Q_UINT8  ) packet;
  s << ( Q_UINT32 ) len;
  s << ( Q_UINT32 ) X1;
  s << ( Q_UINT32 ) speed;  
  
  length=13;
  
	addPacket2List(fileSock, uin);

	fileSock->enableWrite(TRUE);   	
}
void kxFile::sendServerInit()
{
 	debug("Send Server Init");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	
	Q_UINT8 junk=1;
	Q_UINT32 junk2= 0x64;
	Q_UINT16 len=fileName.length()+1;
	
  s << ( Q_UINT8  ) junk;
  s << ( Q_UINT32 ) junk2;
  s << ( Q_UINT16 ) len;
  s.writeRawBytes(fileName.data(),len);
  
  length=7+len;
  
	addPacket2List(fileSock, uin);

	fileSock->enableWrite(TRUE);   	
}
void kxFile::sendHandshake()
{
	debug("Send File HandShake");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 ip=ipToIcq(ENGINE->ourExtIP), lip=ipToIcq(ENGINE->ourIntIP), _port=ENGINE->ourPort, uin=ENGINE->ourUin;
	Q_UINT32 chatPort=port;
	Q_UINT16 version =0x02;
  Q_UINT16 mac =0x00;	 
	Q_UINT8 hs=0xff, tcpc=0x04;	

	s << ( Q_UINT8  ) hs;
	s << ( Q_UINT16 ) version;
  s << ( Q_UINT16 ) mac;		
	s << ( Q_UINT32 ) _port;
	s << ( Q_UINT32 ) ENGINE->ourUin;
	s << ( Q_UINT32 ) ip;	
	s << ( Q_UINT32 ) lip;		
	s << ( Q_UINT8  ) tcpc;
	s << ( Q_UINT32 ) chatPort;	
	
//	debug("ack Packet to send: command: %Xd (%d)",command,command);

	length=1+2+2+4+4+4+4+1+4;
	addPacket2List(fileSock, uin);

	fileSock->enableWrite(TRUE);   	
}

void kxFile::sendClientInit() //packet 0
{
 	debug("Send Client Init");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);
	
	Q_UINT8 junk=0;
	Q_UINT32 junk2=0, speed=0x0, numfiles=1;
	Q_UINT16 len=fileName.length()+1;
	Q_UINT32 size=0;
	if (file) size=file->size();
	
	
  s << ( Q_UINT8  ) junk;  // packet number
  s << ( Q_UINT32 ) junk2; // X1 ?
  s << ( Q_UINT32 ) numfiles;
  s << ( Q_UINT32 ) size;
  s << ( Q_UINT32 ) speed;
  s << ( Q_UINT16 ) len;
  s.writeRawBytes(fileName.data(),len);
  
  length=1+4+4+4+4+2+len;
  
	addPacket2List(fileSock, uin);

	fileSock->enableWrite(TRUE);
}
void kxFile::sendBatchInfo()
{
 	debug("Send Batch Info");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 size=0;
	if (file) size=file->size();  
  
  int c=0;
  QString newFile;
  for (Q_UINT16 t=0; t<fileName.length(); t++)
  {
    if (fileName[t]=='/' || fileName[t]=='\\')
      c=t;
  }
  for (Q_UINT16 t=c+1; t<fileName.length(); t++)
  {
    newFile+=fileName[t];
  }  
       
  Q_UINT16 len=newFile.length()+1;
  Q_UINT16 len2=1;
  Q_UINT32 X2=0x0;
  Q_UINT32 speed=0x64;
  
  Q_UINT8 packet=0x02, X1=0, str2=0;
  
  s << ( Q_UINT8  ) packet;
  s << ( Q_UINT8  ) X1;
  s << ( Q_UINT16 ) len;
  s.writeRawBytes(newFile.latin1(),len);  
  s << ( Q_UINT16 ) len2;  // empty string
  s << ( Q_UINT8  ) str2;  
  s << ( Q_UINT32 ) size;
  s << ( Q_UINT32 ) X2;
  s << ( Q_UINT32 ) speed;
  
  length=1+2+2+1+4+4+4+len;
  
	addPacket2List(fileSock, uin);

	fileSock->enableWrite(TRUE);   	
	status=6;

}
void kxFile::sendFile()
{
 	debug("Sending file..");	
			
  Q_UINT32 curPos, size=file->size(), len=0;
  Q_UINT8 first=0x06;	
  file->open(IO_ReadOnly);
  file->at(sizeDone);
  curPos=sizeDone;
  while(curPos<size)
  {
    len=4096;
    if (size-curPos<len) len=size-curPos;
    debug("  = send file... len: %d, curPos: %d, size: %d",len, curPos, size);
    QDataStream s(*byteArray, IO_ReadWrite);
  	s.setByteOrder(QDataStream::LittleEndian);
    char *buf;
    buf=new char[len+1];
    file->readBlock(buf, len);
    s << ( Q_UINT8 ) first;
    s.writeRawBytes(buf,len);    	
    
    length=1+len;
  	
    if (fileSock) 
    {
      addPacket2List(fileSock, uin);
      fileSock->enableWrite(TRUE);   	  
    }
  	curPos+=len;

     delete buf;
    emit SignalSizeUpdate(curPos);
  }
}
void kxFile::saveFile(QString _fileName, QFile *_file, int start)
{  	    
  file=_file;
   sendStartFile(start,batchNum);
}
void kxFile::closeNow()
{
  if (fileSock) delete fileSock;
  if (fileXSock) delete fileXSock;
}
