#ifndef KXENGINE_H
#define KXENGINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <kapp.h>

#include <v2_codes.h>
#include <qtimer.h>
#include <kxmessage.h>

struct kxAddContactStruct;
class QString;
class QPixmap;
class kxMessage;
class kxContact;
class kxEngine;
class kxConnection;
class kxMainWindow;
class kxTCP;
class kxUDP;
class kxSend;


#define ENGINE kxEngine::getPointer()

class kxEngine : public QObject
{
  Q_OBJECT
public:
  kxEngine();
  
  void init(); // init engine
  
  // variables
  static kxEngine *ptr;
  static kxEngine *getPointer() { return ptr; };

  int statusChangeAck,statusChangeTo;
  
  kxContact *CONTACT;
  kxMessage *MESSAGE;
  kxTCP *TCP;
  kxUDP *UDP;
  int connectRetry;
  int sendSeq;
  
  QString awayMessage;
  QString naMessage;
  QString dndMessage;  

  QTimer connectTimer;
  bool tryLogin;
  int loginStatus;
  
  int connect();
  int disconnect();
  int getStatus() { return currentStatus; };
  void login(int);
  void changeStatus(int);
  void setCurrentStatus(int);
  void setUserInfo(Q_UINT32 _uin, QString _passwd, QString _server, int _port, int _minPort, int _maxPort);
  bool loggedOn();
  void sendAuthorization(UIN);
  void rejectContact(UIN,QString);
  void addContact2List(UIN);
  void notifyContact(UIN, QString, QString, QString, QString);
  void getStatusMessage(UIN, int);
  void setStatusMessages(QString, QString, QString);
  QString getStatusMessages(int);
    
// search:
  int searchForUin(UIN);
  int searchForEmail(const char *_email);
  int searchForExtra(const char *_nick,const char *_first, const char *_last);           
  
// send messages
  kxSend *sendMessage(UIN, QString, bool);
  kxSend *sendUrl(UIN, QString, QString, bool);
  kxSend *sendContacts(UIN, QList<kxAddContactStruct> *, bool);

public slots:
  void SlotConnecting();
  void SlotConnected();
  void SlotDisconnected(int);
  void SlotConnectTimeout();
  void SlotInvalidPassword();
  void SlotErrorString(QString);
  void SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SlotContactChange(UIN );
  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotNewUrl(UIN, kxMessageStruct);
  void SlotNewAuthReq(UIN, kxMessageStruct);
  void SlotNewAdded(UIN, kxMessageStruct);
	void SlotSearchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool);
	void SlotSearchFailed(Q_UINT16);
	void SlotContactAdd2List(UIN, QString);
	void SlotReceivedAck(int);
	void SlotStatusMessage(UIN uin, char *message);
	void SlotNewFile(UIN,int,QString,QString, int);
	

public:  
// neededfor ICQ communication	
  int ourIntIP;
  int maxPort, minPort;
  int ourExtIP;
  int ourPort;
  Q_UINT32 ourUin;
  int currentStatus;
  int ourMode;
  int lastStatus;
  bool webStatus;
  bool hideIP;
  int serverPort;
  QString server;
  QString ourPassword;

signals:  
  void SignalConnectError(QString);
  void SignalInvalidPassword();
  void SignalConnected();
  void SignalConnecting();
  void SignalDisconnected(int);
  void SignalStatusUpdate(int);
  void SignalContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SignalContactChange(UIN );
  void SignalNewMessage(UIN, kxMessageStruct);
  void SignalNewUrl(UIN, kxMessageStruct);
  void SignalNewAuthReq(UIN, kxMessageStruct);
  void SignalNewAdded(UIN, kxMessageStruct);  
  void SignalUpdateDock();  // for docking 
	void SignalSearchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool);
	void SignalSearchFailed(Q_UINT16);
	void SignalContactAdded(UIN, QString);
  void SignalReceivedAck(int);
  void SignalStatusMessage(UIN uin, char *message);
  void SignalNewFile(UIN,int,QString,QString, int);

};


#endif

