#include <kxsend.h>
#include <qapplication.h>
#include <kwin.h>
#include "kxengine.h"
#include <qlabel.h>
#include "kxcontact.h"
#include <kxudp.h>
#include <kxtcp.h>

kxEngine *kxEngine::ptr=0L;

kxEngine::kxEngine() : QObject()
{
  ptr=this;
  
  statusChangeAck=-1;
  sendSeq=0;
}  

void kxEngine::init()
{
  CONTACT=new kxContact();
  CONTACT->init();
  
  MESSAGE=new kxMessage();
  QObject::connect(this, SIGNAL(SignalNewMessage(UIN, kxMessageStruct)), MESSAGE, SLOT(newMessage(UIN, kxMessageStruct)));
  QObject::connect(this, SIGNAL(SignalNewUrl(UIN, kxMessageStruct)), MESSAGE, SLOT(newUrl(UIN, kxMessageStruct)));
  QObject::connect(this, SIGNAL(SignalNewAuthReq(UIN, kxMessageStruct)), MESSAGE, SLOT(newAuthReq(UIN, kxMessageStruct)));
  QObject::connect(this, SIGNAL(SignalNewAdded(UIN, kxMessageStruct)), MESSAGE, SLOT(newAdded(UIN, kxMessageStruct)));
  
  tryLogin=FALSE;
  QObject::connect(&connectTimer, SIGNAL(timeout()), this, SLOT(SlotConnectTimeout()));
  
  currentStatus=STATUS_OFFLINE;    
}

void kxEngine::setUserInfo(Q_UINT32 _uin, QString _passwd, QString _server, int _port, int _minPort, int _maxPort)
{
  ourUin=_uin;
  ourPassword=_passwd;
  server=_server;
  serverPort=_port;
  maxPort=_maxPort;
  minPort=_minPort;  

  TCP=new kxTCP(minPort,maxPort);
  debug("TCP engine started");
  UDP=new kxUDP(TCP->getPort(), TCP->getIntAddr());
  debug("UDP engine started");
  UDP->setFirstData(_uin,_passwd.latin1());

  QObject::connect(UDP, SIGNAL(receivedAck(int)), this, SLOT(SlotReceivedAck(int)));
  QObject::connect(UDP, SIGNAL(connected()), this, SLOT(SlotConnected()));
  QObject::connect(UDP, SIGNAL(connecting()), this, SLOT(SlotConnecting()));
  QObject::connect(UDP, SIGNAL(disconnected(int)), this, SLOT(SlotDisconnected(int)));
  QObject::connect(UDP, SIGNAL(errorString(QString)), this, SLOT(SlotErrorString(QString)));
  QObject::connect(UDP, SIGNAL(invalidPassword()), this, SLOT(SlotInvalidPassword()));
  QObject::connect(UDP, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(TCP, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(UDP, SIGNAL(receivedUrl(UIN,kxMessageStruct)), this, SLOT(SlotNewUrl(UIN, kxMessageStruct)));     
  QObject::connect(TCP, SIGNAL(receivedUrl(UIN,kxMessageStruct)), this, SLOT(SlotNewUrl(UIN, kxMessageStruct)));     
  QObject::connect(UDP, SIGNAL(receivedAuth(UIN,kxMessageStruct)), this, SLOT(SlotNewAuthReq(UIN, kxMessageStruct)));  
  QObject::connect(UDP, SIGNAL(receivedAdded(UIN,kxMessageStruct)), this, SLOT(SlotNewAdded(UIN, kxMessageStruct)));  
  QObject::connect(UDP, SIGNAL(signalContactStatusChange(UIN, Q_UINT16, Q_UINT16 )), this, SLOT(SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16 )));    
  QObject::connect(TCP, SIGNAL(receivedStatusMessage(UIN, char *)), this, SLOT(SlotStatusMessage(UIN, char *)));
  QObject::connect(TCP, SIGNAL(SignalNewFile(UIN,int,QString, QString, int)), this, SLOT(SlotNewFile(UIN, int, QString,QString, int))); 
  QObject::connect(UDP, SIGNAL(receivedMetaSearch(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool)),
                   this, SLOT(SlotSearchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool)));
  QObject::connect(UDP, SIGNAL(receivedMetaSearchFailed(Q_UINT16)), this, SLOT(SlotSearchFailed(Q_UINT16)));                                                                        
}

bool kxEngine::loggedOn()
{ 
  return UDP->loggedOn(); 
}

int kxEngine::connect()
{
  return UDP->connect(server.latin1(), serverPort);
}

void kxEngine::login(int _status)
{
  connectRetry=0;
  connectTimer.start(20000);
  UDP->login(_status);
  tryLogin=TRUE;
  loginStatus=_status;
}
void kxEngine::changeStatus(int _status)
{
  statusChangeAck=UDP->sendStatusChange(_status);
  statusChangeTo=_status;
}
void kxEngine::SlotReceivedAck(int _ack)
{
  if (statusChangeAck==_ack)
  {
    currentStatus=statusChangeTo;
    emit SignalStatusUpdate(statusChangeTo);    
    emit SignalUpdateDock();
  }
  else  emit SignalReceivedAck(_ack);
}

void kxEngine::SlotConnected()
{
  debug("connected!!");
  tryLogin=FALSE;
  connectTimer.stop();  
  currentStatus=STATUS_ONLINE;
  emit SignalConnected();
  emit SignalUpdateDock();  
}
void kxEngine::SlotDisconnected(int _t)
{
  debug("disconnected..");
	for (int t=0; t<CONTACT->count(); t++)
	{
	  debug("Go Offline: %d, %d",CONTACT->getContact(t).uin, CONTACT->getContact(t).status);
		if (ENGINE->CONTACT->getContact(t).status!=STATUS_OFFLINE)
		{
		  debug("Ok, go..");
		  CONTACT->updateStatus(t,STATUS_OFFLINE);
		  emit SignalContactStatusChange(CONTACT->getContact(t).uin,STATUS_OFFLINE, 1);
		}
  }  
  currentStatus=STATUS_OFFLINE;
  emit SignalDisconnected(_t);
  emit SignalUpdateDock();
}
void kxEngine::SlotConnectTimeout()
{
  currentStatus=STATUS_OFFLINE;
  debug("Connect timeout");
  if (connectRetry++>2)
  {
    debug("Retry...");
    connectTimer.start(20000);
    UDP->login(loginStatus);
  }
  else
  {
    connectTimer.stop();  
    QString tmp="Connection timeout";
    emit SignalConnectError(tmp);
    emit SignalDisconnected(kxUDP::TimeOut);
    emit SignalUpdateDock();
    tryLogin=FALSE;
  }
}
void kxEngine::SlotInvalidPassword()
{
  emit SignalInvalidPassword();
  currentStatus=STATUS_OFFLINE;
}
void kxEngine::SlotConnecting()
{
  emit SignalConnecting();
}
void kxEngine::SlotErrorString(QString _str)
{
  currentStatus=STATUS_OFFLINE;
  emit SignalConnectError(_str);
}
int kxEngine::disconnect()
{
  if (tryLogin==TRUE)
    connectTimer.stop();  
   
  UDP->closeConnection(); 
  emit SignalUpdateDock();  
  return 1;
}

void kxEngine::setCurrentStatus(int _status)
{
  currentStatus=_status;
  emit SignalStatusUpdate(_status);
}
void kxEngine::SlotContactStatusChange(UIN _uin, Q_UINT16 _status, Q_UINT16 _type )
{
  emit SignalContactStatusChange(_uin,_status, _type);
}
void kxEngine::SlotContactChange(UIN _uin)
{
  emit SignalContactChange(_uin);
}

void kxEngine::SlotContactAdd2List(UIN _uin, QString)
{
  UDP->sendAddUser2List(_uin);
}

void kxEngine::SlotNewMessage(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewMessage(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewUrl(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewUrl(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewAuthReq(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewAuthReq(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewAdded(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewAdded(_uin, _msg);
  emit SignalUpdateDock();
}

int kxEngine::searchForUin(UIN _uin)
{
  return UDP->sendMetaSearchUin(_uin);
}
int kxEngine::searchForEmail(const char *_email)
{ 
  return UDP->sendMetaSearchEmail(_email);
}
int kxEngine::searchForExtra(const char *_nick,const char *_first, const char *_last)
{
  return UDP->sendMetaSearchNick(_nick,_first, _last);
}
void kxEngine::SlotSearchFound(Q_UINT16 _s, UIN _u, const char *_n, const char *_f, const char *_l, const char *_e, Q_UINT8 _a,Q_UINT16 _un, bool _last)
{
  debug("search Found");
  emit SignalSearchFound(_s, _u, _n, _f, _l, _e, _a, _un, _last);
}
void kxEngine::SlotSearchFailed(Q_UINT16 _s)
{
  debug("search Failed");
	emit SignalSearchFailed(_s);
}
kxSend *kxEngine::sendMessage(UIN _uin, QString _msg, bool _server)
{
  sendSeq++;  
  kxSend *send;
  send=new kxSend(MESSAGE_TYPE, sendSeq, _uin, _msg,"",_server);
  return send;
}
kxSend *kxEngine::sendUrl(UIN _uin, QString _msg, QString _url, bool _server)
{
  sendSeq++;  
  kxSend *send;
  send=new kxSend(URL_TYPE, sendSeq, _uin,_msg,_url, _server);  
  return send;
}
kxSend *kxEngine::sendContacts(UIN _uin, QList<kxAddContactStruct> *_list, bool _server)
{
  sendSeq++;  
  kxSend *send;
  send=new kxSend(sendSeq, _uin,_list, _server);  
  return send;
}
void kxEngine::sendAuthorization(UIN _uin)
{
  UDP->sendAuth(_uin);
}
void kxEngine::rejectContact(UIN _uin,QString _str)
{
  UDP->sendIgnoreAuth(_uin,_str.latin1());
}
void kxEngine::addContact2List(UIN _uin)
{
  UDP->sendAddUser2List(_uin);
}
void kxEngine::notifyContact(UIN _uin, QString _n, QString _fn, QString _ln, QString _e)
{
  UDP->sendAddUser(_uin, _n, _fn, _ln, _e);
}
void kxEngine::SlotStatusMessage(UIN uin, char *message)
{
  emit SignalStatusMessage(uin, message);
  debug("Status Message: %s",message);
}
void kxEngine::getStatusMessage(UIN _uin, int _status)
{
  int sock;
  sock=ENGINE->TCP->connect(_uin);
  if (sock>0)
  {
    TCP->sendReadStatus(_uin, _status);
  }
}
void kxEngine::setStatusMessages(QString away, QString na, QString dnd)
{
  awayMessage=away;
  naMessage=na;
  dndMessage=dnd;
}
QString kxEngine::getStatusMessages(int status)
{
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			return awayMessage;
			break;
 		case STATUS_NA:
			return naMessage;
 			break;					
 		case STATUS_DND:								
			return dndMessage;
 			break;								
 		case STATUS_OCCUPIED:			
 			break;
 		case STATUS_FFC:											
 			break;
 	}
 	return QString("");
}
void kxEngine::SlotNewFile(UIN _u,int _s,QString _m,QString _f, int _si)
{
  emit SignalNewFile(_u,_s,_m, _f, _si);
}
