/***************************************************************************
                          ktail.h  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INCLUDE_KTAIL_H
#define INCLUDE_KTAIL_H

#include <kmainwindow.h>
#include <ktabctl.h>
#include <kapp.h>
#include <kconfig.h>
#include <kfontdialog.h>
//#include <ktablistbox.h>
#include <ktabctl.h>
#include <qtimer.h>
#include <qmlined.h>
#include <stdio.h>
#include <fcntl.h>

#include "mycmdlinedlg.h"
#include "mylogoptdlg.h"
#include "myremovedlg.h"
#include "mytext.h"
#include "ktail_config.h"
//#include "option.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define STA_LINES	1
#define STA_NAME	2

struct file_str {
	char filename[1024];
	char caption[1024];
	int filep;
	long filepos;
	int fstatus;
	bool completelastline;
	mytext *textlist;
	int type;
	pid_t pid;
	};

class rKTabCtl : public KTabCtl
{
	Q_OBJECT
public:
	rKTabCtl(QWidget *parent=0);
public slots:
	void mousePressEvent(QMouseEvent *e);
signals:
	void rightclicked();
	void middleclicked();
};

class ktail : public KMainWindow
{
	Q_OBJECT
public:
	ktail(KApplication *parent=0, const char *name=0);
	~ktail();
//	void resizeEvent (QResizeEvent *);
	void setfont(QFont fo);
	KMenuBar *menubar;
//	KStatusBar *statusbar;
	KTabCtl *tabctl;
//	KTabListBox *kt;
//	QPopupMenu *kt;
	mybox *w;
	QTimer *tim;
	QFont myfont;
/*	QMultiLineEdit *textlist[MAX_FILES]; */
	QList <file_str> filel;
	int active_tab;
	QPopupMenu *fileMenu,*optionMenu,*popmenu;
	int addfile(char *pfilename,char *filter,bool filterflag,int action=0);
//	KDNDDropZone *dnd;
	mycmdlinedlg *cmdlinedlg;
public slots:
	void saveconfig();

private:
//	void setallcwidth(KTabListBox *);
//	void setcwidth(KTabListBox *, int);
	int prev_width,prev_height;
	bool reading,do_stop;
	bool showstatusnonactive;
	void createtextbox();
	void stopall();
	void openregfile(file_str *);
	void openspecialfile(file_str *);
	void openipcpipe(file_str *);
	int readregfile(file_str *);
	int readspecialfile(file_str *);
	int readipcpipe(file_str *);
	void setpossibleitems();
	int idf1,idf2,idf3;
	mylogoptdlg *optionw;

private slots:
	void selectfont();
	void addfiledlg();
	void addcmdline();
//	void removefile();
	void removeit(int no);
	void removewindow();
//	void removeit(int no,int);
	void togglemenubar();
	void togglestatusbar();
//	void toggledecoration();
	void menucallback(int);
	void readintextlist();
	void readintextlistno(file_str *);
	void tabchg(int no);
	void tabchanged(int no);
//	void dropslot(KDNDDropZone *);
	void dialogClosedSlot(QWidget *, bool);
	void clearwindow();
	void reloadwindow();
	void dopopup();
//	void actionOnChange(mytext *);
};

#endif



