/***************************************************************************
                          ktail.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h>
#include <iostream.h>
//#include <ktopwidget.h>
//#include <ktablistbox.h>
#include <kapp.h>
#include <kglobal.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kmenubar.h>
//#include <kwm.h>
#include <kfiledialog.h>
#include <qwidget.h>
#include <qmlined.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qkeycode.h>

#include "ktail.h"
//#include "cmdlinedlg_impl.h"


#define M_HSTATUS	1
#define M_HMENU		2
#define M_HELP		3
#define M_REMOVETHIS	4
#define M_EDITFILTER	5
#define M_SETTINGS	6

#define REGFILE		1
#define SPECIALFILE	2
#define IPCPIPE		3

#define max(x,y)	((x)>(y))?(x):(y)

#define ALLOW_DECOR_CHANGE 1

#define VERSIONSTRING	VERSION

//Window mywindow;

rKTabCtl::rKTabCtl(QWidget *parent)
	: KTabCtl(parent)
{ }

void rKTabCtl::mousePressEvent(QMouseEvent *e)
{
//cerr << "mouse event in tabctl\n";
	if (e->button()==RightButton) {
		emit rightclicked();
//		cerr << "right mouse button\n";
	} else if (e->button()==MidButton)
		emit middleclicked();
	else KTabCtl::mousePressEvent(e);
}

ktail :: ktail(KApplication *, const char *name)
	: KMainWindow(0,name)
{
	char *p,*pf,*fpf,*ac;
	char dummy[2];
	bool has_filters,has_filterflags,has_actions;
	int action;

	QString tmp;
	int ii,found;

	*dummy=0;
	filel.clear();

	tabctl=0; reading=FALSE; do_stop=FALSE;
	cmdlinedlg=0;
	optionw=0;

	menubar=new KMenuBar(this);
	fileMenu=new QPopupMenu;
	menubar->insertItem(i18n("&File"),fileMenu);
	fileMenu->insertItem(i18n("&Add file ..."),
		this,SLOT(addfiledlg()));
	fileMenu->insertItem(i18n("&Add pipe ..."),
		this,SLOT(addcmdline()));
//	idf1=fileMenu->insertItem(i18n("&Remove file ..."),
//		this,SLOT(removefile()));
	fileMenu->insertSeparator();
	idf2=fileMenu->insertItem(i18n("&Clear current log window"),
		this,SLOT(clearwindow()),CTRL + Key_C);
	idf3=fileMenu->insertItem(i18n("&Refresh current log window"),
		this,SLOT(reloadwindow()),CTRL + Key_R);
	fileMenu->insertItem(i18n("&Manage log windows"),
		this,SLOT(removewindow()));
	fileMenu->insertSeparator();
	fileMenu->insertItem(i18n("&Quit"),
		this,SLOT(close()),CTRL + Key_Q);
	optionMenu=new QPopupMenu;
	menubar->insertItem(i18n("&Options"),optionMenu);
	optionMenu->insertItem(i18n("&Font ..."),
		this,SLOT(selectfont()));
	optionMenu->insertItem(i18n("&Settings"),M_SETTINGS);
	optionMenu->insertItem(i18n("Hide &Menubar"),M_HMENU);
	optionMenu->insertItem(i18n("Hide &Statusbar"),M_HSTATUS);

	connect(optionMenu,SIGNAL(activated(int)),this,
		SLOT(menucallback(int)));

	popmenu=new QPopupMenu;
	popmenu->insertItem(i18n("Hide &Menubar"),M_HMENU);
	popmenu->insertItem(i18n("Hide &Statusbar"),M_HSTATUS);
	popmenu->insertItem(i18n("&Edit Filter"),M_EDITFILTER);
	popmenu->insertItem(i18n("&Clear this log window"),
		this,SLOT(clearwindow()));
	popmenu->insertItem(i18n("&Refresh this log window"),
		this,SLOT(reloadwindow()));
	popmenu->insertItem(i18n("&Remove this log"),M_REMOVETHIS);
	connect(popmenu,SIGNAL(activated(int)),this,
		SLOT(menucallback(int)));

	menubar->insertSeparator();
	QString at="ktail " VERSION;
	at+=i18n("\n\nRolf Jakob (rjakob@duffy1.franken.de)\n\nfile monitor for the KDE Desktop Environment");
	QPopupMenu *help = helpMenu(at, false);
	menubar->insertItem(i18n("&Help"),help);
	menubar->show();
//	setMenu(menubar);

	KConfig *config=kapp->config();
	config->setGroup("KTail");

	if (!config->hasKey("font")) {
		QFont fo;
		config->writeEntry("font",fo);
		config->sync();
		}

	ii=0; found=0;

//	statusbar=new KStatusBar(this);
	statusBar()->insertItem("0000",STA_LINES);
	statusBar()->insertItem(i18n("initialize"),STA_NAME);
//	statusBar->show();
//	setStatusBar(statusbar);

	showstatusnonactive=config->readBoolEntry("ShowStatusOfNonActiveFile",false);

	active_tab=0;

	w=new mybox(this);
	connect(w,SIGNAL(rightclicked()),this,SLOT(togglemenubar()));
	connect(w,SIGNAL(middleclicked()),this,SLOT(togglestatusbar()));

	createtextbox();

	QStrList files,filters,efilters,actions;
	has_filters=false;
	has_filterflags=false;
	has_actions=false;

	if (config->hasKey("files")) {
		config->readListEntry("files",files);
		if (config->hasKey("filters")) {
			config->readListEntry("filters",filters);
			has_filters=true;
			if (config->hasKey("filterflags")) {
				config->readListEntry("filterflags",efilters);
				has_filterflags=true;
				}
			}
		if (config->hasKey("actions")) {
			config->readListEntry("actions",actions);
			has_actions=true;
			}
		p=files.first();
		pf=dummy;
		fpf=dummy;
		action=0;
		if (has_actions) {
			ac=actions.first();
			if (ac) action=atoi(ac);
			}
		if (has_filters) pf=filters.first();
		if (has_filterflags) fpf=efilters.first();
		while(p) {
			if (has_filters) {
				addfile(p,pf,*fpf=='e',action);
				pf=filters.next();
				if (has_filterflags)
					fpf=efilters.next();
				}
			else addfile(p,0,false,action);
			p=files.next();
			if (has_actions) {
				ac=actions.next();
				if (ac) action=atoi(ac);
				}
			}
		}

	myfont=config->readFontEntry("font");
	setfont(myfont);
	tabctl->show();

	w->adjustSize();
	w->show();

	readintextlist();

// maybe this helps ...

	active_tab=filel.count()-1;
//	active_tab=0;

	tim=new QTimer(this);
	connect(tim,SIGNAL(timeout()),this,SLOT(readintextlist()));
	tim->start(2000);

	setCentralWidget(w);

	if (config->hasKey("statusbar"))
		if (config->readNumEntry("statusbar")==0)
			statusBar()->hide();

	if (config->hasKey("menubar"))
		if (config->readNumEntry("menubar")==0)
			menubar->hide();

	if (config->hasKey("geometry")) {
		resize(config->readSizeEntry("geometry"));
		}
	prev_width=width();
	prev_height=height();
	
	connect(kapp,SIGNAL(saveYourself()),this,SLOT(saveconfig()));

	setpossibleitems();
}

void ktail :: createtextbox()
{
int i;
file_str *p;

	if (!tabctl) {
		tabctl=new rKTabCtl(w);
		connect(tabctl,SIGNAL(rightclicked()),this,SLOT(togglemenubar()));
		connect(tabctl,SIGNAL(middleclicked()),this,SLOT(togglestatusbar()));
		}
	w->setChild(tabctl);
	w->resize(w->sizeHint());
	w->show();
	i=0;

	connect(tabctl,SIGNAL(tabSelected(int)),
		this,SLOT(tabchanged(int)));

	if (filel.count()) {
		p=filel.first();
		i=0;
		while(p) {
			p->textlist=new mytext(w);
			p->textlist->show();
			p->textlist->setReadOnly(true);
			p->textlist->setAutoUpdate(true);
			connect(p->textlist,SIGNAL(rightclicked()),
				this,SLOT(dopopup()));
//			connect(p->textlist,SIGNAL(altrightclicked()),
//				this,SLOT(toggledecoration()));
			connect(p->textlist,SIGNAL(middleclicked()),
				this,SLOT(togglestatusbar()));
//			connect(p->textlist,SIGNAL(changed(mytext *)),
//				this,SLOT(actionOnChange(mytext *)));
			tabctl->addTab(p->textlist,p->caption);
			p=filel.next();
			i++;
			}
	setpossibleitems();
	}

	tabchg(i-1);

//	tabctl->repaint();
//	repaint();

/*
	dnd=new KDNDDropZone(tabctl,DndURL);
	connect(dnd,SIGNAL(dropAction(KDNDDropZone *)),
	this,SLOT(dropslot(KDNDDropZone *)));
*/
}

void ktail::setpossibleitems()
{

if (filel.count()>0) {
	fileMenu->setItemEnabled(idf1,true);
	fileMenu->setItemEnabled(idf2,true);
	fileMenu->setItemEnabled(idf3,true);
	} else {
	fileMenu->setItemEnabled(idf1,false);
	fileMenu->setItemEnabled(idf2,false);
	fileMenu->setItemEnabled(idf3,false);
	}
}

void ktail :: saveconfig()
{
file_str *help;
char line[1024],num[16];

	KConfig *config=kapp->config();
	config->setGroup("KTail");

	QStrList files,regexps,flags,actions;
	help=filel.first();
	while(help) {
		if (help->type==IPCPIPE) {
			sprintf(line,"|%s",help->filename);
			files.append(line);
			}
		else files.append(help->filename);
		regexps.append(help->textlist->getFilter());
		flags.append(help->textlist->filterIsExcl()?"e":"i");
		sprintf(num,"%d",help->textlist->actionCode());
		actions.append(num);
		help=filel.next();
		}
	config->writeEntry("files",files);
	config->writeEntry("filters",regexps);
	config->writeEntry("filterflags",flags);
	config->writeEntry("actions",actions);
	config->writeEntry("geometry",size());
	config->writeEntry("ShowStatusOfNonActiveFiles",showstatusnonactive);
	config->sync();
}

ktail :: ~ktail()
{
file_str *help;

	saveconfig();
	stopall();

	help=filel.first();
	while(help) {
		if (help->type==IPCPIPE && help->pid) {
			printf("killing process %d\n",help->pid);
			::kill(help->pid,SIGINT);
			}
		if (help->filep>=0) {
			::close(help->filep);
			}
		help=filel.next();
		}
}

void ktail :: stopall()
{
	tim->stop();
	if (reading) do_stop=TRUE;
}

void ktail :: clearwindow()
{
file_str *help;

	help=filel.at(active_tab);
	if (help)
		help->textlist->clear();

}

void ktail :: reloadwindow()
{
file_str *help;

	help=filel.at(active_tab);
	if (!help) return;
	if (help->type==IPCPIPE && help->pid)
		::kill(help->pid,SIGINT);
	if (help->filep>=0) {
		::close(help->filep);
		help->filep=-1;
		}
	help->textlist->clear();

	readintextlistno(help);
}

void ktail :: togglestatusbar()
{
	KConfig *config=kapp->config();
	config->setGroup("KTail");
	if (statusBar()->isVisible()) {
		statusBar()->hide();
		optionMenu->changeItem(i18n("Show &Statusbar"),
			M_HSTATUS);
		popmenu->changeItem(i18n("Show &Statusbar"),
			M_HSTATUS);
		config->writeEntry("statusbar",0);
		} else {
		statusBar()->show();
		optionMenu->changeItem(i18n("Hide &Statusbar"),
			M_HSTATUS);
		popmenu->changeItem(i18n("Hide &Statusbar"),
			M_HSTATUS);
		config->writeEntry("statusbar",1);
		}
	emit resizeEvent((QResizeEvent *)0);
	config->sync();
}

void ktail :: togglemenubar()
{
	KConfig *config=kapp->config();
	config->setGroup("KTail");
	if (menubar->isVisible()) {
		menubar->hide();
		optionMenu->changeItem(i18n("Show &Menubar"),
			M_HMENU);
		popmenu->changeItem(i18n("Show &Menubar"),
			M_HMENU);
		if (!config->hasKey("menubar"))
			KMessageBox::information(this,i18n("ktail Usage"),
			i18n("You may \
reactivate the menu \n\
bar by a right click into the text window"));
		config->writeEntry("menubar",0);
		} else {
		menubar->show();
		optionMenu->changeItem(i18n("Hide &Menubar"),
			M_HMENU);
		popmenu->changeItem(i18n("Hide &Menubar"),
			M_HMENU);
		config->writeEntry("menubar",1);
		}
	emit resizeEvent((QResizeEvent *)0);
	config->sync();
}

/*
void ktail :: toggledecoration()
{
	long wnow=KWM::getDecoration(mywindow);
	if (wnow==KWM::normalDecoration) {
		prev_width=width();
		prev_height=height();
		KWM::setDecoration(mywindow,KWM::noDecoration);
	} else	{
		KWM::setDecoration(mywindow,KWM::normalDecoration);
		resize(prev_width,prev_height);
		}
	show();
}
*/

void ktail :: dopopup()
{
	popmenu->popup(QCursor::pos());
}

void ktail::removewindow()
{
int rc;
unsigned int i;

myremovedlg *rd=new myremovedlg(0,i18n("manage log windows"),true);
for (i=0; i<filel.count(); i++) {
	rd->insertName(filel.at(i)->filename);
	}
rc=rd->exec();
if (rc==QDialog::Accepted) {
	for (i=0;i<filel.count();i++)
		if (rd->isSelected(i))
			removeit(i);
	}
delete rd;
}

void ktail :: menucallback(int no)
{
int maxlines;
int rc;

	switch(no) {
	case M_HSTATUS:
		togglestatusbar(); break;
	case M_HMENU:
		togglemenubar(); break;
	case M_REMOVETHIS:
		removeit(active_tab); break;
	case M_SETTINGS:
		if (!optionw) {
			optionw=new mylogoptdlg(0,i18n("ktail options"),true);
			maxlines=filel.at(active_tab)->textlist->getMaxLines();
			optionw->setMaxL(maxlines);
			optionw->setActionCode(filel.at(active_tab)->textlist->actionCode());
			rc=optionw->exec();
			if (rc==QDialog::Accepted) {
				filel.at(active_tab)->textlist->setMaxLines(optionw->getMaxL());
				filel.at(active_tab)->textlist->setActionCode(optionw->actionCode());
				}
			delete optionw;
			optionw=0;
//			connect(optionw,SIGNAL(windowClosed(QWidget *,bool)),
//			this,SLOT(dialogClosedSlot(QWidget *,bool)));
			}
		break;
	case M_EDITFILTER:
		filel.at(active_tab)->textlist->editFilter();
		break;
	}
}

/*
void ktail :: dropslot(KDNDDropZone *z)
{
char filen[1024];
int typ,rc;

	typ=z->getDataType();
	if (typ==DndURL) {
		strcpy(filen,z->getData());
		if (!strncmp(filen,"file:",5)) {
			rc=addfile(filen+5,"",false);
			}
		}
}
*/

void ktail :: tabchanged(int i)
{
	if ((unsigned)i<filel.count() && i>=0)
		active_tab=i;

	tabchg(i);
}


void ktail :: tabchg(int i)
{
char line[1024];
file_str *help;


	if ((unsigned)i<filel.count() && i>=0) {

		help=filel.at(i);

		switch (help->type) {
		case SPECIALFILE:
			sprintf(line,i18n("monitoring special file %s"),
			filel.at(i)->filename);
			break;
		case IPCPIPE:
			sprintf(line,i18n("monitoring command %s"),
			filel.at(i)->filename);
			break;
		case REGFILE:
		default:
			sprintf(line,i18n("monitoring file %s"),
			help->filename);
			break;
		}

 		statusBar()->changeItem(line,STA_NAME);
		sprintf(line,"%3d",help->textlist->numLines());
		statusBar()->changeItem(line,STA_LINES);
		}

}

void ktail :: selectfont()
{
	KConfig *config=kapp->config();
	config->setGroup("KTail");
	KFontDialog::getFont(myfont);
	config->writeEntry("font",myfont);
	config->sync();
	setfont(myfont);
}

void ktail :: addcmdline()
{
int rc;
char line[1024],line2[1024];

	cmdlinedlg=new mycmdlinedlg(0,
		i18n("Enter command line to open with a pipe"),true);
	cmdlinedlg->setlabel(i18n("Command :"));
	rc=cmdlinedlg->exec();
	if (rc==QDialog::Accepted) {
		strcpy(line,cmdlinedlg->getvalue());
		if (*line!='|') {
			strcpy(line2+1,line);
			*line2='|';
			strcpy(line,line2);
			}
		addfile(line,0,false);
		}
	if (cmdlinedlg) delete cmdlinedlg;
	cmdlinedlg=0;
}

void ktail::dialogClosedSlot(QWidget *w, bool flag)
{
	if (w==optionw) {
		if (flag) {
			filel.at(active_tab)->textlist->setMaxLines(optionw->getMaxL());
			filel.at(active_tab)->textlist->setActionCode(optionw->actionCode());
			}
		delete optionw;
		optionw=0;
		}
}

void ktail :: addfiledlg()
{
int rc;
char path[1024],*p;

	rc=0;
	KConfig *config=kapp->config();
	config->setGroup("KTail");

	if (config->hasKey("lastuseddir"))
		strcpy(path,config->readEntry("lastuseddir"));
	else	strcpy(path,"");

	QString addfilename(KFileDialog::getOpenFileName(*path?path:0,
		"*",0,i18n("ktail: Open...")) );

	if (!addfilename.isEmpty()) {
	rc=addfile((char *)(addfilename.data()),0,false);
	if (rc>=0) {
		config->setGroup("KTail");
		strcpy(path,addfilename.data());
		p=strrchr(path,'/'); if (p) *p=0;
		config->writeEntry("lastuseddir",path);
		config->sync();
		}
	}
}


int ktail :: addfile(char *pfilename, char *filter, bool efilter, int action)
{
struct stat statbuffer;
file_str *help=new file_str;
int rc;
char *p;

	if (*pfilename) {
		help->type=0;
		strcpy(help->filename,pfilename);

		if (*pfilename=='|') {
			strcpy(help->filename,pfilename+1);
			help->type=IPCPIPE;
			}

		if (!help->type) {
			rc=stat(help->filename,&statbuffer);
			if (!rc) {
				if(S_ISREG(statbuffer.st_mode))
					help->type=REGFILE;
				else if(S_ISCHR(statbuffer.st_mode) ||
					S_ISBLK(statbuffer.st_mode) ||
					S_ISFIFO(statbuffer.st_mode) ||
					S_ISSOCK(statbuffer.st_mode))
					help->type=SPECIALFILE;
				}
			/* file does not exist, assume regular file */
			else help->type=REGFILE;
			}

		p=strrchr(help->filename,'/');
		if (p) strcpy(help->caption,p+1);
		else strcpy(help->caption,help->filename);

		help->filep=-1;
		help->fstatus=0;
		help->filepos=0;
		help->pid=0;
		help->completelastline=true;
		help->textlist=new mytext(w);
		help->textlist->show();
		help->textlist->setFilter(filter,efilter);
		help->textlist->setActionCode(action);
		help->textlist->setReadOnly(TRUE);
		connect(help->textlist,SIGNAL(rightclicked()),
			this,SLOT(dopopup()));
//		connect(help->textlist,SIGNAL(altrightclicked()),
//			this,SLOT(toggledecoration()));
		connect(help->textlist,SIGNAL(middleclicked()),
			this,SLOT(togglestatusbar()));
		tabctl->addTab(help->textlist,help->caption);

		filel.append(help);

	/* set new tab the active tab */
		tabchanged(filel.count()-1);
		setfont(myfont);
		setpossibleitems();
		return(1);
		}
	return(-1);
}

void ktail :: removeit(int i)
{
file_str *help;

	if (i<0 || (unsigned)i>=filel.count()) {
		printf("trying to remove non-existant filel(%d)\n",i);
		return;
		}

	help=filel.at(i);
	if (!help) {
		printf("filel.at(%d) is NULL !!\n",i);
		return;
		}

	stopall();

	/* be sure that the file to be deleted is not read */
	while (reading) {
		do_stop=TRUE;
		kapp->processEvents();
		usleep(500000);
		}

	delete filel.at(i)->textlist;
	help=filel.at(i);
	if (help->type==IPCPIPE && help->pid) {
		printf("killing process %d\n",help->pid);
		::kill(help->pid,SIGINT);
		}
	filel.remove(i);
	delete help;

	help=filel.first();
	while(help) {
		if (help->textlist) {
			delete help->textlist;
			help->textlist=0;
			}
		if (help->type==IPCPIPE && help->pid) {
			printf("killing process %d\n",help->pid);
			::kill(help->pid,SIGINT);
			}
		if (help->filep>=0) {
			::close(help->filep);
			}
		help->filep=-1;
		help=filel.next();
		}

//	delete dnd; dnd=0;
	w->removeChild();
	delete tabctl; tabctl=0;
	createtextbox();
	setfont(myfont);
	tabctl->show();
	do_stop=FALSE;
	tim->start(2000);

	w->update();
	update();
	setpossibleitems();
}

void ktail :: setfont(QFont fo)
{
unsigned int i;
	for (i=0;i<filel.count();i++)
		if (filel.at(i)->textlist) {
			filel.at(i)->textlist->setFont(fo);
			}
}

void ktail :: readintextlist()
{
file_str *i;

	if (reading) return;
	reading=TRUE;
	i=filel.first();
	while(i) {
		readintextlistno(i);
		if (do_stop) break;
		i=filel.next();
		}
	reading=FALSE;
	do_stop=FALSE;
}

void ktail :: openregfile(file_str *f)
{
char *line=new char[2050];
long fpos;

	if (f->filename) {
		sprintf(line,i18n("trying to open %s"),
			f->filename);
		statusBar()->changeItem(line,STA_NAME);
		f->filep=open(f->filename,O_RDONLY);
		if (f->filep<0) {
			if (f->fstatus>=0) {
			f->fstatus=-1;
			sprintf(line,i18n("Could not open regular file %s:\n%s"),
				f->filename,strerror(errno));
			KMessageBox::error(this,
				i18n("ktail Error"),line);
				}

			sprintf(line,i18n("%s not opened"),
				f->filename);
			statusBar()->changeItem(line,STA_NAME);
			} else {
			fpos=lseek(f->filep,0,SEEK_END);
			if (fpos<2048) fpos=0;
			else	fpos-=2048;
			fpos=lseek(f->filep,fpos,SEEK_SET);
			f->filepos=fpos;
			if (f->fstatus<0) {
			sprintf(line,i18n("File %s now open"),
				f->filename);
			f->fstatus=0;
			KMessageBox::information(this,
				i18n("ktail Info"),line);
				}
			}
		}
}

void ktail :: openspecialfile(file_str *f)
{
char *line=new char[2050];

	if (f->filename) {
		sprintf(line,i18n("trying to open %s"),
			f->filename);
		statusBar()->changeItem(line,STA_NAME);
		f->filep=open(f->filename,O_RDONLY);
		if (f->filep<0) {
			if (f->fstatus>=0) {
			f->fstatus=-1;
			sprintf(line,i18n("Could not open special file %s:\n%s"),
				f->filename,strerror(errno));
			KMessageBox::error(this,
				i18n("ktail Error"),line);
				}

			sprintf(line,i18n("%s not opened"),
				f->filename);
			statusBar()->changeItem(line,STA_NAME);
			} else {
			if (f->fstatus<0) {
			sprintf(line,i18n("File %s now open"),
				f->filename);
			f->fstatus=0;
			KMessageBox::information(this,
				i18n("ktail Info"),line);
				}
			}
		}
}

void ktail :: openipcpipe(file_str *f)
{
pid_t pid;
int p[2],rc;
char cmdline[1024];

	rc=::pipe(p);
	if (rc) return;
//	printf("pipe successful\n");
	rc=::fcntl(p[0],F_SETFL,O_NONBLOCK);
	if (rc) perror("fcntl");
//	printf("will open sh -c \"%s\"\n",f->filename);
	pid=::fork();
	if (pid<0) return;
//	printf("fork successful\n");
	if (!pid) {
		::close(0);
		::open("/dev/null",O_RDONLY);
		::close(p[0]);
		::close(1);
		::dup(p[1]);
		::close(2);
		::dup(1);
//		fprintf(stdout,"stdout test\n");
//		fprintf(stderr,"stderr test\n");
		sprintf(cmdline,"%s",f->filename);
		::execl("/bin/sh","/bin/sh","-c",cmdline,NULL);
//		::system(f->filename);
//		printf("command exited\n");
		exit(0);

		} else {

		::close(p[1]);
		f->pid=pid;
//		printf("child process is %d\n",pid);
		f->filep=p[0];
		}
}

int ktail :: readregfile(file_str *f)
{
int done,rc;
long fpos;
char *line=new char[32769];
char *sline=new char[1200];
// char *p;
struct stat statbuffer;
// bool complete;
// int lastline;

	done=0;
	while(1) {

	if (do_stop) break;
	rc=read(f->filep,line,32768);
	if (rc<=0) {
		if (rc<0) perror(f->filename);
		(f->fstatus)++;
		if (f->fstatus>=MAX_TRIES) {
			rc=stat(f->filename,&statbuffer);
			if (rc<0) {
				::close(f->filep);
				f->filep=-1;
				f->textlist->clear();
				rc=0; break;
				}
			fpos=lseek(f->filep,0,SEEK_END);

			f->fstatus=0;
			if (fpos<f->filepos) {
				::close(f->filep);
				f->textlist->clear();
				f->filep=-1;
				rc=0; break;
				}
			}
			break;
		}
		f->fstatus=0;
		*(line+rc)=0;
		(f->filepos)+=rc;

	/* search for end of line characters */

/* this is now done in mytext->insertLineAtEnd()

		p=line+strlen(line)-1;
		complete=(*p=='\n');
		while(*p=='\n' || *p=='\r') *p--=0;
*/
	/* append read line to previous if that wasn't complete */

/* this is now done in mytext->insertLineAtEnd()

		if (!f->completelastline) {
			lastline=f->textlist->numLines()-1;
			if (lastline>=0) {
				QString help=f->textlist->textLine(lastline);
				f->textlist->removeLine(lastline);
				help+=line;
				f->textlist->insertLine(help.data());
				}
			}
		else	f->textlist->insertLine(line);
		f->completelastline=complete;
*/
		sprintf(sline,i18n("reading %s"),
		f->filename);
		statusBar()->changeItem(sline,STA_NAME);

		f->textlist->insertLineAtEnd(line);
		f->textlist->update();
		done=1;
		kapp->processEvents();
	}

	delete line;
	delete sline;

	return(done);
}

int ktail :: readspecialfile(file_str *f)
{
int done,rc;
char *line=new char[2050];
char *sline=new char[1200];
char *p;
struct stat statbuffer;

	done=0;
	while(1) {

	if (do_stop) break;
	rc=read(f->filep,line,2048);
	if (rc>0) {
		sprintf(sline,i18n("reading %s"),
		f->filename);
		statusBar()->changeItem(sline,STA_NAME);
	}
	if (rc<=0) {
		if (rc<0) perror(f->filename);
		(f->fstatus)++;
		if (f->fstatus>=MAX_TRIES) {
			rc=stat(f->filename,&statbuffer);
			if (rc<0) {
				::close(f->filep);
				f->filep=-1;
				f->textlist->clear();
				rc=0; break;
				}
			f->fstatus=0;
			}
			break;
		}
		f->fstatus=0;
		*(line+rc)=0;
		(f->filepos)+=rc;
		p=line+strlen(line)-1;
		while(*p=='\n' || *p=='\r') *p--=0;
		f->textlist->insertLineAtEnd(line);
		done=1;
		kapp->processEvents();
	}

	delete line;
	delete sline;

	return(done);
}

int ktail :: readipcpipe(file_str *f)
{
int done,rc;
char *line=new char[2050];
char *sline=new char[1200];
char *p;

	done=0;
	while(1) {

	if (do_stop) break;
	rc=read(f->filep,line,2048);
	if (rc<=0) {
//		if (rc<0) perror(f->filename);
		(f->fstatus)++;
		break;
		}
	sprintf(sline,i18n("reading %s"),
		f->filename);
	statusBar()->changeItem(sline,STA_NAME);
	f->fstatus=0;
	*(line+rc)=0;
	(f->filepos)+=rc;
	p=line+strlen(line)-1;
	while(*p=='\n' || *p=='\r') *p--=0;
	f->textlist->insertLineAtEnd(line);
	done=1;
	kapp->processEvents();
	}

	delete line;
	delete sline;

	return(done);
}

void ktail :: readintextlistno(file_str *f)
{
int done=0;
unsigned t;

	if (f->filep<0) {
		switch(f->type) {
			case REGFILE:
			openregfile(f); break;
			case SPECIALFILE:
			openspecialfile(f); break;
			case IPCPIPE:
			openipcpipe(f); break;
			}
		}

	if (f->filep>=0) {
		switch(f->type) {
			case REGFILE:
			done=readregfile(f); break;
			case SPECIALFILE:
			done=readspecialfile(f); break;
			case IPCPIPE:
			done=readipcpipe(f); break;
			}
		}

	if (done) {
/* done in mytext
		while (f->textlist->numLines()>MAX_LINES) {
			f->textlist->removeLine(0);
			kapp->processEvents();
			}
		f->textlist->setCursorPosition(f->textlist->numLines(),0);
*/
		t=filel.find(f);
		if (!showstatusnonactive) {
			if (t==(unsigned)active_tab) {
//	printf("!showstatusnonactive: switch to %d\n",t);
				tabchg(t);
				}
		} else	tabchg(t);

		tabctl->show();

		if (f->textlist) {
//			cerr << "action : " << f->textlist->actionCode() << endl;
			switch(f->textlist->actionCode()) {
			case ACTION_RAISE:
				raise();
//				cerr << "raise" << endl;
				break;
			case ACTION_DEICONIFY:
				show();
				break;
			case ACTION_DEICONIFYANDRAISE:
				show();
				raise();
				break;
			case ACTION_BEEP:
				kapp->beep();
				break;
			}
			}
		}

}

