/*
   ksmp3play - Curses-based MP3 player

   Copyright (C) 2001 Karl Soderstrom

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include "ksmp3play.h"
#include <curses.h>
#include <string.h>
#include <math.h>

/* FIXME: recode the load_playlist function from scratch. The current one is no good */
void
load_playlist (char *argv)
{
  FILE *infile;
  char line[256];
  char *tmp;
  char filename[256];
  short found = 0;
  int i;

  playlist_changes = 0;

  strcpy ((char *) &filename, argv);
  if (!strcasecmp
      ((char *) &filename[strlen ((char *) &filename) - 4], ".m3u"))
    {
      if (!(infile = fopen (filename, "r")))
	{
	  printf ("Can't open file for reading\n");
	  perror ("fopen");
	  end_program ();
	}
      while (fgets (line, 255, infile))
	{
	  line[strlen (line) - 1] = '\0';
	  if (!strcasecmp (&line[strlen (line) - 4], ".mp3"))
	    {
	      for (i = found = 0; i < num_songs; i++)
		if (!strcmp (play[i].file, line))
		  found = 1;
	      if (!found)
		{

		  strcpy (play[num_songs].file, line);
		  if ((tmp = strtok (line, "/")) != NULL)	/* remove the path to the mp3 file */
		    {
		      while ((tmp = strtok ((char *) NULL, "/")) != NULL)
			strcpy (play[num_songs].mp3file, tmp);
		    }
		  if (!strlen (play[num_songs].mp3file))
		    strcpy (play[num_songs].mp3file, play[num_songs].file);

		  play[num_songs].mp3file[COLS - 15] = '\0';
		  getid3info (play[num_songs].file,
			      play[num_songs].title,
			      play[num_songs].artist,
			      play[num_songs].type,
			      play[num_songs].year, play[num_songs].etc,
			      &play[num_songs].genre);
		  play[num_songs].rate = 5;
		  num_songs++;
		}
	    }
	}
      fclose (infile);
    }

  else
    if (!strcasecmp
	((char *) &filename[strlen ((char *) &filename) - 4], ".ks3"))
    {
      if (!(infile = fopen (filename, "r")))
	{
	  printf ("Can't open file for reading\n");
	  perror ("fopen");
	  end_program ();
	}
      while (fgets (line, 255, infile))
	{
	  line[strlen (line) - 1] = '\0';
	  play[num_songs].vol = atoi (&line[strlen (line) - 3]);
	  line[strlen (line) - 4] = '\0';
	  play[num_songs].rate = atoi (&line[strlen (line) - 1]);
	  line[strlen (line) - 2] = '\0';
	  if (!strcasecmp (&line[strlen (line) - 4], ".mp3"))
	    {
	      for (i = found = 0; i < num_songs; i++)
		if (!strcmp (play[i].file, line))
		  found = 1;
	      if (!found)
		{
		  strcpy (play[num_songs].file, line);
		  if ((tmp = strtok (line, "/")) != NULL)	/* remove the path to the mp3 file */
		    {
		      while ((tmp = strtok ((char *) NULL, "/")) != NULL)
			strcpy (play[num_songs].mp3file, tmp);
		    }
		  if (!strlen (play[num_songs].mp3file))
		    strcpy (play[num_songs].mp3file, play[num_songs].file);
		  play[num_songs].mp3file[COLS - 15] = '\0';
		  getid3info (play[num_songs].file,
			      play[num_songs].title,
			      play[num_songs].artist,
			      play[num_songs].type,
			      play[num_songs].year, play[num_songs].etc,
			      &play[num_songs].genre);
		  num_songs++;
		}
	    }
	}
      fclose (infile);
    }

  else
    if (!strcasecmp
	((char *) &filename[strlen ((char *) &filename) - 4], ".mp3"))
    {
      for (i = found = 0; i < num_songs; i++)
	if (!strcmp (play[i].file, filename))
	  found = 1;
      if (!found)
	{
	  strcpy (play[num_songs].file, filename);
	  if ((tmp = strtok (filename, "/")) != NULL)	/* remove the path to the mp3 file */
	    {
	      while ((tmp = strtok ((char *) NULL, "/")) != NULL)
		strcpy (play[num_songs].mp3file, tmp);
	    }
	  if (!strlen (play[num_songs].mp3file))
	    strcpy (play[num_songs].mp3file, play[num_songs].file);

	  play[num_songs].mp3file[COLS - 15] = '\0';
	  getid3info (play[num_songs].file,
		      play[num_songs].title,
		      play[num_songs].artist,
		      play[num_songs].type,
		      play[num_songs].year, play[num_songs].etc,
		      &play[num_songs].genre);
	  play[num_songs].rate = 5;
	  num_songs++;
	}
    }

  else
    if (!strncasecmp
	((char *) &filename, (char *) "http://", (size_t) strlen ("http://")))
    {
      for (i = found = 0; i < num_songs; i++)
	if (!strcmp (play[i].file, filename))
	  found = 1;
      if (!found)
	{
	  strcpy (play[num_songs].file, filename);
	  strcpy (play[num_songs].mp3file, filename);
	  play[num_songs].mp3file[COLS - 15] = '\0';
	  play[num_songs].rate = 5;
	  num_songs++;
	}
    }

  return;
}

void
write_playlist ()
{
  FILE *ks3file;
  int i;
  playlist_changes = 0;
  if (strlen (ks3playlist) == 0)
    if (!show_ks3playlist_win ())
      return;

  if (!(ks3file = fopen (ks3playlist, "w")))
    {
      printf ("Can't open file for writing\n");
      perror ("fopen");
      end_program ();
    }
  for (i = 0; i < num_songs; i++)
    {
      fprintf (ks3file, "%s %d %.3d\n", play[i].file, play[i].rate,
	       play[i].vol);
    }
  fclose (ks3file);
}

int
delete_song (int song)
{
  int i;
  playlist_changes = 1;
  num_songs--;
  total_time -= play[song].time;
  total_size -= (int) play[song].size / 1024;
  for (i = song; i <= num_songs; i++)
    memcpy (&play[i], &play[i + 1], sizeof (struct PlayList));
  if (selected >= num_songs)
    selected = num_songs - 1;
  if (song <= current_song)
    current_song--;
  if (current_song + 1 == song)
    return (1);
  else
    return (0);
}

void
get_playlist_times (int q)
{
  SMPEG *mpegtmp;
  SMPEG_Info infotmp;

  if (strncmp (play[q].file, "http://", strlen ("http://")) != 0)
    {
      mpegtmp = SMPEG_new (play[q].file, &infotmp, 0);
      if (SMPEG_error (mpegtmp) == NULL)
	{
	  SMPEG_delete (mpegtmp);
	  if (!play[q].time)
	    {
	      play[q].time = infotmp.total_time;
	      play[q].size = infotmp.total_size;
	      total_time += infotmp.total_time;
	      total_size += (int) infotmp.total_size / 1024;
	    }
	}
    }
}

void
generate_random_playlist ()
{
  int m;
  int n;

  num_randoms = 0;
  if (random_method == 1)
    for (m = 0; m < num_songs; m++)
      for (n = 1; n <= play[m].rate; n++)
	{
	  random_playlist[num_randoms] = m;
	  num_randoms++;
	}
  else if (random_method == 2 || getting_times)
    for (m = 0; m < num_songs; m++)
      for (n = 1; n <= pow (play[m].rate, 2); n++)
	{
	  random_playlist[num_randoms] = m;
	  num_randoms++;
	}
  else if (random_method == 3)
    for (m = 0; m < num_songs; m++)
      for (n = 1;
	   n <=
	   floor (pow (play[m].rate, 2) /
		  (play[m].time / 60) ); n++)
	{
	  random_playlist[num_randoms] = m;
	  num_randoms++;
	}
}
