/*
   ksmp3play - Curses-based MP3 player

   Copyright (C) 2001 Karl Soderstrom

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include "ksmp3play.h"

void
getid3info (char mp3[256], char *mp3title, char *mp3artist, char *mp3type,
	    char *mp3year, char *mp3etc, char *mp3genre)
{
  int y;
  FILE *fp;
  char buf[40];

  memset (mp3title, 0, 31 * sizeof (char));
  memset (mp3artist, 0, 31 * sizeof (char));
  if (!(fp = fopen (mp3, "r")) || !search_header (fp))
    return;

  if (fread (buf, 30, sizeof (char), fp) == sizeof (char))
    {
      strncpy (mp3title, buf, 30);
      for (y = 29; y > 0; y--)
	{
	  if (!isspace (mp3title[y]))
	    {
	      mp3title[y + 1] = '\0';
	      break;
	    }
	}
    }
  if (fread (buf, 30, sizeof (char), fp) == sizeof (char))
    {
      strncpy (mp3artist, buf, 30);
      for (y = 29; y > 0; y--)
	{
	  if (!isspace (mp3artist[y]))
	    {
	      mp3artist[y + 1] = '\0';
	      break;
	    }
	}
    }
  fclose (fp);
}

int
search_header (FILE * fp)
{
  int c, flag = 0, success = 0;

  if (fseek (fp, -128, SEEK_END) < 0)
    return success;

  for (;;)
    {
      if ((c = fgetc (fp)) < 0)
	break;
      if (c == 0x54)
	{
	  if (fgetc (fp) == 0x41)
	    {
	      if (fgetc (fp) == 0x47)
		{
		  success = 1;
		  break;
		}
	    }
	  flag = 0;
	}
      else
	flag = 0;
    }
  return success;
}

int
appendNewID3Header (FILE * fp)
{
  int success = 0;

  char c[31] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x41, 0x47
  };
  if (fseek (fp, 0, SEEK_END) < 0)
    return success;
  if (fwrite ((void *) c, sizeof (char), 31, fp) != 31)
    return success;

  return (success = 1);
}

int
writeID3 (char mp3[256], char *mp3title, char *mp3artist)
{
  int success = 0;
  FILE *fp = fopen (mp3, "r+");

  if (!fp)
    return success;

  if (!search_header (fp) && !(appendNewID3Header (fp)))
    {
      fclose (fp);
      return success;
    }

  if ((fwrite (mp3title, sizeof (char), 30, fp)) == 30 &&
      (fwrite (mp3artist, sizeof (char), 30, fp) == 30))
    success = 1;

  fclose (fp);
  return success;
}
