--TEST--
Bug #6031: Recurring events are not displayed in Kolab.
--FILE--
<?php
// Pretend that we are kronolith
class Registry {
    function getApp()
    {
        return 'kronolith';
    }
}
$registry = new Registry;

$conf = array();
$conf['kolab']['imap']['server'] = 'localhost';
$conf['kolab']['imap']['port']   = 0;

// Set a dummy server name
$_SERVER['SERVER_NAME'] = 'localhost';

// Indicate that we want the dummy IMAP driver
$GLOBALS['KOLAB_TESTING'] = array(
    "INBOX/Calendar" => array(
        "status" => array(
            "uidvalidity" => 1205144313,
            "uidnext" => 1
        ),
        "mails" => array(),
        "permissions" => array(
            "syncmltest" => "alriswcd"
        ),
        "annotations" => array(
            "/vendor/kolab/folder-type" => array(
                "value.shared" => "event.default"
            ),
        ),
    ),
);

// We need the basic PEAR library
require_once 'PEAR.php';
require_once 'Horde/Auth.php';
require_once 'Horde/Kolab.php';
require_once 'Horde/Date.php';
require_once 'Horde/Date/Recurrence.php';

// Load the Driver definitions
require_once dirname(__FILE__) . '/../Driver.php';
require_once dirname(__FILE__) . '/../Kronolith.php';

/* Pretend that we are kronolith */
$kolab = &new Kolab('kronolith');

/* Open our calendar */
$kolab->open('INBOX/Calendar', 1);

$object = array(
    'uid' => 1,
    'summary' => 'test',
    'start-date' => 0,
    'end-date' => 14400,
    'recurrence' => array(
        'interval' => 1,
        'cycle' => 'daily',
        'range-type' => 'number',
        'range' => 4,
        'exclusion' => array(
            '1970-01-02',
            '1970-01-03'
        )
    )
);

// Save the event
$kolab->_storage->save($object);
                          
// Check that the driver can be created
$kron = Kronolith_Driver::factory('kolab');

$start = &new Horde_Date(86400);
$end   = &new Horde_Date(172800);

// List the events of tomorrow (none, since recurrence has exception)
$a = $kron->listEvents($start, $end);
if (is_a($a, 'PEAR_Error')) {
  var_dump($a->getMessage());
} else {
  var_dump($a);
}

$start = &new Horde_Date(259200);
$end   = &new Horde_Date(345600);

// List the events in three days (recurring event)
$a = $kron->listEvents($start, $end);
if (is_a($a, 'PEAR_Error')) {
  var_dump($a->getMessage());
} else {
  var_dump($a);
}
--EXPECT--
array(0) {
}
array(1) {
  [1]=>
  string(1) "1"
}
