<!-- javascript action handling -->
<script language="JavaScript" type="text/javascript">
<!--
    function performAction(id, value)
    {
        document.attendeesForm.actionID.value = id;
        document.attendeesForm.actionValue.value = value;
        document.attendeesForm.submit();
        return false;
    }

    function switchTimestamp(timestamp)
    {
        document.attendeesForm.timestamp.value = timestamp;
        document.attendeesForm.submit();
        return false;
    }

    function switchView(view)
    {
        document.attendeesForm.view.value = view;
        document.attendeesForm.submit();
        return false;
    }
// -->
</script>

<form method="post" action="<?php echo $form_handler; ?>" name="attendeesForm">
<?php Util::pformInput(); ?>
<input type="hidden" name="actionID" value="" />
<input type="hidden" name="actionValue" value="" />
<input type="hidden" name="view" value="<?php echo $view ?>" />
<input type="hidden" name="timestamp" value="<?php echo $timestamp ?>" />

<?php $notification->notify(array('status')); ?>

<table width="100%" cellspacing="0">

<!-- header -->
<tr><td colspan="4" class="header"><strong><?php echo $title ?></strong></td></tr>

<!-- attendee list header -->
<tr class="item">
 <td nowrap="nowrap" width="2%" align="center"><?php echo $delimg ?></td>
 <td nowrap="nowrap" width="48%"><strong><?php echo htmlspecialchars(_("Email Address")) ?></strong></td>
 <td nowrap="nowrap" width="25%"><strong><?php echo htmlspecialchars(_("Attendance")) ?></strong></td>
 <td nowrap="nowrap" width="25%"><strong><?php echo htmlspecialchars(_("Response")) ?></strong></td>
</tr>

<!-- attendees -->
<?php $i = 0 ?>
<?php if (empty($attendees)): ?>
 <tr class="item<?php echo ($i++ % 2) ?>"><td align="center" colspan="4"><i><?php echo htmlspecialchars('-- ' . _("No attendees") . ' --') ?></i></td></tr>
<?php else: foreach ($attendees as $email => $status): ?>
 <tr class="item<?php echo ($i++ % 2) ?>">
 <?php
  $statustext = sprintf(_("Remove %s"), $email);
  echo "<td>", Horde::link("javascript:performAction('remove', '" . addslashes($email) . "')", $statustext), Horde::img('delete.png', $statustext, null, $registry->getImageDir('horde')), "</a></td>";
 ?>
  <td><?php echo Horde::link($registry->call('mail/compose', array(array('to' => addslashes($email)))), sprintf(_("Send an email to %s"), $email)), htmlspecialchars($email) . '</a>'; ?></td>
  <td>
   <select name="<?php echo htmlspecialchars("attendance_$i") ?>" onchange="performAction('changeatt', document.attendeesForm.<?php echo htmlspecialchars("attendance_$i") ?>.value + ' <?php echo addslashes($email) ?>');">
    <option value="<?php echo KRONOLITH_PART_REQUIRED ?>"<?php if ($status['attendance'] == KRONOLITH_PART_REQUIRED)  echo ' selected="selected"' ?>><?php echo Kronolith::partToString(KRONOLITH_PART_REQUIRED); ?></option>
    <option value="<?php echo KRONOLITH_PART_OPTIONAL ?>"<?php if ($status['attendance'] == KRONOLITH_PART_OPTIONAL)  echo ' selected="selected"' ?>><?php echo Kronolith::partToString(KRONOLITH_PART_OPTIONAL); ?></option>
    <option value="<?php echo KRONOLITH_PART_NONE ?>"<?php if ($status['attendance'] == KRONOLITH_PART_NONE)  echo ' selected="selected"' ?>><?php echo Kronolith::partToString(KRONOLITH_PART_NONE); ?></option>
   </select>
  </td>
  <td><?php echo Kronolith::responseToString($status['response']) ?></td>
 </tr>
<?php endforeach; ?>
<tr class="item<?php echo ($i++ % 2) ?>"><td align="right" colspan="4">
<input type="submit" class="button" name="clearAll" value="<?php echo htmlspecialchars(_("Clear all attandees")) ?>" />
</td></tr>
<?php endif; ?>
</table>

<br class="spacer" />

<table width="100%" cellspacing="0">
<tr>
 <td align="right" class="light" nowrap="nowrap"><strong><?php echo Horde::highlightAccessKey(_("Add attendees"), $ak = Horde::getAccessKey(_("Add attendees"))) ?>&nbsp;&nbsp;</strong></td>
 <td align="left" class="item0" colspan="2"><input type="text" name="newAttendees" size="50" maxlength="255" <?php echo (!empty($ak)) ? 'accesskey="' . $ak . '" ' : '' ?>/></td>
</tr>
<tr>
 <td>&nbsp;</td>
 <td><input type="submit" class="button" name="addNew" value="<?php echo htmlspecialchars(_("Add these people")) ?>" /></td>
</tr>
<?php if ($registry->hasMethod('contacts/search')): ?>
<tr>
 <td>&nbsp;</td>
 <td><input type="button" class="button" name="contacts" value="<?php echo htmlspecialchars(_("Add people from my Address Book")) ?>" onclick="window.open('<?php echo Horde::applicationUrl('contacts.php') ?>', 'contacts', 'toolbar=no,location=no,status=yes,scrollbars=yes,resizable=yes,width=650,height=350,left=100,top=100'); return false;" /></td>
<?php endif; ?>
</table>

<br class="spacer" />

<?php echo $tabs->render($view) . $vfb_html ?>
<?php if (!empty($legend_html)): ?>
<div style="padding-left:10px; padding-right:10px; padding-top:10px">
 <?php echo $legend_html ?><br/>
</div>
<?php endif; ?>

<div style="text-align:right">
 <input type="button" class="button" value="<?php echo htmlspecialchars(_("Dismiss")) ?>" onclick="performAction('dismiss', '')" />
</div>

</form>
