<?php
/**
 * This class represent a week fbview of mulitple free busy information.
 *
 * Copyright 2003-2005 Mike Cochrane <mike@graftonhall.co.nz>
 * Copyright 2004-2005 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information.
 *
 * $Horde: kronolith/lib/FBView/week.php,v 1.11.4.1 2005/01/03 12:25:40 jan Exp $
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @author  Jan Schneider <jan@horde.org>
 * @package Kronolith
 */
class Kronolith_FreeBusy_View_week extends Kronolith_FreeBusy_View {

    var $view = 'week';

    var $_days = 7;

    function _title()
    {
        global $registry, $prefs;

        return Horde::link('', _("Previous Week"), 'smallheader', null, 'return switchTimestamp(' . ($this->_day - $this->_days * 86400) . ');') .
            Horde::img('nav/left.png', '<', null, $registry->getImageDir('horde')) .
            '</a>' .
            strftime($prefs->getValue('date_format'), $this->_startStamp) .
            ' - ' .
            strftime($prefs->getValue('date_format'), $this->_startStamp + (($this->_days - 1) * 86400)) .
            Horde::link('', _("Next Week"), 'smallheader', null, 'return switchTimestamp(' . ($this->_day + $this->_days * 86400) . ');') .
            Horde::img('nav/right.png', '>', null, $registry->getImageDir('horde')) .
            '</a>';
    }

    function _hours()
    {
        global $prefs;

        $hours_html = '<table width="100%" cellpadding="0" cellspacing="0" style="text-align:center"><tr>';
        $dayWidth = 100 / $this->_days;
        $span = floor(($this->_endHour - $this->_startHour) / 3);
        $date_format = $prefs->getValue('date_format');
        for ($i = 0; $i < $this->_days; $i++) {
            $t = mktime(0, 0, 0, date('n', $this->_day), date('j', $this->_day) + $i, date('Y', $this->_day));
            $day_label = strftime($date_format, $t);
            if ($i > 0) {
                $hours_html .= sprintf('<td colspan="%d" style="white-space:nowrap; overflow:hidden; border-left:1px solid black; width:%s%%">%s</td>',
                                       $span, $dayWidth, $day_label);
            } else {
                $hours_html .= sprintf('<td colspan="%d" style="white-space:nowrap; overflow:hidden; width:%s%%">%s</td>',
                                       $span, $dayWidth, $day_label);
            }
        }
        $hours_html .= '</tr><tr>';

        $width = 100 / ($this->_days * floor(($this->_endHour - $this->_startHour) / 3));
        for ($i = 0; $i < $this->_days; $i++) {
            for ($h = $this->_startHour; $h < $this->_endHour; $h += 3) {
                $t = mktime($h, 0, 0, date('n', $this->_day), date('j', $this->_day), date('Y', $this->_day));

                $hour = strftime('%H:00', $t);
                if (($i + $h) > $this->_startHour) {
                    $hours_html .= sprintf('<td style="white-space:nowrap; overflow:hidden; border-left:1px solid black; width:%d%%">%s</td>',
                                           $width, $hour);
                } else {
                    $hours_html .= sprintf('<td style="white-space:nowrap; overflow:hidden; width:%d%%">%s</td>',
                                           $width, $hour);
                }
            }
        }

        $hours_html .= '</tr></table>';

        return $hours_html;
    }

    function _render($day = null)
    {
        global $prefs;

        if (is_null($day)) {
            list($startDate['year'], $startDate['month'], $startDate['mday']) = explode('-', Date_Calc::beginOfWeek(null, null, null, "%Y-%m-%d"));
            $day = mktime(0, 0, 0, $startDate['month'], $startDate['mday'], $startDate['year']);
        } else {
            list($startDate['year'], $startDate['month'], $startDate['mday']) = explode('-', Date_Calc::beginOfWeek(date('j', $day), date('n', $day), date('Y', $day), "%Y-%m-%d"));
            $day = mktime(0, 0, 0, $startDate['month'], $startDate['mday'], $startDate['year']);
        }
        $this->_day = $day;
        $this->_startStamp = mktime(0, 0, 0, date('n', $day), date('j', $day), date('Y', $day));
        $this->_endStamp   = mktime(23, 59, 59, date('n', $day) + $this->_days - 1, date('j', $day), date('Y', $day));
    }

    function _getBlocks($member, $periods, $blockfile, $label)
    {
        $template = &new Horde_Template();
        $template->set('label', '');

        $count = 0;
        $blocks = '';
        $dayWidth = 100 / $this->_days;
        foreach ($periods as $start => $end) {
            if ($start < $this->_endStamp && $end > $this->_startStamp) {

                $start_day = floor(($start - $this->_startStamp) / (24 * 3600));
                $start_hour = intval(strftime('%H', $start));
                $start_min = intval(strftime('%M', $start));

                $left = $dayWidth * $start_day;
                if ($start_hour >= $this->_startHour && $start_hour < $this->_endHour) {
                    $left += ($start_hour - $this->_startHour) * ($dayWidth / $this->_startHour);
                    $left += ($start_min / 60) * ($dayWidth / $this->_startHour);
                } elseif ($start_hour >= $this->_endHour) {
                    $left += $dayWidth;
                }
                $left = min(100, max(0, $left));

                $end_day = floor(($end - $this->_startStamp) / (24 * 3600));
                $end_hour = intval(strftime('%H', $end));
                $end_min = intval(strftime('%M', $end));

                $right = $dayWidth * $end_day;
                if ($end_hour >= $this->_startHour && $end_hour < $this->_endHour) {
                    $right += ($end_hour - $this->_startHour) * ($dayWidth / $this->_startHour);
                    $right += ($end_min / 60) * ($dayWidth / $this->_startHour);
                } elseif ($end_hour >= $this->_endHour) {
                    $right += $dayWidth;
                }
                $right = min(100, $right);

                if (($right - $left) != 0) {
                    $template->set('left', $left);
                    $template->set('width', $right - $left);
                    $template->set('top', $count++ * 15);
                    $template->set('label', $label);

                    $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/' . $blockfile);
                }
            }
        }

        // Indicate if we don't know the free busy info for any periods
        $start = $member->getStart();
        $end   = $member->getEnd();
        if ($start > $this->_startStamp) {
            if ($start >= $this->_endStamp) {
                $right = 100;
            } else {
                $start_day = floor(($start - $this->_startStamp) / (24 * 3600));
                $start_hour = intval(strftime('%H', $start));
                $start_min = intval(strftime('%M', $start));

                $right = $dayWidth * $start_day;
                if ($start_hour >= $this->_startHour && $start_hour < $this->_endHour) {
                    $right += ($start_hour - $this->_startHour) * ($dayWidth / $this->_startHour);
                    $right += ($start_min / 60) * ($dayWidth / $this->_startHour);
                } elseif ($start_hour >= $this->_endHour) {
                    $right += $dayWidth;
                }
            }
            $left  = 0;

            $template->set('left', $left);
            $template->set('width', min($right - $left, 100));
            $template->set('top', $count++ * 15);

            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        } else if ($end <= $this->_endStamp) {
            if ($end <= $this->_startStamp) {
                $left = 0;
            } else {
                $end_day = floor(($end - $this->_startStamp) / (24 * 3600));
                $end_hour = intval(strftime('%H', $end));
                $end_min = intval(strftime('%M', $end));

                $left = $dayWidth * $end_day;
                if ($end_hour >= $this->_startHour && $end_hour < $this->_endHour) {
                    $left += ($end_hour - $this->_startHour) * ($dayWidth / $this->_startHour);
                    $left += ($end_min / 60) * ($dayWidth / $this->_startHour);
                } elseif ($end_hour >= $this->_endHour) {
                    $left += $dayWidth;
                }
                $left = min(100, $left);
            }
            $right  = 100;

            $template->set('left', $left);
            $template->set('width', min($right - $left, 100));
            $template->set('top', $count++ * 15);

            $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/unknownblock.tpl');
        }

        // overlay the grid
        $template->set('top', $count++ * 15);
        $columns = $this->_days * floor(($this->_endHour - $this->_startHour) / 3);
        $template->set('columns', range(1, $columns));
        $template->set('width', 100 / $columns);
        $blocks .= $template->fetch(KRONOLITH_TEMPLATES . '/fbview/linesblock.tpl');

        return $blocks;
    }

}
