<?php
/**
 * $Horde: kronolith/day.php,v 1.63.8.1 2005/01/03 12:25:39 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/DayView.php';

if ($timestamp = (int)Util::getFormData('timestamp')) {
    $day = &new Horde_Date($timestamp);
    list($year, $month, $day) = array($day->year, $day->month, $day->mday);
} else {
    $year = (int)Util::getFormData('year');
    $month = (int)Util::getFormData('month');
    $day = (int)Util::getFormData('mday');
}
$dayOb = &new Kronolith_DayView($month, $day, $year);
$title = $dayOb->getTime($prefs->getValue('date_format'));
$print_view = (bool)Util::getFormData('print');

Horde::addScriptFile('tooltip.js', 'horde', true);
if (!$print_view) {
    Horde::addScriptFile('popup.js', 'horde', true);
}
require KRONOLITH_TEMPLATES . '/common-header.inc';

if ($print_view) {
    require_once $registry->get('templates', 'horde') . '/javascript/print.js';
} else {
    if ($browser->hasFeature('javascript')) {
        $print_link = Util::addParameter('day.php', array('month' => $month,
                                                          'mday' => $day,
                                                          'year' => $year,
                                                          'timestamp' => $timestamp,
                                                          'print' => 'true'));
        $print_link = Horde::url($print_link);
    }

    require KRONOLITH_TEMPLATES . '/menu.inc';
    Kronolith::tabs();
}

$dayOb->html(KRONOLITH_TEMPLATES);

require $registry->get('templates', 'horde') . '/common-footer.inc';
