/***************************************************************************
                          
                          threadedlister.h  -  description
                             -------------------
    begin                : Tue Feb 01 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef THREADEDLISTER_H
#define THREADEDLISTER_H

#include <qobject.h>
#include <qthread.h>

#include <kfileitem.h>

class KDirLister;
class KRecursiveLister;
class KMyListBox;
class QMutex;

class FileList : public QPtrList<KFileItem> {
    public:
        FileList() : QPtrList<KFileItem>() {}
        FileList( KFileItemList list ) 
            : QPtrList<KFileItem>() {
                KFileItem* it;
                for( it = list.first(); it; it = list.next() )  
                    this->append( it );
            }

    protected:
        int compareItems( QPtrCollection::Item item1, QPtrCollection::Item item2 ) {
            return static_cast<KFileItem*>(item1)->url().url().compare( static_cast<KFileItem*>(item2)->url().url() );
        }
        
};


class ThreadedLister : public QObject, public QThread
{
    Q_OBJECT
    public:
        ThreadedLister( QMutex* mutex, unsigned int* counter, KMyListBox* list );
        ~ThreadedLister();

        static int TYPE() { return 51984; }
        
        inline FileList* items();
        
        inline const KURL & dirname();
        inline bool dirnames();
        inline const QString & filter();
        inline bool hidden();
        
        inline void setDirname( const KURL & dirname );
        inline void setDirnames( bool names );        
        inline void setFilter( const QString & filter );
        inline void setHidden( bool h );
        inline void setRecursive( bool r );
        inline void setRecursiveDirOnlyMode( bool m );
        
    signals:
        void listerDone( ThreadedLister* );
        
    protected:
        void run();
        
    private slots:
        void reclisterFinished();
        void listerFinished();
        
    private:        
        QMutex* m_mutex;
        QMutex* m_internal;
        unsigned int* m_counter;

        FileList m_files;
        
        KURL m_dirname;
        QString m_filter;
        bool m_hidden;
        bool m_recursive;
        bool m_dirnames;
        bool m_dironly;
                
        KDirLister* m_lister;
        KRecursiveLister* m_reclister;
        
        KMyListBox* m_list;
};

void ThreadedLister::setDirname( const KURL & dirname )
{
    m_dirname = dirname;
}

void ThreadedLister::setDirnames( bool names )
{
    m_dirnames = names;
}

void ThreadedLister::setFilter( const QString & filter )
{
    m_filter = filter;
}

void ThreadedLister::setHidden( bool h )
{
    m_hidden = h;
}

void ThreadedLister::setRecursive( bool r )
{
    m_recursive = r;
}

void ThreadedLister::setRecursiveDirOnlyMode( bool m )
{
    m_dironly = m;
}

FileList* ThreadedLister::items()
{
    return &m_files;
}

const KURL & ThreadedLister::dirname()
{
    return m_dirname;
}

bool ThreadedLister::dirnames()
{
    return m_dirnames;
}

const QString & ThreadedLister::filter()
{
    return m_filter;
}

bool ThreadedLister::hidden()
{
    return m_hidden;
}

#endif
