/***************************************************************************
                          kountdown.cpp  -  the screensaver
                             -------------------
    begin                : Sun Feb 10 09:52:20 CET 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : kountdown@erre.user.lysator.liu.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qfontdatabase.h>
#include <qregexp.h>
#include <qcanvas.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kapplication.h>

#include "kountdown.h"
#include "kdtimer.h"
#include "kdtext.h"

Kountdown::Kountdown(WId id) :
KScreenSaver(id), background(0), tiden(0)
{
	// Create a canvas to paint in and a canvasview to show it.
	// Turn of scrollbar and frame and embed after canvas->update()
	// has been called.
	canvas = new QCanvas( width() , height() );
	view = new QCanvasView( canvas, 0, "Main canvas view");
	view->setVScrollBarMode( QScrollView::AlwaysOff );
	view->setHScrollBarMode( QScrollView::AlwaysOff );
	view->setFrameStyle( QFrame::NoFrame | QFrame::Plain );
	view->show();

	canvas->update();
	embed(view);

	canvasText = new KDText(canvas, width(), height());
	canvasText->setTextFlags( Qt::AlignCenter );
	canvasText->setAnimated( true );
	canvasText->setVisible( true );

	readGlobalSettings();
	readSettings(0);

	connect( timer, SIGNAL( reachedMilestone(int) ), this, SLOT( readSettings(int) ) );
	connect( timer, SIGNAL( timeLeftChanged(STimeLeft *) ), this, SLOT( slotUpdateText(STimeLeft *) ) );
	timer->start();
	kountdown();
}

Kountdown::~Kountdown()
{
	delete background;
	background = 0;
	
	timer->stop();
	delete timer;
	timer = 0;

	delete canvasText;
	canvasText = 0;
	delete canvas;
	canvas = 0;
	delete view;
	view = 0;
}

void Kountdown::readGlobalSettings()
{
	int startFormat, halfFormat;
	KConfig *config = KGlobal::config();

	config->setGroup( "Start settings" );
		startFormat = config->readNumEntry( "Display", 9 );

	config->setGroup( "HalfWay settings" );
		halfFormat = config->readNumEntry( "Display", 9 );

	// Setup global settings. Default date is 10 days in the future.
	config->setGroup("Global settings");
		QDateTime temp( QDate::currentDate().addDays(10), QTime::currentTime() );
		QDateTime finish = config->readDateTimeEntry( "FinishDateTime", &temp);
		//QDateTime finish = QDateTime::currentDateTime().addSecs(10);
		targetDate = finish.date().toString();
		targetTime = finish.time().toString();

	// Do we want halfway. Default halfway date is finishdate - 2 days
	if ( config->readBoolEntry( "UseHalfWay", false ) ) {
		temp = QDateTime( finish.addDays(-2) );
		QDateTime half = config->readDateTimeEntry( "HalfDateTime", &temp);
		//QDateTime half = QDateTime::currentDateTime().addSecs(5);
		timer = new KDTimer( finish, startFormat, half, halfFormat );
	}
	else
		timer = new KDTimer( finish, startFormat );

	CHECK_PTR( timer );
}

/*
* Read in settings (Font, color etc.).
* setting: 0 = start, 1 = halfway, 2 = finish
*/
void Kountdown::readSettings( int setting )
{
	KConfig *config = KGlobal::config();

	switch (setting) {
	default:
	case 0:
		config->setGroup( "Start settings" );
		break;
	case 1:
		config->setGroup( "HalfWay settings" );
		break;
	case 2:
		config->setGroup( "Finish settings" );
		break;
	}

	text = config->readEntry( "Text", i18n( "It's now %D days and %S seconds left to %F - %T" ));

	if ( config->readBoolEntry( "RandomBackCol", false ) )
		backCol = randomColor();
	else
		backCol = config->readColorEntry( "BackCol", &Qt::black );

	if ( config->readBoolEntry( "RandomFontCol", false ) )
		fontCol = randomColor();
	else
		fontCol = config->readColorEntry( "FontCol", &Qt::red );

	if ( config->readBoolEntry( "RandomFont", false ) )
		font = randomFont();
	else
		font = config->readFontEntry( "Font" );

	canvasText->setFont( font );
	canvasText->setColor( fontCol );

	switch ( config->readNumEntry( "BackPattern", 0 ) ) {
		default: // fall through
		case 0: // Solid color
			canvas->setBackgroundPixmap( QPixmap() );
			canvas->setBackgroundColor( backCol );
			break;
		case 1: // XOR pixmap
			delete background;
			background = makeXorPattern( backCol.red(), backCol.green(), backCol.blue() );
			canvas->setBackgroundPixmap( *background );
			break;
/*	case 2:
			makeFirePattern( background, backCol.red(), backCol.green(), backCol.blue() );
			break; */
	}

	speed = config->readNumEntry( "Speed", 50 );
	if ( speed > 100 || speed < 0 )
		speed = 50;

	textEffect = config->readNumEntry( "Text effect", 0 );
	canvasText->setEffect( textEffect );

	if ( setting > 0 ) // We have been called to change settings (not setting them ie not constructor)
		kountdown();
}

// Return a random font.
QFont Kountdown::randomFont()
{
  QFontDatabase fdb;

  QStringList fam = fdb.families();
  QString family( fam[ kapp->random() % fam.count() ] );

  QStringList st = fdb.styles( family );
  QString style( st[ kapp->random() % st.count() ] );

  QValueList<int> si = fdb.pointSizes( family, style );
  int size = si[ kapp->random() % si.count() ];

  return fdb.font( family, style, size );
}

// Return a random color
QColor Kountdown::randomColor()
{
  int r = kapp->random() % 256;
  int g = kapp->random() % 256;
  int b = kapp->random() % 256;
  return QColor( r, g, b );
}

void Kountdown::kountdown()
{
	// Make sure we have some text to display and center it.
	slotUpdateText( tiden );
	canvasText->move( width()>>1, height()>>1 );

	// Set advanceperiod
	switch ( textEffect ) {
		default: //fall through
		case 0: // None
			canvasText->setVelocity( 0, 0 );
			canvas->setAdvancePeriod( 1000 );
			break;
		case 1: // Loop
			speed = 33 - (speed / 10) * 3;
			speed = width() / speed;
			speed = speed>>1;
			canvasText->setVelocity( 2, 0 );
			canvas->setAdvancePeriod( 1000/speed );
			break;
		case 2: // Popup
			speed = (100 - speed)>>1;
			canvasText->setVelocity( speed, 0 );
			canvas->setAdvancePeriod( 1000 );
			break;
	}
}
 
void Kountdown::slotUpdateText( STimeLeft *tid )
{
	if ( tid != 0 ) {
		slotGetText( tid );
		tiden = tid;
	}
	else {
		textDisplay = "";
		tiden = 0;
	}
}

void Kountdown::slotGetText(STimeLeft *tiden)
{
	textDisplay = text;
	textDisplay.replace( QRegExp( "%[Yy]" ), QString::number(tiden->years) );
	textDisplay.replace( QRegExp( "%[Oo]" ), QString::number(tiden->months) );
	textDisplay.replace( QRegExp( "%[Ww]" ), QString::number(tiden->weeks) );
	textDisplay.replace( QRegExp( "%[Dd]" ), QString::number(tiden->days) );
	textDisplay.replace( QRegExp( "%[Hh]" ), QString::number(tiden->hours) );
	textDisplay.replace( QRegExp( "%[Mm]" ), QString::number(tiden->mins) );
	textDisplay.replace( QRegExp( "%[Ss]" ), QString::number(tiden->secs) );
	textDisplay.replace( QRegExp( "%[Ff]" ), targetDate );
	textDisplay.replace( QRegExp( "%[Tt]" ), targetTime );
	canvasText->setText( textDisplay );
}

QPixmap * Kountdown::makeXorPattern( int, int g, int b)
{
	QPixmap *pixmap = new QPixmap( 256, 256 );
	pixmap->fill();
	QPainter paint(pixmap);
	for ( int i = 0; i < pixmap->height(); i++ ) {
		for ( int j = 0; j < pixmap->width(); j++) {
			paint.setPen( QColor( (j^i) % 256, g, b ));
			paint.drawPoint( j, i );
		}
	}
	paint.end();
	return pixmap;
}

/*void Kountdown::makeFirePattern( QPixmap *pixmap, int r, int g, int b)
{
	QImage *img = new QImage( width(), height(), 8 );
	QImage *img2 = new QImage( width(), height(), 8 );

	img->setNumColors( 256 );
	img2->setNumColors( 256 );
	for ( int c = 0; c < 128; c++ ) {
		img->setColor( c, qRgb(c + 2, c + 3, 0 ) );
	}
	for ( int c = 128; c < 256; c++ ) {
		img->setColor( c, qRgb(255, c, c) );
	}

	for ( int x = 0; x < img->width(); x++ ) {
		img->setPixel( x, img->height() - 1, (kapp->random() % 50) + 100 );
		img->setPixel( x, img->height() - 2, (kapp->random() % 50) + 100 );
	}

	for ( int y = img->height() - 1; y > 0; y-- ) {
		for ( int x = 1; x < img->width() - 1; x++ ) {
			int index = (img->pixelIndex(x, y) + img->pixelIndex(x - 1, y) + img->pixelIndex( x + 1, y)) / 3;
//			qWarning("index: %i\n", index);
			img->setPixel(x, y - 1, index);
		}
	}
	pixmap->convertFromImage(*img, 0);
	delete img;
	delete img2;
} */

