/***************************************************************************
                          kdtimer.h  -  description
                             -------------------
    begin                : Tue Apr 2 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : kountdown@erre.user.lysator.liu.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDTIMER_H
#define KDTIMER_H

#include <qobject.h>

typedef unsigned long int ULONG;

namespace KD
{
	enum TIME { NIL = 0, SECS = 1, MINS = 2, HOURS = 4, DAYS = 8, WEEKS = 16, MONTHS = 32, YEARS = 64, ALL = 127 };
	enum ROUND { NONE, UP };
};

/**
* The struct that is returned when asking for time left, and which contains all the time.
* @short A struct which contains the time left.
* @author Erik Johansson
*/
struct STimeLeft {
	STimeLeft() { setDateValue( 0 ); setTimeValue( 0 ); reachedHalfWay = false; reachedFinish = false; }

	void setDateValue( unsigned long i ) { years = months = weeks = days = i; }
	void setTimeValue( unsigned long i ) { hours = mins = secs = i; }

	unsigned long years, months, weeks, days, hours, mins, secs;

	// Set to true if we have reached HalfWay or finish
	bool reachedHalfWay;
	bool reachedFinish;
};

// Forward declarations
class QDateTime;
class QTimer;

/**
* The class that does all the counting.
* @author Erik Johansson
*/
class KDTimer : public QObject
{
	Q_OBJECT
	public:
		KDTimer( const QDateTime &, short int );
		KDTimer( const QDateTime &, short int, const QDateTime &, short int );
		~KDTimer();

		void start();
		void stop();
	
	private slots:
		void slotUpdateTimeLeft();
	
	signals:
		// Emited when we reache halfway (1) or finish (2)
		void reachedMilestone(int);
		void timeLeftChanged(STimeLeft *);
		
	private:
		enum { FINISH, HALF, CURRENT, BOTH };
		void init( short, short = KD::NIL );
		void setUpFnPtrList( short );
		
		/**
		* Calculate the numer of whole [years|months|...|secs] from
		* calcDateTime to finishDate, rounding it off according to round.
		* If update is true, updates timeLeft.[years|months|...|secs] with this value.
		* @param round Howto round off (KD::NONE or KD::UP)
		*/
		unsigned int years( KD::ROUND round, bool update = true );
		unsigned int months( KD::ROUND round, bool update = true );
		unsigned int weeks( KD::ROUND round, bool update = true );
		unsigned int days( KD::ROUND round, bool update = true );
		unsigned int hours( KD::ROUND round, bool update = true );
		unsigned int mins( KD::ROUND round, bool update = true );
		unsigned int secs( KD::ROUND round, bool update = true );

		// Date to countdown to and halfway date
		QDateTime *finishDate, *halfDate;
		// Datetime to count from
		QDateTime *calcDateTime;
		// Should we use the halfway date
		bool useHalfWay;
		// The format to use
		short int calcFormat[BOTH];
		// Time left
		STimeLeft timeLeft;
		// Timer which updates timeLeft.
		QTimer *updateTimer;
		// Function pointer list and number of functions
		unsigned int (KDTimer::*fnPtrList[7]) (KD::ROUND, bool);
		unsigned short fnPtrNr;
		// Are we active
		bool running;
};

#endif
