/***************************************************************************
                          kdtext.cpp  -  description
                             -------------------
    begin                : Sun Apr 6 2003
    copyright            : (C) 2003 by Erik Johansson
    email                : kountdown@erre.user.lysator.liu.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qrect.h>
#include <qcanvas.h>

#include <kapplication.h>
 
#include "kdtext.h"

#define MAX_EFFECT 2

KDText::KDText(QCanvas *canvas, int w, int h) :
QCanvasText(canvas), effect(0), cWidth(w/2), cHeight(h/2), tmp(0), posX(w/2), posY(h/2), velX(0), velY(0)
{
	// The diffrent paint functions
	listRepaint[0] = &KDText::repaintNone;
	listRepaint[1] = &KDText::repaintLoop;
	listRepaint[2] = &KDText::repaintPopup;

	repaint = listRepaint[0];
}

void KDText::setEffect(int e)
{
	if ( e < 0 || e > MAX_EFFECT )
		e = 0;
	repaint = listRepaint[e];
}	

void KDText::advance(int phase)
{
	if ( phase == 1 )
		(this->*repaint)();
}

void KDText::setVelocity(double dx, double dy)
{
	velX = dx;
	velY = dy;
	tmp = 0;
	posX = cWidth;
	posY = cHeight;
}

void KDText::repaintNone()
{
	move( cWidth, cHeight );
}

void KDText::repaintLoop()
{
	rect = boundingRect();
	if ( rect.right() <= 0 )
		move( cWidth * 2 + rect.width() / 2, cHeight );
	else
		move( x() - velX, cHeight );
}

void KDText::repaintPopup()
{
	if ( tmp < velX )
		tmp++;
	else {
		tmp = 0;
		rect = boundingRect();
		int w = rect.width();
		int h = rect.height();
		posX = (kapp->random() % (cWidth*2 - w)) + w / 2;
		posY = (kapp->random() % (cHeight*2 - h)) + h / 2;
	}
	move( posX, posY );
}
