/***************************************************************************
                          kdtimer.h  -  description
                             -------------------
    begin                : Tue Apr 2 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDTIMER_H
#define KDTIMER_H

#include <qobject.h>

typedef unsigned long int ULONG;

namespace KD {	
	const short int SECS 		= 1;
	const short int MINS 		= 2;
	const short int HOURS 		= 4;
	const short int DAYS 		= 8;
	const short int WEEKS		= 16;
	const short int MONTHS	= 32;
	const short int YEARS		= 64;
	const short int ALL 			= 127;

	enum ROUND { DOWN, UP, MATH, NONE = DOWN};
};

/**
* The struct that is returned when asking for time left, and which contains all the time.
* @short A struct which contains the time left.
* @author Erik Johansson
*/
struct STimeLeft {
	/**
	* The constructor takes no arguments and only sets some default values for the struckt.
	* @see setDateValue
	*/
	STimeLeft() { setDateValue( 0 ); setTimeValue( 0 ); half = false; finish = false; }
	/**
	Sets the value of years, months, weeks, days to i.
	*/
	void setDateValue( unsigned long i ) { years = months = weeks = days = i; }
	/**
	Sets the value of hours, mins and secs to @p i.
	*/
	void setTimeValue( unsigned long i ) { hours = mins = secs = i; }
	unsigned long years, months, weeks, days, hours, mins, secs;
	bool half;  					// If we have reached half way, set this to true
	bool finish;					// If we have reached the finish, set this to true
};

// Forward declarations
class QDateTime;
class QDate;
class QTime;
class QTimer;

/**
* The class that does all the counting.
* @author Erik Johansson
*/
class KDTimer : public QObject
{
	Q_OBJECT
	public:
		// Fin date + fin settings, no halfway
		KDTimer( const QDateTime *, short int format, short int round );
		// Fin date + fin settings, half date + half settings = fin settings
		KDTimer( const QDateTime *, short int, short int, const QDateTime * );
		// Fin date + fin settings, half date + half settings
		KDTimer( const QDateTime *, short int, short int, const QDateTime *, short int, short int);
		~KDTimer();

		const STimeLeft * start();
		const STimeLeft * stop() { return 0; }
	
	public slots:
		void slotCalcDate();
		void slotCalcTime();
		void slotCheckDateTime();
	
	signals:
		void changeSettings(int);
		void timeLeftChanged();
		
	private:
		enum { FINISH, HALF, CURRENT, BOTH };	
		void init( short int *, short int *, short int * = 0, short int * = 0 );		
		void kountdown();
		
		/**
		* Calculate the numer of whole years left, rounding it off according to @p r.
		* Sets @ref timeLeft.years to years left and adds the years left to @ref calcDate.
		* @param r Howto round off (0 = down, 1 = up, 2 = math)
		*/
		void years( short int r );
		
		/**
		* Calculate the number of whole months left.
		* @param r Howto round off (0 = down, 1 = up, 2 = math)
		* @param f The format as set by the constructor. This to be able to use @ref years()
		* if it hasn't been used before.
		*/
		void months( short int r, const short int f = -1 );
		void weeks( short int r );
		void days( short int, const short int = -1 );
		void hours( short int, const short int = -1 );
		void mins( short int, const short int = -1 );
		void secs( const short int = -1 );
			
		// Date to countdown to and halfway date
		QDateTime *finishDate, *halfDate;
		// Current date and time
		QDateTime *calcDateTime;
		QDate *calcDate;
		QTime *calcTime;
		// Should we use the halfway date
		bool useHalfWay;
		// The format to use
		short int calcFormat[BOTH], roundOff[BOTH];
		// Time left
		STimeLeft timeLeft;
		// Timers
		QTimer *dateTimer, *timeTimer, *checkTimer;
		// Status flags
		bool calcingDate, calcingTime;
};

#endif
