/***************************************************************************
                          timewidget.h  -  a widget with date and time
                             -------------------
    begin                : Sun Feb 17 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMEWIDGET_H
#define TIMEWIDGET_H

#include <qvalidator.h>
#include <qwidget.h>
#include <qdatetime.h>

class QVBoxLayout;
class QHBoxLayout;
class KDateTable;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QSpinBox;

class TimeWidget : public QWidget
{
	Q_OBJECT

	public:
		TimeWidget( QWidget* parent = 0, const char* name = 0 );
		~TimeWidget() {}

		QDateTime getDateTime(); //const;
		void setDateTime( const QDateTime & );

	private slots:
		void slotSetYear( int );
		void slotSetMonth( int );
		void slotSetDay( QDate );
		void slotSetTime();

	private:
		const int MAXYEAR;                          	// Max year to display in year
		const int MINYEAR;                           	// Min year to display in year
		QDate 			date; 										   // Date to display
		QTime				time;             						// Time to display
		QLabel 			*dots1, *dots2, *timeLbl; 	// Label for ":", ":" and "Time:"
		QGroupBox 	*dateBox;									// The frame around everything
		QComboBox 	*month;                         	// The month combobox
		QSpinBox 		*year;                           	// The year spinbox
		KDateTable 	*dateTbl;                       	// Date table
		QLineEdit 		*hour, *min, *sec;          	// Time input

		QVBoxLayout *mainLayout;                	// Layout dateBoxLayout
		QVBoxLayout *dateBoxLayout;            	// Layout dateLayout <> dateTbl <> timeLayout
		QHBoxLayout *dateLayout;                	// Layout month <> spacer <> year
		QHBoxLayout *timeLayout;                	// Layout timeLbl <> hour <> dots1 <> min <> dots2 <> sec
};

//-------------------------------------------------------
// Copied from kcontrol clock settings
// Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>

class KStrictIntValidator : public QIntValidator
{
	public:
		KStrictIntValidator( int bottom, int top, QWidget * parent, const char * name = 0 ) :
			QIntValidator(bottom, top, parent, name) {};

		QValidator::State validate( QString & input, int & d ) const;
};

#endif // TIMEWIDGET_H
