/***************************************************************************
                          timewidget.cpp  -  description
                             -------------------
    begin                : Sun Feb 17 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qdatetime.h>

#include <kdatetbl.h>
#include <klocale.h>

#include "timewidget.h"
#include "global.h"

TimeWidget::TimeWidget( QWidget* parent,  const char* name )
	:	QWidget( parent, name ), MAXYEAR( 2065 ), MINYEAR( 2002 )
{
	mainLayout = new QVBoxLayout( this );

	dateBox = new QGroupBox( 0, Qt::Vertical, i18n( "Date and time to count down to" ), this, "datebox" );
	dateBox->layout()->setSpacing( 0 );
	dateBox->layout()->setMargin( 0 );
	dateBoxLayout = new QVBoxLayout( dateBox->layout() );
	dateBoxLayout->setAlignment( Qt::AlignTop );
	dateBoxLayout->setSpacing( 6 );
	dateBoxLayout->setMargin( 11 );

	dateLayout = new QHBoxLayout;
	dateLayout->setSpacing( 6 );
	dateLayout->setMargin( 0 );

	// The month combobox
	month = new QComboBox( FALSE, dateBox, "month" );
	month->insertItem( i18n("January") );
	month->insertItem( i18n("February") );
	month->insertItem( i18n("March") );
	month->insertItem( i18n("April") );
	month->insertItem( i18n("May") );
	month->insertItem( i18n("June") );
	month->insertItem( i18n("July") );
	month->insertItem( i18n("August") );
	month->insertItem( i18n("September") );
	month->insertItem( i18n("October") );
	month->insertItem( i18n("November") );
	month->insertItem( i18n("December") );
	connect( month, SIGNAL( activated(int) ), this, SLOT( slotSetMonth(int) ) );
	dateLayout->addWidget( month );

	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	dateLayout->addItem( spacer );

	// The year spinbox MINYEAR <=> MAXYEAR
	year = new QSpinBox( dateBox, "year" );
	year->setMaxValue( MAXYEAR );
	year->setMinValue( MINYEAR );
	connect( year, SIGNAL( valueChanged(int) ), this, SLOT( slotSetYear(int) ) );
	dateLayout->addWidget( year );
	dateBoxLayout->addLayout( dateLayout );

	// The date table
	dateTbl = new KDateTable( dateBox );
	dateTbl->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum ) );
	connect( dateTbl, SIGNAL( dateChanged(QDate) ), this, SLOT( slotSetDay(QDate) ) );
	dateBoxLayout->addWidget( dateTbl );

	timeLayout = new QHBoxLayout;
	timeLayout->setSpacing( 6 );
	timeLayout->setMargin( 0 );

	// The time
	timeLbl = new QLabel (i18n( "Time:" ), this);
	timeLayout->addWidget( timeLbl );

	hour = new QLineEdit( dateBox, "hour" );
	hour->setText("0");
	hour->setMaxLength( 2 );
	hour->setValidator(new KStrictIntValidator(0, 23, hour));
	timeLayout->addWidget( hour );

	dots1 = new QLabel( dateBox, "dots1" );
	dots1->setMinimumSize( QSize( 7, 0 ) );
	dots1->setText( ":" );
	dots1->setAlignment( int( QLabel::AlignCenter ) );
	timeLayout->addWidget( dots1 );

	min = new QLineEdit( dateBox, "min" );
	min->setText("0");
	min->setMaxLength( 2 );
	min->setValidator(new KStrictIntValidator(0, 59, min));
	timeLayout->addWidget( min );

	dots2 = new QLabel( dateBox, "dots2" );
	dots2->setMinimumSize( QSize( 7, 0 ) );
	dots2->setText( ":" );
	dots2->setAlignment( int( QLabel::AlignCenter ) );
	timeLayout->addWidget( dots2 );

	sec = new QLineEdit( dateBox, "sec" );
	sec->setText("0");
	sec->setMaxLength( 2 );
	sec->setValidator(new KStrictIntValidator(0, 59, sec));
	timeLayout->addWidget( sec );

	QSpacerItem* timeSpacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	timeLayout->addItem( timeSpacer );

	int w = 2*hour->fontMetrics().width("00");
  	hour->setMaximumWidth(w);
  	min->setMaximumWidth(w);
 	sec->setMaximumWidth(w);
	dateBoxLayout->addLayout( timeLayout );
	mainLayout->addWidget( dateBox );

	// Init widget with todays date + one year
	//setDateTime( QDateTime( QDate( QDate::currentDate().addDays( 365 ) ), QTime::currentTime() ) );
}

void TimeWidget::slotSetYear(int y)
{
	if ( !date.setYMD(y, date.month(), date.day()) )
		date.setYMD(date.year(),date.month(),date.day());
	dateTbl->setDate(date);
}

void TimeWidget::slotSetMonth(int m)
{
	if ( !date.setYMD(date.year(),m+1,date.day()) )
		date.setYMD(date.year(),m+1,1);
	dateTbl->setDate(date);
}

void TimeWidget::slotSetDay( QDate d )
{
	if ( !date.setYMD( date.year(), date.month(), d.day() ) )
		date.setYMD( date.year(), date.month(), date.day() );		
}

void TimeWidget::slotSetTime()
{
	if ( hour->text() == "" )
		hour->setText("0");
	if ( min->text() == "" )
		min->setText("0");
	if ( sec->text() == "" )
		sec->setText("0");
	time = QTime( hour->text().toInt(), min->text().toInt(), sec->text().toInt() );
}

void TimeWidget::setDateTime( const QDateTime &datetime )
{
	if ( datetime <= QDateTime::currentDateTime() )	
	{
		date = QDate::currentDate().addDays(10);
		time = datetime.time();
	} else {
		date = datetime.date();
		time = datetime.time();
	}

	year->setValue( date.year() );
   month->setCurrentItem( date.month() - 1 );	
	dateTbl->setDate(date);

	hour->setText( QString::number( time.hour() ) );
	min->setText( QString::number( time.minute() ) );
	sec->setText( QString::number( time.second() ) );
}

// Can't be const, slotSetTime changes time :(
QDateTime TimeWidget::getDateTime() //const
{
	slotSetTime();
	return QDateTime(date, time);
}

//-------------------------------------------------------
// Copied from kcontrol clock settings
// Copyright (C) 1998 Luca Montecchiani <m.luca@usa.net>

QValidator::State KStrictIntValidator::validate( QString & input, int & d ) const
{
	if( input.isEmpty() )
		return Valid;

	State st = QIntValidator::validate( input, d );

	if( st == Intermediate )
		return Invalid;

	return st;
}
