/***************************************************************************
                          timer.h  -  the screensaver timer
                             -------------------
    begin                : Sat Feb 16 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMER_H
#define TIMER_H

#include <qobject.h>

struct STimeLeft {
	STimeLeft() { error = false; }
	void setValue( unsigned long i, bool b = false ) { days = hours = mins = secs = i; half = b; }
	unsigned long days, hours, mins, secs;
	bool half;  					// If we have reached half way, set this to true
	bool error;              // If there where any error in format, set this to true
};

class QDateTime;

/**
* Timer is a countdown class
*@author Erik Johansson
*/
class Timer : public QObject
{
	Q_OBJECT
	public:
		// Finish date, format (1 = sec, 2 = min, 4 = hour, 8 = day), round off
		// Half way date, half way format, half way round off
		Timer( const QDateTime *, short int = 15, short int = 0, const QDateTime * = 0, short int = -1, short int = 0);
		~Timer();

		STimeLeft getTime();   // Return time left, according to current format

	signals:
		void changeSettings(int);

	private:
		int countdown();     // Calc time left
		void countNoRound( short int );
		void countUpRound( short int );
		void countMathRound( short int );
		QDateTime *targetDate, *halfDate, *oldDate, *tempDate;
		STimeLeft time, returnTime;
		bool useHalfWay, timeLeft;
		short int stringFormat, halfStringFormat;
		short int roundOff, halfRoundOff;
};

#endif
