/***************************************************************************
                          kountdownsetup.h  -  the screensaver setup
                             -------------------
    begin                : Sun Feb 10 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOUNTDOWNSETUP_H
#define KOUNTDOWNSETUP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include "ksetupdlg.h"
#include "global.h"

class QFont;
class QDateTime;

/**
* KountdownSetup is used to setup the Kountdown screensaver
*/

class KountdownSetup : public KSetupDlg
{
   Q_OBJECT

	public:
		KountdownSetup(QWidget *parent=0, const char *name=0);
		~KountdownSetup();

	protected:
		void readSettings();

	public slots:
		void slotOk();
		void slotApply();
		void slotAbout();
		void slotFont();

	private:
		enum NAME { DAYS, HOURS, MINS, SECS };
		QDateTime calcHalfTime( const QDateTime, const ULONG, const ULONG, const ULONG, const ULONG );
		void calcHalfTime( const QDateTime, const QDateTime, ULONG &, ULONG &, ULONG &, ULONG & );
		int calcFormat( bool, bool, bool, bool );
		bool calcFormat( int &, NAME );
		QFont font[3];
};

#endif
