/***************************************************************************
                          kountdown.cpp  -  the screensaver
                             -------------------
    begin                : Sun Feb 10 09:52:20 CET 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qrect.h>
#include <qtimer.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kapp.h>

#include "kountdown.h"
#include "timer.h"
#include "global.h"

Kountdown::Kountdown(WId id)
	: KScreenSaver (id), repaintScreen(true)
{
	readGlobalSettings();
	readSettings(0);
	kountdown();
}

Kountdown::~Kountdown()
{
	repaintTimer->stop();
	getTextTimer->stop();
	delete timer;
}

void Kountdown::readGlobalSettings()
{
	int startFor, halfFor, startRound, halfRound;
	KConfig *config = KGlobal::config();
	config->setGroup("Global settings");

	QDateTime temp( QDate::currentDate().addDays(10), QTime::currentTime() );
	QDateTime finish = config->readDateTimeEntry( "FinishDateTime", &temp);
	targetDate = finish.date().toString();
	targetTime = finish.time().toString();
	QDateTime *half = new QDateTime;
	
	if ( config->readBoolEntry( "UseHalfWay", false ) )
	{
		temp = QDateTime( QDate::currentDate().addDays(5), QTime::currentTime() );
   	*half = config->readDateTimeEntry( "HalfDateTime", &temp);
	} else {
		delete half;
		half = 0;
	}
	
	config->setGroup( "Start settings" );
	startFor = config->readNumEntry( "Display", 15 );
	startRound = config->readNumEntry( "Round Off", 0 );
	
	config->setGroup( "HalfWay settings" );
	halfFor = config->readNumEntry( "Display", 15 );
	halfRound = config->readNumEntry( "Round Off", 0 );

	timer = new Timer( &finish, startFor, startRound, half, halfFor, halfRound );
	CHECK_PTR( timer );
	connect(timer, SIGNAL( changeSettings(int) ), this, SLOT( readSettings(int) ));
}

void Kountdown::readSettings( int moment )
{
	KConfig *config = KGlobal::config();

	switch (moment)
	{
	case 0:
		config->setGroup( "Start settings" );
		break;
	case 1:
		config->setGroup( "HalfWay settings" );
		break;
	case 2:
		config->setGroup( "Finish settings" );
		break;
	}

	text = config->readEntry( "Text", i18n( "Default text, please setup it first" ));
	backCol = config->readColorEntry( "BackCol", &Qt::black );
	fontCol = config->readColorEntry( "FontCol", &Qt::blue );
	font = config->readFontEntry( "Font" );
	loop = config->readBoolEntry( "Loop text", true );
	speed = 150 - config->readNumEntry( "Speed", 50 );
}

void Kountdown::kountdown()
{
	qpixmap = new QPixmap (width(), height());  	// The pixmap we are painting on
	repaintTimer = new QTimer( this );						// The "update screen" timer
	connect( repaintTimer, SIGNAL( timeout() ), this, SLOT( slotRepaint() ) );
	getTextTimer = new QTimer( this );             	// The "get text" timer
	connect( getTextTimer, SIGNAL( timeout() ), this, SLOT( slotGetText() ) );

	// ----------------------------------------------
	// Copied from kbanner - Basic screen saver for KDE
	// Copyright (c)  Martin R. Jones 1996	
	step = 5 * width() / QApplication::desktop()->width();
	if ( step == 0 )
		step = 1;
	//-----------------------------------------------
		
	temp = QRect( width(), 0, 0, height() );
	
	erase();
	getTextTimer->start( 300 );
	repaintTimer->start( speed );
}

void Kountdown::slotGetText()
{
	STimeLeft tiden;
	tiden = timer->getTime();
	if ( tiden.error )
		textDisplay = QString( "Error in format. Check file: %1, line: %2" ).arg(__FILE__).arg(__LINE__);
	else
	{
		textDisplay = text;
		textDisplay.replace( QRegExp( "%[Dd]" ), QString::number(tiden.days) );
		textDisplay.replace( QRegExp( "%[Hh]" ), QString::number(tiden.hours) );
		textDisplay.replace( QRegExp( "%[Mm]" ), QString::number(tiden.mins) );
		textDisplay.replace( QRegExp( "%[Ss]" ), QString::number(tiden.secs) );
		textDisplay.replace( QRegExp( "%[Ff]" ), targetDate );
		textDisplay.replace( QRegExp( "%[Tt]" ), targetTime );
	}
}

void Kountdown::slotRepaint()
{
	QPainter paint(qpixmap);
	paint.fillRect( qpixmap->rect(), backCol );
	paint.setPen( fontCol );
	paint.setFont( font );

	if ( loop )
	{
		rect = paint.boundingRect( temp, AlignVCenter, textDisplay );
		paint.drawText( rect, AlignCenter, textDisplay );
		temp.setX( temp.x() - step );
		if ( temp.x() < -rect.width())
			temp.setX( width() );
	}
	else
		paint.drawText( qpixmap->rect(), AlignCenter, textDisplay );
	
	bitBlt( this, 0, 0, qpixmap, 0, 0, -1, -1, CopyROP);
}
