#ifndef __kfiledialog_h__
#define __kfiledialog_h__

#include <qfiledialog.h>

class KFileDialog
{
public:
    static QString getOpenFileName( const QString &dir,
                                    const QString &filter,
                                    QWidget *parent, const QString &caption );
};

#if defined(_QT_QPE_) || defined(Q_WS_WIN32)

#if defined(_QT_QPE_)
#include <qpe/fileselector.h>
#else
struct DocLnk
{
    QString file() const { return QString::null; }
};
#endif

class QPEFileSelectorWrapper : public QDialog
{
    Q_OBJECT
public:
    QPEFileSelectorWrapper( QWidget *parent, const char *name = 0 );
    virtual ~QPEFileSelectorWrapper();

    QString selectedPath() const { return m_path; }

private slots:
    void fileSelected( const DocLnk &doc );

private:
    QString m_path;
};

#endif

#endif
