
#include "popuphandler.h"

#include <qapp.h>
#include <qtimer.h>

PopupHandler::PopupHandler( QApplication *app, const char *name )
    : QObject( app, name )
{
    app->installEventFilter( this );
    m_menuTimer = new QTimer( this );
    connect( m_menuTimer, SIGNAL( timeout() ),
             this, SLOT( popup() ) );

    m_inPopup = false;
}

bool PopupHandler::eventFilter( QObject *obj, QEvent *ev )
{
    if ( !obj || m_inPopup )
        return false;

    if ( ev->type() == QEvent::MouseButtonPress )
    {
        QMouseEvent *me = static_cast<QMouseEvent *>( ev );
        if ( me->button() == LeftButton )
        {
            m_obj = obj;
            m_mousePressPos = me->pos();
            m_menuTimer->start( 750, true ); // ### hardcoded
            return false;
	}
    }

    if ( ev->type() == QEvent::MouseButtonRelease ||
         ev->type() == QEvent::Leave ||
         ( ev->type() == QEvent::MouseMove &&
           ( static_cast<QMouseEvent *>( ev )->pos() - m_mousePressPos ).manhattanLength() >
             5 ) ) // ### hardcoded
    {
        m_obj = 0;
        m_mousePressPos = QPoint();
        m_menuTimer->stop();
    }


    return false;
}

void PopupHandler::popup()
{
    if ( !m_obj )
        return;

    m_menuTimer->stop();
    m_mousePressPos = QPoint();

    m_inPopup = true;

    // send faked mouse event
    QMouseEvent pev( QEvent::MouseButtonPress, QCursor::pos(), RightButton, RightButton );
    qApp->sendEvent( static_cast<QObject *>( m_obj ), &pev );
    QMouseEvent rev( QEvent::MouseButtonRelease, QCursor::pos(), RightButton, RightButton );
    qApp->sendEvent( static_cast<QObject *>( m_obj ), &rev );

    m_inPopup = false;
}

#include "popuphandler.moc"
