/*  This file is part of the KDE project
    Copyright (C) 2000,2001 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception this program may be linked with Qt non-commercial 
    edition, the resulting executable be distributed, without including the 
    source code for the Qt non-commercial edition in the source distribution.

*/

#include <config.h>
#include <stdlib.h>
#include <kapp.h>
#include <kcookieserver.h>
#include <authcache.h>
#include <khtml_part.h>
#include <klibloader.h>
#include <ecma/kjs_proxy.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <klocale.h>
#include <qtranslator.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <kio/launcher.h>
#include <kssld.h>

#ifdef _WS_QWS_
#include <qwsdisplay_qws.h>
#endif

#ifdef _QT_QPE_
#include "konqplugininterface.h"
#include <qpe/qlibrary.h>
#endif

#if !defined(Q_WS_WIN)
#include <signal.h>
#endif

#include "popuphandler.h"
#include "mainwindowbase.h"
#include "pics/file_broken.xpm"

// ### from ecma/kjs_proxy.cpp and khtml_factory.cpp
extern "C"
{
#ifdef ENABLE_JAVASCRIPT
    KJSProxy *kjs_html_init( KHTMLPart * );
#endif
    void *init_libkhtml();
}

// ### from http_cache_cleaner.cpp
extern int http_cache_cleaner_main( int, char ** );

// ### from khtml_part.cpp
extern int kjs_lib_count;

#ifdef NDEBUG
void messageHandler( QtMsgType , const char *)
{
	// eat this
}
#endif

int main( int argc, char **argv )
{
#if defined(Q_WS_WIN)
    if ( getenv( "KDEDIR" ) == 0 )
    {
	QCString kdedir;
	kdedir.sprintf( "KDEDIR=%s", QDir::currentDirPath().local8Bit().data() );
	_putenv( kdedir.data() );
    }
#else
    signal( SIGCHLD, SIG_IGN );
#endif

    kjs_lib_count++; // ### hack, prevent khtmlpart from deleting the js klibrary object

#ifdef NDEBUG
    qInstallMsgHandler( messageHandler );
#endif
    KApplication app( argc, argv, "konq-embed" );

    if ( locate( "data", "khtml/css/html4.css" ).isEmpty() ||
	 locate( "config", "charsets" ).isEmpty() )
    {
	QMessageBox::critical( 0, i18n( "Fatal Error" ),
			       i18n( "Cannot find data files (html4.css and charsets) .\n"
				     "Make sure the KDEDIR environment variable is set correctly\n"
				     "or you execute this binary in the correct path. In the\n"
				     "directory KDEDIR points to to or in the directory the\n"
				     "executable is located there have to be two files:\n"
				     "share\\apps\\khtml\\css\\html4.css\n"
				     "and\n"
				     "share\\config\\charsets\n\n"
				     "Exiting..." ) );
	return 1;
    }

    // this call is not explicitly necessary, but we do it at this early
    // stage because that makes the launcher process more lightweight
    KIO::Launcher::startLauncherProcess();

#ifdef _QT_QPE_
    QString path = QPEApplication::qpeDir() + "/plugins/konqplugins";
    QDir dir( path, "lib*.so" );
    QStringList list = dir.entryList();
    QStringList::ConstIterator it = list.begin();
    for (; it != list.end(); ++it )
    {
        KonqPluginInterface *iface = 0;
        // ### known leak
        QLibrary *lib = new QLibrary( path + "/" + *it );    
        if ( lib->queryInterface( IID_KonqPluginInterface, 
                                  reinterpret_cast<QUnknownInterface **>( &iface ) ) == QS_OK )
        {
            iface->setup();
            // iface->release(); ... whatever.. we don't ever release the stuff anyway
        }
    }
#endif

#ifndef QT_NO_TRANSLATION

    char *lang = getenv( "LANG" );
    if ( lang )
    {
        QString qmFile = QString::fromLatin1( "konqueror_%1.qm" ).arg( QString::fromLatin1( lang ) );

        // locate the message file in $prefix/share/locale/
        qmFile = locate( "locale", qmFile );

        QTranslator *translator = new QTranslator( &app );
        if ( translator->load( qmFile ) )
            app.installTranslator( translator );
        else
            delete translator;
    }

#endif

#if defined(Q_WS_QWS)
    (void)new PopupHandler( &app, "popup-handler" );
#endif

    KAuthCacheServer authCache;
    authCache.setObjId( "authcache" );
    KCookieServer cookieEater;
    cookieEater.setObjId( "kcookiejar" );

#if defined(HAVE_SSL)
    KSSLD kssld( "kssld" );
#endif

#ifdef ENABLE_JAVASCRIPT
    KLibLoader::self()->library( "kjs_html" )->registerSymbol( "kjs_html_init", (void *)&kjs_html_init );
#endif
//    KLibLoader::self()->library( "libkhtml" )->registerSymbol( "init_libkhtml", (void *)&init_libkhtml );

#if !defined(Q_WS_WIN)
    KApplication::setService( "http_cache_cleaner.desktop", (void *)&http_cache_cleaner_main );
#endif

    KIconLoader::self()->registerIcon( "file_broken", QPixmap( file_broken_xpm ) );

    QObject::connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );

    MainWindowBase *toplevel = MainWindowBase::instantiate();

    bool openedMainWindow = false;

#if defined(_QT_QPE_)
    app.showMainDocumentWidget( toplevel );

    openedMainWindow = ( argc == 3 ) && !strcmp( "-qcop", argv[ 1 ] ) && 
	               ( toplevel->currentView() != 0 );
#else
    toplevel->show();

    app.setMainWidget( toplevel );

    for ( int i = 1; i < argc; i++ )
    {
       KURL u = QString::fromLatin1( QCString( argv[ i ] ) );
       if ( !u.isMalformed() && !u.isEmpty() )
       {
           toplevel->createNewView( u );
           openedMainWindow = true;
       }
    }
#endif

    if ( !openedMainWindow )
    {
        QString startDocumentPath = locate( "data", "konq-embed/start.html" );
        if ( !startDocumentPath.isEmpty() )
            toplevel->createNewView( startDocumentPath.prepend( "file:" ) );
        else
            toplevel->createNewView( KURL() );
    }

    int res = app.exec();

    KIO::Launcher::self()->stopLauncherProcess();

    return res;
}
