/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "part.h"

#include <kdebug.h>

using namespace KParts;

Part::Part( QObject *parent, const char *name )
    : QObject( parent, name )
{
    m_manager = 0;
    m_selectable = false;
    m_widget = 0;
    m_instance = 0;
}

Part::~Part()
{
    if ( m_widget )
    {
        // We need to disconnect first, to avoid calling it !
        disconnect( m_widget, SIGNAL( destroyed() ),
                    this, SLOT( slotWidgetDestroyed() ) );
        kdDebug(1000) << "deleting widget " << m_widget << " " << m_widget->name() << endl;
        delete (QWidget *)m_widget;
    }
}

Part *Part::hitTest( QWidget *widget, const QPoint & )
{
    if ( widget != m_widget )
        return 0;

    return this;
}

QWidget *Part::widget()
{
    return m_widget;
}

void Part::setWidget( QWidget *widget )
{
    ASSERT( !m_widget );
    m_widget = widget;
    connect( m_widget, SIGNAL( destroyed() ),
             this, SLOT( slotWidgetDestroyed() ) );
}

void Part::slotWidgetDestroyed()
{
    kdDebug() << "Part::slotWidgetDestroyed()" << endl;
    m_widget = 0;
    delete this;
}

bool Part::event( QEvent *event )
{
  if ( QObject::event( event ) )
    return true;

  if ( PartActivateEvent::test( event ) )
  {
    partActivateEvent( (PartActivateEvent *)event );
    return true;
  }

  if ( PartSelectEvent::test( event ) )
  {
    partSelectEvent( (PartSelectEvent *)event );
    return true;
  }

  if ( GUIActivateEvent::test( event ) )
  {
    guiActivateEvent( (GUIActivateEvent *)event );
    return true;
  }

  return false;
}

void Part::partActivateEvent( PartActivateEvent * )
{
}

void Part::partSelectEvent( PartSelectEvent * )
{
}

void Part::guiActivateEvent( GUIActivateEvent * )
{
}

ReadOnlyPart::ReadOnlyPart( QObject *parent, const char *name )
    : Part( parent, name )
{
}

ReadOnlyPart::~ReadOnlyPart()
{
}

void ReadOnlyPart::guiActivateEvent( GUIActivateEvent *event )
{
  if (event->activated())
  {
    if (!m_url.isEmpty())
    {
      emit setWindowCaption( m_url.prettyURL() );
    } else emit setWindowCaption( "" );
  }
}

#include "part.moc"

