/***************************************************************************
                          knutvardata.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTVARDATA_H
#define KNUTVARDATA_H


/*******************************/
/*    GLOBAL DEFINE            */
/*******************************/


#define VAR_NONE 0
#define VAR_UTILITY 1
#define VAR_BATTPCT 2
#define VAR_UPSTEMP 3
#define VAR_ACFREQ 4
#define VAR_LOADPCT 5
#define VAR_AMBTEMP 6
#define VAR_AMBHUMID 7
#define VAR_BATTVOLT 8
#define VAR_OUTVOLT 9
#define VAR_CURRENT 10
#define VAR_BATT_TEMP 11
#define VAR_BATT_CURRENT 12

#define MIN_WIDTH_FPANEL 150  //sirka panelu

#define DEFAULT_BG_COLOR Qt::lightGray
#define DEFAULT_FINGER_COLOR Qt::black
#define DEFAULT_OK_COLOR Qt::green
#define DEFAULT_WARNNING_COLOR Qt::yellow
#define DEFAULT_ERROR_COLOR Qt::red
#define DEFAULT_SCALE_COLOR Qt::black
#define DEFAULT_FONT_COLOR Qt::black



#define START_PORT 1024
#define STOP_PORT 65535
#define MIN_DELAY	2000

#define MIN_COLS 1
#define MAX_COLS 5

#define DEFAULT_COUNT_COLS 3 // prednastaveny pocet sloupcu analogovych meraku
#define DEFAULT_PORT 3493 //prednastaveny port
#define DEFAULT_PORT_STR "3493" //prednastaveny port
#define DEFAULT_DELAY 2000 //2000 milisekund

#define DEFAULT_INPUT_VOLTAGE 230
#define DEFAULT_INPUT_FREQUENCE 50

#define NUMBER_OF_VARS 10 // kolik promenych muzeme merit
#define NUMBER_OF_TYPES 13 // pocet typu promenych (none,utility ....)

#define ACFREQ 4
#define UTILITY 1
#define BATTVOLT 8
#define OUTVOLT 9



#define U230V 0
#define U120V 1
#define F50HZ 0
#define F60HZ 1


#include <qcolor.h>
#include <qfont.h>
#include <qstring.h>

#include <klocale.h>

/**
  *@author Daniel Prynych
  */

enum {aRegWhite,aRegGreen,aRegYellow,aRegRed,aRegBlue,aRegCyan,aRegMagenta,aRegBlack};

struct ScaleStructDef {
  int start;
  int end;
  int scaleColor;
  };

struct VarStrucDef {
  QString nameAnalog; // jmeno promene v meraku  napr. UPS Load
  QString nameUnit; // merna jednotka napr %
  int typeAnalog; //typ meraku
  int numberItem; //pocet casti stupnice neni v souvislosti barvou
  int numberInItem; //pocet casti stupnice uvnitr dilku stupnice
  int start; // pocatecni hodnota v meraku
  int end; // pocatecni hodnota v meraku
  struct ScaleStructDef scaleData[5];
  };


struct SettingDataDef {
  int countCols;
  int x;
  int y;
  QColor mainBackgroundColor;
  QColor mPanelBackgroundColor;
  QColor aPanelBackgroundColor;
  QColor analogFingerColor;
  QColor analogOKColor;
  QColor analogWarnningColor;
  QColor analogErrorColor;
  QColor analogScaleColor;
  QColor analogFontColor;
  unsigned int panelFlags;
  int inputVoltage;
  int inputFrequency;
  bool lowHighXfer;
  bool areYouSure;
  bool customBColor;
  bool customBPanelColor;
  bool customBAnalogColor;
  bool customOAnalogColor;
  QFont mPanelFont; // main panel font
  QFont aPanelFont; // analog panel font
  QFont systemFont; // system font
  bool customFont; // use custom font
  };

 /**
  * Trida obshuje data o analogovych panelech,
  * nazev, adresu port, protokol, promene atd.
  *
  * @author Daniel Prynych
  * @short Informace o analog. panelech
  * @version 0.3
  **/
class KNutVarData {
public:
  KNutVarData();
  ~KNutVarData();

 /**
  * Vrati data analogoveho mericiho panelu.
  *
  * @param seqNumber Kod typu meraky.
  * @param data Data pro zadany typ panelu.
  * @since  0.1
  **/
void getData(int seqNumber, struct VarStrucDef& data);

 /**
  * Nastavi data analogoveho mericiho panelu.
  *
  * @param seqNumber Kod typu meraky.
  * @param data Data pro zadany typ panelu.
  *
  * @since  0.1
  **/
void putData (int seqNumber, struct VarStrucDef& data);

 /**
  * Nastavi data analogoveho mericiho panelu pro vstupni a vystupni napeti.
  *
  * @param typeVoltage Typ vstupniho napeti 230/120.
  *
  * @since  0.1
  **/
void setVoltage (int typeVoltage);

 /**
  * Nastavi data analogoveho mericiho panelu pro vstupni frekvence.
  *
  * @param typeFrequence Typ vstupni frekvence 50/60.
  *
  * @since  0.1
  **/
void setFrequency (int typeFrequence);

 /**
  * Nastavi vnitrni cast vybarveni podle low/high xfer,
  * low/high-XFER udava rozpeti pri kterem UPS zpracovava napeti ze site.
  *
  * @param lowXfer Pocatecni hodnota.
  * @param highXfer Konecna hodnota.
  * @since  0.1
  **/
void setXfer (float lowXfer, float highXfer);

 /**
  * Vrati dlouhy nazev analogoveho panelu,
  * je to jmeno toho co vlastne panel meri.
  *
  * @param seqNumber Kod typu meraky.
  * @since  0.1
  **/
QString getNameAnalogData (int seqNumber);


private:
  struct VarStrucDef dataVar[ NUMBER_OF_TYPES ];  /* udrzuje popis Anagovych meraku pro danou promenou jmeno zabarveni typ meraky */
  struct VarStrucDef dataVarVoltage[2];
  struct VarStrucDef dataVarFrequence[2];

  QString upsVarNameAnalog[ NUMBER_OF_TYPES ];
};

#endif
