/***************************************************************************
                          knutupsdata.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTUPSDATA_H
#define KNUTUPSDATA_H

#include <qstring.h>
#include "knutvardata.h"
#include "kanalog.h"

/**
  *@author Daniel Prynych
  */

struct UpsInfo{
QString name; // jmeno
QString upsName; // jmeno UPSky napr mojeups@muj.pc.cz
long delay;
unsigned int port;
bool tcp;
QString userName;
QString password;
bool savePassword;
int upsVarCode[NUMBER_OF_VARS];
int netError; // kod chyby pri spojeni
int scaleEnd[NUMBER_OF_VARS];
int scaleStart[NUMBER_OF_VARS];
KAnalog  *upsAnalogs[NUMBER_OF_VARS];
};


struct UpsRecord {
UpsRecord* nextUpsRecord;
QString name; // jmeno
QString upsName; // jmeno UPSky napr. mojeups@muj.pc.cz
long delay;
unsigned int port;
bool tcp;
QString userName;
QString password;
bool savePassword;
int upsVarCode[NUMBER_OF_VARS];
};


 /**
  * Trida obshuje data o UPS-kach,
  * nazev, adresu port, protokol, promenne atd.
  *
  * @author Daniel Prynych
  * @short Informace o UPS
  * @version 0.2
  **/
class KNutUpsData {

public:
  KNutUpsData();
  ~KNutUpsData();

 /**
  * Prida zaznam.
  *
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  * @since  0.2
  **/
  void add (UpsInfo upsMember);

 /**
  * Prepise zaznam.
  *
  * @param index Udava poradove cislo zaznamu..
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  * @since  0.2
  **/
  void put (int index, UpsInfo upsMember );

 /**
  * Vrati zaznam.
  *
  * @param index Udava poradove cislo zaznamu.
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  *
  * @since  0.2
  **/
  void get (int index, UpsInfo& upsMember );

 /**
  * Vrati ukazatel na jmeno zaznamu.
  *
  * @param index Udava poradove cislo zaznamu.
  * @since  0.1
  **/
  QString* getName (int index);

 /**
  * Zrusi zaznam.
  *
  * @param index Udava poradove cislo zaznamu.
  *
  * @since  0.1
  **/
  void deleteName (int index);

 /**
  * Vrati pocet zaznamu.
  *
  * @since  0.1
  **/
  int getCount ( void );

 /**
  * Vrati ukazatel na zaznam, pokud zaznam neexistuje vrati 0.
  *
  * @param name Je jmeno zaznamu.
  * @since  0.1
  **/
  UpsRecord* findName (const QString name);


private:
  int countMembers;
  UpsRecord *firstRecord, *lastRecord;
};


#endif
