/***************************************************************************
                          knutupsdata.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutupsdata.h"
#include "knutvardata.h"


KNutUpsData::KNutUpsData()  {
// vytvori seznam UPS
  countMembers = 0;
  firstRecord = 0L;
  lastRecord = 0L;
  }

KNutUpsData::~KNutUpsData() {
  UpsRecord* upsPointer;

  // uvolnime zaznamy
  while (firstRecord !=0L) {
    upsPointer = firstRecord;
    firstRecord = firstRecord->nextUpsRecord;
    delete upsPointer;
    }
  }

void KNutUpsData::add (UpsInfo upsMember) {
// vlozime ups na konec

  UpsRecord* upsPointer = new UpsRecord;
  countMembers++;

  upsPointer->nextUpsRecord = NULL; // posledni je nulovy
  upsPointer->name = upsMember.name;
  upsPointer->upsName = upsMember.upsName;
  upsPointer->delay = upsMember.delay;
  upsPointer->port = upsMember.port;
  upsPointer->tcp = upsMember.tcp;
  upsPointer->userName = upsMember.userName;
  upsPointer->password = upsMember.password;
  upsPointer->savePassword = upsMember.savePassword;
  for (int i=0; i< NUMBER_OF_VARS;i++) upsPointer->upsVarCode[i] = upsMember.upsVarCode[i];

  if (firstRecord == 0L) {
  // vlozime prvni zaznam
    firstRecord= upsPointer;
    lastRecord = upsPointer;
    }
  else {
    lastRecord->nextUpsRecord = upsPointer;
    lastRecord = upsPointer;
    }
  }


void KNutUpsData::put (int index, UpsInfo upsMember ) {
  if ((index > -1 ) && (index < countMembers)) {
    UpsRecord* upsPointer = firstRecord;
    for (int i=0; i<index; i++) upsPointer = upsPointer->nextUpsRecord;
    upsPointer->name = upsMember.name;
    upsPointer->upsName = upsMember.upsName;
    upsPointer->delay = upsMember.delay;
    upsPointer->port = upsMember.port;
    upsPointer->tcp = upsMember.tcp;
    upsPointer->userName = upsMember.userName;
    upsPointer->password = upsMember.password;
    upsPointer->savePassword = upsMember.savePassword;
    for (int i=0; i<NUMBER_OF_VARS;i++) upsPointer->upsVarCode[i] = upsMember.upsVarCode[i];
    }
  }


void KNutUpsData::get (int index, UpsInfo& upsMember ) {
  if ((index > -1 ) && (index < countMembers)) {
    UpsRecord* pointer = firstRecord;
    for (int i=0; i<index; i++) pointer = pointer->nextUpsRecord;
    upsMember.name = pointer->name;
    upsMember.upsName = pointer->upsName;
    upsMember.delay = pointer->delay;
    upsMember.port = pointer->port;
    upsMember.tcp = pointer->tcp;
    upsMember.userName = pointer->userName;
    upsMember.password = pointer->password;
    upsMember.savePassword = pointer->savePassword;
    for (int i=0; i<NUMBER_OF_VARS;i++) upsMember.upsVarCode[i] = pointer->upsVarCode[i];
    }
  }

QString* KNutUpsData::getName (int index) {
  if ((index > -1 ) && (index < countMembers)) {
    UpsRecord* upsPointer = firstRecord;
    for (int i=0; i<index; i++) upsPointer = upsPointer->nextUpsRecord;
    return &upsPointer->name;
    }
  else return 0L;
  }


void KNutUpsData::deleteName (int index) {
  if ((index > -1 ) && (index < countMembers)) {
    UpsRecord* upsPointer;
    if (index == 0) {
    // mazeme prvni zaznam
    upsPointer = firstRecord;
    firstRecord = firstRecord->nextUpsRecord;
    }
  else {
    upsPointer = firstRecord;
    UpsRecord* prevPointer = upsPointer;
    for (int i=0; i<index; i++)	{
      prevPointer = upsPointer;
      upsPointer = upsPointer->nextUpsRecord;
      }
    // vyjmeme zaznam se seznamu
    prevPointer->nextUpsRecord = upsPointer->nextUpsRecord;
    if (upsPointer == lastRecord) lastRecord = prevPointer;
    // smazeme zaznam;
    }
  delete upsPointer;
  countMembers--;
  if (firstRecord == 0L) lastRecord=firstRecord;
  }
}


int KNutUpsData::getCount ( void ) { return countMembers; };


UpsRecord* KNutUpsData::findName (const QString name) {
  UpsRecord* upsPointer = firstRecord;
  bool recordFind = FALSE;

  while ((! recordFind) && (upsPointer != 0L )) {
    if (upsPointer->name == name) recordFind = true;
    else upsPointer = upsPointer->nextUpsRecord;
    }
  return upsPointer;
  }
